/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import jkcemu.Main;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.ScreenFrm;

public abstract class AbstractKeyboardFld<T extends EmuSys>
extends JComponent
implements MouseListener {
    protected T emuSys;
    protected KeyData[] keys;
    protected List<KeyData> selectedKeys;
    private KeyData[] shiftKeys;
    private boolean holdShift;
    private boolean lastShiftPressed;
    private Timer nmiTimer;
    private Timer resetTimer;

    protected AbstractKeyboardFld(T t, int n, boolean bl) {
        this.emuSys = t;
        this.keys = new KeyData[n];
        this.selectedKeys = new ArrayList<KeyData>();
        this.shiftKeys = null;
        this.holdShift = true;
        this.lastShiftPressed = false;
        this.nmiTimer = null;
        this.resetTimer = null;
        this.addMouseListener(this);
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public abstract boolean accepts(EmuSys var1);

    protected abstract void keySelectionChanged();

    public abstract void setEmuSys(EmuSys var1) throws IllegalArgumentException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeShiftSelectionTo(boolean bl) {
        boolean bl2 = false;
        if (this.shiftKeys != null && this.shiftKeys.length > 0) {
            List<KeyData> list = this.selectedKeys;
            synchronized (list) {
                if (bl) {
                    for (KeyData keyData : this.shiftKeys) {
                        keyData.locked = true;
                        if (this.selectedKeys.contains(keyData)) continue;
                        this.selectedKeys.add(keyData);
                        bl2 = true;
                    }
                } else {
                    for (KeyData keyData : this.shiftKeys) {
                        if (!this.selectedKeys.remove(keyData)) continue;
                        bl2 = true;
                    }
                }
            }
        }
        if (bl2) {
            this.keySelectionChanged();
            this.repaint();
        }
        return bl2;
    }

    protected void drawMultiLineString(Graphics graphics, int n, int n2, int n3, int n4, String string, int n5) {
        if (string != null) {
            String string2 = null;
            String string3 = null;
            int n6 = string.indexOf(10);
            if (n6 >= 0) {
                string2 = string.substring(0, n6);
                if (n6 + 1 < string.length()) {
                    string3 = string.substring(n6 + 1);
                }
            } else {
                string2 = string;
            }
            if (string2 != null) {
                int n7 = -1;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                if (fontMetrics != null) {
                    n7 = fontMetrics.stringWidth(string2);
                    if (string3 != null) {
                        n7 = Math.max(n7, fontMetrics.stringWidth(string3));
                    }
                }
                int n8 = n + (n3 - n7) / 2 + 1;
                int n9 = n2 + (n4 - n5) / 2 + n5 - 2;
                if (string3 != null) {
                    n9 -= n5 / 2 - 1;
                }
                graphics.drawString(string2, n8, n9);
                if (string3 != null) {
                    graphics.drawString(string3, n8, n9 + n5 + 1);
                }
            }
        }
    }

    protected static void drawStringCenter(Graphics graphics, String string, int n, int n2, int n3) {
        if (string != null && !string.isEmpty()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)) / 2, n2);
            } else {
                graphics.drawString(string, n, n2);
            }
        }
    }

    protected static void drawStringRight(Graphics graphics, String string, int n, int n2, int n3) {
        if (string != null && !string.isEmpty()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                graphics.drawString(string, n + n3 - fontMetrics.stringWidth(string), n2);
            } else {
                graphics.drawString(string, n, n2);
            }
        }
    }

    protected synchronized void fireNMIAfterDelay() {
        ScreenFrm screenFrm;
        if (this.nmiTimer == null) {
            this.nmiTimer = new Timer();
        }
        if ((screenFrm = ((EmuSys)this.emuSys).getScreenFrm()) != null) {
            this.nmiTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EmuThread emuThread = screenFrm.getEmuThread();
                    if (emuThread != null) {
                        emuThread.getZ80CPU().fireNMI();
                    }
                }
            }, 200L);
        }
    }

    protected synchronized void fireWarmResetAfterDelay() {
        ScreenFrm screenFrm;
        if (this.resetTimer == null) {
            this.resetTimer = new Timer();
        }
        if ((screenFrm = ((EmuSys)this.emuSys).getScreenFrm()) != null) {
            this.resetTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    screenFrm.fireReset(EmuThread.ResetLevel.WARM_RESET);
                }
            }, 200L);
        }
    }

    public boolean getHoldShift() {
        return this.holdShift;
    }

    public String getKeyboardName() {
        return null;
    }

    protected Image getImage(String string) {
        return Main.getImage(Main.getScreenFrm(), string);
    }

    public boolean getSelectionChangeOnShiftOnly() {
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (KeyData keyData : this.keys) {
            if (n < keyData.x || n >= keyData.x + keyData.w || n2 < keyData.y || n2 >= keyData.y + keyData.h) continue;
            string = keyData.toolTipText;
            break;
        }
        return string;
    }

    public boolean hasShiftKeys() {
        boolean bl = false;
        for (KeyData keyData : this.keys) {
            if (!keyData.shift) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static boolean hits(KeyData keyData, MouseEvent mouseEvent) {
        boolean bl = false;
        if (keyData != null) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n >= keyData.x && n < keyData.x + keyData.w && n2 >= keyData.y && n2 < keyData.y + keyData.h) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isKeySelected(KeyData keyData) {
        boolean bl = false;
        List<KeyData> list = this.selectedKeys;
        synchronized (list) {
            bl = this.selectedKeys.contains(keyData);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<KeyData> list = this.selectedKeys;
        synchronized (list) {
            this.selectedKeys.clear();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHoldShift(boolean bl) {
        if (bl != this.holdShift) {
            this.holdShift = bl;
            if (!this.holdShift) {
                boolean bl2 = false;
                List<KeyData> list = this.selectedKeys;
                synchronized (list) {
                    int n = this.selectedKeys.size();
                    for (int i = n - 1; i >= 0; --i) {
                        KeyData keyData = this.selectedKeys.get(i);
                        if (keyData.locked) continue;
                        this.selectedKeys.remove(i);
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this.keySelectionChanged();
                    this.repaint();
                }
            }
        }
    }

    protected void setShiftKeys(KeyData ... keyDataArray) {
        this.shiftKeys = keyDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updKeySelection(int[] nArray) {
        boolean bl = false;
        List<KeyData> list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) continue;
                    for (KeyData keyData : this.keys) {
                        if (keyData.col != i || (keyData.value & nArray[i]) == 0) continue;
                        bl = true;
                        keyData.locked = false;
                        this.selectedKeys.add(keyData);
                    }
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.keys != null && mouseEvent.getComponent() == this) {
            Boolean bl = null;
            int n = mouseEvent.getButton();
            if (mouseEvent.isControlDown() || n == 2 || n == 3) {
                bl = Boolean.TRUE;
            } else if (n == 1) {
                bl = Boolean.FALSE;
            }
            if (bl != null) {
                for (KeyData keyData : this.keys) {
                    if (!AbstractKeyboardFld.hits(keyData, mouseEvent)) continue;
                    List<KeyData> list = this.selectedKeys;
                    synchronized (list) {
                        if (this.selectedKeys.contains(keyData)) {
                            this.selectedKeys.remove(keyData);
                        } else {
                            keyData.locked = bl;
                            this.selectedKeys.add(keyData);
                        }
                    }
                    this.lastShiftPressed = bl != false ? false : keyData.shift;
                    this.keySelectionChanged();
                    this.repaint();
                }
                mouseEvent.consume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            boolean bl = false;
            List<KeyData> list = this.selectedKeys;
            synchronized (list) {
                int n = this.selectedKeys.size();
                for (int i = n - 1; i >= 0; --i) {
                    KeyData keyData = this.selectedKeys.get(i);
                    if (keyData.locked || this.holdShift && keyData.shift && this.lastShiftPressed) continue;
                    this.selectedKeys.remove(i);
                    bl = true;
                }
            }
            if (bl) {
                this.keySelectionChanged();
                this.repaint();
            }
            mouseEvent.consume();
        }
    }

    public static class KeyData {
        public int x;
        public int y;
        public int w;
        public int h;
        public String text1;
        public String text2;
        public String text3;
        public Color color;
        public Image image;
        public int col;
        public int value;
        public boolean shift;
        public boolean locked;
        public String toolTipText;

        public KeyData(int n, int n2, int n3, int n4, String string, String string2, String string3, Color color, Image image, int n5, int n6, boolean bl, String string4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.text1 = string;
            this.text2 = string2;
            this.text3 = string3;
            this.color = color;
            this.image = image;
            this.col = n5;
            this.value = n6;
            this.shift = bl;
            this.toolTipText = string4;
        }
    }
}

