/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.EventObject;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.OptionDlg;
import jkcemu.base.ScreenFld;
import jkcemu.base.ScreenFrm;
import jkcemu.image.ImageFrm;
import jkcemu.image.ImgSaver;
import jkcemu.image.ImgSelection;
import jkcemu.text.TextUtil;

public abstract class AbstractScreenFrm
extends BaseFrm
implements FlavorListener {
    public static final String PROP_PREFIX = "jkcemu.";
    public static final String PROP_SCREEN_MARGIN = "screen.margin";
    public static final String PROP_COPY_AND_PASTE_DIRECT = "copy_and_paste.direct";
    public static final boolean DEFAULT_COPY_AND_PASTE_DIRECT = true;
    protected static final String ACTION_COPY = "edit.copy";
    protected static final String ACTION_PASTE = "edit.paste";
    protected static final String ACTION_PASTE_CANCEL = "edit.paste.cancel";
    protected static final String ACTION_PASTE_WITH = "edit.paste.with";
    protected static final String ACTION_SCALE_1 = "scale.1";
    protected static final String ACTION_SCALE_2 = "scale.2";
    protected static final String ACTION_SCALE_3 = "scale.3";
    protected static final String ACTION_SCALE_4 = "scale.4";
    protected static final String ACTION_SCREENIMAGE_SHOW = "screen.image.show";
    protected static final String ACTION_SCREENIMAGE_COPY = "screen.image.copy";
    protected static final String ACTION_SCREENIMAGE_SAVE = "screen.image.save";
    protected static final String ACTION_SCREENTEXT_SHOW = "screen.text.show";
    protected static final String ACTION_SCREENTEXT_COPY = "screen.text.copy";
    protected static final String ACTION_SCREENTEXT_SAVE = "screen.text.save";
    protected static final String ACTION_SCREENSHOT = "screenshot";
    protected static final String ACTION_SCREENVIDEO = "screen.video";
    protected JButton btnCopy = null;
    protected JButton btnPaste = null;
    protected JMenuItem mnuCopy = null;
    protected JMenuItem mnuPaste = null;
    protected JMenuItem mnuPasteWith = null;
    protected JMenuItem mnuPasteCancel = null;
    protected JMenuItem mnuScreenTextCopy = null;
    protected JMenuItem mnuScreenTextSave = null;
    protected JMenuItem mnuScreenTextShow = null;
    protected JMenuItem mnuPopupCopy = null;
    protected JMenuItem mnuPopupPaste = null;
    protected JRadioButtonMenuItem mnuScale1 = null;
    protected JRadioButtonMenuItem mnuScale2 = null;
    protected JRadioButtonMenuItem mnuScale3 = null;
    protected JRadioButtonMenuItem mnuScale4 = null;
    protected JPopupMenu mnuPopup = null;
    protected Clipboard clipboard = null;
    protected boolean copyEnabled = false;
    protected boolean pasteEnabled = false;
    protected volatile boolean screenDirty = false;
    protected ScreenFld screenFld;
    protected int screenRefreshMillis = AbstractScreenFrm.getDefaultScreenRefreshMillis();
    protected Timer screenRefreshTimer = new Timer(this.screenRefreshMillis, this);
    private static Set<String> closeMsgShownSet = new TreeSet<String>();
    private String closeMsg = null;

    protected AbstractScreenFrm() {
        this.screenRefreshTimer.start();
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            this.clipboard = toolkit.getSystemClipboard();
        }
    }

    protected String checkConvertScreenText(String string) {
        int n;
        AbstractScreenDevice abstractScreenDevice = this.getScreenDevice();
        if (abstractScreenDevice != null && string != null && (n = string.length()) > 0 && abstractScreenDevice.shouldAskConvertScreenChar()) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '[' && c != '\\' && c != ']' && c != '{' && c != '|' && c != '}' && c != '~') continue;
                bl = true;
                break;
            }
            if (bl) {
                Object[] objectArray;
                Boolean bl2 = null;
                EmuThread emuThread = abstractScreenDevice.getEmuThread();
                if (emuThread != null) {
                    bl2 = emuThread.getISO646DE();
                }
                if (bl2 == null) {
                    objectArray = new String[]{"ASCII", "Umlaute", "Abbrechen"};
                    JOptionPane jOptionPane = new JOptionPane("Der Text enth\u00e4lt Zeichencodes, die nach ASCII die Zeichen [ \\ ] { | } ~\nund nach ISO646-DE deutsche Umlaute darstellen.\nDa sie eine externe Zeichensatzdatei eingebunden haben,\nkann JKCEMU nicht wissen, ob ASCII-Zeichen\noder deutsche Umlaute angezeigt werden.\nWie sind diese Zeichencodes zu interpretieren?", 3);
                    jOptionPane.setOptions(objectArray);
                    jOptionPane.setWantsInput(false);
                    jOptionPane.createDialog(this, "Zeichensatz").setVisible(true);
                    Object object = jOptionPane.getValue();
                    if (object != null) {
                        if (object.equals(objectArray[0])) {
                            bl = false;
                            if (emuThread != null) {
                                emuThread.setISO646DE(false);
                            }
                        } else if (object.equals(objectArray[1])) {
                            bl = true;
                            if (emuThread != null) {
                                emuThread.setISO646DE(true);
                            }
                        } else {
                            string = null;
                        }
                    } else {
                        string = null;
                    }
                }
                if (bl && string != null) {
                    objectArray = new StringBuilder(n);
                    block10: for (int i = 0; i < n; ++i) {
                        char c = string.charAt(i);
                        switch (c) {
                            case '[': {
                                objectArray.append('\u00c4');
                                continue block10;
                            }
                            case '\\': {
                                objectArray.append('\u00d6');
                                continue block10;
                            }
                            case ']': {
                                objectArray.append('\u00dc');
                                continue block10;
                            }
                            case '{': {
                                objectArray.append('\u00e4');
                                continue block10;
                            }
                            case '|': {
                                objectArray.append('\u00f6');
                                continue block10;
                            }
                            case '}': {
                                objectArray.append('\u00fc');
                                continue block10;
                            }
                            case '~': {
                                objectArray.append('\u00df');
                                continue block10;
                            }
                            default: {
                                objectArray.append(c);
                            }
                        }
                    }
                    string = objectArray.toString();
                }
            }
        }
        return string;
    }

    protected JMenu createEditMenu(boolean bl, boolean bl2) {
        JMenu jMenu = null;
        if (bl || bl2) {
            jMenu = new JMenu("Bearbeiten");
            jMenu.setMnemonic(66);
            if (bl) {
                this.mnuCopy = this.createJMenuItem("Kopieren", ACTION_COPY, KeyStroke.getKeyStroke(67, 8));
                this.mnuCopy.setEnabled(false);
                jMenu.add(this.mnuCopy);
            }
            if (bl2) {
                this.mnuPaste = this.createJMenuItem("Einf\u00fcgen", ACTION_PASTE, KeyStroke.getKeyStroke(86, 8));
                this.mnuPaste.setEnabled(false);
                jMenu.add(this.mnuPaste);
                this.mnuPasteWith = this.createJMenuItem("Einf\u00fcgen mit...", ACTION_PASTE_WITH);
                this.mnuPasteWith.setEnabled(false);
                jMenu.add(this.mnuPasteWith);
                jMenu.addSeparator();
                this.mnuPasteCancel = this.createJMenuItem("Einf\u00fcgen abbrechen", ACTION_PASTE_CANCEL);
                this.mnuPasteCancel.setEnabled(false);
                jMenu.add(this.mnuPasteCancel);
            }
        }
        return jMenu;
    }

    protected JMenu createScaleMenu() {
        JMenu jMenu = new JMenu("Ansicht");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mnuScale1 = this.createJRadioButtonMenuItem(buttonGroup, "100 %", ACTION_SCALE_1, true, KeyStroke.getKeyStroke(49, 8));
        jMenu.add(this.mnuScale1);
        this.mnuScale2 = this.createJRadioButtonMenuItem(buttonGroup, "200 %", ACTION_SCALE_2, false, KeyStroke.getKeyStroke(50, 8));
        jMenu.add(this.mnuScale2);
        this.mnuScale3 = this.createJRadioButtonMenuItem(buttonGroup, "300 %", ACTION_SCALE_3, false, KeyStroke.getKeyStroke(51, 8));
        jMenu.add(this.mnuScale3);
        this.mnuScale4 = this.createJRadioButtonMenuItem(buttonGroup, "400 %", ACTION_SCALE_4, false, KeyStroke.getKeyStroke(52, 8));
        jMenu.add(this.mnuScale4);
        return jMenu;
    }

    protected JMenu createScreenMenu(boolean bl) {
        JMenu jMenu = new JMenu("Bildschirmausgabe");
        jMenu.add(this.createJMenuItem("als Bildschirmfoto anzeigen...", ACTION_SCREENIMAGE_SHOW));
        jMenu.add(this.createJMenuItem("als Bild kopieren", ACTION_SCREENIMAGE_COPY));
        jMenu.add(this.createJMenuItem("als Bilddatei speichern...", ACTION_SCREENIMAGE_SAVE));
        if (bl) {
            jMenu.addSeparator();
            this.mnuScreenTextShow = this.createJMenuItem("im Texteditor anzeigen", ACTION_SCREENTEXT_SHOW);
            jMenu.add(this.mnuScreenTextShow);
            this.mnuScreenTextCopy = this.createJMenuItem("als Text kopieren", ACTION_SCREENTEXT_COPY);
            jMenu.add(this.mnuScreenTextCopy);
            this.mnuScreenTextSave = this.createJMenuItem("als Textdatei speichern...", ACTION_SCREENTEXT_SAVE);
            jMenu.add(this.mnuScreenTextSave);
        }
        return jMenu;
    }

    protected boolean doScreenImageSave() {
        return ImgSaver.saveImageAs(this, this.screenFld.createBufferedImage(), null) != null;
    }

    protected void doScreenScale(int n) {
        this.screenFld.setScreenScale(n);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doScreenTextSave() {
        String string;
        File file;
        String string2;
        boolean bl = false;
        AbstractScreenDevice abstractScreenDevice = this.getScreenDevice();
        if (abstractScreenDevice != null && (string2 = this.checkConvertScreenText(abstractScreenDevice.getScreenText())) != null && (file = EmuUtil.showFileSaveDlg(this, "Textdatei speichern", Main.getLastDirFile("screen"), EmuUtil.getTextFileFilter())) != null && (string = file.getPath()) != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = string2.length();
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    if (c == '\n') {
                        bufferedWriter.newLine();
                        continue;
                    }
                    bufferedWriter.write(c);
                }
                bufferedWriter.close();
                bufferedWriter = null;
                bl = true;
            }
            catch (Exception exception) {
                try {
                    BaseDlg.showErrorDlg((Component)this, string + ":\nSpeichern der Datei fehlgeschlagen\n\n" + exception.getMessage());
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(bufferedWriter);
                    throw throwable;
                }
                EmuUtil.closeSilent(bufferedWriter);
            }
            EmuUtil.closeSilent(bufferedWriter);
        }
        return bl;
    }

    public void firePastingTextFinished() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractScreenFrm.this.pastingTextFinished();
            }
        });
    }

    public static int getDefaultScreenRefreshMillis() {
        int n = 100;
        int n2 = Runtime.getRuntime().availableProcessors();
        if (n2 > 1) {
            n = 50;
            if (n2 >= 4) {
                n = 20;
            }
        }
        return n;
    }

    public int getScreenRefreshMillis() {
        return this.screenRefreshMillis;
    }

    protected abstract AbstractScreenDevice getScreenDevice();

    @Override
    public void lookAndFeelChanged() {
        if (this.mnuPopup != null) {
            SwingUtilities.updateComponentTreeUI(this.mnuPopup);
        }
    }

    protected void pasteText(String string) {
        AbstractScreenDevice abstractScreenDevice = this.getScreenDevice();
        if (abstractScreenDevice != null && string != null && !string.isEmpty()) {
            if (string.indexOf(13) >= 0) {
                string = string.replace('\r', '\n');
            }
            if (string.indexOf(160) >= 0) {
                string = string.replace('\u00a0', ' ');
            }
            if (this.mnuPasteCancel != null) {
                this.mnuPasteCancel.setEnabled(true);
            }
            this.updPasteBtns();
            abstractScreenDevice.startPastingText(string);
        }
    }

    protected void pastingTextFinished() {
        if (this.mnuPasteCancel != null) {
            this.mnuPasteCancel.setEnabled(false);
        }
        this.updPasteBtns();
    }

    public void setCloseMsg(String string) {
        this.closeMsg = string;
    }

    public void setScreenDirty(boolean bl) {
        this.screenDirty = bl;
    }

    protected void setScreenScale(int n) {
        this.screenFld.setScreenScale(n);
        switch (n) {
            case 1: {
                if (this.mnuScale1 == null) break;
                this.mnuScale1.setSelected(true);
                break;
            }
            case 2: {
                if (this.mnuScale2 == null) break;
                this.mnuScale2.setSelected(true);
                break;
            }
            case 3: {
                if (this.mnuScale3 == null) break;
                this.mnuScale3.setSelected(true);
                break;
            }
            case 4: {
                if (this.mnuScale4 == null) break;
                this.mnuScale4.setSelected(true);
            }
        }
    }

    public void setScreenTextSelected(boolean bl) {
        if (!this.copyEnabled) {
            bl = false;
        }
        if (this.mnuCopy != null) {
            this.mnuCopy.setEnabled(bl);
        }
        if (this.mnuPopupCopy != null) {
            this.mnuPopupCopy.setEnabled(bl);
        }
        if (this.btnCopy != null) {
            this.btnCopy.setEnabled(bl);
        }
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        Component component;
        boolean bl = false;
        if (this.mnuPopup != null && (component = mouseEvent.getComponent()) != null) {
            this.mnuPopup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    protected void updPasteBtns() {
        boolean bl = false;
        if (this.pasteEnabled && this.clipboard != null) {
            boolean bl2 = false;
            if (this.mnuPasteCancel != null) {
                bl2 = this.mnuPasteCancel.isEnabled();
            }
            if (!bl2) {
                try {
                    bl = this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.mnuPaste != null) {
            this.mnuPaste.setEnabled(bl);
        }
        if (this.mnuPasteWith != null) {
            this.mnuPasteWith.setEnabled(bl);
        }
        if (this.mnuPopupPaste != null) {
            this.mnuPopupPaste.setEnabled(bl);
        }
        if (this.btnPaste != null) {
            this.btnPaste.setEnabled(bl);
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.updPasteBtns();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        Object object = actionEvent.getSource();
        if (object != null && object == this.screenRefreshTimer) {
            if (this.screenDirty) {
                this.screenFld.repaint();
            }
            bl = true;
        }
        if (!bl) {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        String string;
        boolean bl = false;
        if (eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
            if (string.equals(ACTION_COPY)) {
                bl = true;
                this.doCopy();
            } else if (string.equals(ACTION_PASTE)) {
                bl = true;
                this.doPaste(false);
            } else if (string.equals(ACTION_PASTE_WITH)) {
                bl = true;
                this.doPaste(true);
            } else if (string.equals(ACTION_PASTE_CANCEL)) {
                bl = true;
                this.doPasteCancel();
            } else if (string.equals(ACTION_SCREENIMAGE_SHOW)) {
                bl = true;
                this.doScreenImageShow();
            } else if (string.equals(ACTION_SCREENIMAGE_COPY)) {
                bl = true;
                this.doScreenImageCopy();
            } else if (string.equals(ACTION_SCREENIMAGE_SAVE)) {
                bl = true;
                this.doScreenImageSave();
            } else if (string.equals(ACTION_SCREENTEXT_SHOW)) {
                bl = true;
                this.doScreenTextShow();
            } else if (string.equals(ACTION_SCREENTEXT_SAVE)) {
                bl = true;
                this.doScreenTextSave();
            } else if (string.equals(ACTION_SCREENTEXT_COPY)) {
                bl = true;
                this.doScreenTextCopy();
            } else if (string.equals(ACTION_SCALE_1)) {
                bl = true;
                this.doScreenScale(1);
            } else if (string.equals(ACTION_SCALE_2)) {
                bl = true;
                this.doScreenScale(2);
            } else if (string.equals(ACTION_SCALE_3)) {
                bl = true;
                this.doScreenScale(3);
            } else if (string.equals(ACTION_SCALE_4)) {
                bl = true;
                this.doScreenScale(4);
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        String string;
        AbstractScreenDevice abstractScreenDevice;
        boolean bl = false;
        boolean bl2 = true;
        if (this.closeMsg != null && !this.isVisible() && (abstractScreenDevice = this.getScreenDevice()) != null && !closeMsgShownSet.contains(string = abstractScreenDevice.getClass().getName())) {
            JCheckBox jCheckBox = new JCheckBox("Diese Meldung zuk\u00fcnftig nicht mehr anzeigen");
            boolean bl3 = bl2 = JOptionPane.showConfirmDialog(this, new Object[]{this.closeMsg, jCheckBox}, "Hinweis", 2, 1) == 0;
            if (jCheckBox.isSelected()) {
                closeMsgShownSet.add(string);
            }
        }
        if (bl2) {
            bl = super.doClose();
        }
        return bl;
    }

    @Override
    public boolean doQuit() {
        return super.doClose();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.screenFld && mouseEvent.getClickCount() == 1) {
            int n = mouseEvent.getModifiers();
            if ((n & 0x10) != 0) {
                this.screenFld.clearSelection();
                this.screenFld.requestFocus();
                mouseEvent.consume();
            } else if ((n & 8) != 0 && Main.getBooleanProperty("jkcemu.copy_and_paste.direct", true)) {
                String string = this.checkConvertScreenText(this.screenFld.getSelectedText());
                if (string != null && string.length() > 0) {
                    this.setWaitCursor(true);
                    this.pasteText(string);
                    this.setWaitCursor(false);
                }
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void resetFired() {
        if (this.mnuPasteCancel != null) {
            this.mnuPasteCancel.setEnabled(false);
        }
        this.updPasteBtns();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl && this.clipboard != null) {
                this.clipboard.addFlavorListener(this);
                this.updPasteBtns();
            }
            super.setVisible(bl);
            if (!bl && this.clipboard != null) {
                this.clipboard.addFlavorListener(this);
            }
        }
    }

    private void doCopy() {
        EmuUtil.copyToClipboard(this, this.checkConvertScreenText(this.screenFld.getSelectedText()));
    }

    private void doPaste(boolean bl) {
        if (this.clipboard != null) {
            try {
                String string;
                Object object;
                if (this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && (object = this.clipboard.getData(DataFlavor.stringFlavor)) != null && (string = object.toString()) != null && !string.isEmpty()) {
                    if (bl) {
                        switch (OptionDlg.showOptionDlg(this, "Mit welcher Gro\u00df-/Keinschreibung soll der Text eingef\u00fcgt werden?", "Gro\u00df-/Keinschreibung", 0, "Gro\u00df-/Keinschreibung beibehalten", "Alles in Gro\u00dfbuchstaben", "Alles in Kleinbuchstaben", "Gro\u00df-/Keinschreibung umkehren")) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                string = TextUtil.toUpperCase(string);
                                break;
                            }
                            case 2: {
                                string = TextUtil.toLowerCase(string);
                                break;
                            }
                            case 3: {
                                string = TextUtil.toReverseCase(string);
                                break;
                            }
                            default: {
                                string = null;
                            }
                        }
                    }
                    if (string != null) {
                        this.pasteText(string);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void doPasteCancel() {
        AbstractScreenDevice abstractScreenDevice = this.getScreenDevice();
        if (abstractScreenDevice != null) {
            abstractScreenDevice.cancelPastingText();
        }
    }

    private void doScreenImageCopy() {
        try {
            if (this.clipboard != null) {
                ImgSelection imgSelection = new ImgSelection(this.screenFld.createBufferedImage());
                this.clipboard.setContents(imgSelection, imgSelection);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void doScreenImageShow() {
        ImageFrm.open(this.screenFld.createBufferedImage(), "Schnappschuss");
    }

    private void doScreenTextCopy() {
        AbstractScreenDevice abstractScreenDevice = this.getScreenDevice();
        if (abstractScreenDevice != null) {
            EmuUtil.copyToClipboard(this, this.checkConvertScreenText(abstractScreenDevice.getScreenText()));
        }
    }

    private void doScreenTextShow() {
        ScreenFrm screenFrm;
        String string;
        AbstractScreenDevice abstractScreenDevice = this.getScreenDevice();
        if (abstractScreenDevice != null && (string = this.checkConvertScreenText(abstractScreenDevice.getScreenText())) != null && (screenFrm = Main.getScreenFrm()) != null) {
            screenFrm.openText(string);
        }
    }
}

