/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.util.List;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.AutoInputEntry;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;

public class AutoInputWorker
extends Thread {
    public static final String PROP_AUTOINPUT_PREFIX = "autoinput.";
    private EmuThread emuThread;
    private List<AutoInputEntry> entries;

    public static void start(EmuThread emuThread, Properties properties) {
        List<AutoInputEntry> list;
        EmuSys emuSys = emuThread.getEmuSys();
        if (emuSys != null && (list = AutoInputEntry.readEntries(properties, emuSys.getPropPrefix() + PROP_AUTOINPUT_PREFIX)) != null && !list.isEmpty()) {
            new AutoInputWorker(emuThread, list).start();
        }
    }

    @Override
    public void run() {
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null) {
            try {
                for (AutoInputEntry autoInputEntry : this.entries) {
                    int n = autoInputEntry.getMillisToWait();
                    if (n > 0) {
                        AutoInputWorker.sleep(n);
                    }
                    emuSys.startPastingText(autoInputEntry.getInputText());
                    while (emuSys.isPastingText()) {
                        AutoInputWorker.sleep(10L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private AutoInputWorker(EmuThread emuThread, List<AutoInputEntry> list) {
        super(Main.getThreadGroup(), "JKCEMU auto input");
        this.emuThread = emuThread;
        this.entries = list;
    }
}

