/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.util.NoSuchElementException;

public class ByteIterator {
    private byte[] buf;
    private int offs;
    private int endIdx;
    private int curIdx;

    public ByteIterator(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.offs = n;
        this.curIdx = n;
        this.endIdx = n + n2;
        if (this.endIdx >= byArray.length) {
            this.endIdx = byArray.length;
        }
    }

    public ByteIterator(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public int available() {
        return this.hasNext() ? this.endIdx - this.curIdx : 0;
    }

    public int getIndex() {
        return this.curIdx;
    }

    public boolean hasNext() {
        return this.curIdx >= this.offs && this.curIdx < this.endIdx;
    }

    public byte next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.curIdx++];
    }

    public int nextByte() throws NoSuchElementException {
        return this.next() & 0xFF;
    }

    public int nextInt3LE() throws NoSuchElementException {
        int n = this.nextWord();
        int n2 = this.nextByte();
        return n2 << 16 | n;
    }

    public int nextInt4LE() throws NoSuchElementException {
        int n = this.nextWord();
        int n2 = this.nextWord();
        return n2 << 16 | n;
    }

    public int nextWord() throws NoSuchElementException {
        int n = this.nextByte();
        int n2 = this.nextByte();
        return n2 << 8 | n;
    }

    public int readByte() {
        return this.curIdx >= this.offs && this.curIdx < this.endIdx ? this.buf[this.curIdx++] & 0xFF : -1;
    }

    public int readWord() {
        int n = this.readByte();
        int n2 = this.readByte();
        return n >= 0 && n2 >= 0 ? n2 << 8 & 0xFF00 | n & 0xFF : -1;
    }

    public void setIndex(int n) {
        this.curIdx = n;
    }

    public void skip(int n) {
        if (n > 0) {
            long l = (long)this.curIdx + (long)n;
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            this.curIdx = (int)l;
        }
    }
}

