/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTreeNode;
import jkcemu.base.FileTreeNodeComparator;

public class DirSelectDlg
extends BaseDlg
implements TreeSelectionListener,
TreeWillExpandListener {
    private File selectedFile = null;
    private FileSystemView fsv;
    private FileTreeNodeComparator comparator = FileTreeNodeComparator.getIgnoreCaseInstance();
    private FileTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private JCheckBox btnPhysFileSys;
    private JButton btnApprove;
    private JButton btnCancel;
    private JButton btnNew;

    public static File selectDirectory(Window window, File file) {
        DirSelectDlg dirSelectDlg = new DirSelectDlg(window, file);
        dirSelectDlg.setVisible(true);
        return dirSelectDlg.selectedFile;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.tree) {
            boolean bl = false;
            File file = this.getSelectedFile();
            if (file != null) {
                bl = file.isDirectory();
            }
            this.btnApprove.setEnabled(bl);
            this.btnNew.setEnabled(bl);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null) {
            this.setWaitCursor(true);
            Object object = treePath.getLastPathComponent();
            if (object != null && object instanceof FileTreeNode) {
                this.refreshNode((FileTreeNode)object);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.tree || object == this.btnApprove) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnPhysFileSys) {
                bl = true;
                this.doPhysFileSys();
            } else if (object == this.btnNew) {
                bl = true;
                this.doNew();
            } else if (object == this.btnCancel) {
                bl = true;
                this.selectedFile = null;
                this.doClose();
            }
        }
        return bl;
    }

    private DirSelectDlg(Window window, File file) {
        super(window, "Verzeichnisauswahl");
        this.fsv = EmuUtil.getDifferentLogicalFileSystemView();
        boolean bl = true;
        if (this.fsv != null && file == null) {
            bl = Main.getBooleanProperty("jkcemu.show_phys_filesys", false);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.rootNode = new FileTreeNode(null, null, null, true, bl ? null : this.fsv);
        this.refreshNode(this.rootNode);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.setScrollsOnExpand(true);
        this.tree.setShowsRootHandles(true);
        this.add((Component)new JScrollPane(this.tree), gridBagConstraints);
        this.btnPhysFileSys = null;
        if (this.fsv != null) {
            this.btnPhysFileSys = new JCheckBox("Physische Dateisystemstruktur anzeigen", bl);
            this.btnPhysFileSys.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            ++gridBagConstraints.gridy;
            this.add((Component)this.btnPhysFileSys, gridBagConstraints);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnApprove = new JButton("Ausw\u00e4hlen");
        this.btnApprove.setEnabled(false);
        jPanel.add(this.btnApprove);
        this.btnNew = new JButton("Neu...");
        this.btnNew.setEnabled(false);
        jPanel.add(this.btnNew);
        this.btnCancel = new JButton("Abbrechen");
        jPanel.add(this.btnCancel);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.tree.addKeyListener(this);
        this.btnApprove.addActionListener(this);
        this.btnApprove.addKeyListener(this);
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        this.btnNew.addActionListener(this);
        this.btnNew.addKeyListener(this);
        this.setSize(300, 300);
        this.setResizable(true);
        this.setParentCentered();
        if (file != null) {
            final ArrayList<String> arrayList = new ArrayList<String>();
            while (file != null) {
                String string = file.getName();
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                if (string == null) {
                    string = file.getPath();
                }
                if (string == null) break;
                arrayList.add(string);
                file = file.getParentFile();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DirSelectDlg.this.selectPath(arrayList);
                }
            });
        }
    }

    private void doApprove() {
        File file = this.getSelectedFile();
        if (file != null && file.isDirectory()) {
            this.selectedFile = file;
            this.doClose();
        }
    }

    private void doPhysFileSys() {
        if (this.btnPhysFileSys != null) {
            boolean bl = this.btnPhysFileSys.isSelected();
            EmuUtil.setProperty(Main.getProperties(), "jkcemu.show_phys_filesys", bl);
            this.rootNode.setFileSystemView(bl ? null : this.fsv);
            this.rootNode.setChildrenLoaded(false);
            this.refreshNode(this.rootNode);
            this.treeModel.nodeStructureChanged(this.rootNode);
        }
    }

    private void doNew() {
        FileTreeNode fileTreeNode;
        Object object;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof FileTreeNode && (fileTreeNode = (FileTreeNode)object) != null) {
            File file;
            this.refreshNode(fileTreeNode);
            File file2 = fileTreeNode.getFile();
            if (file2 != null && file2.isDirectory() && (file = EmuUtil.createDir(this, file2)) != null) {
                try {
                    FileTreeNode fileTreeNode2 = new FileTreeNode(fileTreeNode, file.toPath(), null, false, null);
                    fileTreeNode.add(fileTreeNode2);
                    this.treeModel.nodeStructureChanged(fileTreeNode);
                    final JTree jTree = this.tree;
                    final TreePath treePath2 = treePath.pathByAddingChild(fileTreeNode2);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTree.setSelectionPath(treePath2);
                        }
                    });
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
    }

    private File getSelectedFile() {
        Object object;
        File file = null;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof FileTreeNode) {
            file = ((FileTreeNode)object).getFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNode(FileTreeNode fileTreeNode) {
        if (!fileTreeNode.hasChildrenLoaded()) {
            Comparable<File> comparable;
            Iterator iterator;
            fileTreeNode.removeAllChildren();
            boolean bl = false;
            boolean bl2 = false;
            FileSystemView fileSystemView = fileTreeNode.getFileSystemView();
            if (fileSystemView != null) {
                iterator = null;
                comparable = fileTreeNode.getFile();
                if (comparable != null) {
                    iterator = fileSystemView.getFiles((File)comparable, true);
                } else {
                    iterator = fileSystemView.getRoots();
                    bl2 = true;
                }
                if (iterator != null) {
                    for (Object object : iterator) {
                        if (!((File)object).isDirectory() || !bl2 && ((File)object).isHidden()) continue;
                        fileTreeNode.add(new FileTreeNode(fileTreeNode, null, (File)object, bl2, fileSystemView));
                    }
                }
                bl = true;
            }
            if (!bl) {
                iterator = null;
                try {
                    comparable = fileTreeNode.getPath();
                    if (comparable != null) {
                        if (Files.isDirectory((Path)comparable, LinkOption.NOFOLLOW_LINKS) && !Files.isSymbolicLink((Path)comparable)) {
                            iterator = Files.newDirectoryStream((Path)comparable);
                        }
                    } else {
                        iterator = FileSystems.getDefault().getRootDirectories();
                        bl2 = true;
                    }
                    Iterator iterator2 = iterator.iterator();
                    while (iterator2.hasNext()) {
                        Path path = (Path)iterator2.next();
                        try {
                            if (!Files.isDirectory(path, new LinkOption[0]) || !bl2 && Files.isHidden(path)) continue;
                            fileTreeNode.add(new FileTreeNode(fileTreeNode, path, null, bl2, null));
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (iterator != null && iterator instanceof Closeable) {
                        EmuUtil.closeSilent((Closeable)((Object)iterator));
                    }
                }
            }
            fileTreeNode.sort(this.comparator);
            fileTreeNode.setChildrenLoaded(true);
        }
    }

    private void selectPath(List<String> list) {
        Object object;
        TreeNode treeNode = this.rootNode;
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        arrayList.add(treeNode);
        block0: for (int i = list.size() - 1; treeNode != null && i >= 0; --i) {
            if (treeNode instanceof FileTreeNode) {
                this.refreshNode((FileTreeNode)treeNode);
            }
            object = list.get(i);
            int n = treeNode.getChildCount();
            for (int j = 0; j < n; ++j) {
                String string;
                TreeNode treeNode2 = treeNode.getChildAt(j);
                if (treeNode2 == null || (string = treeNode2.toString()) == null || !string.equals(object)) continue;
                arrayList.add(treeNode2);
                treeNode = treeNode2;
                continue block0;
            }
        }
        if (arrayList.size() > 1) {
            object = new TreePath(arrayList.toArray());
            final JTree jTree = this.tree;
            EventQueue.invokeLater(new Runnable((TreePath)object){
                final /* synthetic */ TreePath val$tp;
                {
                    this.val$tp = treePath;
                }

                @Override
                public void run() {
                    jTree.expandPath(this.val$tp);
                    jTree.makeVisible(this.val$tp);
                    jTree.setSelectionPath(this.val$tp);
                }
            });
        }
    }
}

