/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.LoadData;

public class FileInfo {
    public static final String CSW_MAGIC = "Compressed Square Wave\u001a";
    public static final String KCTAP_MAGIC = "\u00c3KC-TAPE by AF. ";
    public static final String TZX_MAGIC = "ZXTape!\u001a";
    private byte[] header;
    private long fileLen;
    private int fileType;
    private FileFormat fileFmt;
    private String fileText;
    private String fileDesc;
    private String addrText;
    private String infoText;
    private int nextTAPOffs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo analyzeFile(File file) {
        FileInfo fileInfo;
        block6: {
            fileInfo = null;
            if (file != null) {
                try {
                    FileInputStream fileInputStream;
                    block7: {
                        long l = file.length();
                        if (l <= 0L) break block6;
                        fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(file);
                            byte[] byArray = new byte[256];
                            int n = EmuUtil.read(fileInputStream, byArray);
                            if (n <= 0) break block7;
                            if (n < byArray.length) {
                                byArray = Arrays.copyOf(byArray, n);
                            }
                            fileInfo = FileInfo.analyzeFile(byArray, file);
                        }
                        catch (Throwable throwable) {
                            EmuUtil.closeSilent(fileInputStream);
                            throw throwable;
                        }
                    }
                    EmuUtil.closeSilent(fileInputStream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return fileInfo;
    }

    public static FileInfo analyzeFile(byte[] byArray, File file) {
        FileInfo fileInfo = null;
        if (byArray != null) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Object object;
            String string = null;
            FileFormat fileFormat = null;
            String string2 = null;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            long l = 0L;
            if (file != null) {
                object = file.getName();
                if (object != null) {
                    string = ((String)object).toUpperCase();
                }
                l = file.length();
            }
            if (l > 32L && byArray.length > 15) {
                int n11 = byArray[13] & 0xFF;
                n6 = byArray[14] & 0xFF;
                n5 = byArray[15] & 0xFF;
                if (byArray[13] == -45 && byArray[14] == -45 && byArray[15] == -45) {
                    fileFormat = FileFormat.HEADERSAVE;
                    n8 = FileInfo.getBegAddr(byArray, fileFormat);
                    n9 = FileInfo.getEndAddr(byArray, fileFormat);
                    n4 = byArray[12] & 0xFF;
                    if (n4 >= 32 && n4 < 127) {
                        n7 = n4;
                    }
                }
            }
            if (fileFormat == null && l > 144L && byArray.length > 33 && FileInfo.isKCTapMagicAt(byArray, 0)) {
                int n12 = -1;
                n6 = byArray[16] & 0xFF;
                n5 = byArray[17] & 0xFF;
                n4 = byArray[18] & 0xFF;
                n3 = byArray[19] & 0xFF;
                if (!(n5 >= 211 && n5 <= 216 || n4 >= 211 && n4 <= 216 || n3 >= 211 && n3 <= 216)) {
                    fileFormat = n6 == 0 ? FileFormat.KCTAP_Z9001 : (n6 == 1 ? FileFormat.KCTAP_KC85 : FileFormat.KCTAP_SYS);
                    n8 = FileInfo.getBegAddr(byArray, fileFormat);
                    n9 = FileInfo.getEndAddr(byArray, fileFormat);
                    if (n8 >= 0 && n8 <= n9) {
                        n2 = (n9 - n8 + 127) / 128;
                        n12 = 16 + 129 * (n2 + 1);
                    }
                } else if (n5 == 211 && n4 == 211 && n3 == 211 || n5 == 215 && n4 == 215 && n3 == 215) {
                    fileFormat = FileFormat.KCTAP_BASIC_PRG;
                    n8 = FileInfo.getBegAddr(byArray, fileFormat);
                    n9 = FileInfo.getEndAddr(byArray, fileFormat);
                    if (n8 >= 0 && n8 <= n9) {
                        n2 = (n9 - n8 + 13 + 127) / 128;
                        n12 = 16 + 129 * n2;
                    }
                } else if (n5 == 212 && n4 == 212 && n3 == 212 || n5 == 216 && n4 == 216 && n3 == 216) {
                    fileFormat = FileFormat.KCTAP_BASIC_DATA;
                } else if (n5 == 213 && n4 == 213 && n3 == 213 || n5 == 217 && n4 == 217 && n3 == 217) {
                    fileFormat = FileFormat.KCTAP_BASIC_ASC;
                }
                if (n12 > 0 && FileInfo.isKCTapMagicAt(byArray, n12)) {
                    n10 = n12;
                }
            }
            if (fileFormat == null && l > 20L && byArray.length > 2) {
                object = new AtomicBoolean();
                n6 = FileInfo.hasKCBlkNums(byArray, (AtomicBoolean)object) ? 1 : 0;
                n5 = n6 != 0 ? 1 : 0;
                n4 = byArray[n5++] & 0xFF;
                n3 = byArray[n5++] & 0xFF;
                n2 = byArray[n5] & 0xFF;
                if (n4 == 211 && n3 == 211 && n2 == 211 || n4 == 215 && n3 == 215 && n2 == 215) {
                    fileFormat = n6 != 0 ? (((AtomicBoolean)object).get() ? FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS : FileFormat.KCBASIC_HEAD_PRG_BLKN) : FileFormat.KCBASIC_HEAD_PRG;
                } else if (n4 == 212 && n3 == 212 && n2 == 212 || n4 == 216 && n3 == 216 && n2 == 216) {
                    fileFormat = n6 != 0 ? (((AtomicBoolean)object).get() ? FileFormat.KCBASIC_HEAD_DATA_BLKN_CKS : FileFormat.KCBASIC_HEAD_DATA_BLKN) : FileFormat.KCBASIC_HEAD_DATA;
                } else if (n4 == 213 && n3 == 213 && n2 == 213 || n4 == 217 && n3 == 217 && n2 == 217) {
                    fileFormat = n6 != 0 ? (((AtomicBoolean)object).get() ? FileFormat.KCBASIC_HEAD_ASC_BLKN_CKS : FileFormat.KCBASIC_HEAD_ASC_BLKN) : FileFormat.KCBASIC_HEAD_ASC;
                }
            }
            if (fileFormat == null && l > (long)CSW_MAGIC.length() && byArray.length > CSW_MAGIC.length() && FileInfo.isCswMagicAt(byArray, 0)) {
                fileFormat = FileFormat.CSW;
            }
            if (fileFormat == null && l > (long)TZX_MAGIC.length() && byArray.length > TZX_MAGIC.length() && FileInfo.isTzxMagicAt(byArray, 0)) {
                fileFormat = FileFormat.TZX;
                if (string != null && string.endsWith(".CDT")) {
                    fileFormat = FileFormat.CDT;
                }
            }
            if (fileFormat == null && l > 10L && byArray.length > 10) {
                char c = (char)(byArray[3] & 0xFF);
                n6 = (char)(byArray[4] & 0xFF);
                n5 = (char)(byArray[5] & 0xFF);
                n4 = (char)(byArray[6] & 0xFF);
                if ((byArray[0] & 0xFF) == 58 && EmuUtil.isHexChar(byArray[1] & 0xFF) && EmuUtil.isHexChar(byArray[2] & 0xFF) && EmuUtil.isHexChar(c) && EmuUtil.isHexChar(n6) && EmuUtil.isHexChar(n5) && EmuUtil.isHexChar(n4) && EmuUtil.isHexChar(byArray[7] & 0xFF) && EmuUtil.isHexChar(byArray[8] & 0xFF) && EmuUtil.isHexChar(byArray[9] & 0xFF) && EmuUtil.isHexChar(byArray[10] & 0xFF)) {
                    fileFormat = FileFormat.INTELHEX;
                }
            }
            if (fileFormat == null && file != null && string != null) {
                AtomicBoolean atomicBoolean;
                if (string.endsWith(".KCB") && l > 127L && byArray.length > 20 && (n4 = byArray[(n5 = (n6 = (int)(FileInfo.hasKCBlkNums(byArray, atomicBoolean = new AtomicBoolean()) ? 1 : 0)) != 0 ? 1 : 0) + 16] & 0xFF) >= 2 && n4 <= 4 && EmuUtil.getWord(byArray, n5 + 17) <= 1025 && EmuUtil.getWord(byArray, n5 + 19) >= 1033) {
                    fileFormat = n6 != 0 ? (atomicBoolean.get() ? FileFormat.KCB_BLKN_CKS : FileFormat.KCB_BLKN) : FileFormat.KCB;
                }
                if (fileFormat == null && (string.endsWith(".KCC") || string.endsWith(".KCM") || string.endsWith(".851") || string.endsWith(".852") || string.endsWith(".853") || string.endsWith(".854") || string.endsWith(".855")) && l > 127L && byArray.length > 16) {
                    AtomicBoolean atomicBoolean2 = new AtomicBoolean();
                    fileFormat = FileInfo.hasKCBlkNums(byArray, atomicBoolean2) ? (atomicBoolean2.get() ? FileFormat.KCC_BLKN_CKS : FileFormat.KCC_BLKN) : FileFormat.KCC;
                    n8 = FileInfo.getBegAddr(byArray, fileFormat);
                    n9 = FileInfo.getEndAddr(byArray, fileFormat);
                }
                if (fileFormat == null && string.endsWith(".SSS") && l >= 9L && byArray.length >= 9) {
                    fileFormat = FileFormat.KCBASIC_PRG;
                }
                if (fileFormat == null && string.endsWith(".ABC") && l >= 8L && byArray.length >= 8 && (byArray[1] & 0xFF) == 99 && EmuUtil.getWord(byArray, 0) >= 25351) {
                    fileFormat = FileFormat.BASIC_PRG;
                    n8 = 25344;
                    string2 = "AC1-BASIC6-Programmdatei";
                }
                if (fileFormat == null && string.endsWith(".BAC") && l >= 8L && byArray.length >= 8 && (byArray[1] & 0xFE) == 96 && EmuUtil.getWord(byArray, 0) >= 24829) {
                    fileFormat = FileFormat.BASIC_PRG;
                    n8 = 24823;
                    string2 = "BACOBAS-Programmdatei";
                }
                if (fileFormat == null && string.endsWith(".BAS") && l >= 8L && byArray.length >= 8) {
                    if ((byArray[0] & 0xFF) == 255 && (byArray[2] & 0xFE) == 128 && EmuUtil.getWord(byArray, 1) >= 32775) {
                        fileFormat = FileFormat.RBASIC_PRG;
                        n8 = 32769;
                    } else if ((byArray[1] & 0xFE) == 4 && EmuUtil.getWord(byArray, 0) >= 1031) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 1025;
                        string2 = "BASIC-Programmdatei f\u00fcr KC-ROM-BASIC";
                    } else if ((byArray[1] & 0xFE) == 16 && EmuUtil.getWord(byArray, 0) >= 4103) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 4097;
                        string2 = "BASIC-Programmdatei f\u00fcr Kramer-MC";
                    } else if ((byArray[1] & 0xFE) == 96 && EmuUtil.getWord(byArray, 0) >= 24829) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 24823;
                        string2 = "BASIC-Programmdatei f\u00fcr AC1/LLC2";
                    } else if ((byArray[1] & 0xFF) == 99 && EmuUtil.getWord(byArray, 0) >= 25351) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 25344;
                        string2 = "AC1-BASIC6-Programmdatei";
                    } else if (((byArray[1] & 0xFF) == 111 || (byArray[1] & 0xFF) == 112) && EmuUtil.getWord(byArray, 0) >= 28605) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 28599;
                        string2 = "BASIC-Programmdatei f\u00fcr AC1 (12K BASIC)";
                    } else if ((byArray[1] & 0xFE) == 44 && EmuUtil.getWord(byArray, 0) >= 11271) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 11265;
                        string2 = "BASIC-Programmdatei f\u00fcr KC-RAM-BASIC";
                    } else if (((byArray[1] & 0xFF) == 55 || (byArray[1] & 0xFF) == 56) && EmuUtil.getWord(byArray, 0) >= 14198) {
                        fileFormat = FileFormat.BASIC_PRG;
                        n8 = 14192;
                        string2 = "BASIC-Programmdatei f\u00fcr H\u00fcbler-Grafik-MC";
                    }
                }
                if (fileFormat == null && string.endsWith(".RMC") && l >= 8L && byArray.length >= 7 && (byArray[0] & 0xFF) == 254) {
                    fileFormat = FileFormat.RMC;
                    n8 = FileInfo.getBegAddr(byArray, fileFormat);
                    n9 = FileInfo.getEndAddr(byArray, fileFormat);
                }
                if (fileFormat == null && string.endsWith(".TAP") && !FileInfo.isKCTapMagicAt(byArray, 0)) {
                    fileFormat = FileFormat.ZXTAP;
                }
                if (fileFormat == null && string.endsWith(".BIN") && l > 0L) {
                    fileFormat = FileFormat.BIN;
                    string2 = "BIN-Datei";
                }
                if (fileFormat == null && string.endsWith(".ROM") && l > 0L) {
                    fileFormat = FileFormat.BIN;
                    string2 = "ROM-Datei";
                }
            }
            if (fileFormat == null && string2 == null && string != null && (n = string.lastIndexOf(46)) >= 0 && n + 1 < string.length()) {
                string2 = string.substring(n + 1) + "-Datei";
            }
            StringBuilder stringBuilder = new StringBuilder(26);
            if (n8 < 0) {
                n8 = FileInfo.getBegAddr(byArray, fileFormat);
            }
            if (n8 >= 0) {
                stringBuilder.append(String.format("%04X", n8));
                if (n9 < 0) {
                    n9 = FileInfo.getEndAddr(byArray, fileFormat);
                }
                if (n9 >= n8) {
                    stringBuilder.append(String.format("-%04X", n9));
                    n6 = FileInfo.getStartAddr(byArray, fileFormat);
                    if (n6 >= n8 && n6 <= n9) {
                        stringBuilder.append(String.format(" Start=%04X", n6));
                    }
                }
            }
            if (n7 != -1) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("Typ=");
                stringBuilder.append((char)n7);
            }
            fileInfo = new FileInfo(byArray, l, n7, fileFormat, string2, FileInfo.getFileDesc(byArray, fileFormat), stringBuilder.length() > 0 ? stringBuilder.toString() : null, n10);
        }
        return fileInfo;
    }

    public LoadData createLoadData(byte[] byArray) throws IOException {
        return FileInfo.createLoadData(byArray, this.fileFmt);
    }

    public static LoadData createLoadData(byte[] byArray, FileFormat fileFormat) throws IOException {
        LoadData loadData = null;
        if (fileFormat != null) {
            if (fileFormat.equals(FileFormat.KCTAP_BASIC_DATA) || fileFormat.equals(FileFormat.KCTAP_BASIC_ASC) || fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC) || fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC_BLKN_CKS) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA_BLKN_CKS)) {
                throw new IOException("Laden von KC-BASIC-Datenfeldern und KC-BASIC-ASCII-Listings\nwird nicht unterst\u00fctzt");
            }
            if (fileFormat.equals(FileFormat.KCB_BLKN)) {
                byArray = FileInfo.removeKCBlockNums(byArray);
                fileFormat = FileFormat.KCB;
            } else if (fileFormat.equals(FileFormat.KCC_BLKN)) {
                byArray = FileInfo.removeKCBlockNums(byArray);
                fileFormat = FileFormat.KCC;
            } else if (fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN)) {
                byArray = FileInfo.removeKCBlockNums(byArray);
                fileFormat = FileFormat.KCBASIC_HEAD_PRG;
            } else if (fileFormat.equals(FileFormat.KCB_BLKN_CKS)) {
                byArray = FileInfo.removeKCBlockNumsAndChecksums(byArray);
                fileFormat = FileFormat.KCB;
            } else if (fileFormat.equals(FileFormat.KCC_BLKN_CKS)) {
                byArray = FileInfo.removeKCBlockNumsAndChecksums(byArray);
                fileFormat = FileFormat.KCC;
            } else if (fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS)) {
                byArray = FileInfo.removeKCBlockNumsAndChecksums(byArray);
                fileFormat = FileFormat.KCBASIC_HEAD_PRG;
            }
            if (fileFormat.equals(FileFormat.CDT) || fileFormat.equals(FileFormat.TZX) || fileFormat.equals(FileFormat.ZXTAP)) {
                throw new IOException("Die Datei ist eine Tape-Datei und kann nur\n\u00fcber die emulierte Kassettenschnittstelle\n(Audiofunktion) geladen werden.");
            }
            if (fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85) || fileFormat.equals(FileFormat.KCTAP_BASIC_PRG)) {
                loadData = FileInfo.createLoadDataFromKCTAP(byArray, fileFormat);
            } else if (fileFormat.equals(FileFormat.INTELHEX)) {
                loadData = FileInfo.createLoadDataFromINTELHEX(byArray);
            } else {
                int n = -1;
                int n2 = -1;
                if (fileFormat.equals(FileFormat.HEADERSAVE)) {
                    if (byArray.length >= 32) {
                        n = EmuUtil.getWord(byArray, 0);
                        n2 = (EmuUtil.getWord(byArray, 2) - n & 0xFFFF) + 1;
                    }
                    loadData = new LoadData(byArray, 32, n2, n, -1, fileFormat);
                    int n3 = byArray[12] & 0xFF;
                    if (n3 == 67) {
                        loadData.setStartAddr(EmuUtil.getWord(byArray, 4));
                    }
                    loadData.setFileType(n3);
                } else if (fileFormat.equals(FileFormat.KCB)) {
                    int n4 = EmuUtil.getWord(byArray, 17);
                    int n5 = EmuUtil.getWord(byArray, 19);
                    if (n4 > 1025 || n5 < 1033) {
                        new IOException("Laden als KCB-Datei nicht m\u00f6glich");
                    }
                    n = 1025;
                    int n6 = -1;
                    int n7 = n;
                    do {
                        if ((n6 = EmuUtil.getWord(byArray, 128 + n7 - n4)) > 0 && n6 <= n7 || n6 >= n5) {
                            new IOException("Laden als KCB-Datei nicht m\u00f6glich");
                        }
                        n2 = n7 - n + 2;
                    } while ((n7 = n6) > 0);
                    loadData = new LoadData(byArray, 128 + n - n4, n2, n, -1, fileFormat);
                    loadData.setInfoMsg("Es wird nur das eigentliche KC-BASIC-Programm geladen.\nEventuell in der Datei enthaltener Maschinencode oder\nsonstige Daten werden nicht geladen!\nWenn Sie das w\u00fcnschen, m\u00fcssen Sie die Datei\nals KCC-Datei laden.");
                } else if (fileFormat.equals(FileFormat.KCC)) {
                    if (byArray.length >= 128) {
                        n = EmuUtil.getWord(byArray, 17);
                        n2 = EmuUtil.getWord(byArray, 19) - n + 1 & 0xFFFF;
                    }
                    loadData = new LoadData(byArray, 128, n2, n, -1, fileFormat);
                    if (byArray[16] >= 3) {
                        loadData.setStartAddr(EmuUtil.getWord(byArray, 21));
                    }
                } else if (fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG)) {
                    if (byArray.length > 12) {
                        n2 = EmuUtil.getWord(byArray, 11);
                    }
                    if (n2 <= 0) {
                        new IOException("Laden als KC-BASIC-Datei nicht m\u00f6glich");
                    }
                    loadData = new LoadData(byArray, 13, n2, FileInfo.getKCBasicBegAddr(byArray, 14), -1, fileFormat);
                } else if (fileFormat.equals(FileFormat.KCBASIC_PRG)) {
                    if (byArray.length > 1) {
                        n2 = EmuUtil.getWord(byArray, 0);
                    }
                    if (n2 <= 0) {
                        new IOException("Laden als KC-BASIC-Datei nicht m\u00f6glich");
                    }
                    loadData = new LoadData(byArray, 2, n2, FileInfo.getKCBasicBegAddr(byArray, 3), -1, fileFormat);
                } else if (fileFormat.equals(FileFormat.BASIC_PRG)) {
                    if (byArray.length > 1) {
                        n = FileInfo.getBegAddr(byArray, fileFormat);
                    }
                    if (n < 0) {
                        new IOException("Laden als BASIC-Datei nicht m\u00f6glich");
                    }
                    loadData = new LoadData(byArray, 0, byArray.length, n, -1, fileFormat);
                } else if (fileFormat.equals(FileFormat.RBASIC_PRG)) {
                    loadData = new LoadData(byArray, 1, byArray.length, 32769, -1, fileFormat);
                } else if (fileFormat.equals(FileFormat.RMC)) {
                    n = EmuUtil.getWord(byArray, 1);
                    loadData = new LoadData(byArray, 7, (EmuUtil.getWord(byArray, 3) - n & 0xFFFF) + 1, n, EmuUtil.getWord(byArray, 5) - n & 0xFFFF, fileFormat);
                }
            }
        }
        if (loadData == null) {
            loadData = new LoadData(byArray, 0, byArray.length, -1, -1, fileFormat);
        }
        return loadData;
    }

    public static LoadData createLoadData(File file) throws IOException {
        LoadData loadData = null;
        byte[] byArray = FileInfo.readFile(file);
        if (byArray != null) {
            FileInfo fileInfo = FileInfo.analyzeFile(byArray, file);
            loadData = fileInfo != null ? FileInfo.createLoadData(byArray, fileInfo.getFileFormat()) : new LoadData(byArray, 0, byArray.length, -1, -1, null);
        }
        return loadData;
    }

    public boolean equalsFileFormat(FileFormat fileFormat) {
        return this.fileFmt != null && fileFormat != null ? this.fileFmt.equals(fileFormat) : false;
    }

    public String getAddrText() {
        return this.addrText;
    }

    public static int getBegAddr(byte[] byArray, FileFormat fileFormat) {
        int n = -1;
        if (byArray != null && fileFormat != null) {
            if (fileFormat.equals(FileFormat.HEADERSAVE) && byArray.length > 1) {
                n = EmuUtil.getWord(byArray, 0);
            } else if (fileFormat.equals(FileFormat.KCB) && byArray.length > 20) {
                if (EmuUtil.getWord(byArray, 17) <= 1025 && EmuUtil.getWord(byArray, 19) >= 1033) {
                    n = 1025;
                }
            } else if ((fileFormat.equals(FileFormat.KCB_BLKN) || fileFormat.equals(FileFormat.KCB_BLKN_CKS)) && byArray.length > 21) {
                if (EmuUtil.getWord(byArray, 18) <= 1025 && EmuUtil.getWord(byArray, 20) >= 1033) {
                    n = 1025;
                }
            } else if (fileFormat.equals(FileFormat.KCC) && byArray.length > 18) {
                n = EmuUtil.getWord(byArray, 17);
            } else if ((fileFormat.equals(FileFormat.KCC_BLKN) || fileFormat.equals(FileFormat.KCC_BLKN_CKS)) && byArray.length > 19) {
                n = EmuUtil.getWord(byArray, 18);
            } else if ((fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85)) && byArray.length > 35) {
                n = EmuUtil.getWord(byArray, 34);
            } else if (fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) && byArray.length > 31) {
                n = FileInfo.getKCBasicBegAddr(byArray, 31);
            } else if (fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG) && byArray.length > 14) {
                n = FileInfo.getKCBasicBegAddr(byArray, 14);
            } else if ((fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS)) && byArray.length > 15) {
                n = FileInfo.getKCBasicBegAddr(byArray, 15);
            } else if (fileFormat.equals(FileFormat.KCBASIC_PRG) && byArray.length > 3) {
                n = FileInfo.getKCBasicBegAddr(byArray, 3);
            } else if (fileFormat.equals(FileFormat.BASIC_PRG)) {
                switch (byArray[1] & 0xFF) {
                    case 16: 
                    case 17: {
                        n = 4097;
                        break;
                    }
                    case 4: 
                    case 5: {
                        n = 1025;
                        break;
                    }
                    case 96: 
                    case 97: {
                        n = 24823;
                        break;
                    }
                    case 99: {
                        n = 25344;
                        break;
                    }
                    case 111: 
                    case 112: {
                        n = 28599;
                        break;
                    }
                    case 44: 
                    case 45: {
                        n = 11265;
                        break;
                    }
                    case 54: 
                    case 55: {
                        n = 14192;
                    }
                }
            } else if (fileFormat.equals(FileFormat.RBASIC_PRG)) {
                n = 32769;
            } else if (fileFormat.equals(FileFormat.RMC) && byArray.length > 2) {
                n = EmuUtil.getWord(byArray, 1);
            } else if (fileFormat.equals(FileFormat.INTELHEX) && byArray.length > 6) {
                char c = (char)(byArray[3] & 0xFF);
                char c2 = (char)(byArray[4] & 0xFF);
                char c3 = (char)(byArray[5] & 0xFF);
                char c4 = (char)(byArray[6] & 0xFF);
                if ((byArray[0] & 0xFF) == 58 && EmuUtil.isHexChar(c) && EmuUtil.isHexChar(c2) && EmuUtil.isHexChar(c3) && EmuUtil.isHexChar(c4)) {
                    n = FileInfo.getHexValue(c) << 12 | FileInfo.getHexValue(c2) << 8 | FileInfo.getHexValue(c3) << 4 | FileInfo.getHexValue(c4);
                }
            }
        }
        return n;
    }

    public int getBegAddr() {
        return FileInfo.getBegAddr(this.header, this.fileFmt);
    }

    public static int getEndAddr(byte[] byArray, FileFormat fileFormat) {
        int n = -1;
        if (byArray != null && fileFormat != null) {
            if (fileFormat.equals(FileFormat.HEADERSAVE) && byArray.length > 3) {
                n = EmuUtil.getWord(byArray, 2);
            } else if (fileFormat.equals(FileFormat.KCB) && byArray.length > 20) {
                int n2 = EmuUtil.getWord(byArray, 19) - 1 & 0xFFFF;
                if (EmuUtil.getWord(byArray, 17) <= 1025 && n2 >= 1033) {
                    n = n2 > 0 ? n2 : 65535;
                }
            } else if ((fileFormat.equals(FileFormat.KCB_BLKN) || fileFormat.equals(FileFormat.KCB_BLKN_CKS)) && byArray.length > 21) {
                int n3 = EmuUtil.getWord(byArray, 20) - 1 & 0xFFFF;
                if (EmuUtil.getWord(byArray, 18) <= 1025 && n3 >= 1033) {
                    n = n3 > 0 ? n3 : 65535;
                }
            } else if (fileFormat.equals(FileFormat.KCC) && byArray.length > 20) {
                n = EmuUtil.getWord(byArray, 19) - 1 & 0xFFFF;
                if (n == 0 && EmuUtil.getWord(byArray, 17) != 0) {
                    n = 65535;
                }
            } else if ((fileFormat.equals(FileFormat.KCC_BLKN) || fileFormat.equals(FileFormat.KCC_BLKN_CKS)) && byArray.length > 21) {
                n = EmuUtil.getWord(byArray, 20) - 1 & 0xFFFF;
                if (n == 0 && EmuUtil.getWord(byArray, 18) != 0) {
                    n = 65535;
                }
            } else if ((fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001)) && byArray.length > 37) {
                n = EmuUtil.getWord(byArray, 36) & 0xFFFF;
                if (n == 0 && EmuUtil.getWord(byArray, 34) != 0) {
                    n = 65535;
                }
            } else if (fileFormat.equals(FileFormat.KCTAP_KC85) && byArray.length > 37) {
                n = EmuUtil.getWord(byArray, 36) - 1 & 0xFFFF;
                if (n == 0 && EmuUtil.getWord(byArray, 34) != 0) {
                    n = 65535;
                }
            } else if (fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) && byArray.length > 31) {
                n = EmuUtil.getWord(byArray, 28) + ((byArray[31] & 0xFF) << 8);
            } else if (fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG) && byArray.length > 14) {
                n = EmuUtil.getWord(byArray, 11) + ((byArray[14] & 0xFF) << 8);
            } else if ((fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS)) && byArray.length > 15) {
                n = EmuUtil.getWord(byArray, 12) + ((byArray[15] & 0xFF) << 8);
            } else if (fileFormat.equals(FileFormat.KCBASIC_PRG) && byArray.length > 3) {
                n = EmuUtil.getWord(byArray, 0) + ((byArray[3] & 0xFF) << 8);
            } else if (fileFormat.equals(FileFormat.RMC) && byArray.length > 4) {
                n = EmuUtil.getWord(byArray, 3);
            }
        }
        return n;
    }

    public int getEndAddr() {
        return FileInfo.getEndAddr(this.header, this.fileFmt);
    }

    public String getFileDesc() {
        return this.fileDesc;
    }

    public static String getFileDesc(byte[] byArray, FileFormat fileFormat) {
        String string = null;
        if (byArray != null && fileFormat != null) {
            if (fileFormat.equals(FileFormat.HEADERSAVE) && byArray.length >= 32) {
                string = FileInfo.getFileDesc(byArray, 16, 16);
            } else if ((fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85)) && byArray.length >= 28) {
                String string2;
                string = FileInfo.getFileDesc(byArray, 17, 11);
                if (string != null && string.length() < 8 && (string2 = FileInfo.getFileDesc(byArray, 25, 3)) != null) {
                    string = string + "." + string2;
                }
            } else if ((fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) || fileFormat.equals(FileFormat.KCTAP_BASIC_DATA) || fileFormat.equals(FileFormat.KCTAP_BASIC_ASC)) && byArray.length >= 28) {
                string = FileInfo.getFileDesc(byArray, 20, 8);
            } else if ((fileFormat.equals(FileFormat.KCB) || fileFormat.equals(FileFormat.KCC)) && byArray.length >= 11) {
                String string3;
                string = FileInfo.getFileDesc(byArray, 0, 11);
                if (string != null && string.length() < 8 && (string3 = FileInfo.getFileDesc(byArray, 8, 3)) != null) {
                    string = string + "." + string3;
                }
            } else if ((fileFormat.equals(FileFormat.KCB_BLKN) || fileFormat.equals(FileFormat.KCB_BLKN_CKS) || fileFormat.equals(FileFormat.KCC_BLKN) || fileFormat.equals(FileFormat.KCC_BLKN_CKS)) && byArray.length >= 12) {
                String string4;
                string = FileInfo.getFileDesc(byArray, 1, 11);
                if (string != null && string.length() < 8 && (string4 = FileInfo.getFileDesc(byArray, 9, 3)) != null) {
                    string = string + "." + string4;
                }
            } else if ((fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG)) && byArray.length >= 11) {
                string = FileInfo.getFileDesc(byArray, 3, 8);
            } else if ((fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_ASC_BLKN_CKS) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_DATA_BLKN_CKS) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS)) && byArray.length >= 12) {
                string = FileInfo.getFileDesc(byArray, 4, 8);
            }
        }
        return string;
    }

    public FileFormat getFileFormat() {
        return this.fileFmt;
    }

    public String getFileText() {
        return this.fileText;
    }

    public int getFileType() {
        return this.fileType;
    }

    public static int getFileType(byte[] byArray, FileFormat fileFormat) {
        int n = -1;
        if (byArray != null && fileFormat != null && fileFormat.equals(FileFormat.HEADERSAVE) && byArray.length > 12) {
            n = byArray[12] & 0xFF;
        }
        return n;
    }

    public String getInfoText() {
        return this.infoText;
    }

    public int getNextTAPOffset() {
        return this.nextTAPOffs;
    }

    public static int getStartAddr(byte[] byArray, FileFormat fileFormat) {
        int n = -1;
        if (byArray != null && fileFormat != null) {
            if (fileFormat.equals(FileFormat.HEADERSAVE) && byArray.length > 12) {
                if ((byArray[12] & 0xFF) == 67) {
                    n = EmuUtil.getWord(byArray, 4);
                }
            } else if (fileFormat.equals(FileFormat.KCC) && byArray.length > 22) {
                n = EmuUtil.getWord(byArray, 21);
                if (n == 0) {
                    n = -1;
                }
            } else if ((fileFormat.equals(FileFormat.KCC_BLKN) || fileFormat.equals(FileFormat.KCC_BLKN_CKS)) && byArray.length > 23) {
                n = EmuUtil.getWord(byArray, 22);
                if (n == 0) {
                    n = -1;
                }
            } else if ((fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85)) && byArray.length > 39) {
                n = EmuUtil.getWord(byArray, 38);
                if (n == 0) {
                    n = -1;
                }
            } else if (fileFormat.equals(FileFormat.RMC)) {
                n = EmuUtil.getWord(byArray, 5);
            }
        }
        return n;
    }

    public int getStartAddr() {
        return FileInfo.getStartAddr(this.header, this.fileFmt);
    }

    public static boolean isCswMagicAt(byte[] byArray, int n) {
        return EmuUtil.isTextAt(CSW_MAGIC, byArray, n);
    }

    public static boolean isKCBasicProgramFormat(FileFormat fileFormat) {
        boolean bl = false;
        if (fileFormat != null) {
            bl = fileFormat.equals(FileFormat.KCB) || fileFormat.equals(FileFormat.KCB_BLKN) || fileFormat.equals(FileFormat.KCB_BLKN_CKS) || fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS) || fileFormat.equals(FileFormat.KCBASIC_PRG);
        }
        return bl;
    }

    public boolean isKCBasicProgramFormat() {
        return FileInfo.isKCBasicProgramFormat(this.fileFmt);
    }

    public static boolean isKCTapMagicAt(byte[] byArray, int n) {
        return EmuUtil.isTextAt(KCTAP_MAGIC, byArray, n);
    }

    public boolean isTapeFile() {
        boolean bl = false;
        if (this.fileFmt != null && (this.fileFmt.equals(FileFormat.CDT) || this.fileFmt.equals(FileFormat.CSW) || this.fileFmt.equals(FileFormat.TZX) || this.fileFmt.equals(FileFormat.ZXTAP))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTzxMagicAt(byte[] byArray, int n) {
        return EmuUtil.isTextAt(TZX_MAGIC, byArray, n);
    }

    public static byte[] readFile(File file) throws IOException {
        return EmuUtil.readFile(file, false, 851968);
    }

    private FileInfo(byte[] byArray, long l, int n, FileFormat fileFormat, String string, String string2, String string3, int n2) {
        this.header = byArray;
        this.fileLen = l;
        this.fileType = n;
        this.fileFmt = fileFormat;
        this.fileText = string;
        this.fileDesc = string2;
        this.addrText = string3;
        this.nextTAPOffs = n2;
        this.infoText = null;
        if (this.fileText == null && fileFormat != null) {
            this.fileText = fileFormat.toString();
        }
        if (this.fileText != null && !this.fileText.isEmpty()) {
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(this.fileText);
            if (this.addrText != null) {
                if (bl) {
                    stringBuilder.append(": ");
                    bl = false;
                }
                stringBuilder.append(this.addrText);
            }
            if (this.fileDesc != null) {
                if (bl) {
                    stringBuilder.append(": ");
                } else if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.fileDesc);
            }
            this.infoText = stringBuilder.toString();
        }
    }

    private static LoadData createLoadDataFromINTELHEX(byte[] byArray) throws IOException {
        byte[] byArray2;
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        boolean bl = true;
        int n = -1;
        int n2 = -1;
        int n3 = byteArrayInputStream.read();
        while (bl && n3 != -1) {
            while (n3 != -1 && n3 != 58) {
                n3 = byteArrayInputStream.read();
            }
            if (n3 == -1) continue;
            int n4 = FileInfo.parseHex(byteArrayInputStream, 4);
            int n5 = FileInfo.parseHex(byteArrayInputStream, 2);
            switch (n5) {
                case 0: {
                    int n6;
                    if (n6 <= 0) break;
                    if (n < 0) {
                        n = n4;
                        n2 = n4;
                    }
                    if (n4 == n2) {
                        while (n6 > 0) {
                            byteArrayOutputStream.write(FileInfo.parseHex(byteArrayInputStream, 2));
                            --n6;
                            ++n2;
                        }
                        break;
                    }
                    string = "Die Datei enth\u00e4lt mehrere nicht zusammenh\u00e4ngende Datenbereiche.\nEs wurde nur der erste Bereich geladen.";
                    break;
                }
                case 1: {
                    bl = false;
                    break;
                }
                case 2: {
                    int n6;
                    for (n6 = FileInfo.parseHex(byteArrayInputStream, 2); n6 > 0; --n6) {
                        if (FileInfo.parseHex(byteArrayInputStream, 2) == 0) continue;
                        string = "Die Datei enth\u00e4lt einen Datensatz f\u00fcr eine segmentierte Adresse,\nder von JKCEMU nicht unterst\u00fctzt wird.\nEs werden nur die Daten bis zu diesem Datensatz geladen.";
                    }
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    int n6;
                    while (n6 > 0) {
                        if (FileInfo.parseHex(byteArrayInputStream, 2) != 0) {
                            string = "Die Datei enth\u00e4lt einen Datensatz f\u00fcr eine lineare 32-Bit-Adresse,\ndie au\u00dferhalb des von JKCEMU emulierten Adressraumes liegt.\nEs werden nur die Daten bis zu diesem Datensatz geladen.";
                        }
                        --n6;
                    }
                    break;
                }
                default: {
                    string = String.format("Die Datei enth\u00e4lt einen Datensatzart des Typs %d,\nder von JKCEMU nicht unterst\u00fctzt wird.\nEs werden nur die Daten bis zu diesem Datensatz geladen.", n5);
                }
            }
            if (string != null) {
                if (byteArrayOutputStream.size() == 0) {
                    throw new IOException(string);
                }
                bl = false;
            }
            n3 = byteArrayInputStream.read();
        }
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        LoadData loadData = null;
        if (n >= 0 && (byArray2 = byteArrayOutputStream.toByteArray()) != null && byArray2.length > 0) {
            loadData = new LoadData(byArray2, 0, byArray2.length, n, -1, FileFormat.INTELHEX);
        }
        if (loadData == null) {
            new IOException("Laden als Intel-HEX-Datei nicht m\u00f6glich");
        }
        loadData.setInfoMsg(string);
        return loadData;
    }

    private static LoadData createLoadDataFromKCTAP(byte[] byArray, FileFormat fileFormat) throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        if ((fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85)) && byArray.length > 39) {
            n = EmuUtil.getWord(byArray, 34);
            n3 = EmuUtil.getWord(byArray, 36) - n + 1 & 0xFFFF;
            n2 = EmuUtil.getWord(byArray, 38);
            if (n2 == 0) {
                n2 = -1;
            }
            n4 = 145;
        } else if (fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) && byArray.length > 31) {
            n = FileInfo.getKCBasicBegAddr(byArray, 31);
            n3 = EmuUtil.getWord(byArray, 28);
            n4 = 30;
            n5 = 115;
            bl = true;
        }
        if (n < 0 || n3 <= 0) {
            throw new IOException("Laden als KC-TAP-Datei nicht m\u00f6glich");
        }
        byte[] byArray2 = new byte[n3];
        int n6 = 0;
        int n7 = n3;
        while (n7 > 0 && n4 < byArray.length && n6 < byArray2.length) {
            if (n5 == 0) {
                n5 = 128;
            } else {
                byArray2[n6++] = byArray[n4];
                --n7;
                --n5;
            }
            ++n4;
        }
        LoadData loadData = new LoadData(byArray2, 0, n3 - n7, n, n2, fileFormat);
        return loadData;
    }

    private static String getFileDesc(byte[] byArray, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n4 = 0;
        while (n2 > 0 && n < byArray.length && (n3 = byArray[n++] & 0xFF) != 0) {
            if (n3 == 32) {
                ++n4;
            } else if (n3 > 32 && Character.isDefined(n3)) {
                while (n4 > 0) {
                    stringBuilder.append(' ');
                    --n4;
                }
                stringBuilder.append((char)n3);
            }
            --n2;
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private static int getHexValue(char c) {
        int n = -1;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'A' && c <= 'Z') {
            n = c - 65 + 10;
        } else if (c >= 'a' && c <= 'z') {
            n = c - 97 + 10;
        }
        return n;
    }

    private static int getKCBasicBegAddr(byte[] byArray, int n) {
        int n2 = -1;
        if (byArray != null && n >= 0 && n < byArray.length) {
            n2 = (byArray[n] & 0xFF) < 44 ? 1025 : 11265;
        }
        return n2;
    }

    private static boolean hasKCBlkNums(byte[] byArray, AtomicBoolean atomicBoolean) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        if (byArray != null && byArray.length > 0 && ((n = byArray[0] & 0xFF) == 0 || n == 1)) {
            int n2;
            int n3;
            if (byArray.length > 129) {
                n3 = 0;
                for (n2 = 1; n2 <= 128; ++n2) {
                    n3 += byArray[n2] & 0xFF;
                }
                if ((n3 & 0xFF) == (byArray[129] & 0xFF)) {
                    bl2 = true;
                }
            }
            bl = true;
            for (n2 = n3 = bl2 ? 130 : 129; n2 < byArray.length; n2 += n3) {
                int n4 = byArray[n2] & 0xFF;
                if (n4 == 255) {
                    if (n2 + n3 >= byArray.length) break;
                    bl = false;
                    break;
                }
                if (n4 != n + 1) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (atomicBoolean != null) {
            atomicBoolean.set(bl2);
        }
        return bl;
    }

    private static int parseHex(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3 = inputStream.read();
            if (n3 >= 48 && n3 <= 57) {
                n2 = n2 << 4 | n3 - 48 & 0xF;
            } else if (n3 >= 65 && n3 <= 70) {
                n2 = n2 << 4 | n3 - 65 + 10 & 0xF;
            } else if (n3 >= 97 && n3 <= 102) {
                n2 = n2 << 4 | n3 - 97 + 10 & 0xF;
            } else {
                throw new IOException("Datei entspricht nicht dem erwarteten HEX-Format.");
            }
            --n;
        }
        return n2;
    }

    private static byte[] removeKCBlockNums(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                if (i % 129 == 0) continue;
                byteArrayOutputStream.write(by);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        return byArray2;
    }

    private static byte[] removeKCBlockNumsAndChecksums(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                if (i % 130 == 0 || i % 130 == 129) continue;
                byteArrayOutputStream.write(by);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        return byArray2;
    }
}

