/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.swing.JProgressBar;

public class FileProgressInputStream
extends InputStream {
    private RandomAccessFile in;
    private long inRead;
    private long inLen;
    private long inEnd;
    private long progressUpdPeriod;
    private long progressUpdCounter;
    private JProgressBar progressBar;

    public FileProgressInputStream(File file, JProgressBar jProgressBar, int n) throws IOException {
        this.in = new RandomAccessFile(file, "r");
        try {
            this.inLen = this.in.length();
        }
        catch (IOException iOException) {
            try {
                this.in.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        this.inRead = 0L;
        this.inEnd = this.inLen * (long)n;
        this.progressUpdPeriod = this.inEnd / 100L;
        this.progressUpdCounter = 0L;
        this.progressBar = jProgressBar;
        this.fireProgressValues(0, 100, 0);
    }

    public long length() throws IOException {
        return this.inLen;
    }

    public void seek(long l) throws IOException {
        this.in.seek(l);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        ++this.inRead;
        if (this.progressUpdCounter < this.progressUpdPeriod) {
            ++this.progressUpdCounter;
        } else {
            this.progressUpdCounter = 0L;
            if (this.progressUpdPeriod > 0L && this.inEnd > 0L) {
                this.fireProgressValues(-1, -1, (int)Math.round((double)this.inRead / (double)this.inEnd * 100.0));
            }
        }
        return this.in.read();
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = l;
        long l3 = this.in.getFilePointer();
        if (l3 + l > this.inLen) {
            l2 = this.inLen - l3;
        }
        this.in.seek(l3 + l2);
        return l2;
    }

    private void fireProgressValues(final int n, final int n2, final int n3) {
        final JProgressBar jProgressBar = this.progressBar;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n >= 0) {
                    jProgressBar.setMinimum(n);
                }
                if (n2 >= 0) {
                    jProgressBar.setMaximum(n2);
                }
                if (n3 >= 0) {
                    jProgressBar.setValue(n3);
                }
            }
        });
    }
}

