/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jkcemu.base.FileEntry;

public class FileTableModel
extends AbstractTableModel
implements Comparator<FileEntry> {
    private static DateFormat dateFmt = null;
    private Column[] cols;
    private List<FileEntry> rows;
    private boolean sortCaseSensitive;
    private boolean sortDesc;
    private Column sortCol;

    public FileTableModel(Column ... columnArray) {
        this.cols = columnArray;
        this.rows = new ArrayList<FileEntry>();
        this.sortCol = Column.NAME;
        this.sortCaseSensitive = false;
        this.sortDesc = false;
    }

    public void addRow(FileEntry fileEntry, boolean bl) {
        int n = this.rows.size();
        this.rows.add(fileEntry);
        if (bl) {
            this.fireTableRowsInserted(n, n);
        }
    }

    public void clear(boolean bl) {
        this.rows.clear();
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public FileEntry getRow(int n) {
        return n >= 0 && n < this.rows.size() ? this.rows.get(n) : null;
    }

    public void removeRow(int n, boolean bl) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.remove(n);
            if (bl) {
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public void setRow(int n, FileEntry fileEntry) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.set(n, fileEntry);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void setSortCaseSensitive(boolean bl) {
        this.sortCaseSensitive = bl;
    }

    public void sort(int n) {
        if (n >= 0 && n < this.cols.length) {
            if (this.cols[n] == this.sortCol) {
                this.sortDesc = !this.sortDesc;
            } else {
                this.sortCol = this.cols[n];
                this.sortDesc = false;
            }
            try {
                Collections.sort(this.rows, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireTableDataChanged();
        }
    }

    public void sortAscending(int n) {
        if (n >= 0 && n < this.cols.length) {
            this.sortCol = this.cols[n];
            this.sortDesc = false;
            try {
                Collections.sort(this.rows, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public int compare(FileEntry fileEntry, FileEntry fileEntry2) {
        int n = 0;
        if (fileEntry != null && fileEntry2 != null) {
            switch (this.sortCol) {
                case INFO: {
                    n = this.compareObject(fileEntry.getInfo(), fileEntry2.getInfo());
                    break;
                }
                case SIZE: {
                    n = this.compareLong(fileEntry.getSize(), fileEntry2.getSize());
                    break;
                }
                case LAST_MODIFIED: {
                    n = this.compareLong(fileEntry.getLastModified(), fileEntry2.getLastModified());
                    break;
                }
                case FILE: {
                    n = this.compareFile(fileEntry.getFile(), fileEntry2.getFile());
                    break;
                }
                case USER_NUM: {
                    n = this.compareObject(fileEntry.getUserNum(), fileEntry2.getUserNum());
                    break;
                }
                case VALUE: {
                    n = this.compareObject(fileEntry.getValue(), fileEntry2.getValue());
                }
            }
            if (n == 0) {
                n = this.compareString(fileEntry.getName(), fileEntry2.getName());
            }
        }
        return this.sortDesc ? -n : n;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class<Object> clazz = Object.class;
        if (n >= 0 && n < this.cols.length) {
            switch (this.cols[n]) {
                case LAST_MODIFIED: 
                case NAME: {
                    clazz = String.class;
                    break;
                }
                case FILE: {
                    clazz = File.class;
                    break;
                }
                case SIZE: {
                    clazz = Long.class;
                    break;
                }
                case USER_NUM: {
                    clazz = Integer.class;
                    break;
                }
                case READ_ONLY: 
                case SYSTEM_FILE: 
                case ARCHIVE: {
                    clazz = Boolean.class;
                }
            }
        }
        return clazz;
    }

    @Override
    public int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (n >= 0 && n < this.cols.length) {
            switch (this.cols[n]) {
                case NAME: {
                    string = "Name";
                    break;
                }
                case INFO: {
                    string = "Typ/Gr\u00f6\u00dfe";
                    break;
                }
                case SIZE: {
                    string = "Gr\u00f6\u00dfe";
                    break;
                }
                case LAST_MODIFIED: {
                    string = "Zuletzt ge\u00e4ndert";
                    break;
                }
                case FILE: {
                    string = "Datei";
                    break;
                }
                case USER_NUM: {
                    string = "User";
                    break;
                }
                case VALUE: {
                    string = "Wert";
                    break;
                }
                case READ_ONLY: {
                    string = "Schreibgesch\u00fctzt";
                    break;
                }
                case SYSTEM_FILE: {
                    string = "System-Datei";
                    break;
                }
                case ARCHIVE: {
                    string = "Archiv";
                }
            }
        }
        return string;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FileEntry fileEntry;
        Object object = null;
        if (n >= 0 && n < this.rows.size() && n2 >= 0 && n2 < this.cols.length && (fileEntry = this.rows.get(n)) != null) {
            switch (this.cols[n2]) {
                case NAME: {
                    object = fileEntry.getName();
                    break;
                }
                case INFO: {
                    object = fileEntry.getInfo();
                    break;
                }
                case SIZE: {
                    object = fileEntry.getSize();
                    break;
                }
                case LAST_MODIFIED: {
                    Long l = fileEntry.getLastModified();
                    if (l == null) break;
                    if (dateFmt == null) {
                        dateFmt = DateFormat.getDateTimeInstance(2, 2);
                    }
                    object = dateFmt.format(new Date(l));
                    break;
                }
                case FILE: {
                    object = fileEntry.getFile();
                    break;
                }
                case USER_NUM: {
                    object = fileEntry.getUserNum();
                    break;
                }
                case VALUE: {
                    object = fileEntry.getValue();
                    break;
                }
                case READ_ONLY: {
                    object = FileTableModel.toBoolean(fileEntry.isReadOnly());
                    break;
                }
                case SYSTEM_FILE: {
                    object = FileTableModel.toBoolean(fileEntry.isSystemFile());
                    break;
                }
                case ARCHIVE: {
                    object = FileTableModel.toBoolean(fileEntry.isArchive());
                }
            }
        }
        return object;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0 && n2 < this.cols.length) {
            switch (this.cols[n2]) {
                case READ_ONLY: 
                case SYSTEM_FILE: 
                case ARCHIVE: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        FileEntry fileEntry;
        if (n >= 0 && n < this.rows.size() && n2 >= 0 && n2 < this.cols.length && (fileEntry = this.rows.get(n)) != null) {
            boolean bl = true;
            switch (this.cols[n2]) {
                case READ_ONLY: {
                    fileEntry.setReadOnly(FileTableModel.parseBoolean(object));
                    bl = true;
                    break;
                }
                case SYSTEM_FILE: {
                    fileEntry.setSystemFile(FileTableModel.parseBoolean(object));
                    bl = true;
                    break;
                }
                case ARCHIVE: {
                    fileEntry.setArchive(FileTableModel.parseBoolean(object));
                    bl = true;
                }
            }
            if (bl) {
                this.fireTableRowsUpdated(n, n);
            }
        }
    }

    private int compareObject(Object object, Object object2) {
        long l;
        long l2;
        int n = 0;
        n = object != null && object2 != null ? (object instanceof Number && object2 instanceof Number ? ((l2 = ((Number)object).longValue()) < (l = ((Number)object2).longValue()) ? -1 : (l2 > l ? 1 : 0)) : (object instanceof Number ? 1 : (object2 instanceof Number ? -1 : this.compareString(object, object2)))) : this.compareString(object, object2);
        return n;
    }

    private int compareFile(File file, File file2) {
        int n = 0;
        if (file != null && file2 != null) {
            n = this.compareString(file.getName(), file2.getName());
        } else if (file != null && file2 == null) {
            n = 1;
        } else if (file == null && file2 != null) {
            n = -1;
        }
        return n;
    }

    private int compareLong(Long l, Long l2) {
        int n = 0;
        if (l != null && l2 != null) {
            n = l.compareTo(l2);
        } else if (l != null && l2 == null) {
            n = -1;
        } else if (l == null && l2 != null) {
            n = 1;
        }
        return n;
    }

    private int compareString(Object object, Object object2) {
        String string = null;
        String string2 = null;
        if (object != null) {
            string = object.toString();
        }
        if (object2 != null) {
            string2 = object2.toString();
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return this.sortCaseSensitive ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
    }

    private static boolean parseBoolean(Object object) {
        boolean bl = false;
        if (object != null) {
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else {
                String string = object.toString();
                if (string != null) {
                    bl = Boolean.parseBoolean(string);
                }
            }
        }
        return bl;
    }

    private static Boolean toBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static enum Column {
        NAME,
        INFO,
        SIZE,
        LAST_MODIFIED,
        FILE,
        USER_NUM,
        VALUE,
        READ_ONLY,
        SYSTEM_FILE,
        ARCHIVE;

    }
}

