/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.HelpFrm;
import jkcemu.print.PrintOptionsDlg;
import jkcemu.print.PrintUtil;
import jkcemu.text.TextUtil;

public class HTMLViewFrm
extends BaseFrm
implements CaretListener,
Printable {
    protected JEditorPane editorPane;
    protected JScrollPane scrollPane;
    private int findPos = 0;
    private Pattern findPattern = null;
    private JMenuItem mnuFilePrintOptions = null;
    private JMenuItem mnuFilePrint = null;
    private JMenuItem mnuFileClose = null;
    private JMenuItem mnuEditCopy = null;
    private JMenuItem mnuEditFind = null;
    private JMenuItem mnuEditFindNext = null;
    private JMenuItem mnuEditFindPrev = null;
    private JMenuItem mnuEditSelectAll = null;
    private JMenuItem mnuHelpContent = null;

    protected HTMLViewFrm() {
        Main.updIcon(this);
    }

    protected void createMenuBar(JMenu jMenu, JMenu jMenu2, String string) {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        if (jMenu == null) {
            jMenu = new JMenu("Datei");
            jMenu.setMnemonic(68);
        }
        jMenuBar.add(jMenu);
        this.mnuFilePrintOptions = this.createJMenuItem("Druckoptionen...");
        jMenu.add(this.mnuFilePrintOptions);
        this.mnuFilePrint = this.createJMenuItem("Drucken...", KeyStroke.getKeyStroke(80, 2));
        jMenu.add(this.mnuFilePrint);
        jMenu.addSeparator();
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuFileClose);
        JMenu jMenu3 = new JMenu("Bearbeiten");
        jMenu3.setMnemonic(66);
        jMenuBar.add(jMenu3);
        this.mnuEditCopy = this.createJMenuItem("Kopieren", KeyStroke.getKeyStroke(67, 2));
        this.mnuEditCopy.setEnabled(false);
        jMenu3.add(this.mnuEditCopy);
        jMenu3.addSeparator();
        this.mnuEditFind = this.createJMenuItem("Suchen...", KeyStroke.getKeyStroke(70, 2));
        jMenu3.add(this.mnuEditFind);
        this.mnuEditFindNext = this.createJMenuItem("Weitersuchen", KeyStroke.getKeyStroke(114, 0));
        this.mnuEditFindNext.setEnabled(false);
        jMenu3.add(this.mnuEditFindNext);
        this.mnuEditFindPrev = this.createJMenuItem("R\u00fcckw\u00e4rts suchen", KeyStroke.getKeyStroke(114, 1));
        this.mnuEditFindPrev.setEnabled(false);
        jMenu3.add(this.mnuEditFindPrev);
        jMenu3.addSeparator();
        this.mnuEditSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        jMenu3.add(this.mnuEditSelectAll);
        if (jMenu2 != null) {
            jMenuBar.add(jMenu2);
        }
        if (string != null) {
            JMenu jMenu4 = new JMenu("?");
            jMenuBar.add(jMenu4);
            this.mnuHelpContent = this.createJMenuItem("Hilfe...");
            this.mnuHelpContent.setActionCommand(string);
            jMenu4.add(this.mnuHelpContent);
        }
    }

    protected void createEditorPane(Object object) {
        this.editorPane = new JEditorPane();
        this.editorPane.setMargin(new Insets(5, 5, 5, 5));
        this.editorPane.setEditable(false);
        this.editorPane.addCaretListener(this);
        this.scrollPane = new JScrollPane(this.editorPane);
        this.add((Component)this.scrollPane, object);
    }

    protected void doFind() {
        String string;
        Object object;
        String string2 = this.editorPane.getSelectedText();
        if (string2 != null && string2.isEmpty()) {
            string2 = null;
        }
        if (string2 == null && this.findPattern != null) {
            string2 = this.findPattern.toString();
        }
        Object[] objectArray = new String[]{"Suchen", "Abbrechen"};
        JOptionPane jOptionPane = new JOptionPane("Suche nach:", -1);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(objectArray[0]);
        jOptionPane.setWantsInput(true);
        if (string2 != null) {
            jOptionPane.setInitialSelectionValue(string2);
        }
        jOptionPane.createDialog(this, "Suchen").setVisible(true);
        if (jOptionPane.getValue() == objectArray[0] && (object = jOptionPane.getInputValue()) != null && (string = object.toString()) != null && !string.isEmpty()) {
            try {
                this.findPattern = Pattern.compile(string, 82);
                this.findPos = 0;
                this.mnuEditFindNext.setEnabled(true);
                this.mnuEditFindPrev.setEnabled(true);
                this.doFindNext(false);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    private void doFindNext(boolean bl) {
        if (this.findPattern != null) {
            Matcher matcher;
            boolean bl2;
            String string = null;
            Document document = this.editorPane.getDocument();
            if (document != null) {
                try {
                    string = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (string == null) {
                string = "";
            }
            if (this.findPos > string.length()) {
                this.findPos = 0;
            }
            if (!(bl2 = this.findNext(matcher = this.findPattern.matcher(string), bl)) && this.findPos > 0) {
                this.findPos = 0;
                bl2 = this.findNext(matcher, bl);
            }
            if (!bl2) {
                TextUtil.showTextNotFound(this);
            }
        } else {
            this.doFind();
        }
    }

    protected void doPrint() {
        PrintUtil.doPrint(this, this, this.getTitle());
    }

    protected void doSelectAll() {
        final JEditorPane jEditorPane = this.editorPane;
        jEditorPane.requestFocus();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jEditorPane.selectAll();
            }
        });
    }

    public void setHTMLText(String string) {
        this.editorPane.setContentType("text/html");
        this.editorPane.setText(string);
        try {
            this.editorPane.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.editorPane.getSelectionStart();
        int n2 = this.editorPane.getSelectionEnd();
        this.mnuEditCopy.setEnabled(n >= 0 && n < n2);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        if (Main.getPrintPageNum()) {
            d4 -= 20.0;
        }
        if (d3 < 1.0 || d4 < 1.0) {
            throw new PrinterException("Die Seite hat keinen bedruckbaren Bereich,\nda die R\u00e4nder zu gro\u00df sind.");
        }
        double d5 = d3 / (double)this.editorPane.getWidth();
        int n2 = 1;
        int n3 = n * (int)Math.round(d4 / d5);
        if (n3 >= 0 && n3 < this.editorPane.getHeight()) {
            if (Main.getPrintPageNum()) {
                PrintUtil.printCenteredPageNum(graphics, pageFormat, 10, n + 1);
            }
            if (d5 < 1.0 && graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).scale(d5, d5);
                d /= d5;
                d2 /= d5;
                d3 /= d5;
                d4 /= d5;
            }
            int n4 = (int)Math.round(d);
            int n5 = (int)Math.round(d2);
            int n6 = (int)Math.round(d3);
            int n7 = (int)Math.round(d4);
            graphics.clipRect(n4, n5, n6 + 1, n7 + 1);
            graphics.translate(n4, n5 - n3);
            this.editorPane.print(graphics);
            n2 = 0;
        }
        return n2;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.mnuFilePrintOptions) {
                bl = true;
                PrintOptionsDlg.showPrintOptionsDlg(this, false, false);
            } else if (object == this.mnuFilePrint) {
                bl = true;
                this.doPrint();
            } else if (object == this.mnuFileClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuEditCopy) {
                bl = true;
                this.editorPane.copy();
            } else if (object == this.mnuEditFind) {
                bl = true;
                this.doFind();
            } else if (object == this.mnuEditFindNext) {
                bl = true;
                this.doFindNext(false);
            } else if (object == this.mnuEditFindPrev) {
                bl = true;
                this.doFindNext(true);
            } else if (object == this.mnuEditSelectAll) {
                bl = true;
                this.doSelectAll();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(this.mnuHelpContent.getActionCommand());
            }
        }
        return bl;
    }

    private boolean findNext(Matcher matcher, boolean bl) {
        int n;
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            int n3;
            n2 = 0;
            n = -1;
            while (matcher.find(n2) && (n3 = matcher.start()) < this.findPos - 1) {
                n = n3;
                n2 = n3 + 1;
            }
            if (n < 0) {
                n2 = this.findPos;
                while (matcher.find(n2)) {
                    n3 = matcher.start();
                    if (n >= 0 && n3 < n) break;
                    n = n3;
                    n2 = n3 + 1;
                }
            }
            if (n >= 0) {
                bl3 = matcher.find(n);
            }
        } else {
            bl3 = matcher.find(this.findPos);
        }
        if (bl3) {
            n2 = matcher.start();
            n = matcher.end();
            if (n2 >= 0 && n2 < n) {
                final JEditorPane jEditorPane = this.editorPane;
                jEditorPane.requestFocus();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            jEditorPane.setCaretPosition(n2);
                            jEditorPane.moveCaretPosition(n);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                this.findPos = n2 + 1;
                bl2 = true;
            }
        }
        return bl2;
    }
}

