/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexDocument
extends PlainDocument {
    private int maxLen;
    private String preErrText;

    public HexDocument(int n) {
        this(n, null);
    }

    public HexDocument(int n, String string) {
        this.maxLen = n;
        this.preErrText = "";
        if (string != null) {
            this.preErrText = string.endsWith(":") ? string + "\n" : string + ":\n";
        }
    }

    public void clear() {
        int n = this.getLength();
        if (n > 0) {
            try {
                this.remove(0, n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public Integer getInteger() throws NumberFormatException {
        Integer n = null;
        try {
            String string = this.getText(0, this.getLength());
            if (string != null && !string.isEmpty()) {
                n = this.parseHex(string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }

    public int getMaxLength() {
        return this.maxLen;
    }

    public int intValue() throws NumberFormatException {
        String string = null;
        try {
            string = this.getText(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.parseHex(string != null ? string : "");
    }

    public void setMaxLength(int n) {
        if (n > 0) {
            try {
                int n2 = this.getLength() - n;
                if (n2 > 0) {
                    this.remove(0, n2);
                }
                this.maxLen = n;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setMaxLength(int n, char c) {
        int n2;
        this.setMaxLength(n);
        if (n2 > 0) {
            try {
                String string = Character.toString(c);
                for (n2 = n - this.getLength(); n2 > 0; --n2) {
                    this.insertString(0, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setValue(int n, int n2) {
        int n3;
        String string = Integer.toHexString(n).toUpperCase();
        if (n2 > 0 && (n3 = string.length()) < n2) {
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n3; i < n2; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            string = n2 > this.maxLen && this.maxLen > 0 ? stringBuilder.substring(n2 - this.maxLen) : stringBuilder.toString();
        }
        try {
            n3 = this.getLength();
            if (n3 > 0) {
                this.remove(0, n3);
            }
            this.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        if (string != null && (n2 = string.length()) > 0) {
            int n3 = 0;
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                char c = Character.toUpperCase(string.charAt(i));
                if ((c < '0' || c > '9') && (c < 'A' || c > 'F')) continue;
                cArray[n3++] = c;
            }
            if (n3 > this.maxLen - this.getLength()) {
                n3 = this.maxLen - this.getLength();
            }
            if (n3 > 0) {
                super.insertString(n, new String(cArray, 0, n3), attributeSet);
            }
        }
    }

    private int parseHex(String string) throws NumberFormatException {
        int n = 0;
        try {
            n = Integer.parseInt(string.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(this.preErrText + "Ung\u00fcltiges Format!\n" + "Bitte geben Sie eine hexadezimale Zahl ein.");
        }
        return n;
    }
}

