/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jkcemu.Main;
import jkcemu.base.BaseDlg;

public class ProfileDlg
extends BaseDlg
implements DocumentListener,
ListSelectionListener {
    private File selectedProfile = null;
    private DefaultListModel<String> listModel;
    private JList<String> list;
    private Document docProfileName;
    private JTextField fldProfileName;
    private JButton btnOK;
    private JButton btnDelete;
    private JButton btnCancel;

    public ProfileDlg(Frame frame, String string, String string2, File file, boolean bl) {
        super((Window)frame, string);
        Object object;
        Serializable serializable;
        int n = -1;
        String string3 = null;
        this.listModel = new DefaultListModel();
        try {
            serializable = Main.getConfigDir();
            if (serializable != null && (object = serializable.listFiles()) != null) {
                Arrays.sort((Object[])object);
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    int n2;
                    String string4;
                    if (!((File)object[i]).isFile() || (string4 = ((File)object[i]).getName()) == null || (n2 = string4.length()) <= 8 || !string4.startsWith("prf_") || !string4.endsWith(".xml")) continue;
                    String string5 = string4.substring(4, n2 - 4);
                    if (file != null && file.equals(object[i])) {
                        n = this.listModel.getSize();
                        string3 = string5;
                    }
                    this.listModel.addElement(string5);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Profile:"), serializable);
        this.list = new JList<String>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(10);
        this.list.setPrototypeCellValue("123456789012345678901234567890");
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets.top = 0;
        ((GridBagConstraints)serializable).insets.bottom = 5;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ++((GridBagConstraints)serializable).gridy;
        this.add((Component)new JScrollPane(this.list, 22, 32), serializable);
        this.fldProfileName = null;
        this.docProfileName = null;
        if (bl) {
            this.fldProfileName = new JTextField();
            this.fldProfileName.addActionListener(this);
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets.top = 5;
            ((GridBagConstraints)serializable).weighty = 0.0;
            ++((GridBagConstraints)serializable).gridy;
            this.add((Component)this.fldProfileName, serializable);
            if (string3 != null) {
                this.fldProfileName.setText(string3);
            } else {
                this.fldProfileName.setText("standard");
            }
        }
        if (n >= 0) {
            this.list.setSelectedIndex(n);
        }
        object = new JPanel(new GridLayout(4, 1, 5, 5));
        this.btnOK = new JButton(string2);
        this.btnOK.addActionListener(this);
        this.btnOK.addKeyListener(this);
        ((Container)object).add(this.btnOK);
        this.btnDelete = new JButton("L\u00f6schen");
        this.btnDelete.addActionListener(this);
        this.btnDelete.addKeyListener(this);
        ((Container)object).add(this.btnDelete);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        ((Container)object).add(this.btnCancel);
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets.top = 5;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).gridheight = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ++((GridBagConstraints)serializable).gridx;
        this.add((Component)object, serializable);
        this.pack();
        this.setParentCentered();
        if (this.fldProfileName != null) {
            this.docProfileName = this.fldProfileName.getDocument();
            if (this.docProfileName != null) {
                this.docProfileName.addDocumentListener(this);
            }
        }
        this.updOKButton();
        if (n < 0) {
            this.btnDelete.setEnabled(false);
        }
        this.list.addListSelectionListener(this);
        this.list.addKeyListener(this);
        this.list.addMouseListener(this);
    }

    public File getSelectedProfile() {
        return this.selectedProfile;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updOKButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updOKButton();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = this.list.getSelectedValue();
        if (string != null) {
            if (this.fldProfileName != null) {
                this.fldProfileName.setText(string.toString());
            }
            this.btnDelete.setEnabled(true);
        } else {
            this.btnDelete.setEnabled(false);
        }
        this.updOKButton();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getComponent() == this.list) {
                mouseEvent.consume();
                this.doApply();
            } else {
                super.mouseClicked(mouseEvent);
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.fldProfileName != null) {
            this.fldProfileName.requestFocus();
        } else {
            this.list.requestFocus();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnOK || object == this.list || object == this.fldProfileName) {
                bl = true;
                this.doApply();
            } else if (object == this.btnDelete) {
                bl = true;
                this.doDelete();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private void doApply() {
        if (this.fldProfileName != null) {
            int n;
            String string = this.fldProfileName.getText();
            if (string != null && (n = string.length()) > 0) {
                boolean bl = true;
                char c = string.charAt(0);
                if (c != '_' && c >= 'A' && c <= 'Z' && c >= 'a' && c <= 'z') {
                    bl = false;
                } else {
                    for (int i = 1; i < n; ++i) {
                        c = string.charAt(i);
                        if (c == '_' || c < 'A' || c > 'Z' || c < 'a' || c > 'z' || c < '0' || c > '9') continue;
                        bl = false;
                    }
                }
                if (bl) {
                    this.selectedProfile = ProfileDlg.getProfile(string);
                } else {
                    ProfileDlg.showErrorDlg((Component)this, "Der ausgew\u00e4hlte Name enth\u00e4lt ung\u00fcltigeZeichen.\nDas erste Zeichen muss ein Buchstabe oder Unterstrich sein.\nAb dem zweiten Zeichen sind zus\u00e4tzlich Ziffern erlaubt.", "Ung\u00fcltiger Profilname");
                }
            }
        } else {
            String string;
            String string2 = this.list.getSelectedValue();
            if (string2 != null && (string = string2.toString()) != null && !string.isEmpty()) {
                this.selectedProfile = ProfileDlg.getProfile(string);
            }
        }
        if (this.selectedProfile != null) {
            this.doClose();
        }
    }

    private void doDelete() {
        String string = this.list.getSelectedValue();
        if (string != null && ProfileDlg.showYesNoDlg(this, "M\u00f6chten Sie das Profil l\u00f6schen?")) {
            File file = ProfileDlg.getProfile(string.toString());
            if (file.delete()) {
                this.listModel.removeElement(string);
                this.btnDelete.setEnabled(false);
            } else {
                ProfileDlg.showErrorDlg((Component)this, "Das Profil kann nicht gel\u00f6scht werden.");
            }
        }
    }

    private static File getProfile(String string) {
        String string2 = "prf_" + string + ".xml";
        File file = Main.getConfigDir();
        return file != null ? new File(file, string2) : new File(string2);
    }

    private void updOKButton() {
        boolean bl = true;
        if (this.docProfileName != null) {
            int n = this.docProfileName.getLength();
            if (n > 0) {
                try {
                    String string = this.docProfileName.getText(0, n);
                    if (string != null && !string.trim().isEmpty()) {
                        bl = true;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            bl = this.list.getSelectedIndex() >= 0;
        }
        this.btnOK.setEnabled(bl);
    }
}

