/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.EmuUtil;
import jkcemu.base.RAMFloppyFld;
import jkcemu.text.TextUtil;

public class RAMFloppy {
    public static final String PROP_FILE = "file";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_KBYTE = "kbyte";
    private RFType rfType;
    private int size;
    private int addr;
    private int endOfData;
    private int prevEndOfData;
    private boolean prevDataChanged;
    private boolean readOnly;
    private volatile boolean dataChanged;
    private byte[] dataBuf;
    private String infoText;
    private String sysName;
    private File file;
    private RAMFloppyFld ramFloppyFld;

    public RAMFloppy() {
        this.initRF();
        this.dataBuf = null;
        this.ramFloppyFld = null;
    }

    public void clear() {
        this.endOfData = 0;
        this.dataChanged = false;
        if (this.dataBuf != null) {
            Arrays.fill(this.dataBuf, (byte)-27);
        }
        this.fireRAMFloppyChanged();
    }

    public static boolean complies(RAMFloppy rAMFloppy, String string, RFType rFType, Properties properties, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (rFType == RFType.MP_3_1988) {
            n = 262144;
            bl2 = EmuUtil.getBooleanProperty(properties, string2 + PROP_ENABLED, false);
        } else {
            n = RAMFloppy.getRAMFloppySize(properties, string2);
            if (n > 0) {
                bl2 = true;
            }
        }
        if (rAMFloppy != null) {
            if (bl2) {
                bl = TextUtil.equals(string, rAMFloppy.sysName) && rFType == rAMFloppy.rfType && n == rAMFloppy.size;
            }
        } else if (!bl2) {
            bl = true;
        }
        return bl;
    }

    public void deinstall() {
        this.initRF();
        this.fireRAMFloppyChanged();
    }

    public int getByte(int n) {
        int n2 = 255;
        if (n >= 0 && n < this.size) {
            n2 = 0;
            if (this.dataBuf != null && n < this.dataBuf.length) {
                n2 = this.dataBuf[n] & 0xFF;
            }
            this.fireRAMFloppyAccess();
        }
        return n2;
    }

    public File getFile() {
        return this.file;
    }

    public String getInfoText() {
        return this.infoText != null ? this.infoText : "RAM-Floppy nicht emuliert";
    }

    public int getSize() {
        return this.size;
    }

    public int getUsedSize() {
        return this.endOfData;
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public void install(String string, RFType rFType, int n, String string2, String string3) {
        if (!TextUtil.equals(string, this.sysName) || rFType != this.rfType || n != this.size || !TextUtil.equals(string2, this.infoText)) {
            this.rfType = rFType;
            this.size = n;
            this.addr = 0;
            this.endOfData = 0;
            this.dataChanged = false;
            this.readOnly = false;
            this.infoText = string2;
            this.sysName = string;
            this.file = null;
            if (this.dataBuf != null) {
                Arrays.fill(this.dataBuf, (byte)0);
            }
            if (string3 != null && !string3.isEmpty()) {
                boolean bl = true;
                if (this.file != null && TextUtil.equals(string3, this.file.getPath())) {
                    bl = false;
                }
                if (bl) {
                    try {
                        this.load(new File(string3));
                    }
                    catch (IOException iOException) {
                        EmuUtil.fireShowError(Main.getScreenFrm(), string2 + " konnte nicht geladen werden.", iOException);
                    }
                }
            }
            this.fireRAMFloppyChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        this.ensureBufferSize();
        if (this.dataBuf != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.endOfData = EmuUtil.read(fileInputStream, this.dataBuf);
                this.file = file;
                this.dataChanged = false;
                for (int i = this.endOfData; i < this.dataBuf.length; ++i) {
                    this.dataBuf[i] = 0;
                }
                this.fireRAMFloppyChanged();
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(fileInputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(fileInputStream);
        }
    }

    public static RAMFloppy prepare(RAMFloppy rAMFloppy, String string, RFType rFType, String string2, Properties properties, String string3) {
        RAMFloppy rAMFloppy2 = null;
        if (rAMFloppy != null) {
            if (rFType == RFType.MP_3_1988) {
                if (EmuUtil.getBooleanProperty(properties, string3 + PROP_ENABLED, false)) {
                    rAMFloppy.install(string, rFType, 262144, string2, EmuUtil.getProperty(properties, string3 + PROP_FILE));
                    rAMFloppy2 = rAMFloppy;
                }
            } else {
                int n = RAMFloppy.getRAMFloppySize(properties, string3);
                if (n > 0) {
                    rAMFloppy.install(string, rFType, n, string2, EmuUtil.getProperty(properties, string3 + PROP_FILE));
                    rAMFloppy2 = rAMFloppy;
                }
            }
        }
        return rAMFloppy2;
    }

    public int readByte(int n) {
        int n2 = 255;
        switch (this.rfType) {
            case ADW: {
                if ((n & 1) != 0) break;
                n2 = this.getByte(this.addr | n >> 8 & 0x7F);
                break;
            }
            case MP_3_1988: {
                if ((n &= 7) >= 0 && n <= 3) {
                    n2 = this.getByte(n << 16 & 0x30000 | this.addr & 0xFFFF);
                    this.addr = this.addr & 0x3FF00 | this.addr + 1 & 0xFF;
                    this.fireRAMFloppyAccess();
                    break;
                }
                if (n == 6) {
                    n2 = this.addr >> 8 & 0xFF;
                    this.fireRAMFloppyAccess();
                    break;
                }
                if (n != 7) break;
                n2 = this.addr & 0xFF;
                this.fireRAMFloppyAccess();
            }
        }
        return n2;
    }

    public void reset() {
        this.readOnly = false;
        this.addr = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            if (this.dataBuf != null) {
                ((OutputStream)fileOutputStream).write(this.dataBuf, 0, Math.min(this.endOfData, this.dataBuf.length));
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
            this.file = file;
            this.dataChanged = false;
            this.fireRAMFloppyChanged();
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
    }

    public boolean setByte(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < this.size) {
            this.ensureBufferSize();
            if (this.dataBuf != null && n < this.dataBuf.length) {
                this.dataBuf[n] = (byte)n2;
                if (n >= this.endOfData) {
                    this.endOfData = n + 1;
                }
                this.dataChanged = true;
                this.fireRAMFloppyChanged();
                bl = true;
            }
            this.fireRAMFloppyAccess();
        }
        return bl;
    }

    public void setRAMFloppyFld(RAMFloppyFld rAMFloppyFld) {
        this.ramFloppyFld = rAMFloppyFld;
    }

    public void writeByte(int n, int n2) {
        switch (this.rfType) {
            case ADW: {
                if ((n & 1) == 0) {
                    if (!this.readOnly) {
                        this.setByte(this.addr | n >> 8 & 0x7F, n2);
                        break;
                    }
                    this.fireRAMFloppyAccess();
                    break;
                }
                this.readOnly = (n & 0x8000) != 0;
                this.addr = n << 7 & 0x3F8000 | n2 << 7 & 0x7F80;
                this.fireRAMFloppyAccess();
                break;
            }
            case MP_3_1988: {
                if ((n &= 7) >= 0 && n <= 3) {
                    this.setByte(n << 16 & 0x30000 | this.addr & 0xFFFF, n2);
                    this.addr = this.addr & 0x3FF00 | this.addr + 1 & 0xFF;
                    break;
                }
                if (n == 6) {
                    this.addr = this.addr & 0x300FF | n2 << 8 & 0xFF00;
                    this.fireRAMFloppyAccess();
                    break;
                }
                if (n != 7) break;
                this.addr = this.addr & 0x3FF00 | n2 & 0xFF;
                this.fireRAMFloppyAccess();
            }
        }
    }

    public void ensureBufferSize() {
        if (this.size > 0) {
            if (this.dataBuf != null) {
                if (this.dataBuf.length < this.size) {
                    byte[] byArray = new byte[this.size];
                    System.arraycopy(this.dataBuf, 0, byArray, 0, this.dataBuf.length);
                    Arrays.fill(byArray, this.dataBuf.length, byArray.length, (byte)0);
                    this.dataBuf = byArray;
                }
            } else {
                this.dataBuf = new byte[this.size];
                Arrays.fill(this.dataBuf, (byte)0);
            }
        }
    }

    private void fireRAMFloppyAccess() {
        RAMFloppyFld rAMFloppyFld = this.ramFloppyFld;
        if (rAMFloppyFld != null) {
            rAMFloppyFld.fireRAMFloppyAccess();
        }
    }

    private void fireRAMFloppyChanged() {
        RAMFloppyFld rAMFloppyFld = this.ramFloppyFld;
        if (rAMFloppyFld != null && (this.dataChanged != this.prevDataChanged || this.endOfData != this.prevEndOfData)) {
            this.prevDataChanged = this.dataChanged;
            this.prevEndOfData = this.endOfData;
            rAMFloppyFld.fireRAMFloppyChanged();
        }
    }

    private static int getRAMFloppySize(Properties properties, String string) {
        int n = EmuUtil.getIntProperty(properties, string + PROP_KBYTE, 0);
        return n == 128 || n == 512 || n == 2048 ? n * 1024 : 0;
    }

    private void initRF() {
        this.rfType = RFType.OTHER;
        this.size = 0;
        this.addr = 0;
        this.endOfData = 0;
        this.prevEndOfData = 0;
        this.prevDataChanged = false;
        this.dataChanged = false;
        this.readOnly = false;
        this.infoText = null;
        this.sysName = null;
        this.file = null;
    }

    public static enum RFType {
        ADW,
        MP_3_1988,
        OTHER;

    }
}

