/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.HelpFrm;
import jkcemu.base.RAMFloppy;
import jkcemu.base.RAMFloppyFld;
import jkcemu.text.TextUtil;

public class RAMFloppyFrm
extends BaseFrm {
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_HELP = "help";
    private static final String HELP_PAGE = "/help/ramfloppy.htm";
    private static RAMFloppyFrm instance = null;
    private EmuThread emuThread;
    private RAMFloppyFld rfFld1;
    private RAMFloppyFld rfFld2;
    private String rfInfo1;
    private String rfInfo2;
    private int rfSize1;
    private int rfSize2;

    public static void close() {
        if (instance != null) {
            instance.doClose();
            instance = null;
        }
    }

    public static void open(EmuThread emuThread) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new RAMFloppyFrm(emuThread);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        EmuSys emuSys;
        boolean bl2 = super.applySettings(properties, bl);
        boolean bl3 = true;
        if (this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null) {
            RAMFloppy rAMFloppy = null;
            RAMFloppy rAMFloppy2 = null;
            if (emuSys.supportsRAMFloppy1()) {
                rAMFloppy = this.emuThread.getRAMFloppy1();
            }
            if (emuSys.supportsRAMFloppy2()) {
                rAMFloppy2 = this.emuThread.getRAMFloppy2();
            }
            if (this.equalsRF(rAMFloppy, this.rfSize1, this.rfInfo1) && this.equalsRF(rAMFloppy2, this.rfSize2, this.rfInfo2)) {
                bl3 = false;
            }
        }
        if (bl3) {
            RAMFloppyFrm.close();
        }
        return bl2;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        String string;
        boolean bl = false;
        if (eventObject != null && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
            if (string.equals(ACTION_CLOSE)) {
                bl = true;
                this.doClose();
            } else if (string.equals(ACTION_HELP)) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public void resetFired() {
        if (this.rfFld1 != null) {
            this.rfFld1.fireRAMFloppyChanged();
        }
        if (this.rfFld2 != null) {
            this.rfFld2.fireRAMFloppyChanged();
        }
    }

    private RAMFloppyFrm(EmuThread emuThread) {
        ImageObserver imageObserver;
        this.emuThread = emuThread;
        this.rfFld1 = null;
        this.rfFld2 = null;
        this.rfInfo1 = null;
        this.rfInfo2 = null;
        this.rfSize1 = -1;
        this.rfSize2 = -1;
        this.setTitle("JKCEMU RAM-Floppies");
        Main.updIcon(this);
        int n = 0;
        RAMFloppy rAMFloppy = null;
        RAMFloppy rAMFloppy2 = null;
        if (emuThread != null && (imageObserver = emuThread.getEmuSys()) != null) {
            if (((EmuSys)imageObserver).supportsRAMFloppy1() && (rAMFloppy = emuThread.getRAMFloppy1()) != null) {
                ++n;
            }
            if (((EmuSys)imageObserver).supportsRAMFloppy2() && (rAMFloppy2 = emuThread.getRAMFloppy2()) != null) {
                ++n;
            }
        }
        imageObserver = new JMenuBar();
        this.setJMenuBar((JMenuBar)imageObserver);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenu.add(this.createJMenuItem("Schlie\u00dfen", ACTION_CLOSE));
        ((JMenuBar)imageObserver).add(jMenu);
        JMenu jMenu2 = new JMenu("?");
        jMenu2.add(this.createJMenuItem("Hilfe...", ACTION_HELP));
        ((JMenuBar)imageObserver).add(jMenu2);
        if (n > 0) {
            this.setLayout(new GridLayout(n, 1, 5, 5));
            if (rAMFloppy != null) {
                this.rfInfo1 = rAMFloppy.getInfoText();
                this.rfSize1 = rAMFloppy.getSize();
                this.rfFld1 = new RAMFloppyFld(this, rAMFloppy);
                this.rfFld1.setBorder(BorderFactory.createTitledBorder(this.rfInfo1));
                this.add(this.rfFld1);
                --n;
            }
            if (n > 0 && rAMFloppy2 != null) {
                this.rfInfo2 = rAMFloppy2.getInfoText();
                this.rfSize2 = rAMFloppy2.getSize();
                this.rfFld2 = new RAMFloppyFld(this, rAMFloppy2);
                this.rfFld2.setBorder(BorderFactory.createTitledBorder(this.rfInfo2));
                this.add(this.rfFld2);
            }
        }
        this.setLocationByPlatform(true);
        this.applySettings(Main.getProperties(), false);
        this.pack();
        this.setResizable(true);
        new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMFloppyFrm.this.checkLEDState();
            }
        }).start();
    }

    private void checkLEDState() {
        if (this.rfFld1 != null) {
            this.rfFld1.checkLEDState();
        }
        if (this.rfFld2 != null) {
            this.rfFld2.checkLEDState();
        }
    }

    private boolean equalsRF(RAMFloppy rAMFloppy, int n, String string) {
        boolean bl = false;
        if (rAMFloppy != null) {
            if (rAMFloppy.getSize() == n && TextUtil.equals(rAMFloppy.getInfoText(), string)) {
                bl = true;
            }
        } else if (n < 0) {
            bl = true;
        }
        return bl;
    }
}

