/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.io.File;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jkcemu.Main;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.RAMFloppy;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class RAMFloppySettingsFld
extends AbstractSettingsFld {
    private JCheckBox btnRF;
    private JLabel labelRF;
    private JLabel labelFile;
    private JComboBox<String> comboSize;
    private FileNameFld fileNameFld;
    private JButton btnSelect;
    private JButton btnRemove;

    public RAMFloppySettingsFld(SettingsFrm settingsFrm, String string, String string2, RAMFloppy.RFType rFType) {
        super(settingsFrm, string);
        this.propPrefix = string;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnRF = null;
        this.labelRF = null;
        this.comboSize = null;
        if (rFType == RAMFloppy.RFType.MP_3_1988) {
            this.btnRF = new JCheckBox(string2);
            gridBagConstraints.gridwidth = 0;
            this.add((Component)this.btnRF, gridBagConstraints);
        } else if (rFType == RAMFloppy.RFType.ADW) {
            this.labelRF = new JLabel(string2 + ":");
            this.add((Component)this.labelRF, gridBagConstraints);
            this.comboSize = new JComboBox();
            this.comboSize.setEditable(false);
            this.comboSize.addItem("Nicht emulieren");
            this.comboSize.addItem("128 KByte");
            this.comboSize.addItem("512 KByte");
            this.comboSize.addItem("2 MByte");
            gridBagConstraints.gridwidth = 0;
            ++gridBagConstraints.gridx;
            this.add(this.comboSize, gridBagConstraints);
        }
        this.labelFile = new JLabel("Automatisch laden (optional):");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelFile, gridBagConstraints);
        this.fileNameFld = new FileNameFld();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fileNameFld, gridBagConstraints);
        this.btnSelect = this.createImageButton("/images/file/open.png", "Abbilddatei ausw\u00e4hlen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx += 2;
        this.add((Component)this.btnSelect, gridBagConstraints);
        this.btnRemove = this.createImageButton("/images/file/delete.png", "Abbilddatei entfernen");
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnRemove, gridBagConstraints);
        if (this.btnRF != null) {
            this.btnRF.addActionListener(this);
        }
        if (this.comboSize != null) {
            this.comboSize.addActionListener(this);
        }
        this.enableFileDrop(this.fileNameFld);
        this.updFieldsEnabled();
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        if (properties != null) {
            properties.remove(this.propPrefix + "enabled");
            properties.remove(this.propPrefix + "kbyte");
            if (this.comboSize != null) {
                int n = 0;
                switch (this.comboSize.getSelectedIndex()) {
                    case 1: {
                        n = 128;
                        break;
                    }
                    case 2: {
                        n = 512;
                        break;
                    }
                    case 3: {
                        n = 2048;
                    }
                }
                EmuUtil.setProperty(properties, this.propPrefix + "kbyte", n);
            } else if (this.btnRF != null) {
                EmuUtil.setProperty(properties, this.propPrefix + "enabled", Boolean.toString(this.btnRF.isSelected()));
            }
            File file = this.fileNameFld.getFile();
            properties.setProperty(this.propPrefix + "file", file != null ? file.getPath() : "");
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnRF || object == this.comboSize) {
                this.updFieldsEnabled();
                this.fireDataChanged();
                bl = true;
            } else if (object == this.btnSelect) {
                File file = this.selectFile("RAM-Floppy-Abbilddatei ausw\u00e4hlen", "ramfloppy", this.fileNameFld.getFile(), EmuUtil.getBinaryFileFilter());
                if (file != null) {
                    this.fileNameFld.setFile(file);
                    this.btnRemove.setEnabled(this.labelFile.isEnabled());
                    this.fireDataChanged();
                }
                bl = true;
            } else if (object == this.btnRemove) {
                File file = this.fileNameFld.getFile();
                if (file != null) {
                    this.fileNameFld.setFileName(null);
                    this.btnRemove.setEnabled(false);
                    this.fireDataChanged();
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = false;
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        if (dropTargetContext != null && dropTargetContext.getComponent() == this.fileNameFld && !this.fileNameFld.isEnabled()) {
            dropTargetDragEvent.rejectDrag();
            bl = true;
        }
        if (!bl) {
            super.dragEnter(dropTargetDragEvent);
        }
    }

    @Override
    protected boolean fileDropped(Component component, File file) {
        boolean bl = false;
        if (file != null) {
            this.fileNameFld.setFile(file);
            this.btnRemove.setEnabled(this.labelFile.isEnabled());
            Main.setLastFile(file, "ramfloppy");
            this.fireDataChanged();
            bl = true;
        }
        return bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.btnRF != null) {
            this.btnRF.setEnabled(bl);
        } else if (this.labelRF != null) {
            this.labelRF.setEnabled(bl);
        }
        this.updFieldsEnabled();
    }

    @Override
    public void updFields(Properties properties) {
        if (this.btnRF != null) {
            this.btnRF.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "enabled", false));
        } else if (this.comboSize != null) {
            int n = 0;
            String string = EmuUtil.getProperty(properties, this.propPrefix + "kbyte");
            if (string != null && !string.isEmpty()) {
                try {
                    switch (Integer.valueOf(string)) {
                        case 128: {
                            n = 1;
                            break;
                        }
                        case 512: {
                            n = 2;
                            break;
                        }
                        case 2048: {
                            n = 3;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n >= 0 && n < this.comboSize.getItemCount()) {
                try {
                    this.comboSize.setSelectedIndex(n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        this.fileNameFld.setFileName(EmuUtil.getProperty(properties, this.propPrefix + "file"));
        this.updFieldsEnabled();
    }

    private void updFieldsEnabled() {
        boolean bl = false;
        if (this.btnRF != null) {
            bl = this.btnRF.isSelected();
        } else if (this.labelRF != null && this.comboSize != null && this.labelRF.isEnabled() && this.comboSize.getSelectedIndex() > 0) {
            bl = true;
        }
        this.labelFile.setEnabled(bl);
        this.fileNameFld.setEnabled(bl);
        this.btnSelect.setEnabled(bl);
        this.btnRemove.setEnabled(bl && this.fileNameFld.getFile() != null);
    }
}

