/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileSaver;
import jkcemu.base.HelpFrm;
import jkcemu.base.HexDocument;
import jkcemu.base.LimitedDocument;
import jkcemu.base.ScreenFrm;
import jkcemu.base.UserInputException;
import jkcemu.emusys.A5105;
import jkcemu.emusys.KC85;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.Z9001;

public class SaveDlg
extends BaseDlg
implements DocumentListener {
    private static final String HELP_PAGE = "/help/loadsave.htm";
    private ScreenFrm screenFrm;
    private int begAddr;
    private int endAddr;
    private BasicType basicType;
    private FileFilter basicFileFilter;
    private boolean kcbasic;
    private boolean fileTypeFixed;
    private boolean z9001;
    private boolean autoFillHeadBegAddr;
    private JTextField fldMemBegAddr;
    private JTextField fldMemEndAddr;
    private JTextField fldHeadBegAddr;
    private JTextField fldHeadStartAddr;
    private JTextField fldHeadFileDesc;
    private JComboBox<String> comboHeadFileType;
    private JLabel labelHeadBegAddr;
    private JLabel labelHeadStartAddr;
    private JLabel labelHeadFileType;
    private JLabel labelHeadFileDesc;
    private JCheckBox btnKeepHeader;
    private JRadioButton btnFileFmtBIN;
    private JRadioButton btnFileFmtKCC;
    private JRadioButton btnFileFmtTAP;
    private JRadioButton btnFileFmtSSS;
    private JRadioButton btnFileFmtBAS;
    private JRadioButton btnFileFmtRMC;
    private JRadioButton btnFileFmtHS;
    private JRadioButton btnFileFmtHEX;
    private JRadioButton btnBegBlkNum0;
    private JRadioButton btnBegBlkNum1;
    private JButton btnSave;
    private JButton btnHelp;
    private JButton btnCancel;
    private HexDocument docMemBegAddr;
    private HexDocument docMemEndAddr;
    private HexDocument docHeadBegAddr;
    private HexDocument docHeadStartAddr;
    private LimitedDocument docHeadFileDesc;
    private LimitedDocument docHeadFileType;

    public SaveDlg(ScreenFrm screenFrm, int n, int n2, String string, BasicType basicType, FileFilter fileFilter) {
        super((Window)screenFrm, string);
        Serializable serializable;
        this.screenFrm = screenFrm;
        this.begAddr = n;
        this.endAddr = n2;
        this.basicType = basicType;
        this.basicFileFilter = fileFilter;
        this.kcbasic = false;
        this.fileTypeFixed = false;
        this.z9001 = false;
        this.autoFillHeadBegAddr = true;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Zu speichernder Bereich"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)new JLabel("Anfangsadresse:"), gridBagConstraints2);
        this.docMemBegAddr = new HexDocument(4, "Anfangsadresse des Speicherbereichs");
        this.fldMemBegAddr = new JTextField(this.docMemBegAddr, "", 5);
        if (n >= 0) {
            this.docMemBegAddr.setValue(n, 4);
        }
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldMemBegAddr, gridBagConstraints2);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)new JLabel("Endadresse:"), gridBagConstraints2);
        this.docMemEndAddr = new HexDocument(4, "Endadresse des Speicherbereichs");
        this.fldMemEndAddr = new JTextField(this.docMemEndAddr, "", 5);
        if (n >= 0 && n2 >= 0) {
            this.fldMemEndAddr.setText(String.format("%04X", n2));
        }
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldMemEndAddr, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Dateiformat"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnFileFmtBIN = new JRadioButton("Speicherabbilddatei ohne Kopfdaten (*.bin)", false);
        buttonGroup.add(this.btnFileFmtBIN);
        jPanel2.add((Component)this.btnFileFmtBIN, gridBagConstraints3);
        this.btnFileFmtKCC = new JRadioButton("KC-Systemdatei (*.kcc)", false);
        buttonGroup.add(this.btnFileFmtKCC);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtKCC, gridBagConstraints3);
        this.btnFileFmtTAP = new JRadioButton("KC-TAP-Datei (*.tap)", false);
        buttonGroup.add(this.btnFileFmtTAP);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtTAP, gridBagConstraints3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnBegBlkNum0 = new JRadioButton("Erster Block hat Nr. 0 (KC85/1, KC87, Z9001)");
        buttonGroup2.add(this.btnBegBlkNum0);
        gridBagConstraints3.insets.left = 50;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnBegBlkNum0, gridBagConstraints3);
        this.btnBegBlkNum1 = new JRadioButton("Erster Block hat Nr. 1 (HC900, KC85/2-5, KC-BASIC)");
        buttonGroup2.add(this.btnBegBlkNum1);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnBegBlkNum1, gridBagConstraints3);
        gridBagConstraints3.insets.left = 5;
        this.btnFileFmtSSS = new JRadioButton("KC-BASIC-Programmdatei (*.sss)");
        buttonGroup.add(this.btnFileFmtSSS);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtSSS, gridBagConstraints3);
        this.btnFileFmtBAS = new JRadioButton("BASIC-/RBASIC-Programmdatei (*.bas; *.abc)");
        buttonGroup.add(this.btnFileFmtBAS);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtBAS, gridBagConstraints3);
        this.btnFileFmtRMC = new JRadioButton("RBASIC-Maschinencodedatei (*.rmc)");
        buttonGroup.add(this.btnFileFmtRMC);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtRMC, gridBagConstraints3);
        this.btnFileFmtHS = new JRadioButton("Headersave-Datei (*.z80)");
        buttonGroup.add(this.btnFileFmtHS);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtHS, gridBagConstraints3);
        this.btnFileFmtHEX = new JRadioButton("Intel-HEX-Datei (*.hex)");
        buttonGroup.add(this.btnFileFmtHEX);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnFileFmtHEX, gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Kopfdaten"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelHeadFileDesc = new JLabel("Bezeichnung:");
        jPanel3.add((Component)this.labelHeadFileDesc, gridBagConstraints4);
        this.docHeadFileDesc = new LimitedDocument(FileFormat.getTotalMaxFileDescLength());
        this.docHeadFileDesc.setAsciiOnly(true);
        this.fldHeadFileDesc = new JTextField(this.docHeadFileDesc, "", 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldHeadFileDesc, gridBagConstraints4);
        this.labelHeadFileType = new JLabel("Typ:");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets.top = 5;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelHeadFileType, gridBagConstraints4);
        this.comboHeadFileType = new JComboBox();
        this.comboHeadFileType.setEditable(true);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 0;
        ++gridBagConstraints4.gridx;
        jPanel3.add(this.comboHeadFileType, gridBagConstraints4);
        this.docHeadFileType = new LimitedDocument();
        this.docHeadFileType.setAsciiOnly(true);
        ComboBoxEditor comboBoxEditor = this.comboHeadFileType.getEditor();
        if (comboBoxEditor != null && (serializable = comboBoxEditor.getEditorComponent()) != null && serializable instanceof JTextComponent) {
            ((JTextComponent)serializable).setDocument(this.docHeadFileType);
        }
        if ((serializable = this.fldHeadFileDesc.getFont()) != null) {
            this.comboHeadFileType.setFont((Font)serializable);
        }
        this.labelHeadBegAddr = new JLabel("Anfangsadresse:");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelHeadBegAddr, gridBagConstraints4);
        this.docHeadBegAddr = new HexDocument(4, "Anfangsadresse in den Kopfdaten");
        this.fldHeadBegAddr = new JTextField(this.docHeadBegAddr, "", 5);
        if (n >= 0) {
            this.fldHeadBegAddr.setText(String.format("%04X", n));
        }
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 0.5;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldHeadBegAddr, gridBagConstraints4);
        this.labelHeadStartAddr = new JLabel("Startadresse:");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.labelHeadStartAddr, gridBagConstraints4);
        this.docHeadStartAddr = new HexDocument(4, "Startadresse in den Kopfdaten");
        this.fldHeadStartAddr = new JTextField(this.docHeadStartAddr, "", 5);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 0.5;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldHeadStartAddr, gridBagConstraints4);
        this.btnKeepHeader = new JCheckBox("Headersave-Kopfdaten nach 00E0-00FF kopieren");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.btnKeepHeader, gridBagConstraints4);
        JPanel jPanel4 = new JPanel(new GridLayout(3, 1, 5, 5));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel4, gridBagConstraints);
        this.btnSave = new JButton("Speichern");
        jPanel4.add(this.btnSave);
        this.btnHelp = new JButton("Hilfe");
        jPanel4.add(this.btnHelp);
        this.btnCancel = new JButton("Abbrechen");
        jPanel4.add(this.btnCancel);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = -1;
        switch (basicType) {
            case TINYBASIC: {
                this.btnFileFmtHS.setSelected(true);
                n3 = 98;
                bl4 = true;
                break;
            }
            case MS_DERIVED_BASIC: {
                this.btnFileFmtBAS.setSelected(true);
                n3 = 66;
                bl = true;
                bl4 = true;
                break;
            }
            case MS_DERIVED_BASIC_HS: {
                this.btnFileFmtHS.setSelected(true);
                n3 = 66;
                bl = true;
                bl4 = true;
                break;
            }
            case KCBASIC: {
                this.btnFileFmtSSS.setSelected(true);
                this.btnBegBlkNum1.setSelected(true);
                this.kcbasic = true;
                n3 = 66;
                bl2 = true;
                bl4 = true;
                break;
            }
            case RBASIC: {
                this.btnFileFmtBAS.setSelected(true);
                n3 = 66;
                bl = true;
                bl4 = true;
            }
        }
        this.btnFileFmtBAS.setEnabled(bl);
        this.btnFileFmtSSS.setEnabled(bl2);
        if (n3 > 0) {
            this.fileTypeFixed = true;
            if (EmuUtil.setSelectedHeadersaveFileTypeItem(this.comboHeadFileType, n3)) {
                this.comboHeadFileType.setEditable(false);
                this.comboHeadFileType.setEnabled(false);
            }
        }
        if (!bl4) {
            boolean bl5 = false;
            boolean bl6 = false;
            EmuSys emuSys = this.screenFrm.getEmuThread().getEmuSys();
            if (emuSys != null) {
                bl5 = emuSys instanceof A5105;
                bl3 = emuSys instanceof KC85;
                bl6 = emuSys instanceof Z1013;
                this.z9001 = emuSys instanceof Z9001;
            }
            if (bl5) {
                this.btnFileFmtRMC.setSelected(true);
            } else if (bl3 || this.z9001) {
                this.btnFileFmtKCC.setSelected(true);
            } else if (bl6) {
                this.btnFileFmtHS.setSelected(true);
                this.btnKeepHeader.setSelected(Main.getBooleanProperty("jkcemu.loadsave.header.keep", false));
            } else {
                this.btnFileFmtBIN.setSelected(true);
            }
        }
        if (bl4 || bl3) {
            this.btnBegBlkNum1.setSelected(true);
        } else {
            this.btnBegBlkNum0.setSelected(true);
        }
        this.updHeadFields();
        this.pack();
        this.fldMemBegAddr.setColumns(0);
        this.fldMemEndAddr.setColumns(0);
        this.fldMemEndAddr.setColumns(0);
        this.fldHeadBegAddr.setColumns(0);
        this.fldHeadStartAddr.setColumns(0);
        this.setParentCentered();
        this.setResizable(true);
        this.updSaveBtn();
        this.fldMemBegAddr.addActionListener(this);
        this.docMemBegAddr.addDocumentListener(this);
        this.fldMemEndAddr.addActionListener(this);
        this.docMemEndAddr.addDocumentListener(this);
        this.btnFileFmtBIN.addActionListener(this);
        this.btnFileFmtKCC.addActionListener(this);
        this.btnFileFmtTAP.addActionListener(this);
        this.btnBegBlkNum0.addActionListener(this);
        this.btnBegBlkNum1.addActionListener(this);
        this.btnFileFmtSSS.addActionListener(this);
        this.btnFileFmtBAS.addActionListener(this);
        this.btnFileFmtRMC.addActionListener(this);
        this.btnFileFmtHS.addActionListener(this);
        this.btnFileFmtHEX.addActionListener(this);
        this.fldHeadFileDesc.addActionListener(this);
        this.fldHeadBegAddr.addActionListener(this);
        this.docHeadBegAddr.addDocumentListener(this);
        this.fldHeadStartAddr.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnSave.addKeyListener(this);
        this.btnHelp.addActionListener(this);
        this.btnHelp.addKeyListener(this);
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docContentChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docContentChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docContentChanged(documentEvent);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.fldMemBegAddr.requestFocus();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnFileFmtBIN || object == this.btnFileFmtKCC || object == this.btnFileFmtTAP || object == this.btnBegBlkNum0 || object == this.btnBegBlkNum1 || object == this.btnFileFmtSSS || object == this.btnFileFmtBAS || object == this.btnFileFmtRMC || object == this.btnFileFmtHS || object == this.btnFileFmtHEX) {
                bl = true;
                this.updHeadFields();
            } else if (object == this.fldHeadFileDesc || object == this.btnSave) {
                bl = true;
                this.doSave();
            } else if (object == this.btnHelp) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object instanceof JTextField) {
                bl = true;
                ((JTextField)object).transferFocus();
            }
        }
        return bl;
    }

    private void doSave() {
        boolean bl = false;
        FileFormat fileFormat = this.getSelectedFileFmt();
        try {
            File file;
            int n;
            if (fileFormat == null) {
                throw new UserInputException("Dateiformat nicht ausgew\u00e4hlt");
            }
            int n2 = this.docMemBegAddr.intValue() & 0xFFFF;
            int n3 = this.docMemEndAddr.intValue() & 0xFFFF;
            if (this.begAddr >= 0 && this.endAddr >= 0 && (n2 > this.begAddr || n3 < this.endAddr)) {
                throw new UserInputException(String.format("Der angegebene Adressbereich beinhaltet nicht vollst\u00e4ndig\ndas zu speichernde Programm (%04X-%04X).", this.begAddr, this.endAddr));
            }
            String string = this.fldHeadFileDesc.getText();
            if (string != null && (n = fileFormat.getMaxFileDescLength()) > 0 && string.length() > n) {
                throw new UserInputException(String.format("Die Bezeichnung der Datei ist zu lang(max. %d Zeichen).", n));
            }
            n = this.btnFileFmtBIN.isSelected() ? 1 : 0;
            boolean bl2 = this.btnFileFmtKCC.isSelected();
            boolean bl3 = this.btnFileFmtTAP.isSelected();
            boolean bl4 = this.btnFileFmtSSS.isSelected();
            boolean bl5 = this.btnFileFmtBAS.isSelected();
            boolean bl6 = this.btnFileFmtRMC.isSelected();
            boolean bl7 = this.btnFileFmtHS.isSelected();
            boolean bl8 = this.btnFileFmtHEX.isSelected();
            String string2 = "Datei speichern";
            FileFilter fileFilter = null;
            if (n != 0) {
                string2 = "Bin\u00e4rdatei speichern";
                fileFilter = EmuUtil.getBinaryFileFilter();
            } else if (bl2) {
                string2 = "KC-System-Datei speichern";
                fileFilter = EmuUtil.getKCSystemFileFilter();
            } else if (bl3) {
                string2 = "KC-TAP-Datei speichern";
                fileFilter = EmuUtil.getKCTapFileFilter();
            } else if (bl4) {
                string2 = "KC-BASIC-Programmdatei speichern";
                fileFilter = EmuUtil.getKCBasicFileFilter();
            } else if (bl5) {
                string2 = this.basicType.equals((Object)BasicType.RBASIC) ? "RBASIC-Programmdatei speichern" : "BASIC-Programmdatei speichern";
                fileFilter = this.basicFileFilter != null ? this.basicFileFilter : EmuUtil.getBasicFileFilter();
            } else if (bl6) {
                string2 = "RBASIC-Maschinencodedatei speichern";
                fileFilter = EmuUtil.getRMCFileFilter();
            } else if (bl7) {
                string2 = "Headersave-Datei speichern";
                fileFilter = EmuUtil.getHeadersaveFileFilter();
            } else if (bl8) {
                string2 = "Intel-HEX-Datei speichern";
                fileFilter = EmuUtil.getHexFileFilter();
            }
            String string3 = null;
            switch (this.basicType) {
                case MS_DERIVED_BASIC: 
                case MS_DERIVED_BASIC_HS: 
                case RBASIC: {
                    if (bl5 || bl7) break;
                    string3 = this.btnFileFmtBAS.getText();
                    break;
                }
                case KCBASIC: {
                    if (bl3 || bl4 || bl7) break;
                    string3 = this.btnFileFmtSSS.getText();
                }
            }
            boolean bl9 = true;
            if (string3 != null) {
                bl9 = SaveDlg.showYesNoWarningDlg(this, "Das von Ihnen ausgew\u00e4hlte Dateiformat wird \u00fcblicherweise\nnicht zum Speichern von BASIC-Programmen verwendet.\nZwar k\u00f6nnen Sie das Programm in dem Format speichern, jedoch\nwird JKCEMU beim Laden der Datei das BASIC-Programm nicht erkennen\nund somit die Systemzellen des BASIC-Interpreters nicht anpassen.\nDadurch l\u00e4sst sich das Programm dann nicht nutzen.\n\nDas bevorzugte Dateiformat zum Speichern von BASIC-Programmen ist:\n\n    " + string3 + "\n\nM\u00f6chten Sie trotzdem in dem" + " von Ihnen gew\u00e4hlten Dateiformat" + " speichern?", "Warnung");
            }
            if (bl9 && (file = EmuUtil.showFileSaveDlg(this.screenFrm, string2, Main.getLastDirFile("software"), fileFilter)) != null) {
                try {
                    Object object;
                    int n4 = n2;
                    Integer n5 = null;
                    String string4 = null;
                    if ((bl2 || bl3 && !this.kcbasic || bl7 || bl8) && (object = this.fldHeadBegAddr.getText()) != null && !((String)object).trim().isEmpty()) {
                        n4 = this.docHeadBegAddr.intValue() & 0xFFFF;
                    }
                    if ((bl2 || bl3 && !this.kcbasic || bl6 || bl7) && (object = this.fldHeadStartAddr.getText()) != null && !((String)object).trim().isEmpty()) {
                        n5 = this.docHeadStartAddr.intValue() & 0xFFFF;
                    }
                    if ((object = this.comboHeadFileType.getSelectedItem()) != null) {
                        string4 = object.toString();
                    }
                    EmuThread emuThread = this.screenFrm.getEmuThread();
                    FileSaver.saveFile(file, fileFormat, emuThread, n2, n3, !this.basicType.equals((Object)BasicType.NO_BASIC), n4, n5, string, string4, this.btnKeepHeader.isSelected() ? emuThread : null);
                    bl = true;
                    Main.setLastFile(file, "software");
                    this.screenFrm.showStatusText("Datei gespeichert");
                }
                catch (IOException iOException) {
                    SaveDlg.showErrorDlg((Component)this, "Datei kann nicht gespeichert werden.\n\n" + iOException.getMessage());
                }
                catch (Exception exception) {
                    SaveDlg.showErrorDlg((Component)this, exception.getMessage());
                }
            }
        }
        catch (UserInputException userInputException) {
            SaveDlg.showErrorDlg((Component)this, userInputException.getMessage());
        }
        if (bl) {
            this.doClose();
        }
    }

    private void docContentChanged(DocumentEvent documentEvent) {
        if (this.autoFillHeadBegAddr) {
            Document document = documentEvent.getDocument();
            if (document == this.docMemBegAddr) {
                this.fldHeadBegAddr.setText(this.fldMemBegAddr.getText());
            } else if (document == this.docHeadBegAddr && this.fldHeadBegAddr.hasFocus()) {
                this.autoFillHeadBegAddr = false;
            }
        }
        this.updSaveBtn();
    }

    private FileFormat getSelectedFileFmt() {
        FileFormat fileFormat = null;
        if (this.btnFileFmtBIN.isSelected()) {
            fileFormat = FileFormat.BIN;
        } else if (this.btnFileFmtKCC.isSelected()) {
            fileFormat = FileFormat.KCC;
        } else if (this.btnFileFmtTAP.isSelected()) {
            fileFormat = this.kcbasic ? FileFormat.KCTAP_BASIC_PRG : (this.btnBegBlkNum0.isSelected() ? FileFormat.KCTAP_Z9001 : FileFormat.KCTAP_KC85);
        } else if (this.btnFileFmtSSS.isSelected()) {
            fileFormat = FileFormat.KCBASIC_PRG;
        } else if (this.btnFileFmtBAS.isSelected()) {
            fileFormat = this.basicType == BasicType.RBASIC ? FileFormat.RBASIC_PRG : FileFormat.BASIC_PRG;
        } else if (this.btnFileFmtRMC.isSelected()) {
            fileFormat = FileFormat.RMC;
        } else if (this.btnFileFmtHS.isSelected()) {
            fileFormat = FileFormat.HEADERSAVE;
        } else if (this.btnFileFmtHEX.isSelected()) {
            fileFormat = FileFormat.INTELHEX;
        }
        return fileFormat;
    }

    private void updHeadFields() {
        boolean bl = this.btnFileFmtKCC.isSelected();
        boolean bl2 = this.btnFileFmtTAP.isSelected();
        boolean bl3 = this.btnFileFmtSSS.isSelected();
        boolean bl4 = this.btnFileFmtBAS.isSelected();
        boolean bl5 = this.btnFileFmtRMC.isSelected();
        boolean bl6 = this.btnFileFmtHS.isSelected();
        boolean bl7 = this.btnFileFmtHEX.isSelected();
        this.btnBegBlkNum0.setEnabled(bl2 && !this.kcbasic);
        this.btnBegBlkNum1.setEnabled(bl2 && !this.kcbasic);
        boolean bl8 = true;
        if (this.begAddr >= 0 && (bl2 && this.kcbasic || bl3 || bl4)) {
            bl8 = false;
            this.docMemBegAddr.setValue(this.begAddr, 4);
        }
        this.fldMemBegAddr.setEnabled(bl8);
        boolean bl9 = bl8 && (bl || bl2 && !this.kcbasic || bl6 || bl5 || bl7);
        this.labelHeadBegAddr.setEnabled(bl9);
        this.fldHeadBegAddr.setEnabled(bl9);
        boolean bl10 = bl8 && (bl || bl2 && !this.kcbasic || bl6 || bl5);
        this.labelHeadStartAddr.setEnabled(bl10);
        this.fldHeadStartAddr.setEnabled(bl10);
        String string = this.fldHeadFileDesc.getText();
        int n = 0;
        int n2 = 0;
        if (!this.fileTypeFixed) {
            this.comboHeadFileType.removeAllItems();
            if (bl6) {
                EmuUtil.addHeadersaveFileTypeItemsTo(this.comboHeadFileType);
                n = 16;
                n2 = 1;
            } else if (bl || bl2) {
                if (this.z9001 && bl || bl2 && this.btnBegBlkNum0.isSelected()) {
                    n = 8;
                    n2 = 3;
                    this.comboHeadFileType.addItem("");
                    this.comboHeadFileType.addItem("COM");
                } else {
                    n = 11;
                }
            }
        }
        this.docHeadFileDesc.setMaxLength(n);
        this.fldHeadFileDesc.setText(string);
        this.docHeadFileType.setMaxLength(n2);
        this.labelHeadFileType.setEnabled(n2 > 0);
        this.comboHeadFileType.setEnabled(n2 > 0);
        boolean bl11 = bl || bl2 || bl6;
        this.labelHeadFileDesc.setEnabled(bl11);
        this.fldHeadFileDesc.setEnabled(bl11);
        this.btnKeepHeader.setEnabled(bl6 && this.screenFrm.getEmuThread().getEmuSys() instanceof Z1013);
    }

    private void updSaveBtn() {
        if (this.btnSave != null) {
            boolean bl = false;
            if (this.docMemBegAddr.getLength() > 0 && this.docMemEndAddr.getLength() > 0) {
                try {
                    if (this.docMemBegAddr.intValue() <= this.docMemEndAddr.intValue()) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.btnSave.setEnabled(bl);
        }
    }

    public static enum BasicType {
        NO_BASIC,
        TINYBASIC,
        MS_DERIVED_BASIC,
        MS_DERIVED_BASIC_HS,
        KCBASIC,
        RBASIC,
        OTHER_BASIC;

    }
}

