/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import jkcemu.base.BaseDlg;
import jkcemu.disk.CPCDisk;
import jkcemu.disk.CopyQMDisk;
import jkcemu.disk.FloppyDiskStationFrm;
import jkcemu.disk.ImageDisk;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;
import jkcemu.disk.TeleDisk;

public abstract class AbstractFloppyDisk {
    public static final String PROP_CYLINDERS = "cylinders";
    public static final String PROP_FILE = "file";
    public static final String PROP_READONLY = "readonly";
    public static final String PROP_RESOURCE = "resource";
    public static final String PROP_SECTORS_PER_CYL = "sectors_per_cylinder";
    public static final String PROP_SECTORSIZE = "sectorsize";
    public static final String PROP_SIDES = "sides";
    private Frame owner;
    private volatile int sides;
    private volatile int cyls;
    private volatile int sectorsPerCyl;
    private volatile int sectorSize;
    private volatile String fmtText;
    private String mediaText;
    private String warningText;
    private int[] sectorIdxMap;

    protected AbstractFloppyDisk(Frame frame, int n, int n2, int n3, int n4, int n5) {
        this.owner = frame;
        this.sides = n;
        this.cyls = n2;
        this.sectorsPerCyl = n3;
        this.sectorSize = n4;
        this.fmtText = null;
        this.mediaText = null;
        this.warningText = null;
        this.sectorIdxMap = null;
        if (n5 > 1 && n5 < n3 && n3 > 2) {
            this.sectorIdxMap = new int[n3];
            Arrays.fill(this.sectorIdxMap, -1);
            int n6 = 0;
            int n7 = 0;
            while (n6 < n3) {
                while (this.sectorIdxMap[n7] >= 0) {
                    n7 = (n7 + 1) % n3;
                }
                this.sectorIdxMap[n7] = n6++;
                n7 = (n7 + n5) % n3;
            }
        }
    }

    protected AbstractFloppyDisk(Frame frame, int n, int n2, int n3, int n4) {
        this(frame, n, n2, n3, n4, 0);
    }

    public void closeSilent() {
    }

    protected void fireShowError(final String string, final Exception exception) {
        if (this.owner instanceof FloppyDiskStationFrm) {
            ((FloppyDiskStationFrm)this.owner).fireShowDiskError(this, string, exception);
        } else {
            final Frame frame = this.owner;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseDlg.showErrorDlg((Component)frame, string, exception);
                }
            });
        }
    }

    protected void fireShowReadError(int n, int n2, int n3, Exception exception) {
        this.fireShowError(String.format("Sektor [C=%d,H=%d,R=%d] kann nicht gelesen werden", n, n2, n3), exception);
    }

    protected void fireShowWriteError(int n, int n2, int n3, Exception exception) {
        this.fireShowError(String.format("Sektor [C=%d,H=%d,R=%d] kann nicht geschrieben werden", n, n2, n3), exception);
    }

    public boolean formatTrack(int n, int n2, SectorID[] sectorIDArray, byte[] byArray) {
        boolean bl = false;
        if (!this.isReadOnly() && sectorIDArray != null && sectorIDArray.length > 0) {
            bl = true;
            for (int i = 0; i < sectorIDArray.length; ++i) {
                SectorData sectorData;
                boolean bl2 = false;
                SectorID sectorID = sectorIDArray[i];
                if (sectorID != null && (sectorData = this.getSectorByID(n, n2, sectorID.getCylinder(), sectorID.getHead(), sectorID.getSectorNum(), sectorID.getSizeCode())) != null) {
                    bl2 = this.writeSector(n, n2, sectorData, byArray, byArray.length, false);
                }
                if (bl2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public int getCylinders() {
        return this.cyls;
    }

    public Date getDiskDate() {
        return null;
    }

    public int getDiskSize() {
        return this.sides * this.cyls * this.sectorsPerCyl * this.sectorSize;
    }

    public abstract String getFileFormatText();

    public String getFormatText() {
        if (this.fmtText == null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            if (this.sides > 0 && this.cyls > 0 && this.sectorsPerCyl > 0 && this.sectorSize > 0) {
                int n = this.sides * this.cyls * this.sectorsPerCyl * this.sectorSize / 1024;
                int n2 = this.getSysTracks();
                if (n2 > 0 && n2 < this.cyls) {
                    stringBuilder.append(this.sides * (this.cyls - n2) * this.sectorsPerCyl * this.sectorSize / 1024);
                    stringBuilder.append('/');
                    stringBuilder.append(n);
                    stringBuilder.append(" KByte, ");
                } else {
                    stringBuilder.append(n);
                    stringBuilder.append(" KByte brutto, ");
                }
                stringBuilder.append(this.cyls);
                stringBuilder.append(" Spuren a ");
                stringBuilder.append(this.sectorsPerCyl);
                stringBuilder.append(" * ");
                stringBuilder.append(this.sectorSize);
                stringBuilder.append(" Bytes");
                switch (this.sides) {
                    case 1: {
                        stringBuilder.append(", einseitig");
                        break;
                    }
                    case 2: {
                        stringBuilder.append(", doppelseitig");
                    }
                }
            } else {
                stringBuilder.append("unformatiert");
            }
            if (this.isReadOnly()) {
                stringBuilder.append(", schreibgesch\u00fctzt");
            }
            this.fmtText = stringBuilder.toString();
        }
        return this.fmtText;
    }

    public String getMediaText() {
        return this.mediaText;
    }

    public String getRemark() {
        return null;
    }

    public int getSectorOffset() throws IOException {
        int n = -1;
        int n2 = this.getCylinders();
        int n3 = this.getSides();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                int n5 = -1;
                int n6 = this.getSectorsOfCylinder(i, j);
                for (n4 = 0; n4 < n6; ++n4) {
                    SectorData sectorData = this.getSectorByIndex(i, j, n4);
                    if (sectorData == null) continue;
                    int n7 = sectorData.getSectorNum();
                    if ((n5 < 0 || n7 < n5) && (n5 = n7) <= 1) break;
                }
                n4 = 1 - n5;
                if (n5 < 1 || n >= 0 && n != n4) {
                    throw new IOException("Diskette hat unregelm\u00e4\u00dfige Sektornummern");
                }
                n = n4;
            }
        }
        return n;
    }

    public int getSectorSize() {
        return this.sectorSize;
    }

    public int getSectorsPerCylinder() {
        return this.sectorsPerCyl;
    }

    public abstract SectorData getSectorByIndex(int var1, int var2, int var3);

    public SectorData getSectorByID(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 - 1;
        SectorData sectorData = this.getSectorByIndex(n, n2, n7);
        if (sectorData != null && (sectorData.getCylinder() != n3 || sectorData.getHead() != n4 || sectorData.getSectorNum() != n5 || n6 >= 0 && sectorData.getSizeCode() != n6)) {
            sectorData = null;
        }
        if (sectorData == null) {
            int n8 = this.getSectorsOfCylinder(n, n2);
            for (int i = 0; i < n8; ++i) {
                SectorData sectorData2;
                if (i == n7 || (sectorData2 = this.getSectorByIndex(n, n2, i)) == null || sectorData2.getCylinder() != n3 || sectorData2.getHead() != n4 || sectorData2.getSectorNum() != n5 || n6 >= 0 && sectorData2.getSizeCode() != n6) continue;
                sectorData = sectorData2;
                break;
            }
        }
        return sectorData;
    }

    public int getSectorsOfCylinder(int n, int n2) {
        int n3 = 0;
        int n4 = this.getSides();
        if (n2 < n4 && n4 >= 1 && n >= 0 && n < this.getCylinders()) {
            n3 = this.getSectorsPerCylinder();
        }
        return n3;
    }

    public int getSides() {
        return this.sides;
    }

    protected int getSysTracks() {
        return 0;
    }

    public String getWarningText() {
        return this.warningText;
    }

    public static boolean isDiskFileHeader(byte[] byArray) {
        return CopyQMDisk.isCopyQMFileHeader(byArray) || CPCDisk.isCPCDiskFileHeader(byArray) || ImageDisk.isImageDiskFileHeader(byArray) || TeleDisk.isTeleDiskFileHeader(byArray);
    }

    public boolean isReadOnly() {
        return true;
    }

    public void putSettingsTo(Properties properties, String string) {
        if (properties != null) {
            properties.setProperty(string + PROP_READONLY, Boolean.toString(this.isReadOnly()));
            properties.setProperty(string + PROP_SIDES, Integer.toString(this.getSides()));
            properties.setProperty(string + PROP_CYLINDERS, Integer.toString(this.getCylinders()));
            properties.setProperty(string + PROP_SECTORS_PER_CYL, Integer.toString(this.getSectorsPerCylinder()));
            properties.setProperty(string + PROP_SECTORSIZE, Integer.toString(this.getSectorSize()));
        }
    }

    protected int sectorIndexToInterleave(int n) {
        if (this.sectorIdxMap != null && n >= 0 && n < this.sectorIdxMap.length) {
            n = this.sectorIdxMap[n];
        }
        return n;
    }

    public void setMediaText(String string) {
        this.mediaText = string;
    }

    public void setOwner(Frame frame) {
        this.owner = frame;
    }

    public void setCylinders(int n) {
        if (n != this.cyls) {
            this.cyls = n;
            this.fireDiskFmtChanged();
        }
    }

    public void setSectorSize(int n) {
        if (n != this.sectorSize) {
            this.sectorSize = n;
            this.fireDiskFmtChanged();
        }
    }

    public void setSectorsPerCylinder(int n) {
        if (n != this.sectorsPerCyl) {
            this.sectorsPerCyl = n;
            this.fireDiskFmtChanged();
        }
    }

    public void setSides(int n) {
        if (n != this.sides) {
            this.sides = n;
            this.fireDiskFmtChanged();
        }
    }

    public void setWarningText(String string) {
        this.warningText = string;
    }

    public boolean supportsDeletedSectors() {
        return false;
    }

    protected static void throwSectorSpaceTooSmall(int n, int n2, int n3) throws IOException {
        throw new IOException(String.format("Seite %d, Spur %d, Sektor %d: Datenfeld zu klein,\nDer Sektor kann nicht geschrieben werden,\nweil das Datenfeld des Sektors kleiner ist,\nals es laut Diskettenformat sein m\u00fcsste.", n2 - 1, n, n3));
    }

    protected static void throwUnexpectedEOF() throws IOException {
        throw new IOException("Unerwartetes Dateiende");
    }

    public boolean writeSector(int n, int n2, SectorData sectorData, byte[] byArray, int n3, boolean bl) {
        return false;
    }

    private static String createSectorKey(int n, int n2, int n3) {
        return String.format("%d:%d:%d", n, n2, n3);
    }

    private void fireDiskFmtChanged() {
        this.fmtText = null;
        if (this.owner instanceof FloppyDiskStationFrm) {
            ((FloppyDiskStationFrm)this.owner).fireDiskFormatChanged(this);
        }
    }
}

