/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;

public class AnaDisk
extends AbstractFloppyDisk {
    private String fileName;
    private FileLock fileLock;
    private RandomAccessFile raf;
    private long fileLen;
    private boolean resource;
    private Map<Integer, List<SectorData>> side0;
    private Map<Integer, List<SectorData>> side1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(AbstractFloppyDisk abstractFloppyDisk, File file) throws IOException {
        StringBuilder stringBuilder = null;
        OutputStream outputStream = null;
        try {
            outputStream = EmuUtil.createOptionalGZipOutputStream(file);
            boolean bl = false;
            int n = abstractFloppyDisk.getSides();
            int n2 = abstractFloppyDisk.getCylinders();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n3 = abstractFloppyDisk.getSectorsOfCylinder(i, j);
                    for (int k = 0; k < n3; ++k) {
                        int n4;
                        SectorData sectorData = abstractFloppyDisk.getSectorByIndex(i, j, k);
                        if (sectorData == null) continue;
                        if (sectorData.checkError() || sectorData.hasBogusID() || sectorData.isDeleted()) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(1024);
                            }
                            stringBuilder.append(String.format("Seite %d, Spur %d, Sektor %d:", j + 1, i, sectorData.getSectorNum()));
                            n4 = 0;
                            if (sectorData.hasBogusID()) {
                                stringBuilder.append(" Sektor-ID generiert");
                                n4 = 1;
                            }
                            if (sectorData.checkError()) {
                                if (n4 != 0) {
                                    stringBuilder.append(',');
                                }
                                stringBuilder.append(" CRC-Fehler");
                                n4 = 1;
                            }
                            if (sectorData.isDeleted()) {
                                if (n4 != 0) {
                                    stringBuilder.append(',');
                                }
                                stringBuilder.append(" als gel\u00f6scht markiert");
                                n4 = 1;
                                bl = true;
                            }
                            stringBuilder.append('\n');
                        }
                        outputStream.write(i);
                        outputStream.write(j);
                        outputStream.write(sectorData.getCylinder());
                        outputStream.write(sectorData.getHead());
                        outputStream.write(sectorData.getSectorNum());
                        outputStream.write(sectorData.getSizeCode());
                        n4 = sectorData.getDataLength();
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        outputStream.write(n4 & 0xFF);
                        outputStream.write(n4 >> 8);
                        if (n4 <= 0) continue;
                        sectorData.writeTo(outputStream, n4);
                    }
                }
            }
            outputStream.close();
            outputStream = null;
            if (stringBuilder != null) {
                stringBuilder.append("\nDie angezeigten Informationen k\u00f6nnen in einer AnaDisk-Datei nicht gespeichert werden\nund sind deshalb in der erzeugten Datei nicht mehr enthalten.\n");
                if (bl) {
                    stringBuilder.append("\nGel\u00f6schte Sektoren werden in AnaDisk-Dateien nicht unterst\u00fctzt\nund sind deshalb als normale Sektoren enthalten.\n");
                }
            }
        }
        finally {
            EmuUtil.closeSilent(outputStream);
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnaDisk newFile(Frame frame, File file) throws IOException {
        AnaDisk anaDisk = null;
        FileLock fileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileLock = EmuUtil.lockFile(file, randomAccessFile);
            randomAccessFile.setLength(0L);
            randomAccessFile.seek(0L);
            anaDisk = new AnaDisk(frame, 0, 0, 0, 0, file.getPath(), false, randomAccessFile, fileLock, 0L, null, null);
            if (anaDisk != null) return anaDisk;
        }
        catch (Throwable throwable) {
            if (anaDisk != null) throw throwable;
            EmuUtil.releaseSilent(fileLock);
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.releaseSilent(fileLock);
        EmuUtil.closeSilent(randomAccessFile);
        return anaDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnaDisk openFile(Frame frame, File file) throws IOException {
        AnaDisk anaDisk = null;
        FileLock fileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileLock = EmuUtil.lockFile(file, randomAccessFile);
            anaDisk = AnaDisk.createInstance(frame, null, randomAccessFile, fileLock, file.getPath(), false);
            if (anaDisk != null) return anaDisk;
        }
        catch (Throwable throwable) {
            if (anaDisk != null) throw throwable;
            EmuUtil.releaseSilent(fileLock);
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.releaseSilent(fileLock);
        EmuUtil.closeSilent(randomAccessFile);
        return anaDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnaDisk readFile(Frame frame, File file) throws IOException {
        AnaDisk anaDisk = null;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            if (EmuUtil.isGZipFile(file)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            anaDisk = AnaDisk.createInstance(frame, inputStream, null, null, file.getPath(), false);
        }
        finally {
            if (anaDisk == null) {
                EmuUtil.closeSilent(inputStream);
            }
        }
        return anaDisk;
    }

    public static AnaDisk readResourceStream(Frame frame, InputStream inputStream, String string) throws IOException {
        return AnaDisk.createInstance(frame, inputStream, null, null, string, true);
    }

    @Override
    public synchronized void closeSilent() {
        EmuUtil.releaseSilent(this.fileLock);
        EmuUtil.closeSilent(this.raf);
    }

    @Override
    public boolean formatTrack(int n, int n2, SectorID[] sectorIDArray, byte[] byArray) {
        boolean bl = false;
        if (this.raf != null && sectorIDArray != null && byArray != null && sectorIDArray.length > 0) {
            Map<Integer, List<SectorData>> map = null;
            if ((n2 & 1) != 0) {
                if (this.side1 == null) {
                    this.side1 = new HashMap<Integer, List<SectorData>>();
                }
                map = this.side1;
            } else {
                if (this.side0 == null) {
                    this.side0 = new HashMap<Integer, List<SectorData>>();
                }
                map = this.side0;
            }
            List<SectorData> list = map.get(n);
            if (list == null) {
                list = new ArrayList<SectorData>(sectorIDArray.length);
                map.put(n, list);
            }
            if (list.isEmpty()) {
                try {
                    this.raf.seek(this.fileLen);
                    for (int i = 0; i < sectorIDArray.length; ++i) {
                        int n3;
                        SectorID sectorID = sectorIDArray[i];
                        this.raf.write(n);
                        this.raf.write(n2);
                        this.raf.write(sectorID.getCylinder());
                        this.raf.write(sectorID.getHead());
                        this.raf.write(sectorID.getSectorNum());
                        this.raf.write(sectorID.getSizeCode());
                        this.raf.write(byArray.length & 0xFF);
                        this.raf.write(byArray.length >> 8);
                        this.raf.write(byArray);
                        SectorData sectorData = new SectorData(i, sectorID.getCylinder(), sectorID.getHead(), sectorID.getSectorNum(), sectorID.getSizeCode(), byArray, 0, byArray.length);
                        sectorData.setDisk(this);
                        sectorData.setFilePortionLen(byArray.length + 8);
                        sectorData.setFilePos(this.fileLen);
                        list.add(sectorData);
                        int n4 = n3 = (n2 & 1) != 0 ? 2 : 1;
                        if (n3 > this.getSides()) {
                            this.setSides(n3);
                        }
                        if (n >= this.getCylinders()) {
                            this.setCylinders(n + 1);
                        }
                        if (sectorIDArray.length > this.getSectorsPerCylinder()) {
                            this.setSectorsPerCylinder(sectorIDArray.length);
                        }
                        if (this.getSectorSize() == 0) {
                            this.setSectorSize(byArray.length);
                        }
                        this.fileLen += 8L;
                        this.fileLen += (long)byArray.length;
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    bl = false;
                    this.fireShowError("Anh\u00e4ngen von Sektoren fehlgeschlagen", iOException);
                }
            } else {
                bl = super.formatTrack(n, n2, sectorIDArray, byArray);
            }
        }
        return bl;
    }

    @Override
    public String getFileFormatText() {
        return "AnaDisk-Datei";
    }

    @Override
    public synchronized SectorData getSectorByIndex(int n, int n2, int n3) {
        SectorData sectorData = null;
        List<SectorData> list = this.getSectorsOfCyl(n, n2);
        if (list != null && n3 >= 0 && n3 < list.size() && (sectorData = list.get(n3)) != null) {
            sectorData.setDisk(this);
        }
        return sectorData;
    }

    @Override
    public int getSectorsOfCylinder(int n, int n2) {
        List<SectorData> list = this.getSectorsOfCyl(n, n2);
        return list != null ? list.size() : 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.raf == null;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        if (properties != null && this.fileName != null) {
            if (this.resource) {
                properties.setProperty(string + "resource", this.fileName);
            } else {
                properties.setProperty(string + "file", this.fileName);
            }
            properties.setProperty(string + "readonly", Boolean.toString(this.isReadOnly()));
        }
    }

    @Override
    public boolean writeSector(int n, int n2, SectorData sectorData, byte[] byArray, int n3, boolean bl) {
        boolean bl2 = false;
        if (this.raf != null && sectorData != null && byArray != null && !bl && sectorData.getDisk() == this) {
            int n4 = sectorData.getSectorNum();
            long l = sectorData.getFilePos();
            if (l >= 0L) {
                try {
                    if (n3 + 8 < sectorData.getFilePortionLen()) {
                        AnaDisk.throwSectorSpaceTooSmall(n, n2, sectorData.getSectorNum());
                    }
                    this.raf.seek(l + 8L);
                    this.raf.write(byArray, 0, n3);
                    sectorData.setData(bl, byArray, n3);
                    bl2 = true;
                }
                catch (IOException iOException) {
                    this.fireShowWriteError(n, n2, n4, iOException);
                    sectorData.setError(true);
                }
            }
        }
        return bl2;
    }

    private AnaDisk(Frame frame, int n, int n2, int n3, int n4, String string, boolean bl, RandomAccessFile randomAccessFile, FileLock fileLock, long l, Map<Integer, List<SectorData>> map, Map<Integer, List<SectorData>> map2) {
        super(frame, n, n2, n3, n4);
        this.fileName = string;
        this.resource = bl;
        this.raf = randomAccessFile;
        this.fileLock = fileLock;
        this.fileLen = l;
        this.side0 = map;
        this.side1 = map2;
    }

    private static AnaDisk createInstance(Frame frame, InputStream inputStream, RandomAccessFile randomAccessFile, FileLock fileLock, String string, boolean bl) throws IOException {
        AnaDisk anaDisk = null;
        if (inputStream == null) {
            inputStream = EmuUtil.createInputStream(randomAccessFile);
        }
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        long l = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            long l2 = l;
            int n4 = inputStream.read();
            if (n4 < 0) break;
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            int n11 = inputStream.read();
            l += 8L;
            int n12 = n11 << 8 & 0xFF00 | n10 & 0xFF;
            if (n5 < 0 || n5 > 1 || n6 < 0 || n7 < 0 || n7 > 1 || n8 < 1 || n9 < 0 || n9 > 3 || n10 < 0 || n11 < 0 || n12 < 0) break;
            if (n4 >= n) {
                n = n4 + 1;
            }
            int n13 = 128;
            if (n9 > 0) {
                n13 <<= n9;
            }
            if (n3 == 0) {
                n3 = n13;
            }
            byte[] byArray = null;
            if (n12 > 0) {
                byArray = new byte[n13];
                int n14 = 0;
                while (n12 > 0) {
                    int n15 = inputStream.read();
                    ++l;
                    if (n15 != -1 && n14 < byArray.length) {
                        byArray[n14++] = (byte)n15;
                    }
                    --n12;
                }
                while (n14 < byArray.length) {
                    byArray[n14++] = 0;
                }
            }
            HashMap hashMap3 = null;
            if (n5 == 0) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap3 = hashMap;
            } else if (n5 == 1) {
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                }
                hashMap3 = hashMap2;
            }
            if (hashMap3 == null) continue;
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap3.get(n4);
            if (arrayList == null) {
                arrayList = n4 > 0 && n2 > 0 ? new ArrayList(n2) : new ArrayList<Object>();
                hashMap3.put(n4, arrayList);
            }
            boolean bl2 = false;
            for (SectorData sectorData : arrayList) {
                if (!sectorData.equalsSectorID(n6, n7, n8, n9) || !sectorData.equalsData(byArray, 0, n13)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            SectorData sectorData = new SectorData(arrayList.size(), n6, n7, n8, n9, byArray, 0, byArray != null ? byArray.length : 0);
            sectorData.setFilePos(l2);
            sectorData.setFilePortionLen((int)(l - l2));
            arrayList.add(sectorData);
            n2 = Math.max(n2, arrayList.size());
        }
        if (hashMap != null || hashMap2 != null) {
            int n16 = 1;
            if (hashMap2 != null) {
                ++n16;
            }
            anaDisk = new AnaDisk(frame, n16, n, n2, n3, string, bl, randomAccessFile, fileLock, l, hashMap, hashMap2);
        }
        if (anaDisk == null) {
            throw new IOException("Datei ist keine AnaDisk-Datei");
        }
        return anaDisk;
    }

    private List<SectorData> getSectorsOfCyl(int n, int n2) {
        Map<Integer, List<SectorData>> map;
        List<SectorData> list = null;
        Map<Integer, List<SectorData>> map2 = map = (n2 & 1) != 0 ? this.side1 : this.side0;
        if (map != null) {
            list = map.get(n);
        }
        return list;
    }
}

