/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileEntry;
import jkcemu.base.FileNameFld;
import jkcemu.base.FileTableModel;
import jkcemu.base.HelpFrm;
import jkcemu.base.NIOFileTimesViewFactory;
import jkcemu.base.ReplyTextDlg;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.AnaDisk;
import jkcemu.disk.CPCDisk;
import jkcemu.disk.ChangeFileAttrsDlg;
import jkcemu.disk.CopyQMDisk;
import jkcemu.disk.DiskImgCreator;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskFormatSelectFld;
import jkcemu.disk.ImageDisk;
import jkcemu.disk.PlainDisk;
import jkcemu.disk.TeleDisk;
import jkcemu.text.TextUtil;

public class DiskImgCreateFrm
extends BaseFrm
implements ChangeListener,
DropTargetListener,
FlavorListener,
ListSelectionListener {
    private static final String HELP_PAGE = "/help/disk/creatediskimg.htm";
    private static DiskImgCreateFrm instance = null;
    private Clipboard clipboard = null;
    private File lastOutFile = null;
    private boolean dataChanged = false;
    private JMenuItem mnuClose;
    private JMenuItem mnuNew;
    private JMenuItem mnuFileAdd;
    private JMenuItem mnuFileRemove;
    private JMenuItem mnuSort;
    private JMenuItem mnuSave;
    private JMenuItem mnuChangeAttrs;
    private JMenuItem mnuChangeUser;
    private JMenuItem mnuPaste;
    private JMenuItem mnuSelectAll;
    private JMenuItem mnuHelpContent;
    private JButton btnFileAdd;
    private JButton btnFileRemove;
    private JButton btnSave;
    private JButton btnFileUp;
    private JButton btnFileDown;
    private JButton btnSysTrackFileSelect;
    private JButton btnSysTrackFileRemove;
    private JTabbedPane tabbedPane;
    private FileTableModel tableModel;
    private JTable table;
    private JScrollPane scrollPane;
    private FloppyDiskFormatSelectFld fmtSelectFld;
    private JLabel labelSysTrackFile;
    private FileNameFld fldSysTrackFileName;
    private JTextField fldRemark;
    private JLabel labelStatus;
    private DropTarget dropTargetFile1;
    private DropTarget dropTargetFile2;
    private DropTarget dropTargetSysTrackFile;

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new DiskImgCreateFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object != null) {
            if (object == this.tabbedPane) {
                this.updActionButtons();
                this.updStatusText();
            } else if (object == this.fmtSelectFld) {
                this.updSysTrackFileFieldsEnabled();
                this.updStatusText();
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file;
        Object object = dropTargetDropEvent.getSource();
        if (object == this.dropTargetFile1 || object == this.dropTargetFile2) {
            if (EmuUtil.isFileDrop(dropTargetDropEvent)) {
                dropTargetDropEvent.acceptDrop(1);
                this.pasteFiles(dropTargetDropEvent.getTransferable());
            }
        } else if (object == this.dropTargetSysTrackFile && (file = EmuUtil.fileDrop(this, dropTargetDropEvent)) != null) {
            this.addSysTrackFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.updPasteButton();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updActionButtons();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        this.updStatusText();
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.mnuClose) {
            bl = true;
            this.doClose();
        } else if (object == this.mnuFileAdd || object == this.btnFileAdd) {
            bl = true;
            this.doFileAdd();
        } else if (object == this.mnuFileRemove || object == this.btnFileRemove) {
            bl = true;
            this.doFileRemove();
        } else if (object == this.mnuNew) {
            bl = true;
            this.doNew();
        } else if (object == this.mnuSort) {
            bl = true;
            this.tableModel.sortAscending(0);
        } else if (object == this.mnuSave || object == this.btnSave) {
            bl = true;
            this.doSave();
        } else if (object == this.btnFileDown) {
            bl = true;
            this.doFileDown();
        } else if (object == this.btnFileUp) {
            bl = true;
            this.doFileUp();
        } else if (object == this.btnSysTrackFileSelect) {
            bl = true;
            this.doSysTrackFileSelect();
        } else if (object == this.mnuChangeAttrs) {
            bl = true;
            this.doChangeAttrs();
        } else if (object == this.mnuChangeUser) {
            bl = true;
            this.doChangeUser();
        } else if (object == this.mnuPaste) {
            bl = true;
            this.doPaste();
        } else if (object == this.mnuSelectAll) {
            bl = true;
            this.doSelectAll();
        } else if (object == this.btnSysTrackFileRemove) {
            bl = true;
            this.doSysTrackFileRemove();
        } else if (object == this.mnuHelpContent) {
            bl = true;
            HelpFrm.open(HELP_PAGE);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = true;
        if (this.dataChanged) {
            this.setState(0);
            this.toFront();
            if (!BaseDlg.showYesNoDlg(this, "Daten ge\u00e4ndert!\nTrotzdem schlie\u00dfen?")) {
                bl = false;
            }
        }
        if (bl) {
            this.tableModel.clear(true);
            this.updStatusText();
            bl = super.doClose();
        }
        if (bl) {
            this.dataChanged = false;
            Main.checkQuit(this);
        }
        return bl;
    }

    private void doChangeAttrs() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            ChangeFileAttrsDlg changeFileAttrsDlg = new ChangeFileAttrsDlg((Window)this);
            changeFileAttrsDlg.setVisible(true);
            Boolean bl = changeFileAttrsDlg.getReadOnlyValue();
            Boolean bl2 = changeFileAttrsDlg.getSystemFileValue();
            Boolean bl3 = changeFileAttrsDlg.getArchiveValue();
            if (bl != null || bl2 != null || bl3 != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    FileEntry fileEntry = this.tableModel.getRow(nArray[i]);
                    if (fileEntry == null) continue;
                    if (bl != null) {
                        fileEntry.setReadOnly(bl);
                    }
                    if (bl2 != null) {
                        fileEntry.setSystemFile(bl2);
                    }
                    if (bl3 != null) {
                        fileEntry.setArchive(bl3);
                    }
                    this.tableModel.fireTableRowsUpdated(n, n);
                }
            }
        }
    }

    private void doChangeUser() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Object object;
            Object object2;
            int n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                Integer n2;
                object2 = this.tableModel.getRow(nArray[i]);
                if (object2 == null || (n2 = ((FileEntry)object2).getUserNum()) == null) continue;
                if (n >= 0) {
                    if (n2 == n) continue;
                    n = -1;
                    break;
                }
                n = n2;
            }
            if (n < 0 || n > 15) {
                n = 0;
            }
            JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
            jPanel.add(new JLabel("User-Bereich:"));
            object2 = new JSpinner(new SpinnerNumberModel(n, 0, 15, 1));
            jPanel.add((Component)object2);
            int n3 = JOptionPane.showConfirmDialog(this, jPanel, "User-Bereich \u00e4ndern", 2, -1);
            if (n3 == 0 && (object = ((JSpinner)object2).getValue()) != null && object instanceof Number && (n = ((Number)object).intValue()) >= 0 && n <= 15) {
                Integer n4 = n;
                for (int i = 0; i < nArray.length; ++i) {
                    int n5 = nArray[i];
                    FileEntry fileEntry = this.tableModel.getRow(n5);
                    if (fileEntry == null) continue;
                    fileEntry.setUserNum(n4);
                    this.tableModel.fireTableRowsUpdated(n5, n5);
                }
            }
        }
    }

    public void doNew() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.dataChanged) {
            stringBuilder.append("Die letzten \u00c3nderungen wurden nicht gespeichert!");
        }
        if (this.tableModel.getRowCount() > 0 || this.fldSysTrackFileName.getFile() != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Die hinzugef\u00fcgten Dateien werden entfernt.");
        }
        if (stringBuilder.length() > 0) {
            bl = BaseDlg.showConfirmDlg(this, stringBuilder.toString());
        }
        if (bl) {
            this.tableModel.clear(true);
            this.fldSysTrackFileName.setFile(null);
            this.dataChanged = false;
            this.lastOutFile = null;
            this.updTitle();
        }
    }

    private void doPaste() {
        if (this.clipboard != null) {
            try {
                this.pasteFiles(this.clipboard.getContents(this));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void doSelectAll() {
        int n = this.table.getRowCount();
        if (n > 0) {
            this.table.setRowSelectionInterval(0, n - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSave() {
        boolean bl = true;
        if (this.tableModel.getRowCount() == 0) {
            bl = BaseDlg.showYesNoDlg(this, "Es wurden keine Dateien hinzugef\u00fcgt.\nM\u00f6chten Sie eine leere Diskettenabbilddatei erstellen?");
        }
        int n = this.fmtSelectFld.getSysTracks();
        File file = this.fldSysTrackFileName.getFile();
        if (file != null && n == 0 && JOptionPane.showConfirmDialog(this, "Sie haben ein Format ohne Systemspuren ausgew\u00e4hlt,\naber eine Datei f\u00fcr die Systemspuren angegeben.\nDiese Datei wird ignoriert.", "Warnung", 2, 2) != 0) {
            return;
        }
        if (!bl) return;
        File file2 = EmuUtil.showFileSaveDlg(this, "Diskettenabbilddatei speichern", this.lastOutFile != null ? this.lastOutFile : Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter(), EmuUtil.getAnaDiskFileFilter(), EmuUtil.getCopyQMFileFilter(), EmuUtil.getDskFileFilter(), EmuUtil.getImageDiskFileFilter(), EmuUtil.getTeleDiskFileFilter());
        if (file2 == null) return;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = file2.getName();
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.endsWith(".gz")) {
                string2 = string2.substring(0, string2.length() - 3);
            }
            bl2 = TextUtil.endsWith(string2, DiskUtil.plainDiskFileExt);
            bl3 = TextUtil.endsWith(string2, DiskUtil.anaDiskFileExt);
            bl5 = TextUtil.endsWith(string2, DiskUtil.copyQMFileExt);
            bl4 = TextUtil.endsWith(string2, DiskUtil.dskFileExt);
            bl6 = TextUtil.endsWith(string2, DiskUtil.imageDiskFileExt);
            bl7 = TextUtil.endsWith(string2, DiskUtil.teleDiskFileExt);
        }
        if (bl2 || bl3 || bl5 || bl4 || bl6 || bl7) {
            boolean bl8 = false;
            OutputStream outputStream = null;
            try {
                Object object;
                int n2 = this.fmtSelectFld.getSides();
                int n3 = this.fmtSelectFld.getCylinders();
                int n4 = this.fmtSelectFld.getSectorsPerCylinder();
                int n5 = this.fmtSelectFld.getSectorSize();
                DiskImgCreator diskImgCreator = new DiskImgCreator(new NIOFileTimesViewFactory(), n2, n3, n, n4, n5, this.fmtSelectFld.isBlockNum16Bit(), this.fmtSelectFld.getBlockSize(), this.fmtSelectFld.getDirBlocks(), this.fmtSelectFld.isDateStamperEnabled());
                if (file != null && n > 0) {
                    diskImgCreator.fillSysTracks(file);
                }
                int n6 = this.tableModel.getRowCount();
                for (int i = 0; i < n6; ++i) {
                    object = this.tableModel.getRow(i);
                    if (object == null) continue;
                    try {
                        diskImgCreator.addFile(((FileEntry)object).getUserNum(), ((FileEntry)object).getName(), ((FileEntry)object).getFile(), ((FileEntry)object).isReadOnly(), ((FileEntry)object).isSystemFile(), ((FileEntry)object).isArchive());
                        continue;
                    }
                    catch (IOException iOException) {
                        this.fireSelectRowInterval(i, i);
                        String string3 = iOException.getMessage();
                        if (string3 != null && string3.isEmpty()) {
                            string3 = null;
                        }
                        if (JOptionPane.showConfirmDialog(this, string3 = string3 != null ? ((FileEntry)object).getName() + ":\n" + string3 : ((FileEntry)object).getName() + " kann nicht hinzugef\u00fcgt werden.", "Fehler", 2, 0) == 0) continue;
                        bl8 = true;
                        break;
                    }
                }
                if (bl8) return;
                byte[] byArray = diskImgCreator.getPlainDiskByteBuffer();
                if (bl2) {
                    outputStream = EmuUtil.createOptionalGZipOutputStream(file2);
                    outputStream.write(byArray);
                    outputStream.close();
                    outputStream = null;
                } else {
                    object = PlainDisk.createForByteArray(this, file2.getPath(), byArray, new FloppyDiskFormat(n2, n3, n4, n5), this.fmtSelectFld.getInterleave());
                    if (object != null) {
                        if (bl3) {
                            AnaDisk.export((AbstractFloppyDisk)object, file2);
                        } else if (bl5) {
                            CopyQMDisk.export((AbstractFloppyDisk)object, file2, this.fldRemark.getText());
                        } else if (bl4) {
                            CPCDisk.export((AbstractFloppyDisk)object, file2);
                        } else if (bl6) {
                            ImageDisk.export((AbstractFloppyDisk)object, file2, this.fldRemark.getText());
                        } else if (bl7) {
                            TeleDisk.export((AbstractFloppyDisk)object, file2, this.fldRemark.getText());
                        }
                    }
                }
                this.dataChanged = false;
                this.lastOutFile = file2;
                this.updTitle();
                Main.setLastFile(file2, "disk");
                this.labelStatus.setText("Diskettenabbilddatei gespeichert");
                return;
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this, exception);
                return;
            }
            finally {
                EmuUtil.closeSilent(outputStream);
            }
        } else {
            BaseDlg.showErrorDlg((Component)this, "Aus der Dateiendung der ausgew\u00e4hlten Datei\nkann JKCEMU das Dateiformat nicht erkennen.\nW\u00e4hlen Sie bitte einen Dateinamen mit einer f\u00fcr\ndas gew\u00fcnschte Format \u00fcblichen Dateiendung aus.");
        }
    }

    private void doFileAdd() {
        List<File> list = EmuUtil.showMultiFileOpenDlg(this, "Dateien hinzuf\u00fcgen", Main.getLastDirFile("software"), new FileFilter[0]);
        if (list != null) {
            int n = this.table.getRowCount();
            for (File file : list) {
                if (!this.addFile(file)) continue;
                Main.setLastFile(file, "software");
            }
            this.updSelectAllEnabled();
            this.fireSelectRowInterval(n, this.table.getRowCount() - 1);
        }
    }

    private void doFileRemove() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.tableModel.removeRow(nArray[i], true);
                this.mnuSort.setEnabled(this.tableModel.getRowCount() > 1);
                this.dataChanged = true;
            }
            this.updSelectAllEnabled();
            this.updStatusText();
        }
    }

    private void doFileDown() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            if (nArray[nArray.length - 1] + 1 < this.tableModel.getRowCount()) {
                int n = nArray.length - 1;
                while (n >= 0) {
                    int n2 = nArray[n];
                    FileEntry fileEntry = this.tableModel.getRow(n2);
                    FileEntry fileEntry2 = this.tableModel.getRow(n2 + 1);
                    if (fileEntry != null && fileEntry2 != null) {
                        this.tableModel.setRow(n2, fileEntry2);
                        this.tableModel.setRow(n2 + 1, fileEntry);
                        this.tableModel.fireTableDataChanged();
                        this.dataChanged = true;
                    }
                    int n3 = n--;
                    nArray[n3] = nArray[n3] + 1;
                }
            }
            this.fireSelectRows(nArray);
        }
    }

    private void doFileUp() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            if (nArray[0] > 0) {
                int n = 0;
                while (n < nArray.length) {
                    int n2 = nArray[n];
                    FileEntry fileEntry = this.tableModel.getRow(n2);
                    FileEntry fileEntry2 = this.tableModel.getRow(n2 - 1);
                    if (fileEntry != null && fileEntry2 != null) {
                        this.tableModel.setRow(n2, fileEntry2);
                        this.tableModel.setRow(n2 - 1, fileEntry);
                        this.tableModel.fireTableDataChanged();
                        this.dataChanged = true;
                    }
                    int n3 = n++;
                    nArray[n3] = nArray[n3] - 1;
                }
            }
            this.fireSelectRows(nArray);
        }
    }

    private void doSysTrackFileSelect() {
        File file = EmuUtil.showFileOpenDlg(this, "Datei \u00fcffnen", Main.getLastDirFile("software"), new FileFilter[0]);
        if (file != null) {
            this.addSysTrackFile(file);
        }
    }

    private void doSysTrackFileRemove() {
        this.fldSysTrackFileName.setFile(null);
        this.btnSysTrackFileRemove.setEnabled(false);
    }

    private DiskImgCreateFrm() {
        this.updTitle();
        Main.updIcon(this);
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            this.clipboard = toolkit.getSystemClipboard();
        }
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuNew = this.createJMenuItem("Neue Diskettenabbilddatei");
        jMenu.add(this.mnuNew);
        jMenu.addSeparator();
        this.mnuFileAdd = this.createJMenuItem("Hinzuf\u00fcgen...");
        jMenu.add(this.mnuFileAdd);
        this.mnuFileRemove = this.createJMenuItem("Entfernen", KeyStroke.getKeyStroke(127, 0));
        jMenu.add(this.mnuFileRemove);
        jMenu.addSeparator();
        this.mnuSort = this.createJMenuItem("Sortieren");
        this.mnuSort.setEnabled(false);
        jMenu.add(this.mnuSort);
        jMenu.addSeparator();
        this.mnuSave = this.createJMenuItem("Diskettenabbilddatei speichern...");
        jMenu.add(this.mnuSave);
        jMenu.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuPaste = this.createJMenuItem("Einf\u00fcgen");
        jMenu2.add(this.mnuPaste);
        jMenu2.addSeparator();
        this.mnuChangeAttrs = this.createJMenuItem("Dateiattribute \u00e4ndern...");
        jMenu2.add(this.mnuChangeAttrs);
        this.mnuChangeUser = this.createJMenuItem("User-Bereich \u00e4ndern...");
        jMenu2.add(this.mnuChangeUser);
        jMenu2.addSeparator();
        this.mnuSelectAll = this.createJMenuItem("Alles ausw\u00e4hlem");
        this.mnuSelectAll.setEnabled(false);
        jMenu2.add(this.mnuSelectAll);
        JMenu jMenu3 = new JMenu("?");
        jMenuBar.add(jMenu3);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.add((Component)jToolBar, gridBagConstraints);
        this.btnFileAdd = this.createImageButton("/images/file/open.png", "Hinzuf\u00fcgen");
        jToolBar.add(this.btnFileAdd);
        this.btnFileRemove = this.createImageButton("/images/file/delete.png", "Entfernen");
        jToolBar.add(this.btnFileRemove);
        jToolBar.addSeparator();
        this.btnSave = this.createImageButton("/images/file/save_as.png", "Diskettenabbilddatei speichern");
        jToolBar.add(this.btnSave);
        jToolBar.addSeparator();
        this.btnFileDown = this.createImageButton("/images/nav/down.png", "Nach unten");
        jToolBar.add(this.btnFileDown);
        this.btnFileUp = this.createImageButton("/images/nav/up.png", "Nach oben");
        jToolBar.add(this.btnFileUp);
        this.tabbedPane = new JTabbedPane();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.tableModel = new FileTableModel(FileTableModel.Column.NAME, FileTableModel.Column.FILE, FileTableModel.Column.SIZE, FileTableModel.Column.LAST_MODIFIED, FileTableModel.Column.USER_NUM, FileTableModel.Column.READ_ONLY, FileTableModel.Column.SYSTEM_FILE, FileTableModel.Column.ARCHIVE);
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 300));
        this.table.setRowSelectionAllowed(true);
        this.table.setRowSorter(null);
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setSelectionMode(2);
        this.table.addMouseListener(this);
        EmuUtil.setTableColWidths(this.table, 100, 280, 70, 130, 40, 40, 40, 40);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
            this.updActionButtons();
        }
        this.scrollPane = new JScrollPane(this.table);
        this.tabbedPane.addTab("Dateien", this.scrollPane);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Format", new JScrollPane(jPanel));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.fmtSelectFld = new FloppyDiskFormatSelectFld(true);
        jPanel.add((Component)this.fmtSelectFld, gridBagConstraints2);
        this.labelSysTrackFile = new JLabel("Datei f\u00fcr Systemspuren:");
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.labelSysTrackFile, gridBagConstraints2);
        this.fldSysTrackFileName = new FileNameFld();
        this.fldSysTrackFileName.setEditable(false);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldSysTrackFileName, gridBagConstraints2);
        this.btnSysTrackFileSelect = this.createImageButton("/images/file/open.png", "\u00d6ffnen");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx += 5;
        jPanel.add((Component)this.btnSysTrackFileSelect, gridBagConstraints2);
        this.btnSysTrackFileRemove = this.createImageButton("/images/file/delete.png", "\u00d6ffnen");
        this.btnSysTrackFileRemove.setEnabled(false);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnSysTrackFileRemove, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Kommentar", new JScrollPane(jPanel2));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel2.add((Component)new JLabel("Kommentar zur Diskettenabbilddatei:"), gridBagConstraints3);
        this.fldRemark = new JTextField("Erzeugt mit JKCEMU");
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.fldRemark, gridBagConstraints3);
        JLabel jLabel = new JLabel("Achtung!");
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(font.deriveFont(1));
        }
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets.top = 10;
        gridBagConstraints3.insets.bottom = 0;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)jLabel, gridBagConstraints3);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)new JLabel("Ein Kommentar wird nur bei CopyQM-, ImageDisk- und TeleDisk-Dateien unterst\u00fctzt."), gridBagConstraints3);
        this.labelStatus = new JLabel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelStatus, gridBagConstraints);
        this.updStatusText();
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.tabbedPane.addChangeListener(this);
        this.fmtSelectFld.addChangeListener(this);
        if (this.clipboard != null) {
            this.clipboard.addFlavorListener(this);
        }
        this.dropTargetFile1 = new DropTarget(this.table, this);
        this.dropTargetFile2 = new DropTarget(this.scrollPane, this);
        this.dropTargetSysTrackFile = new DropTarget(this.fldSysTrackFileName, this);
        this.dropTargetFile1.setActive(true);
        this.dropTargetFile1.setActive(true);
        this.dropTargetSysTrackFile.setActive(true);
        this.updActionButtons();
        this.updBgColor();
        this.updPasteButton();
    }

    private boolean addFile(File file) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        if (file.isDirectory() && (string = file.getName()) != null) {
            try {
                int n = Integer.parseInt(string);
                if (n >= 1 && n <= 15) {
                    File[] fileArray;
                    bl2 = true;
                    if (BaseDlg.showYesNoDlg(this, "Sollen die Dateien im Verzeichnis " + string + "\nin der Benutzerebene " + string + " hinzugef\u00fcgt werden?") && (fileArray = file.listFiles()) != null) {
                        for (File file2 : fileArray) {
                            if (file2.isFile() && !(bl = this.addFileInternal(n, file2))) break;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl2) {
            bl = this.addFileInternal(0, file);
        }
        return bl;
    }

    private boolean addFileInternal(int n, File file) {
        String string;
        boolean bl = false;
        long l = -1L;
        if (file.isFile()) {
            l = file.length();
            if (l < 1L) {
                string = file.getName();
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                if (string == null) {
                    string = file.getPath();
                }
                if (!BaseDlg.showYesNoDlg(this, "Datei " + string + ":\nDie Datei ist leer!\n" + "Trotzdem hinzuf\u00fcgen?")) {
                    file = null;
                }
            } else if (l > 524288L) {
                BaseDlg.showErrorDlg((Component)this, "Datei ist zu gro\u00df!");
                file = null;
            } else {
                string = file.getName();
                if (string != null && string.equalsIgnoreCase("@boot.sys") && BaseDlg.showYesNoDlg(this, "@boot.sys:\nJKCEMU verwendet Dateien mit diesem Namen f\u00fcr den Inhalt der Systemspuren.\nM\u00f6chten Sie deshalb nun diese Datei f\u00fcr die Systemspuren verwenden,\nanstelle Sie als gew\u00f6hnliche Datei im Directory einzubinden?")) {
                    this.fldSysTrackFileName.setFile(file);
                    this.btnSysTrackFileRemove.setEnabled(true);
                    file = null;
                    bl = true;
                }
            }
        } else {
            BaseDlg.showErrorDlg((Component)this, "Es k\u00f6nnen nur regul\u00e4re Dateien hinzugef\u00fcgt werden.");
            file = null;
        }
        if (file != null) {
            string = null;
            String string2 = file.getName();
            if (string2 != null) {
                string = DiskImgCreateFrm.createEntryName(string2);
            }
            if (string == null) {
                CharSequence charSequence;
                String string3 = "Dateiname";
                String string4 = null;
                if (string2 != null) {
                    char c;
                    int n2;
                    if (!string2.isEmpty()) {
                        string3 = "Datei: " + string2;
                    }
                    charSequence = new StringBuilder(12);
                    int n3 = string2.length();
                    int n4 = 0;
                    for (n2 = 0; n4 < 8 && n2 < n3; ++n2) {
                        c = Character.toUpperCase(string2.charAt(n2));
                        if (DiskUtil.isValidCPMFileNameChar(c)) {
                            ((StringBuilder)charSequence).append(c);
                            ++n4;
                            continue;
                        }
                        if (c == '.') break;
                    }
                    if (n4 > 0 && (n2 = string2.lastIndexOf(46)) > 0) {
                        c = '\u0001';
                        n4 = 0;
                        for (int i = n2 + 1; n4 < 3 && i < n3; ++i) {
                            char c2 = Character.toUpperCase(string2.charAt(i));
                            if (!DiskUtil.isValidCPMFileNameChar(c2)) continue;
                            if (c != '\u0000') {
                                ((StringBuilder)charSequence).append('.');
                                c = '\u0000';
                            }
                            ((StringBuilder)charSequence).append(c2);
                            ++n4;
                        }
                    }
                    string4 = ((StringBuilder)charSequence).toString();
                }
                charSequence = null;
                do {
                    if ((charSequence = ReplyTextDlg.showReplyTextDlg(this, "Dateiname im 8.3-Format:", string3, string4)) == null || (string = DiskImgCreateFrm.createEntryName((String)charSequence)) != null) continue;
                    BaseDlg.showErrorDlg((Component)this, "Der eingegebene Name ist ung\u00fcltig.");
                } while (charSequence != null && string == null);
            }
            if (string != null) {
                boolean bl2 = false;
                int n5 = this.tableModel.getRowCount();
                for (int i = 0; i < n5; ++i) {
                    FileEntry fileEntry = this.tableModel.getRow(i);
                    if (fileEntry == null || !fileEntry.getName().equals(string)) continue;
                    this.table.setRowSelectionInterval(i, i);
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    BaseDlg.showErrorDlg((Component)this, "Es existiert bereits ein Eintrag mit diesem Namen.");
                } else {
                    long l2;
                    FileEntry fileEntry = new FileEntry(string);
                    fileEntry.setUserNum(n);
                    if (l >= 0L) {
                        fileEntry.setSize(l);
                    }
                    if ((l2 = file.lastModified()) != 0L) {
                        fileEntry.setLastModified(l2);
                    }
                    fileEntry.setFile(file);
                    fileEntry.setReadOnly(!file.canWrite());
                    fileEntry.setSystemFile(false);
                    fileEntry.setArchive(false);
                    this.tableModel.addRow(fileEntry, true);
                    this.updStatusText();
                    this.mnuSort.setEnabled(this.tableModel.getRowCount() > 1);
                    this.dataChanged = true;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void addSysTrackFile(File file) {
        String string = null;
        if (!file.exists()) {
            string = "Datei nicht gefunden";
        } else if (!file.isFile()) {
            string = "Datei ist keine regul\u00e4re Datei";
        }
        if (string != null) {
            BaseDlg.showErrorDlg((Component)this, string);
        } else {
            this.fldSysTrackFileName.setFile(file);
            this.btnSysTrackFileRemove.setEnabled(true);
        }
    }

    private static String createEntryName(String string) {
        StringBuilder stringBuilder = new StringBuilder(12);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; !bl && i < n3; ++i) {
            char c = Character.toUpperCase(string.charAt(i));
            if (DiskUtil.isValidCPMFileNameChar(c)) {
                if (!bl2 && n < 8) {
                    stringBuilder.append(c);
                    ++n;
                    continue;
                }
                if (bl2 && n2 < 3) {
                    stringBuilder.append(c);
                    ++n2;
                    continue;
                }
                bl = true;
                continue;
            }
            if (c == '.') {
                if (!bl2 && n >= 1 && n <= 8) {
                    stringBuilder.append(c);
                    bl2 = true;
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        return bl ? null : stringBuilder.toString();
    }

    private void fireSelectRows(final int[] nArray) {
        final JTable jTable = this.table;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTable.clearSelection();
                for (int n : nArray) {
                    jTable.addRowSelectionInterval(n, n);
                }
            }
        });
    }

    private void fireSelectRowInterval(final int n, final int n2) {
        final JTable jTable = this.table;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int n3 = jTable.getRowCount();
                    if (n >= 0 && n < n3 && n <= n2) {
                        jTable.setRowSelectionInterval(n, Math.min(n2, n3 - 1));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteFiles(Transferable transferable) {
        try {
            Object object;
            if (transferable != null && (object = transferable.getTransferData(DataFlavor.javaFileListFlavor)) != null && object instanceof Collection) {
                int n = this.table.getRowCount();
                for (Object e : (Collection)object) {
                    if (e == null) continue;
                    File file = null;
                    if (e instanceof File) {
                        file = (File)e;
                    } else if (e instanceof String) {
                        file = new File((String)e);
                    }
                    if (file == null || this.addFile(file)) continue;
                    break;
                }
                this.fireSelectRowInterval(n, this.table.getRowCount() - 1);
            }
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        finally {
            this.updSelectAllEnabled();
        }
    }

    private void updActionButtons() {
        int[] nArray;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl = this.tabbedPane.getSelectedIndex() == 0;
        if (bl && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
            bl2 = true;
            Arrays.sort(nArray);
            if (nArray[nArray.length - 1] + 1 < this.tableModel.getRowCount()) {
                bl3 = true;
            }
            if (nArray[0] > 0) {
                bl4 = true;
            }
        }
        this.btnFileAdd.setEnabled(bl);
        this.mnuFileRemove.setEnabled(bl2);
        this.btnFileRemove.setEnabled(bl2);
        this.btnFileDown.setEnabled(bl3);
        this.btnFileUp.setEnabled(bl4);
        this.mnuChangeAttrs.setEnabled(bl2);
        this.mnuChangeUser.setEnabled(bl2);
    }

    private void updBgColor() {
        Color color = this.table.getBackground();
        JViewport jViewport = this.scrollPane.getViewport();
        if (color != null && jViewport != null) {
            jViewport.setBackground(color);
        }
    }

    private void updPasteButton() {
        boolean bl = false;
        if (this.clipboard != null) {
            try {
                bl = this.clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.mnuPaste.setEnabled(bl);
    }

    private void updSelectAllEnabled() {
        this.mnuSelectAll.setEnabled(this.table.getRowCount() > 0);
    }

    private void updStatusText() {
        String string = "Bereit";
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            long l = 0L;
            int n2 = this.tableModel.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Long l2;
                FileEntry fileEntry = this.tableModel.getRow(i);
                if (fileEntry == null || (l2 = fileEntry.getSize()) == null || l2 <= 0L) continue;
                long l3 = l2 / 1024L;
                if (l3 * 1024L < l2) {
                    ++l3;
                }
                l += l3;
            }
            StringBuilder stringBuilder = new StringBuilder(64);
            if (n2 == 1) {
                stringBuilder.append("1 Datei");
            } else {
                stringBuilder.append(n2);
                stringBuilder.append(" Dateien");
            }
            stringBuilder.append(" mit ");
            stringBuilder.append(l);
            stringBuilder.append(" KByte hinzugef\u00fcgt");
            string = stringBuilder.toString();
        } else if (n == 1) {
            int n3 = this.fmtSelectFld.getSides();
            int n4 = this.fmtSelectFld.getCylinders();
            int n5 = this.fmtSelectFld.getSysTracks();
            int n6 = this.fmtSelectFld.getSectorsPerCylinder();
            int n7 = this.fmtSelectFld.getSectorSize();
            int n8 = n3 * n4 * n6 * n7 / 1024;
            string = n5 > 0 ? String.format("%d/%dK Diskettenformat eingestellt", n3 * (n4 - n5) * n6 * n7 / 1024, n8) : String.format("%dK Diskettenformat eingestellt", n8);
        }
        this.labelStatus.setText(string);
    }

    private void updSysTrackFileFieldsEnabled() {
        boolean bl = this.fmtSelectFld.getSysTracks() > 0;
        this.labelSysTrackFile.setEnabled(bl);
        this.fldSysTrackFileName.setEnabled(bl);
        this.btnSysTrackFileSelect.setEnabled(bl);
        this.btnSysTrackFileRemove.setEnabled(bl && this.fldSysTrackFileName.getFile() != null);
    }

    private void updTitle() {
        String string = "JKCEMU CP/M-Diskettenabbilddatei erstellen";
        if (this.lastOutFile != null) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append(string);
            stringBuilder.append(": ");
            String string2 = this.lastOutFile.getName();
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            string = stringBuilder.toString();
        }
        this.setTitle(string);
    }
}

