/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jkcemu.base.AbstractThreadDlg;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTimesView;
import jkcemu.base.FileTimesViewFactory;
import jkcemu.base.NIOFileTimesViewFactory;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DateStamper;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.SectorData;
import jkcemu.filebrowser.FileBrowserFrm;

public class DiskUnpacker
extends AbstractThreadDlg {
    private AbstractFloppyDisk disk;
    private String diskDesc;
    private File outDir;
    private int sysTracks;
    private int sides;
    private int sectPerCyl;
    private int sectorOffset;
    private int sectorSize;
    private int blockSize;
    private int maxBlocksPerEntry;
    private int sectPerBlock;
    private boolean blockNum16Bit;
    private boolean applyReadOnly;
    private boolean forceLowerCase;
    private boolean fileErr;
    private boolean blockNumErr;

    public static void unpackDisk(Window window, AbstractFloppyDisk abstractFloppyDisk, String string, File file, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        DiskUnpacker diskUnpacker = new DiskUnpacker(window, abstractFloppyDisk, string, file, n, n2, bl, bl2, bl3);
        diskUnpacker.setTitle(string + " entpacken");
        diskUnpacker.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProgress() {
        block36: {
            int n;
            Object object;
            block38: {
                Object object2;
                int n2;
                int n3;
                Object object3;
                block37: {
                    block35: {
                        if (this.sides >= 1 && this.sides <= 2 && this.sectPerCyl >= 1 && this.sectorSize >= 256 && this.blockSize >= 1024 && this.sectPerBlock >= 1 && this.maxBlocksPerEntry >= 1) break block35;
                        StringBuilder stringBuilder = new StringBuilder(256);
                        stringBuilder.append("Ung\u00fcltiger Formatangaben:\n\nSeiten:                  ");
                        stringBuilder.append(this.sides);
                        stringBuilder.append("\nSektoren pro Spur:       ");
                        stringBuilder.append(this.sectPerCyl);
                        stringBuilder.append("\nSektorgr\u00f6\u00dfe:             ");
                        stringBuilder.append(this.sectorSize);
                        stringBuilder.append("\nBlockgr\u00f6\u00dfe:              ");
                        stringBuilder.append(this.blockSize);
                        stringBuilder.append("\nSektoren pro Block:      ");
                        stringBuilder.append(this.sectPerBlock);
                        stringBuilder.append("\nMax. Bl\u00f6cke pro Eintrag: ");
                        stringBuilder.append(this.maxBlocksPerEntry);
                        stringBuilder.append('\n');
                        this.appendToLog(stringBuilder.toString());
                        this.incErrorCount();
                        break block36;
                    }
                    if (this.sysTracks > 0) {
                        object3 = "@boot.sys";
                        File file = new File(this.outDir, (String)object3);
                        object = null;
                        n3 = 0;
                        this.outDir.mkdirs();
                        this.appendToLog((String)object3 + "\n");
                        try {
                            object = new FileOutputStream(file);
                            n = this.disk.getSectorsPerCylinder();
                            for (n2 = 0; n2 < this.sysTracks; ++n2) {
                                for (int i = 0; i < this.disk.getSides(); ++i) {
                                    for (int j = 0; j < n; ++j) {
                                        object2 = this.disk.getSectorByID(n2, i, n2, i, j + 1 + this.sectorOffset, -1);
                                        if (object2 == null) continue;
                                        if (object2.checkError()) {
                                            n3 = 1;
                                        }
                                        object2.writeTo((OutputStream)object, -1);
                                    }
                                }
                            }
                            object.close();
                            object = null;
                        }
                        catch (IOException iOException) {
                            this.appendErrorToLog(iOException);
                            this.incErrorCount();
                            n3 = 1;
                        }
                        finally {
                            EmuUtil.closeSilent((Closeable)object);
                            if (n3 != 0) {
                                object3 = "@boot.sys.error";
                                if (file.renameTo(new File(this.outDir, "@boot.sys.error"))) {
                                    this.appendToLog("  Datei in " + (String)object3 + " umbenannt\n");
                                    this.disableAutoClose();
                                }
                            }
                        }
                    }
                    object3 = new ArrayList();
                    int n4 = 0;
                    while ((object = this.readLogicalBlock(n4++)) != null && DiskUtil.isFilledDir(object)) {
                        object3.add(object);
                    }
                    object = null;
                    if (!object3.isEmpty()) break block37;
                    this.appendToLog(this.diskDesc + " ist leer.\n");
                    this.disableAutoClose();
                    break block38;
                }
                n3 = DiskUtil.getExtentsPerDirEntry(this.blockSize, this.blockNum16Bit);
                n = 0;
                n2 = 1;
                NIOFileTimesViewFactory nIOFileTimesViewFactory = new NIOFileTimesViewFactory();
                this.outDir.mkdirs();
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    block39: {
                        object2 = (byte[])iterator.next();
                        if (object2 == null) break block39;
                        int n5 = 0;
                        while (n5 + 31 < ((byte[])object2).length) {
                            block40: {
                                FileTimesView fileTimesView;
                                int n6;
                                Object object4;
                                String string;
                                int n7 = object2[n5] & 0xEF;
                                int n8 = DiskUtil.getExtentNumByEntryPos(object2, n5);
                                if (n7 < 0 || n7 > 31 || n8 < 0 || n8 >= n3 || (string = this.getFileName((byte[])object2, n5 + 1)) == null) break block40;
                                this.fileErr = false;
                                boolean bl = false;
                                if (this.applyReadOnly) {
                                    bl = (object2[n5 + 9] & 0x80) != 0;
                                }
                                File file = this.outDir;
                                if (n7 > 0) {
                                    object4 = String.valueOf(n7);
                                    file = new File(this.outDir, (String)object4);
                                    file.mkdirs();
                                    this.appendToLog((String)object4 + File.separatorChar + string + "\n");
                                } else {
                                    this.appendToLog(string + "\n");
                                }
                                object4 = new File(file, string);
                                OutputStream outputStream = null;
                                try {
                                    int n9;
                                    outputStream = n2 != 0 && string.equalsIgnoreCase("!!!TIME&.DAT") ? new ByteArrayOutputStream((n9 = object2[n5 + 15] & 0xFF) > 0 ? n9 * 128 : 32) : new FileOutputStream((File)object4);
                                    this.writeEntryContentTo(outputStream, (byte[])object2, n5, 0);
                                    n9 = n3;
                                    while (this.writeExtentContentTo(outputStream, (List<byte[]>)object3, (byte[])object2, n5, n9, n3)) {
                                        n9 += n3;
                                    }
                                    outputStream.close();
                                    if (outputStream instanceof ByteArrayOutputStream && (object = (Object)((ByteArrayOutputStream)outputStream).toByteArray()) != null) {
                                        outputStream = new FileOutputStream((File)object4);
                                        outputStream.write((byte[])object);
                                        outputStream.close();
                                    }
                                    outputStream = null;
                                }
                                catch (IOException iOException) {
                                    try {
                                        this.appendErrorToLog(iOException);
                                        this.incErrorCount();
                                        this.fileErr = true;
                                    }
                                    catch (Throwable throwable) {
                                        EmuUtil.closeSilent(outputStream);
                                        throw throwable;
                                    }
                                    EmuUtil.closeSilent(outputStream);
                                }
                                EmuUtil.closeSilent(outputStream);
                                if (object != null && (n6 = (n + n5) / 2) + 15 < ((Object)object).length && (fileTimesView = ((FileTimesViewFactory)nIOFileTimesViewFactory).getFileTimesView((File)object4)) != null) {
                                    fileTimesView.setTimesInMillis(DateStamper.getMillis(object, n6), DateStamper.getMillis(object, n6 + 5), DateStamper.getMillis(object, n6 + 10));
                                }
                                if (this.fileErr) {
                                    String string2 = string + ".error";
                                    if (((File)object4).renameTo(new File(this.outDir, string2))) {
                                        this.appendToLog("  Umbenannt in ");
                                        this.appendToLog(string2);
                                        this.appendToLog("\n");
                                        this.disableAutoClose();
                                    }
                                } else if (bl) {
                                    EmuUtil.setFileWritable((File)object4, false);
                                }
                            }
                            n2 = 0;
                            n5 += 32;
                        }
                    }
                    n += this.blockSize;
                }
            }
            FileBrowserFrm.fireFileChanged(this.outDir.getParentFile());
            Window window = this.getOwner();
            if (window != null) {
                n = this.errorCount > 0 ? 1 : 0;
                StringBuilder stringBuilder = new StringBuilder();
                if (n != 0) {
                    stringBuilder.append("Beim Entpacken traten Fehler auf!");
                    if (this.blockNumErr) {
                        stringBuilder.append("\n\nWahrscheinlich ist die Blockgr\u00f6\u00dfe zu gro\u00df oder das Blocknummernformat (8/16 Bit) falsch eingestellt.\nWenn dem so ist, sind auch die ohne Fehlermeldung entpackten Dateien korrupt!");
                    }
                } else {
                    stringBuilder.append("Fertig!");
                }
                if (object != null) {
                    stringBuilder.append("\n\nDateStamper erkannt:\nDie Zeitstempel der entpackten Dateien wurden auf die in der Datei\n!!!TIME&.DAT enthaltenen Werte gesetzt.");
                }
                String string = stringBuilder.toString();
                EventQueue.invokeLater(new Runnable(n != 0, window, string){
                    final /* synthetic */ boolean val$error;
                    final /* synthetic */ Window val$owner;
                    final /* synthetic */ String val$msg;
                    {
                        this.val$error = bl;
                        this.val$owner = window;
                        this.val$msg = string;
                    }

                    @Override
                    public void run() {
                        if (this.val$error) {
                            BaseDlg.showWarningDlg(this.val$owner, this.val$msg);
                        } else {
                            BaseDlg.showInfoDlg(this.val$owner, this.val$msg, "Entpacken");
                        }
                    }
                });
            }
        }
        this.disk.closeSilent();
    }

    private DiskUnpacker(Window window, AbstractFloppyDisk abstractFloppyDisk, String string, File file, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(window, "JKCEMU disk unpacker", false);
        this.disk = abstractFloppyDisk;
        this.diskDesc = string;
        this.outDir = file;
        this.sysTracks = n;
        this.sides = abstractFloppyDisk.getSides();
        this.sectPerCyl = abstractFloppyDisk.getSectorsPerCylinder();
        this.sectorOffset = abstractFloppyDisk.getSectorOffset();
        this.sectorSize = abstractFloppyDisk.getSectorSize();
        this.blockSize = n2;
        this.sectPerBlock = this.sectorSize > 0 ? n2 / this.sectorSize : 0;
        this.maxBlocksPerEntry = bl ? 8 : 16;
        this.blockNum16Bit = bl;
        this.applyReadOnly = bl2;
        this.forceLowerCase = bl3;
        this.fileErr = false;
        this.blockNumErr = false;
    }

    private String getFileName(byte[] byArray, int n) {
        String string;
        String string2 = this.getFileNamePortion(byArray, n, 8);
        if (string2 != null && (string = this.getFileNamePortion(byArray, n + 8, 3)) != null) {
            string2 = string2 + "." + string;
        }
        return string2;
    }

    private String getFileNamePortion(byte[] byArray, int n, int n2) {
        boolean bl = false;
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if ((n5 = byArray[n++] & 0x7F) == 32) {
                ++n4;
                continue;
            }
            if (n5 > 32 && n5 < 127) {
                while (n4 > 0) {
                    cArray[n3++] = 95;
                    --n4;
                }
                char c = (char)n5;
                if (this.forceLowerCase) {
                    c = Character.toLowerCase(c);
                }
                if (DiskUtil.isValidCPMFileNameChar(c)) {
                    cArray[n3++] = c;
                    continue;
                }
                cArray[n3++] = 95;
                continue;
            }
            bl = true;
            break;
        }
        return !bl && n3 > 0 ? new String(cArray, 0, n3) : null;
    }

    private byte[] readLogicalBlock(int n) {
        byte[] byArray = new byte[this.blockSize];
        int n2 = byArray.length;
        for (int i = 0; i < this.sectPerBlock; ++i) {
            SectorData sectorData;
            int n3 = 0;
            int n4 = this.sides * this.sysTracks * this.sectPerCyl + (this.sectPerBlock * n + i);
            int n5 = n4 / this.sectPerCyl / this.sides;
            int n6 = 0;
            int n7 = n4 - n5 * this.sectPerCyl * this.sides;
            if (n7 >= this.sectPerCyl) {
                ++n6;
                n7 -= this.sectPerCyl;
            }
            if ((sectorData = this.disk.getSectorByID(n5, n6, n5, n6, n7 + 1 + this.sectorOffset, -1)) != null) {
                n3 = sectorData.read(byArray, i * this.sectorSize, this.sectorSize);
                n2 -= n3;
            }
            if (n3 <= 0) break;
        }
        return (byte[])(n2 == 0 ? byArray : null);
    }

    private void writeEntryContentTo(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = DiskUtil.getExtentNumByEntryPos(byArray, n);
        int n5 = (byArray[n + 15] & 0xFF) * 128;
        if (n4 > n2) {
            n5 += 16384 * (n4 - n2);
        }
        if ((n3 = (n5 + this.blockSize - 1) / this.blockSize) > this.maxBlocksPerEntry) {
            this.blockNumErr = true;
            this.appendErrorToLog(String.format("Ung\u00fcltiger Gr\u00f6\u00dfeneintrag in Extent %d", n4, this.blockNum16Bit ? 16 : 8));
            this.incErrorCount();
            this.fileErr = true;
            n3 = this.maxBlocksPerEntry;
        }
        int n6 = n + 16;
        for (int i = 0; n5 > 0 && i < n3; ++i) {
            int n7 = 0;
            if (this.blockNum16Bit) {
                n7 = EmuUtil.getWord(byArray, n6);
                n6 += 2;
            } else {
                n7 = byArray[n6++] & 0xFF;
            }
            if (n7 == 0) {
                this.blockNumErr = true;
                throw new IOException(String.format("Ung\u00fcltige Blocknummer 0 in Extent %d", n4));
            }
            for (int j = 0; j < this.sectPerBlock; ++j) {
                SectorData sectorData;
                int n8 = this.sides * this.sysTracks * this.sectPerCyl + (this.sectPerBlock * n7 + j);
                int n9 = n8 / this.sectPerCyl / this.sides;
                int n10 = 0;
                int n11 = n8 - n9 * this.sectPerCyl * this.sides;
                if (n11 >= this.sectPerCyl) {
                    ++n10;
                    n11 -= this.sectPerCyl;
                }
                if ((sectorData = this.disk.getSectorByID(n9, n10, n9, n10, n11 + 1 + this.sectorOffset, -1)) != null) {
                    if (sectorData.checkError()) {
                        this.appendErrorToLog(String.format("Sektor [H=%d,C=%d,R=%d] im Block %02Xh fehlerhaft", n10, n9, n11 + 1, n7));
                        this.incErrorCount();
                        this.fileErr = true;
                    }
                    n5 -= sectorData.writeTo(outputStream, n5);
                    continue;
                }
                this.blockNumErr = true;
                throw new IOException(String.format("Sektor [H=%d,C=%d,R=%d] im Block %02Xh nicht gefunden", n10, n9, n11 + 1, n7));
            }
        }
    }

    private boolean writeExtentContentTo(OutputStream outputStream, List<byte[]> list, byte[] byArray, int n, int n2, int n3) throws IOException {
        boolean bl = false;
        for (byte[] byArray2 : list) {
            if (byArray2 != null) {
                int n4 = 0;
                while (n4 + 31 < byArray2.length) {
                    if (byArray2 != byArray || n4 != n) {
                        int n5 = DiskUtil.getExtentNumByEntryPos(byArray2, n4);
                        if (n5 >= n2 && n5 < n2 + n3) {
                            bl = true;
                            for (int i = 0; i < 12; ++i) {
                                if (byArray2[n4 + i] == byArray[n + i]) continue;
                                bl = false;
                                break;
                            }
                        }
                        if (bl) {
                            this.writeEntryContentTo(outputStream, byArray2, n4, n2);
                            break;
                        }
                    }
                    n4 += 32;
                }
            }
            if (!bl) continue;
            break;
        }
        return bl;
    }
}

