/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.DeviceIO;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileEntry;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.AnaDisk;
import jkcemu.disk.CPCDisk;
import jkcemu.disk.CopyQMDisk;
import jkcemu.disk.DiskUnpacker;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskFormatDlg;
import jkcemu.disk.ImageDisk;
import jkcemu.disk.PlainDisk;
import jkcemu.disk.SectorData;
import jkcemu.disk.TeleDisk;
import jkcemu.text.TextUtil;

public class DiskUtil {
    public static final String[] anaDiskFileExt = new String[]{".dump"};
    public static final String[] copyQMFileExt = new String[]{".cqm", ".qm"};
    public static final String[] dskFileExt = new String[]{".dsk"};
    public static final String[] imageDiskFileExt = new String[]{".imd"};
    public static final String[] isoFileExt = new String[]{".iso"};
    public static final String[] teleDiskFileExt = new String[]{".td0"};
    public static final String[] plainDiskFileExt = new String[]{".img", ".image", ".raw"};
    public static final String[] gzAnaDiskFileExt = new String[]{".dump.gz"};
    public static final String[] gzCopyQMFileExt = new String[]{".cqm.gz", ".qm.gz"};
    public static final String[] gzDskFileExt = new String[]{".dsk.gz"};
    public static final String[] gzImageDiskFileExt = new String[]{".imd.gz"};
    public static final String[] gzISOFileExt = new String[]{".iso.gz"};
    public static final String[] gzTeleDiskFileExt = new String[]{".td0.gz"};
    public static final String[] gzPlainDiskFileExt = new String[]{".img.gz", ".image.gz", ".raw.gz"};
    public static final int DEFAULT_BLOCK_SIZE = 2048;

    public static boolean checkAndConfirmWarning(Component component, AbstractFloppyDisk abstractFloppyDisk) {
        String string;
        boolean bl = true;
        if (abstractFloppyDisk != null && (string = abstractFloppyDisk.getWarningText()) != null && JOptionPane.showConfirmDialog(component, string, "Warnung", 2, 2) != 0) {
            bl = false;
        }
        return bl;
    }

    public static Boolean checkBlockNum16Bit(byte[] byArray, long l, AtomicInteger atomicInteger) {
        Boolean bl = null;
        Integer n = null;
        if (byArray != null) {
            int n2 = -1;
            int n3 = -1;
            int n4 = 1024;
            if (l <= 0L) {
                l = FloppyDiskFormat.getMaxDiskSize();
            }
            int n5 = 0;
            while ((bl == null || n == null) && n5 + 31 < byArray.length) {
                int n6 = byArray[n5] & 0xFF;
                int n7 = byArray[n5 + 15] & 0xFF;
                if (n6 >= 0 && n6 <= 31 && n7 > 0) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = (n7 * 128 + n4 - 1) / n4;
                    int n12 = (n7 * 128 + 2048 - 1) / 2048;
                    if (n12 > 8) {
                        bl = Boolean.FALSE;
                    }
                    int n13 = n5 + 16;
                    int n14 = 0;
                    TreeSet<Integer> treeSet = new TreeSet<Integer>();
                    for (n10 = 0; n10 < 16 && (n9 = byArray[n13++] & 0xFF) != 0; ++n10) {
                        ++n14;
                        if (n10 >= n12) continue;
                        if (n9 > n2) {
                            n2 = n9;
                        }
                        if (treeSet.add(n9)) continue;
                        bl = Boolean.TRUE;
                        n14 = 0;
                        break;
                    }
                    n13 = n5 + 16;
                    n10 = 0;
                    for (n9 = 0; n9 < 8; ++n9) {
                        n8 = EmuUtil.getWord(byArray, n13);
                        n13 += 2;
                        if (n8 == 0) break;
                        ++n10;
                        if (n9 >= n12) continue;
                        if (n8 > n3) {
                            n3 = n8;
                        }
                        if ((long)(n8 * n4) < l) continue;
                        bl = Boolean.FALSE;
                    }
                    if (n14 != n10) {
                        n9 = 0;
                        n8 = 0;
                        boolean bl2 = false;
                        int n15 = 0;
                        int n16 = 0;
                        if (bl != null) {
                            if (bl.booleanValue()) {
                                n9 = 1;
                            } else {
                                n8 = 1;
                            }
                        }
                        if (n11 > 0) {
                            if (n9 == 0 && n11 == n14) {
                                bl2 = false;
                                n15 = n4;
                                ++n16;
                            }
                            if (n8 == 0 && n11 == n10) {
                                bl2 = true;
                                n15 = n4;
                                ++n16;
                            }
                        }
                        if (n12 > 0) {
                            if (n9 == 0 && n12 == n14) {
                                bl2 = false;
                                n15 = 2048;
                                ++n16;
                            }
                            if (n8 == 0 && n12 == n10) {
                                bl2 = true;
                                n15 = 2048;
                                ++n16;
                            }
                        }
                        if (n16 == 1) {
                            if (bl != null) {
                                if (bl == bl2) {
                                    n = n15;
                                }
                            } else {
                                bl = bl2;
                                n = n15;
                            }
                        }
                    }
                }
                n5 += 32;
            }
            if (bl != null) {
                if (n == null) {
                    if (bl.booleanValue()) {
                        if (n3 > 0 && (long)(n3 * 2048) >= l && (long)(n3 * n4) < l) {
                            n = n4;
                        }
                    } else if (n2 > 0 && (long)(n2 * 2048) >= l && (long)(n2 * n4) < l) {
                        n = n4;
                    }
                }
            } else if (n3 > 0 && (long)(n3 * n4) > l) {
                bl = Boolean.FALSE;
            }
        }
        if (atomicInteger != null && n != null) {
            atomicInteger.set(n);
        }
        return bl;
    }

    public static boolean checkFileExt(Component component, File file, String[] ... stringArray) {
        boolean bl = false;
        String string = file.getName();
        if (string != null) {
            string = string.toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!TextUtil.endsWith(string, stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            bl = BaseDlg.showYesNoWarningDlg(component, "Die Dateiendung entspricht nicht der f\u00fcr diesen Dateityp \u00fcblichen Endung.\nWenn Sie die Datei sp\u00e4ter einmal \u00f6ffnen m\u00f6chten,\nwird JKCEMU den Dateityp nicht richtig erkennen k\u00f6nnen.\n\nM\u00f6chten Sie trotzdem fortsetzen?", "Achtung");
        }
        return bl;
    }

    public static boolean equalsDiskSize(DeviceIO.RandomAccessDevice randomAccessDevice, int n) {
        boolean bl;
        block5: {
            bl = false;
            try {
                byte[] byArray = new byte[1024];
                if (n < byArray.length) break block5;
                randomAccessDevice.seek(n - byArray.length);
                if (randomAccessDevice.read(byArray, 0, byArray.length) != byArray.length) break block5;
                try {
                    if (randomAccessDevice.read(byArray, 0, byArray.length) <= 0) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static byte[] findAndReadDirBytes(InputStream inputStream, DeviceIO.RandomAccessDevice randomAccessDevice, RandomAccessFile randomAccessFile, AbstractFloppyDisk abstractFloppyDisk, AtomicInteger atomicInteger) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(6144);
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 1024;
        int n5 = 110592 / n4;
        boolean bl = true;
        block6: for (int i = 0; bl && i < n5; ++i) {
            if (byArray == null) {
                byArray = new byte[n4];
            }
            Arrays.fill(byArray, (byte)0);
            try {
                if (inputStream != null) {
                    if (EmuUtil.read(inputStream, byArray) <= 0) {
                        bl = false;
                    }
                } else {
                    bl = DiskUtil.readBlock(byArray, i, randomAccessDevice, randomAccessFile, abstractFloppyDisk);
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!bl) continue;
            switch (DiskUtil.getDirStatus(byArray)) {
                case EMPTY_DIR: {
                    if (byArray2 == null) {
                        byArray2 = byArray;
                        n2 = i;
                    }
                    ++n;
                    if (byteArrayOutputStream.size() > 0) {
                        byteArrayOutputStream.write(byArray, 0, byArray.length);
                    }
                    byArray = null;
                    continue block6;
                }
                case FILLED_DIR: {
                    if (n3 < 0) {
                        n3 = i;
                    }
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                    byArray = null;
                    continue block6;
                }
                default: {
                    if (n3 < 0) continue block6;
                    bl = false;
                }
            }
        }
        if (byteArrayOutputStream.size() == 0 && byArray2 != null && n2 >= 0) {
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            n3 = n2;
        }
        if (atomicInteger != null && byteArrayOutputStream.size() > 0 && n3 >= 0) {
            atomicInteger.set(n3 * n4);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int getExtentNumByEntryPos(byte[] byArray, int n) {
        int n2 = 0;
        if (byArray != null && n + 14 < byArray.length) {
            n2 = byArray[n + 12] & 0x1F | byArray[n + 14] << 5 & 0x7E0;
        }
        return n2;
    }

    public static int getExtentsPerDirEntry(int n, boolean bl) {
        int n2 = n * (bl ? 8 : 16);
        return n2 > 16384 ? (n2 + 16384 - 1) / 16384 : 1;
    }

    public static boolean isFilledDir(byte[] byArray) {
        return DiskUtil.getDirStatus(byArray) == DirStatus.FILLED_DIR;
    }

    public static boolean isValidCPMFileNameChar(char c) {
        boolean bl = false;
        if (c > ' ' && c <= '~' && "<>.,;:=?*[]".indexOf(c) < 0) {
            bl = true;
        }
        return bl;
    }

    public static List<FileEntry> readDirectory(AbstractFloppyDisk abstractFloppyDisk) {
        return DiskUtil.extractDirectory(DiskUtil.findAndReadDirBytes(null, null, null, abstractFloppyDisk, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<FileEntry> readDirFromPlainDisk(File file) {
        List<FileEntry> list = null;
        if (file != null) {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                if (EmuUtil.isGZipFile(file)) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                list = DiskUtil.extractDirectory(DiskUtil.findAndReadDirBytes(inputStream, null, null, null, null));
            }
            catch (IOException iOException) {
                EmuUtil.closeSilent(inputStream);
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(inputStream);
                    throw throwable;
                }
            }
            EmuUtil.closeSilent(inputStream);
        }
        return list;
    }

    public static AbstractFloppyDisk readDiskFile(Frame frame, File file, boolean bl) throws IOException {
        String string;
        AbstractFloppyDisk abstractFloppyDisk = DiskUtil.readNonPlainDiskFile(frame, file, bl);
        if (abstractFloppyDisk == null && file != null && (string = file.getName()) != null) {
            if (TextUtil.endsWith(string = string.toLowerCase(), plainDiskFileExt) || TextUtil.endsWith(string, gzPlainDiskFileExt)) {
                FloppyDiskFormatDlg floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)frame, FloppyDiskFormat.getFormatByDiskSize(file.length()), FloppyDiskFormatDlg.Flag.PHYS_FORMAT);
                floppyDiskFormatDlg.setVisible(true);
                FloppyDiskFormat floppyDiskFormat = floppyDiskFormatDlg.getFormat();
                if (floppyDiskFormat != null) {
                    abstractFloppyDisk = PlainDisk.createForByteArray(frame, file.getPath(), EmuUtil.readFile(file, true, FloppyDiskFormat.getMaxDiskSize()), floppyDiskFormat);
                }
            } else {
                throw new IOException("Unbekanntes Format einer Diskettenabbilddatei");
            }
        }
        return abstractFloppyDisk;
    }

    public static int readDiskSize(DeviceIO.RandomAccessDevice randomAccessDevice) throws IOException {
        int n = -1;
        int[] nArray = new int[]{737280, 819200, 1228800, 1474560, 0x2D0000};
        for (int i = 0; i < nArray.length; ++i) {
            if (!DiskUtil.equalsDiskSize(randomAccessDevice, nArray[i])) continue;
            n = nArray[i];
            break;
        }
        return n;
    }

    public static AbstractFloppyDisk readNonPlainDiskFile(Frame frame, File file, boolean bl) throws IOException {
        AbstractFloppyDisk abstractFloppyDisk = null;
        if (file != null) {
            byte[] byArray;
            String string = file.getName();
            if (string != null && (TextUtil.endsWith(string = string.toLowerCase(), anaDiskFileExt) || TextUtil.endsWith(string, gzAnaDiskFileExt))) {
                abstractFloppyDisk = AnaDisk.readFile(frame, file);
            }
            if (abstractFloppyDisk == null && (byArray = EmuUtil.readFile(file, true, 256)) != null) {
                if (CopyQMDisk.isCopyQMFileHeader(byArray)) {
                    abstractFloppyDisk = CopyQMDisk.readFile(frame, file);
                } else if (CPCDisk.isCPCDiskFileHeader(byArray)) {
                    abstractFloppyDisk = CPCDisk.readFile(frame, file);
                } else if (ImageDisk.isImageDiskFileHeader(byArray)) {
                    abstractFloppyDisk = ImageDisk.readFile(frame, file);
                } else if (TeleDisk.isTeleDiskFileHeader(byArray)) {
                    abstractFloppyDisk = TeleDisk.readFile(frame, file, bl);
                }
            }
        }
        return abstractFloppyDisk;
    }

    public static void unpackDisk(Window window, File file, AbstractFloppyDisk abstractFloppyDisk, boolean bl) throws IOException {
        Boolean bl2;
        int n;
        int n2 = 0;
        int n3 = 2048;
        boolean bl3 = true;
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        AtomicInteger atomicInteger2 = new AtomicInteger(-1);
        byte[] byArray = DiskUtil.findAndReadDirBytes(null, null, null, abstractFloppyDisk, atomicInteger);
        if (atomicInteger.get() > 0 && (n = abstractFloppyDisk.getSides() * abstractFloppyDisk.getSectorsPerCylinder() * abstractFloppyDisk.getSectorSize()) > 0) {
            n2 = atomicInteger.get() / n;
        }
        if ((bl2 = DiskUtil.checkBlockNum16Bit(byArray, n = abstractFloppyDisk.getDiskSize(), atomicInteger2)) != null) {
            bl3 = bl2;
        }
        if (atomicInteger2.get() > 0) {
            n3 = atomicInteger2.get();
        } else {
            int n4;
            boolean bl4 = false;
            if (abstractFloppyDisk.getCylinders() == 40 && abstractFloppyDisk.getSides() == 1 && abstractFloppyDisk.getSectorsPerCylinder() == 9 && abstractFloppyDisk.getSectorSize() == 512 && ((n4 = abstractFloppyDisk.getSectorOffset()) == 64 || n4 == 192)) {
                n3 = 1024;
                bl4 = true;
            }
            if (!bl4 && bl2 != null && !bl2.booleanValue()) {
                n4 = n / 256;
                while (n3 < n4) {
                    n3 *= 2;
                }
                atomicInteger2.set(n3);
            }
        }
        FloppyDiskFormatDlg floppyDiskFormatDlg = null;
        if (bl) {
            floppyDiskFormatDlg = new FloppyDiskFormatDlg(window, null, FloppyDiskFormatDlg.Flag.SYSTEM_TRACKS, FloppyDiskFormatDlg.Flag.BLOCK_SIZE, FloppyDiskFormatDlg.Flag.BLOCK_NUM_SIZE, FloppyDiskFormatDlg.Flag.APPLY_READONLY, FloppyDiskFormatDlg.Flag.FORCE_LOWERCASE);
            if (byArray.length > 0 && atomicInteger.get() >= 0) {
                floppyDiskFormatDlg.setRecognizedSysTracks(n2);
            }
            if (bl2 != null) {
                floppyDiskFormatDlg.setRecognizedBlockNum16Bit(bl2);
                if (atomicInteger2.get() > 0) {
                    floppyDiskFormatDlg.setRecognizedBlockSize(atomicInteger2.get());
                }
            }
        } else {
            floppyDiskFormatDlg = new FloppyDiskFormatDlg(window, null, FloppyDiskFormatDlg.Flag.APPLY_READONLY, FloppyDiskFormatDlg.Flag.FORCE_LOWERCASE);
        }
        floppyDiskFormatDlg.setVisible(true);
        if (floppyDiskFormatDlg.wasApproved()) {
            if (bl) {
                n2 = floppyDiskFormatDlg.getSysTracks();
                n3 = floppyDiskFormatDlg.getBlockSize();
                bl3 = floppyDiskFormatDlg.getBlockNum16Bit();
            }
            if (n2 >= 0 && n3 > 0) {
                File file2;
                String string = abstractFloppyDisk.getFileFormatText();
                if (string == null) {
                    string = "Diskettenabbilddatei";
                }
                if ((file2 = EmuUtil.askForOutputDir(window, file, "Entpacken nach:", string + " entpacken")) != null) {
                    DiskUnpacker.unpackDisk(window, abstractFloppyDisk, string, file2, n2, n3, bl3, floppyDiskFormatDlg.getApplyReadOnly(), floppyDiskFormatDlg.getForceLowerCase());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackPlainDisk(Frame frame, String string) throws IOException {
        DeviceIO.RandomAccessDevice randomAccessDevice = null;
        try {
            randomAccessDevice = DeviceIO.openDeviceForRandomAccess(string, true);
            Main.setLastDriveFileName(string);
            if (DiskUtil.unpackPlainDisk(frame, string, randomAccessDevice, null, "Diskette", DiskUtil.readDiskSize(randomAccessDevice), EmuUtil.getHomeDirFile(), "diskette")) {
                randomAccessDevice = null;
            }
        }
        finally {
            EmuUtil.closeSilent(randomAccessDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackPlainDiskFile(Frame frame, File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            long l = file.length();
            String string = file.getName();
            if (string != null) {
                int n = string.lastIndexOf(".");
                string = n > 0 ? string.substring(0, n) : string + ".d";
            }
            randomAccessFile = new RandomAccessFile(file, "r");
            if (DiskUtil.unpackPlainDisk(frame, file.getPath(), null, randomAccessFile, "Einfache Abbilddatei", l, file.getParentFile(), string)) {
                randomAccessFile = null;
            }
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.closeSilent(randomAccessFile);
    }

    private static List<FileEntry> extractDirectory(byte[] byArray) {
        ArrayList<Object> arrayList = null;
        if (byArray != null && byArray.length > 0) {
            Object object;
            int n;
            Object object2;
            int n2;
            HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
            int n3 = 0;
            while (n3 + 15 < byArray.length) {
                int n4 = byArray[n3] & 0xFF;
                if (n4 >= 0 && n4 <= 15) {
                    int n5;
                    n2 = n3 + 1;
                    object2 = new StringBuilder(12);
                    for (n = 0; n < 8; ++n) {
                        if ((n5 = byArray[n2++] & 0x7F) <= 32 || n5 >= 127) continue;
                        ((StringBuilder)object2).append((char)n5);
                    }
                    if (((StringBuilder)object2).length() > 0) {
                        n = 1;
                        for (n5 = 0; n5 < 3; ++n5) {
                            int n6;
                            if ((n6 = byArray[n2++] & 0x7F) <= 32 || n6 >= 127) continue;
                            if (n != 0) {
                                ((StringBuilder)object2).append('.');
                                n = 0;
                            }
                            ((StringBuilder)object2).append((char)n6);
                        }
                        n5 = (byArray[n3 + 15] & 0xFF) * 128;
                        object = ((StringBuilder)object2).toString();
                        Long l = (Long)hashMap.get(object);
                        l = l != null ? Long.valueOf(l + (long)n5) : Long.valueOf(n5);
                        hashMap.put(object, l);
                    }
                }
                n3 += 32;
            }
            Set set = hashMap.keySet();
            if (set != null && (n2 = set.size()) > 0 && (object2 = set.toArray(new String[n2])) != null) {
                Arrays.sort((Object[])object2);
                arrayList = new ArrayList(n2);
                for (n = 0; n < ((Object)object2).length; ++n) {
                    Object object3 = object2[n];
                    if (object3 == null) continue;
                    object = new FileEntry((String)object3);
                    ((FileEntry)object).setSize((Long)hashMap.get(object3));
                    arrayList.add(object);
                }
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
        }
        return arrayList;
    }

    private static DirStatus getDirStatus(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (byArray != null && byArray.length > 31) {
            bl = true;
            bl2 = true;
            int n = 0;
            while (n + 31 < byArray.length) {
                int n2 = byArray[n] & 0xFF;
                if (n2 != 229) {
                    bl2 = false;
                }
                if ((n2 & 0xE0) != 0 && n2 != 32 && n2 != 33 && n2 != 229) {
                    bl = false;
                    break;
                }
                if (n2 <= 15) {
                    int n3 = n + 1;
                    for (int i = 0; bl && i < 11; ++i) {
                        int n4;
                        if ((n4 = byArray[n3++] & 0x7F) >= 32 && n4 < 127) continue;
                        bl = false;
                        break;
                    }
                }
                n += 32;
            }
        }
        DirStatus dirStatus = DirStatus.NO_DIR;
        if (bl) {
            dirStatus = bl2 ? DirStatus.EMPTY_DIR : DirStatus.FILLED_DIR;
        }
        return dirStatus;
    }

    private static boolean readBlock(byte[] byArray, int n, DeviceIO.RandomAccessDevice randomAccessDevice, RandomAccessFile randomAccessFile, AbstractFloppyDisk abstractFloppyDisk) {
        boolean bl = false;
        try {
            if (randomAccessDevice != null) {
                randomAccessDevice.seek(n * byArray.length);
                if (randomAccessDevice.read(byArray, 0, byArray.length) == byArray.length) {
                    bl = true;
                }
            }
            if (randomAccessFile != null) {
                randomAccessFile.seek(n * byArray.length);
                if (randomAccessFile.read(byArray) == byArray.length) {
                    bl = true;
                }
            } else if (abstractFloppyDisk != null) {
                int n2;
                int n3 = byArray.length;
                int n4 = abstractFloppyDisk.getSides();
                int n5 = abstractFloppyDisk.getSectorsPerCylinder();
                int n6 = abstractFloppyDisk.getSectorSize();
                if (n4 > 0 && n5 > 0 && n6 > 0 && (n2 = byArray.length / n6) > 0) {
                    for (int i = 0; i < n2; ++i) {
                        SectorData sectorData;
                        int n7 = 0;
                        int n8 = n2 * n + i;
                        int n9 = n8 / n5 / n4;
                        int n10 = 0;
                        int n11 = n8 - n9 * n5 * n4;
                        if (n11 >= n5) {
                            ++n10;
                            n11 -= n5;
                        }
                        if ((sectorData = abstractFloppyDisk.getSectorByID(n9, n10, n9, n10, n11 + 1, -1)) != null) {
                            n7 = sectorData.read(byArray, i * n6, n6);
                            n3 -= n7;
                        }
                        if (n7 <= 0) break;
                    }
                }
                if (n3 == 0) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private static boolean unpackPlainDisk(Frame frame, String string, DeviceIO.RandomAccessDevice randomAccessDevice, RandomAccessFile randomAccessFile, String string2, long l, File file, String string3) throws IOException {
        int n;
        boolean bl = false;
        int n2 = 2048;
        int n3 = 0;
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        AtomicInteger atomicInteger2 = new AtomicInteger(-1);
        byte[] byArray = DiskUtil.findAndReadDirBytes(null, randomAccessDevice, randomAccessFile, null, atomicInteger);
        FloppyDiskFormat floppyDiskFormat = FloppyDiskFormat.getFormatByDiskSize(l);
        if (floppyDiskFormat != null && atomicInteger.get() > 0 && (n = floppyDiskFormat.getSides() * floppyDiskFormat.getSectorsPerCylinder() * floppyDiskFormat.getSectorSize()) > 0) {
            n3 = atomicInteger.get() / n;
        }
        Boolean bl2 = DiskUtil.checkBlockNum16Bit(byArray, l, atomicInteger2);
        if (atomicInteger2.get() > 0) {
            n2 = atomicInteger2.get();
        } else if (bl2 != null && !bl2.booleanValue()) {
            int n4 = (int)(l / 256L);
            while (n2 < n4) {
                n2 *= 2;
            }
            atomicInteger2.set(n2);
        }
        FloppyDiskFormatDlg floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)frame, floppyDiskFormat, FloppyDiskFormatDlg.Flag.PHYS_FORMAT, FloppyDiskFormatDlg.Flag.SYSTEM_TRACKS, FloppyDiskFormatDlg.Flag.BLOCK_SIZE, FloppyDiskFormatDlg.Flag.BLOCK_NUM_SIZE, FloppyDiskFormatDlg.Flag.APPLY_READONLY, FloppyDiskFormatDlg.Flag.FORCE_LOWERCASE);
        if (byArray.length > 0 && atomicInteger.get() >= 0 && floppyDiskFormat != null) {
            floppyDiskFormatDlg.setRecognizedSysTracks(n3);
        }
        if (bl2 != null) {
            floppyDiskFormatDlg.setRecognizedBlockNum16Bit(bl2);
            if (atomicInteger2.get() > 0) {
                floppyDiskFormatDlg.setRecognizedBlockSize(atomicInteger2.get());
            }
        }
        floppyDiskFormatDlg.setVisible(true);
        floppyDiskFormat = floppyDiskFormatDlg.getFormat();
        if (floppyDiskFormat != null) {
            File file2;
            n3 = floppyDiskFormatDlg.getSysTracks();
            n2 = floppyDiskFormatDlg.getBlockSize();
            if (n3 >= 0 && n2 > 0 && (file2 = EmuUtil.askForOutputDir(frame, file, string3, "Entpacken nach:", string2 + " entpacken")) != null) {
                PlainDisk plainDisk = null;
                if (randomAccessDevice != null) {
                    plainDisk = PlainDisk.createForDrive(frame, string, randomAccessDevice, true, floppyDiskFormat);
                } else if (randomAccessFile != null) {
                    plainDisk = PlainDisk.createForFile(frame, string, randomAccessFile, true, floppyDiskFormat);
                }
                if (plainDisk != null) {
                    DiskUnpacker.unpackDisk(frame, plainDisk, string2, file2, n3, n2, floppyDiskFormatDlg.getBlockNum16Bit(), floppyDiskFormatDlg.getApplyReadOnly(), floppyDiskFormatDlg.getForceLowerCase());
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static enum DirStatus {
        NO_DIR,
        EMPTY_DIR,
        FILLED_DIR;

    }
}

