/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;
import jkcemu.Main;
import jkcemu.base.BaseDlg;

public class DriveSelectDlg
extends BaseDlg {
    private static final String[] unixDevFiles = new String[]{"/dev/floppy", "/dev/cdrom", "/dev/dvd", "/dev/fd0", "/dev/fd1", "/dev/sdb", "/dev/sdc", "/dev/sr0"};
    private String driveFileName = null;
    private JComboBox<Object> comboDrive;
    private JCheckBox btnReadOnly;
    private JButton btnOK;
    private JButton btnCancel;

    public static String selectDriveFileName(Window window) {
        DriveSelectDlg driveSelectDlg = new DriveSelectDlg(window, false);
        driveSelectDlg.setVisible(true);
        return driveSelectDlg.getSelectedDriveFileName();
    }

    public DriveSelectDlg(Window window, boolean bl) {
        super(window, "Auswahl Laufwerk");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        String string = Main.getLastDriveFileName();
        this.comboDrive = new JComboBox();
        if (Main.isUnixLikeOS()) {
            this.add((Component)new JLabel("Ger\u00e4tedatei:"), gridBagConstraints);
            this.comboDrive.setEditable(true);
            for (String string2 : unixDevFiles) {
                if (!new File(string2).exists()) continue;
                this.comboDrive.addItem(string2);
            }
            if (string != null && !string.isEmpty()) {
                this.comboDrive.setSelectedItem(string);
            }
        } else {
            File[] fileArray;
            this.add((Component)new JLabel("Laufwerk:"), gridBagConstraints);
            this.comboDrive.setEditable(false);
            boolean bl2 = false;
            int n = -1;
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            if (fileSystemView != null && (fileArray = File.listRoots()) != null) {
                int n2 = -1;
                for (File file : fileArray) {
                    String string3;
                    int n3;
                    String string4;
                    if (!fileSystemView.isDrive(file) || (string4 = file.getPath()) == null || (n3 = string4.length()) < 2 || string4.charAt(1) != ':') continue;
                    if (n3 > 2) {
                        string4 = string4.substring(0, 2);
                    }
                    if ((string3 = fileSystemView.getSystemDisplayName(file)) != null && string3.isEmpty()) {
                        string3 = null;
                    }
                    if (string3 == null) {
                        string3 = string4;
                    }
                    String string5 = "\\\\.\\" + string4;
                    if (n < 0 && string != null && string5.equals(string)) {
                        n = this.comboDrive.getItemCount();
                    }
                    if (fileSystemView.isFloppyDrive(file)) {
                        n2 = this.comboDrive.getItemCount();
                    }
                    this.comboDrive.addItem(new DriveItem(string3, string5));
                    bl2 = true;
                }
                if (n < 0) {
                    n = n2 >= 0 ? n2 : 1;
                }
            }
            if (!bl2) {
                for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                    String string6 = String.format("\\\\.\\%c:", Character.valueOf(c));
                    if (n >= 0 || string == null || !string6.equals(string)) continue;
                    n = this.comboDrive.getItemCount();
                }
            }
            if (n >= 0 && n < this.comboDrive.getItemCount()) {
                try {
                    this.comboDrive.setSelectedIndex(n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        this.comboDrive.addKeyListener(this);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        this.add(this.comboDrive, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        if (bl) {
            this.btnReadOnly = new JCheckBox("Nur lesen", true);
            this.add((Component)this.btnReadOnly, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else {
            this.btnReadOnly = null;
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.add((Component)jPanel, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        this.btnOK.addKeyListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
    }

    public String getSelectedDriveFileName() {
        return this.driveFileName;
    }

    public boolean isReadOnlySelected() {
        return this.btnReadOnly != null ? this.btnReadOnly.isSelected() : false;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnOK || object == this.comboDrive) {
                Object object2 = this.comboDrive.getSelectedItem();
                if (object2 != null) {
                    if (object2 instanceof DriveItem) {
                        this.driveFileName = ((DriveItem)object2).fileName;
                        this.doClose();
                    } else {
                        String string = object2.toString();
                        if (string != null && !string.isEmpty()) {
                            this.driveFileName = string;
                            this.doClose();
                        }
                    }
                }
                bl = true;
            } else if (object == this.btnCancel) {
                this.doClose();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this && this.btnOK != null) {
            this.btnOK.requestFocus();
        }
    }

    private class DriveItem {
        private String itemText;
        private String fileName;

        private DriveItem(String string, String string2) {
            this.itemText = string;
            this.fileName = string2;
        }

        public String toString() {
            return this.itemText;
        }
    }
}

