/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.util.Arrays;
import jkcemu.Main;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;
import z80emu.Z80CPU;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80TStatesListener;

public class FDC8272
implements Runnable,
Z80MaxSpeedListener,
Z80TStatesListener {
    private static Command[] cmds = new Command[]{Command.INVALID, Command.INVALID, Command.READ_TRACK, Command.SPECIFY, Command.SENSE_DRIVE_STATUS, Command.WRITE_DATA, Command.READ_DATA, Command.RECALIBRATE, Command.SENSE_INTERRUPT_STATUS, Command.WRITE_DELETED_DATA, Command.READ_ID, Command.INVALID, Command.READ_DELETED_DATA, Command.FORMAT_TRACK, Command.INVALID, Command.SEEK, Command.INVALID, Command.SCAN_EQUAL, Command.INVALID, Command.INVALID, Command.INVALID, Command.INVALID, Command.INVALID, Command.INVALID, Command.INVALID, Command.SCAN_LOW_OR_EQUAL, Command.INVALID, Command.INVALID, Command.INVALID, Command.SCAN_HIGH_OR_EQUAL, Command.INVALID, Command.INVALID};
    private static final int ARG0_SK_MASK = 32;
    private static final int ARG0_MT_MASK = 128;
    private static final int DRIVE_MASK = 3;
    private static final int HEAD_MASK = 4;
    private static final int HEAD_DRIVE_MASK = 7;
    private static final int STM_REQUEST_FOR_MASTER = 128;
    private static final int STM_DATA_INPUT = 64;
    private static final int STM_NON_DMA_MODE = 32;
    private static final int STM_BUSY = 16;
    private static final int STM_DRIVE_MASK = 15;
    private static final int ST0_ERROR_MASK = 192;
    private static final int ST0_ABORT_BECAUSE_READY_CHANGED = 192;
    private static final int ST0_INVALID_COMMAND_ISSUE = 128;
    private static final int ST0_ABNORMAL_TERMINATION = 64;
    private static final int ST0_SEEK_END = 32;
    private static final int ST0_EQUIPMENT_CHECK = 16;
    private static final int ST0_NOT_READY = 8;
    private static final int ST1_END_OF_CYLINDER = 128;
    private static final int ST1_DATA_ERROR = 32;
    private static final int ST1_OVERRUN = 16;
    private static final int ST1_NO_DATA = 4;
    private static final int ST1_NOT_WRITABLE = 2;
    private static final int ST1_MISSING_ADDRESS_MARK = 1;
    private static final int ST2_CONTROL_MARK = 64;
    private static final int ST2_DATA_ERROR_IN_DATA_FIELD = 32;
    private static final int ST2_SCAN_EQUAL_HIT = 8;
    private static final int ST2_SCAN_NOT_SATISFIED = 4;
    private static final int ST2_MISSING_DATA_ADDRESS_MARK = 1;
    private static final int ST3_WRITE_PROTECTED = 64;
    private static final int ST3_READY = 32;
    private static final int ST3_TRACK_0 = 16;
    private static final int ST3_TWO_SIDE = 8;
    private DriveSelector driveSelector;
    private FloppyDiskDrive executingDrive;
    private volatile Command curCmd;
    private FormatStatus formatStatus;
    private Object ioLock;
    private volatile IOTaskCmd ioTaskCmd;
    private volatile Thread ioTaskThread;
    private volatile boolean ioTaskEnabled;
    private volatile boolean ioTaskNoWait;
    private volatile boolean tcEnabled;
    private volatile boolean tcFired;
    private volatile boolean interruptReq;
    private volatile boolean dmaReq;
    private boolean dmaMode;
    private boolean seekMode;
    private boolean eotReached;
    private volatile int[] args;
    private int argIdx;
    private int[] results;
    private int resultIdx;
    private int sectorIdCyl;
    private int sectorIdHead;
    private int sectorIdRec;
    private int sectorIdSizeCode;
    private int mhz;
    private volatile int statusRegMain;
    private int statusReg0;
    private int statusReg1;
    private int statusReg2;
    private int statusReg3;
    private int stepRateMillis;
    private int tStatesTillIOReq;
    private int tStatesTillIOStart;
    private int tStatesTillOverrun;
    private int tStateRotationCounter;
    private int tStateStepCounter;
    private volatile int tStatesPerMilli;
    private volatile int tStatesPerRotation;
    private volatile int tStatesPerStep;
    private volatile int debugLevel;
    private int[] seekStatus;
    private int[] remainSeekSteps;
    private byte[] dataBuf;
    private int dataPos;
    private int dataLen;
    private int remainBytes;
    private int curSectorIdx;
    private volatile SectorData curSector;
    private SectorData.Reader curSectorReader;

    public FDC8272(DriveSelector driveSelector, int n) {
        this.driveSelector = driveSelector;
        this.mhz = n;
        this.curCmd = Command.INVALID;
        this.executingDrive = null;
        this.dmaMode = false;
        this.stepRateMillis = 16;
        this.tStatesPerMilli = 0;
        this.tStatesPerRotation = 0;
        this.tStatesPerStep = 0;
        this.debugLevel = 0;
        this.dataBuf = null;
        this.args = new int[9];
        this.results = new int[7];
        this.remainSeekSteps = new int[4];
        this.seekStatus = new int[4];
        this.ioLock = new Object();
        this.ioTaskCmd = IOTaskCmd.IDLE;
        this.ioTaskEnabled = true;
        this.ioTaskNoWait = false;
        this.ioTaskThread = new Thread(Main.getThreadGroup(), this, "JKCEMU FDC");
        String string = System.getProperty("jkcemu.debug.fdc");
        if (string != null) {
            try {
                this.debugLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ioTaskThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        this.ioTaskEnabled = false;
        this.ioTaskThread.interrupt();
        Thread thread = this.ioTaskThread;
        synchronized (thread) {
            try {
                this.ioTaskThread.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTC() {
        if (this.debugLevel > 1) {
            System.out.println("FDC: TC");
        }
        this.tStatesTillIOReq = 0;
        this.tStatesTillIOStart = 0;
        this.tStatesTillOverrun = 0;
        block3 : switch (this.curCmd) {
            case FORMAT_TRACK: {
                this.statusRegMain &= 0xFFFFFF7F;
                switch (this.formatStatus) {
                    case WAIT_FOR_HOLE: {
                        this.stopExecution();
                        break block3;
                    }
                    case RECEIVE_DATA: {
                        break block3;
                    }
                }
                this.setIdle();
                break;
            }
            case READ_DATA: 
            case READ_DELETED_DATA: 
            case READ_TRACK: 
            case SCAN_EQUAL: 
            case SCAN_LOW_OR_EQUAL: 
            case SCAN_HIGH_OR_EQUAL: {
                if (!this.tcEnabled) break;
                this.stopExecution();
                break;
            }
            case WRITE_DATA: 
            case WRITE_DELETED_DATA: {
                Thread thread = this.ioTaskThread;
                synchronized (thread) {
                    if (this.tcEnabled) {
                        this.tcFired = true;
                        this.tcEnabled = false;
                        this.dmaReq = false;
                        this.statusRegMain &= 0xFFFFFF7F;
                        this.statusRegMain &= 0xFFFFFFBF;
                        this.statusRegMain &= 0xFFFFFFDF;
                        this.tStatesTillIOReq = 0;
                        this.tStatesTillIOStart = 0;
                        this.tStatesTillOverrun = 0;
                        this.ioTaskCmd = IOTaskCmd.WRITE_SECTOR;
                        try {
                            this.ioTaskThread.notify();
                        }
                        catch (IllegalMonitorStateException illegalMonitorStateException) {
                            this.ioTaskNoWait = true;
                        }
                    }
                    break;
                }
            }
        }
    }

    public boolean getIndexHoleState() {
        return this.tStateRotationCounter < this.tStatesPerRotation / 100;
    }

    public boolean isDMARequest() {
        return this.dmaReq;
    }

    public boolean isInterruptRequest() {
        return this.interruptReq;
    }

    public int readMainStatusReg() {
        int n = this.statusRegMain;
        if (this.debugLevel > 2) {
            System.out.printf("FDC: read status: %02X\n", n);
        }
        this.interruptReq = false;
        return n;
    }

    public int readData() {
        int n = -1;
        if (!this.dmaMode) {
            n = this.readFromDisk();
        }
        if (n == -1) {
            n = this.statusRegMain;
            if (this.resultIdx >= 0 && this.resultIdx < this.results.length) {
                n = this.results[this.resultIdx];
                --this.resultIdx;
                if (this.resultIdx < 0) {
                    this.setIdle();
                }
            }
        }
        this.interruptReq = false;
        if (this.debugLevel > 1) {
            System.out.printf("FDC: read data: %02X\n", n);
        }
        return n;
    }

    public int readDMA() {
        int n = -1;
        this.dmaReq = false;
        if (this.dmaMode) {
            n = this.readFromDisk();
        }
        if (this.debugLevel > 1) {
            System.out.printf("FDC: read dma: %02X\n", n);
        }
        return n;
    }

    public void reset(boolean bl) {
        if (this.debugLevel > 0) {
            System.out.println("FDC: reset");
        }
        if (bl) {
            this.dmaMode = false;
            this.stepRateMillis = 16;
        }
        this.executingDrive = null;
        this.seekMode = false;
        this.ioTaskNoWait = false;
        this.tcEnabled = false;
        this.tcFired = false;
        this.dmaReq = false;
        this.interruptReq = false;
        this.statusRegMain = 128;
        this.statusReg3 = 0;
        this.formatStatus = FormatStatus.IDLE;
        this.ioTaskCmd = IOTaskCmd.IDLE;
        this.curSector = null;
        this.curSectorReader = null;
        this.curSectorIdx = -1;
        this.dataPos = -1;
        this.dataLen = 0;
        this.remainBytes = 0;
        this.tStatesTillIOReq = 0;
        this.tStatesTillIOStart = 0;
        this.tStatesTillOverrun = 0;
        this.tStateRotationCounter = 0;
        this.tStateStepCounter = 0;
        Arrays.fill(this.seekStatus, -1);
        this.clearSectorID();
        this.clearRegs012();
        Arrays.fill(this.args, 0);
        Arrays.fill(this.results, 0);
        Arrays.fill(this.remainSeekSteps, 0);
        this.setIdle();
    }

    public void setTStatesPerMilli(int n) {
        this.tStatesPerMilli = n;
        this.tStatesPerRotation = n * 20;
        this.calcTStatesPerStep();
    }

    public void write(int n) {
        if (this.debugLevel > 1) {
            System.out.printf("FDC: write: %02X\n", n);
        }
        if (!this.dmaMode && this.executingDrive != null) {
            this.writeToDrive(n);
        } else {
            this.writeCmd(n);
        }
    }

    public void writeDMA(int n) {
        if (this.debugLevel > 1) {
            System.out.printf("FDC: write dma: %02X\n", n);
        }
        this.dmaReq = false;
        if (this.dmaMode) {
            this.writeToDrive(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.ioTaskEnabled) {
            Object object = this.ioTaskThread;
            synchronized (object) {
                if ((this.curCmd == Command.WRITE_DATA || this.curCmd == Command.WRITE_DELETED_DATA) && this.tcFired) {
                    this.stopExecution();
                }
                if (this.ioTaskNoWait) {
                    this.ioTaskNoWait = false;
                } else {
                    try {
                        this.ioTaskThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                }
            }
            if (!this.ioTaskEnabled) continue;
            object = IOTaskCmd.IDLE;
            Thread thread = this.ioTaskThread;
            synchronized (thread) {
                object = this.ioTaskCmd;
                this.ioTaskCmd = IOTaskCmd.IDLE;
            }
            switch (1.$SwitchMap$jkcemu$disk$FDC8272$IOTaskCmd[((Enum)object).ordinal()]) {
                case 1: {
                    this.execIOFormatTrack();
                    break;
                }
                case 2: {
                    this.execIOReadSectorByID();
                    break;
                }
                case 3: {
                    this.execIOReadSectorByIndex();
                    break;
                }
                case 4: {
                    this.execIOReadSectorForWrite();
                    break;
                }
                case 5: {
                    this.execIOWriteSector();
                }
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        this.setTStatesPerMilli(z80CPU.getMaxSpeedKHz());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        Thread thread = this.ioTaskThread;
        synchronized (thread) {
            if (this.tStatesTillIOStart > 0) {
                this.tStatesTillIOStart -= n;
                if (this.tStatesTillIOStart <= 0 && this.ioTaskCmd != IOTaskCmd.IDLE) {
                    if (this.eotReached) {
                        this.statusReg0 |= 0x40;
                        this.statusReg1 |= 0x80;
                        this.stopExecution();
                        this.eotReached = false;
                    } else {
                        try {
                            this.ioTaskThread.notify();
                        }
                        catch (IllegalMonitorStateException illegalMonitorStateException) {
                            this.ioTaskNoWait = true;
                        }
                    }
                }
            }
        }
        if (this.tStatesTillIOReq > 0) {
            this.tStatesTillIOReq -= n;
            if (this.tStatesTillIOReq <= 0) {
                switch (this.curCmd) {
                    case FORMAT_TRACK: {
                        this.setByteWritable(false);
                        break;
                    }
                    case READ_DATA: 
                    case READ_DELETED_DATA: 
                    case READ_TRACK: {
                        this.setByteReadable();
                        break;
                    }
                    case SCAN_EQUAL: 
                    case SCAN_LOW_OR_EQUAL: 
                    case SCAN_HIGH_OR_EQUAL: 
                    case WRITE_DATA: 
                    case WRITE_DELETED_DATA: {
                        this.setByteWritable(true);
                    }
                }
            }
        }
        this.tStateRotationCounter += n;
        if (this.tStatesPerRotation > 0 && this.tStateRotationCounter >= this.tStatesPerRotation) {
            this.tStateRotationCounter = 0;
            if (this.curCmd == Command.FORMAT_TRACK) {
                switch (this.formatStatus) {
                    case WAIT_FOR_HOLE: {
                        this.formatStatus = FormatStatus.RECEIVE_DATA;
                        this.dataPos = 0;
                        this.setByteWritable(false);
                        break;
                    }
                    case RECEIVE_DATA: {
                        this.startIOTask(IOTaskCmd.FORMAT_TRACK, 0);
                        this.formatStatus = FormatStatus.BUSY;
                    }
                }
            }
        }
        if (this.seekMode) {
            this.tStateStepCounter += n;
            if (this.tStateStepCounter >= this.tStatesPerStep) {
                this.tStateStepCounter = 0;
                this.execSeekStep();
            }
        }
        if (this.tStatesTillOverrun > 0) {
            this.tStatesTillOverrun -= n;
            if (this.tStatesTillOverrun <= 0 && this.getExecutingDrive() != null) {
                this.statusReg0 |= 0x40;
                this.statusReg1 |= 0x10;
            }
        }
    }

    private void addSectorNum(int n) {
        if (this.sectorIdRec == this.args[6]) {
            if ((this.args[0] & 0x80) != 0) {
                if ((this.args[1] & 4) == 0) {
                    this.sectorIdRec = 1;
                    this.args[1] = this.args[1] | 4;
                } else {
                    this.eotReached = true;
                    this.sectorIdRec = 1;
                    ++this.sectorIdCyl;
                    this.args[1] = this.args[1] & 0xFFFFFFFB;
                }
            } else {
                this.eotReached = true;
                this.sectorIdRec = 1;
                ++this.sectorIdCyl;
            }
        } else {
            this.sectorIdRec += n;
        }
    }

    private void calcTStatesPerStep() {
        this.tStatesPerStep = this.stepRateMillis * this.tStatesPerMilli / this.mhz;
    }

    private void clearRegs012() {
        this.statusReg0 = 0;
        this.statusReg1 = 0;
        this.statusReg2 = 0;
    }

    private void clearSectorID() {
        this.sectorIdCyl = 0;
        this.sectorIdHead = 0;
        this.sectorIdRec = 0;
        this.sectorIdSizeCode = 0;
        this.statusReg0 = 0;
        this.statusReg1 = 0;
        this.statusReg2 = 0;
    }

    private void execIOFormatTrack() {
        int n;
        boolean bl = false;
        int n2 = 0;
        FloppyDiskDrive floppyDiskDrive = this.getExecutingDrive();
        if (floppyDiskDrive != null && this.dataBuf != null && (n = this.dataPos / 4) > 0 && n * 4 <= this.dataBuf.length) {
            int n3 = this.args[2] & 0xF;
            int n4 = 128;
            if (n3 > 0) {
                n4 = 128 << n3;
            }
            byte[] byArray = new byte[n4];
            Arrays.fill(byArray, (byte)this.args[5]);
            SectorID[] sectorIDArray = new SectorID[n];
            int n5 = 0;
            while (n2 + 3 < this.dataBuf.length && n5 < sectorIDArray.length) {
                int n6 = this.dataBuf[n2++] & 0xFF;
                int n7 = this.dataBuf[n2++] & 0xFF;
                int n8 = this.dataBuf[n2++] & 0xFF;
                int n9 = this.dataBuf[n2++] & 0xFF;
                sectorIDArray[n5++] = new SectorID(n6, n7, n8, n9);
            }
            bl = floppyDiskDrive.formatTrack(this.args[1] >> 2 & 1, sectorIDArray, byArray);
        }
        if ((floppyDiskDrive = this.getExecutingDrive()) != null) {
            if (this.dataBuf.length >= 4) {
                this.sectorIdCyl = this.dataBuf[0] & 0xFF;
                this.sectorIdHead = this.dataBuf[0] & 0xFF;
                this.sectorIdRec = this.dataBuf[0] & 0xFF;
                this.sectorIdSizeCode = this.dataBuf[0] & 0xFF;
            }
            if (bl) {
                if ((n2 -= 4) + 3 < this.dataBuf.length) {
                    this.sectorIdCyl = this.dataBuf[n2++] & 0xFF;
                    this.sectorIdHead = this.dataBuf[n2++] & 0xFF;
                    this.sectorIdRec = (this.dataBuf[n2++] & 0xFF) + 1;
                    this.sectorIdSizeCode = this.dataBuf[n2] & 0xFF;
                }
            } else {
                this.statusReg0 |= 0x40;
                if (this.executingDrive.isReadOnly()) {
                    this.statusReg1 |= 2;
                } else {
                    this.statusReg1 |= 0x20;
                    this.statusReg2 |= 0x20;
                }
            }
            this.stopExecution();
        }
    }

    private void execIOReadSectorByID() {
        AbstractFloppyDisk abstractFloppyDisk;
        boolean bl = false;
        SectorData sectorData = null;
        FloppyDiskDrive floppyDiskDrive = this.getExecutingDrive();
        if (floppyDiskDrive != null && (abstractFloppyDisk = floppyDiskDrive.getDisk()) != null) {
            int n = this.getArgHead();
            if (abstractFloppyDisk.supportsDeletedSectors()) {
                int n2 = this.getSectorIndexByCurHeadPos(floppyDiskDrive);
                if (n2 >= 0) {
                    boolean bl2 = true;
                    int n3 = -1;
                    int n4 = n2;
                    while (bl2 && (n4 < n3 || n3 < 0)) {
                        sectorData = floppyDiskDrive.readSectorByIndex(n, n4);
                        if (sectorData == null && n2 > 0) {
                            n3 = n2;
                            n2 = 0;
                            n4 = 0;
                            continue;
                        }
                        bl2 = false;
                        if (sectorData == null) continue;
                        if (this.curCmd == Command.READ_DELETED_DATA) {
                            if (!sectorData.isDeleted()) {
                                this.statusReg2 |= 0x40;
                                if ((this.args[0] & 0x20) != 0) {
                                    ++n4;
                                    bl2 = true;
                                } else {
                                    bl = true;
                                }
                            }
                        } else if (sectorData.isDeleted()) {
                            this.statusReg2 |= 0x40;
                            if ((this.args[0] & 0x20) != 0) {
                                ++n4;
                                bl2 = true;
                            } else {
                                bl = true;
                            }
                        }
                        if (bl2 || sectorData.getCylinder() == this.sectorIdCyl && sectorData.getHead() == this.sectorIdHead && sectorData.getSectorNum() == this.sectorIdRec && sectorData.getSizeCode() == this.sectorIdSizeCode) continue;
                        ++n4;
                        bl2 = true;
                    }
                }
            } else {
                sectorData = floppyDiskDrive.readSectorByID(n, 0, this.sectorIdCyl, this.sectorIdHead, this.sectorIdRec, this.sectorIdSizeCode);
            }
        }
        if ((floppyDiskDrive = this.getExecutingDrive()) != null) {
            if (sectorData != null) {
                if (sectorData.checkError()) {
                    this.statusReg0 |= 0x40;
                    this.statusReg1 |= 0x20;
                    this.statusReg2 |= 0x20;
                }
                this.curSector = sectorData;
                this.curSectorReader = sectorData.reader();
                this.remainBytes = this.dataLen;
                this.startIOReqTimer();
            } else {
                this.statusReg0 |= 0x40;
                if (!bl) {
                    if (this.sectorIdCyl == this.args[2] && this.sectorIdHead == this.args[3] && this.sectorIdRec == this.args[4]) {
                        this.statusReg1 |= 4;
                        this.statusReg1 |= 1;
                    } else {
                        this.statusReg1 |= 0x80;
                    }
                }
                this.stopExecution();
            }
        }
    }

    private void execIOReadSectorByIndex() {
        SectorData sectorData = null;
        FloppyDiskDrive floppyDiskDrive = this.executingDrive;
        if (floppyDiskDrive != null) {
            sectorData = floppyDiskDrive.readSectorByIndex(this.getArgHead(), this.sectorIdRec - 1);
        }
        if ((floppyDiskDrive = this.getExecutingDrive()) != null) {
            if (sectorData != null) {
                this.curSector = sectorData;
                this.curSectorReader = sectorData.reader();
                this.remainBytes = this.dataLen;
                if (this.curCmd == Command.READ_TRACK) {
                    this.setByteReadable();
                } else {
                    this.sectorIdCyl = sectorData.getCylinder();
                    this.sectorIdHead = sectorData.getHead();
                    this.sectorIdRec = sectorData.getSectorNum();
                    this.sectorIdSizeCode = sectorData.getSizeCode();
                    if (sectorData.isEmpty()) {
                        this.statusReg1 |= 1;
                        this.statusReg2 |= 1;
                    }
                    this.stopExecution();
                }
            } else {
                this.statusReg0 |= 0x40;
                if (this.sectorIdRec == 1) {
                    this.statusReg1 |= 4;
                    this.statusReg1 |= 1;
                } else {
                    this.statusReg1 |= 0x80;
                }
                this.stopExecution();
            }
        }
    }

    private void execIOReadSectorForWrite() {
        AbstractFloppyDisk abstractFloppyDisk;
        SectorData sectorData = null;
        FloppyDiskDrive floppyDiskDrive = this.executingDrive;
        if (floppyDiskDrive != null && (abstractFloppyDisk = floppyDiskDrive.getDisk()) != null) {
            sectorData = floppyDiskDrive.readSectorByID(this.getArgHead(), 0, this.sectorIdCyl, this.sectorIdHead, this.sectorIdRec, this.sectorIdSizeCode);
        }
        if ((floppyDiskDrive = this.getExecutingDrive()) != null) {
            if (sectorData != null) {
                this.curSector = sectorData;
                this.dataPos = 0;
                this.setByteWritable(true);
            } else {
                this.statusReg0 |= 0x40;
                this.statusReg1 |= 4;
                this.statusReg1 |= 1;
                this.stopExecution();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execIOWriteSector() {
        FloppyDiskDrive floppyDiskDrive = this.executingDrive;
        boolean bl = false;
        SectorData sectorData = this.curSector;
        if (floppyDiskDrive != null) {
            if (sectorData != null && this.dataBuf != null && this.dataPos >= 0) {
                this.curSector = null;
                while (this.dataPos < this.dataLen && this.dataPos < this.dataBuf.length) {
                    this.dataBuf[this.dataPos++] = 0;
                }
                bl = floppyDiskDrive.writeSector(this.getArgHead(), sectorData, this.dataBuf, this.dataLen, this.curCmd == Command.WRITE_DELETED_DATA);
                this.dataPos = -1;
                floppyDiskDrive = this.executingDrive;
                if (floppyDiskDrive != null) {
                    if (bl) {
                        this.incSectorNum();
                        Thread thread = this.ioTaskThread;
                        synchronized (thread) {
                            if (this.tcFired) {
                                this.stopExecution();
                            } else {
                                this.startIOTask(IOTaskCmd.READ_SECTOR_FOR_WRITE, this.tStatesPerRotation);
                            }
                        }
                    } else {
                        this.statusReg0 |= 0x40;
                        if (floppyDiskDrive.isReadOnly()) {
                            this.statusReg1 |= 2;
                        } else {
                            this.statusReg1 |= 0x20;
                            this.statusReg2 |= 0x20;
                        }
                        this.stopExecution();
                    }
                }
            } else if (this.tcFired) {
                this.stopExecution();
            }
        }
    }

    private void execSeekStep() {
        boolean bl = false;
        int n = 1;
        for (int i = 0; i < this.remainSeekSteps.length; ++i) {
            boolean bl2 = false;
            if (this.remainSeekSteps[i] > 0) {
                FloppyDiskDrive floppyDiskDrive = this.getDrive(i);
                if (floppyDiskDrive != null) {
                    int n2 = i;
                    this.remainSeekSteps[n2] = this.remainSeekSteps[n2] - 1;
                    if (floppyDiskDrive.seekStep()) {
                        int n3 = i;
                        this.seekStatus[n3] = this.seekStatus[n3] | 0x20;
                        this.interruptReq = true;
                    } else if (this.remainSeekSteps[i] > 0) {
                        bl2 = true;
                    } else {
                        int n4 = i;
                        this.seekStatus[n4] = this.seekStatus[n4] | 0x40;
                        int n5 = i;
                        this.seekStatus[n5] = this.seekStatus[n5] | 0x20;
                        int n6 = i;
                        this.seekStatus[n6] = this.seekStatus[n6] | 0x10;
                        this.interruptReq = true;
                    }
                } else {
                    int n7 = i;
                    this.seekStatus[n7] = this.seekStatus[n7] | 0x40;
                    int n8 = i;
                    this.seekStatus[n8] = this.seekStatus[n8] | 0x20;
                    int n9 = i;
                    this.seekStatus[n9] = this.seekStatus[n9] | 8;
                    this.interruptReq = true;
                }
            }
            if (bl2) {
                bl = true;
            } else {
                this.remainSeekSteps[i] = 0;
            }
            n <<= 1;
        }
        this.seekMode = bl;
    }

    private void execSenseDriveStatus() {
        this.statusReg3 = this.args[1] & 7;
        FloppyDiskDrive floppyDiskDrive = this.getArgDrive();
        if (floppyDiskDrive != null) {
            this.statusReg3 |= 8;
            if (floppyDiskDrive.getCylinder() == 0) {
                this.statusReg3 |= 0x10;
            }
            if (floppyDiskDrive.isReady()) {
                this.statusReg3 |= 0x20;
            }
            if (floppyDiskDrive.isReadOnly()) {
                this.statusReg3 |= 0x40;
            }
        }
        this.results[0] = this.statusReg3;
        this.resultIdx = 0;
        this.setResultMode();
    }

    private void execSenseInterruptStatus() {
        this.results[0] = 0;
        this.results[1] = 128;
        int n = 1;
        for (int i = 0; i < this.seekStatus.length; ++i) {
            int n2 = this.seekStatus[i];
            if (n2 >= 0) {
                if ((n2 & 0xF8) != 0) {
                    this.results[1] = n2 | i;
                    FloppyDiskDrive floppyDiskDrive = this.getDrive(i);
                    if (floppyDiskDrive != null) {
                        this.results[0] = floppyDiskDrive.getCylinder();
                    }
                    this.statusRegMain &= ~n;
                    this.seekStatus[i] = -1;
                    break;
                }
                this.results[1] = 0;
            }
            n <<= 1;
        }
        this.resultIdx = 1;
        this.setResultMode();
    }

    private int getSectorIndexByCurHeadPos(FloppyDiskDrive floppyDiskDrive) {
        AbstractFloppyDisk abstractFloppyDisk;
        int n = -1;
        if (floppyDiskDrive != null && (abstractFloppyDisk = floppyDiskDrive.getDisk()) != null) {
            int n2 = this.getArgHead();
            int n3 = floppyDiskDrive.getCylinder();
            int n4 = abstractFloppyDisk.getSectorsOfCylinder(n3, n2);
            int n5 = this.tStatesPerRotation;
            if (n4 > 0 && n5 > 0 && n2 < abstractFloppyDisk.getSides() && n3 < abstractFloppyDisk.getCylinders() && (n = Math.round((float)this.tStateRotationCounter / (float)n5 * (float)n4)) >= n4) {
                n = n4 - 1;
            }
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    private int getArgDataLen() {
        int n = this.args[5] & 0xF;
        int n2 = this.args[8];
        if (n > 0) {
            n2 = 128 << n;
        }
        return n2;
    }

    private FloppyDiskDrive getArgDrive() {
        return this.getDrive(this.args[1] & 3);
    }

    private int getArgHead() {
        return this.args[1] >> 2 & 1;
    }

    private FloppyDiskDrive getDrive(int n) {
        return this.driveSelector.getFloppyDiskDrive(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FloppyDiskDrive getExecutingDrive() {
        FloppyDiskDrive floppyDiskDrive = null;
        Object object = this.ioLock;
        synchronized (object) {
            floppyDiskDrive = this.executingDrive;
        }
        return floppyDiskDrive;
    }

    private void incSectorNum() {
        this.addSectorNum(1);
    }

    private int readFromDisk() {
        int n = -1;
        FloppyDiskDrive floppyDiskDrive = this.executingDrive;
        if (floppyDiskDrive != null && (this.curCmd == Command.READ_DATA || this.curCmd == Command.READ_DELETED_DATA || this.curCmd == Command.READ_TRACK)) {
            this.tStatesTillOverrun = 0;
            SectorData sectorData = this.curSector;
            SectorData.Reader reader = this.curSectorReader;
            if (sectorData != null && reader != null) {
                if (this.remainBytes > 0) {
                    n = reader.read();
                    --this.remainBytes;
                }
                if (n < 0 || (this.statusReg0 & 0xC0) != 0 || (this.statusReg2 & 0x40) != 0 && (this.args[0] & 0x20) == 0) {
                    this.stopExecution();
                } else {
                    this.statusRegMain &= 0xFFFFFF7F;
                    if (this.remainBytes > 0 && this.curSectorReader.isByteAvailable()) {
                        this.startIOReqTimer();
                    } else {
                        this.curSector = null;
                        this.curSectorReader = null;
                        this.incSectorNum();
                        if (this.curCmd == Command.READ_TRACK) {
                            this.startIOTask(IOTaskCmd.READ_SECTOR_BY_INDEX, this.tStatesPerRotation / 5);
                        } else {
                            this.startIOTask(IOTaskCmd.READ_SECTOR_BY_ID, this.tStatesPerRotation / 5);
                        }
                    }
                }
            }
        }
        return n;
    }

    private void seek(int n, int n2, int n3) {
        this.statusRegMain &= 0xFFFFFFEF;
        this.statusReg0 = 0;
        if (n >= 0 && n < this.seekStatus.length) {
            this.seekStatus[n] = n2 << 2 & 4 | n;
            FloppyDiskDrive floppyDiskDrive = this.getDrive(n);
            if (floppyDiskDrive != null) {
                if (floppyDiskDrive.getCylinder() == n3) {
                    int n4 = n;
                    this.seekStatus[n4] = this.seekStatus[n4] | 0x20;
                    this.interruptReq = true;
                } else {
                    this.statusRegMain = n > 0 ? (this.statusRegMain |= 1 << n) : (this.statusRegMain |= 1);
                    floppyDiskDrive.setSeekMode(n2, n3);
                    this.remainSeekSteps[n] = 77;
                    if (!this.seekMode) {
                        this.tStateStepCounter = 0;
                        this.seekMode = true;
                    }
                }
            } else {
                int n5 = n;
                this.seekStatus[n5] = this.seekStatus[n5] | 0x40;
                int n6 = n;
                this.seekStatus[n6] = this.seekStatus[n6] | 8;
                int n7 = n;
                this.seekStatus[n7] = this.seekStatus[n7] | 0x20;
                this.interruptReq = true;
            }
        } else {
            this.statusReg0 |= 0xC0;
            this.statusReg0 |= 0x20;
            this.statusReg0 |= 8;
            this.statusReg0 |= n2 << 2 & 4;
            this.statusReg0 |= n & 3;
            this.interruptReq = true;
        }
    }

    private void setByteReadable() {
        if (this.dmaMode) {
            this.dmaReq = true;
        } else {
            this.statusReg0 &= 0xFFFFFFF8;
            this.statusReg0 |= this.args[1] & 7;
            this.interruptReq = true;
        }
        this.statusRegMain |= 0x40;
        this.statusRegMain |= 0x80;
        this.startOverrunTimer();
    }

    private void setByteWritable(boolean bl) {
        if (this.dmaMode) {
            this.dmaReq = true;
        } else {
            this.statusReg0 &= 0xFFFFFFF8;
            this.statusReg0 |= this.args[1] & 7;
            this.interruptReq = true;
        }
        this.statusRegMain &= 0xFFFFFFBF;
        this.statusRegMain |= 0x80;
        if (bl) {
            this.startOverrunTimer();
        }
    }

    private void setDataBuf(int n) {
        this.dataLen = n;
        if (this.dataBuf != null && this.dataBuf.length < n) {
            this.dataBuf = null;
        }
        if (this.dataBuf == null) {
            this.dataBuf = new byte[n];
        }
    }

    private void setExecutionMode() {
        this.statusRegMain &= 0xFFFFFF7F;
        this.statusRegMain &= 0xFFFFFFBF;
        this.statusRegMain |= 0x10;
        if (!this.dmaMode) {
            this.statusRegMain |= 0x20;
        }
    }

    private void setIdle() {
        this.statusRegMain &= 0xF;
        this.statusRegMain |= 0x80;
        this.argIdx = 0;
        this.resultIdx = -1;
        this.eotReached = false;
        this.tcEnabled = false;
        this.tcFired = false;
        this.executingDrive = null;
        this.curCmd = Command.INVALID;
    }

    private void setResultMode() {
        this.dmaReq = false;
        this.tStatesTillIOReq = 0;
        this.tStatesTillOverrun = 0;
        this.statusRegMain &= 0xF;
        this.statusRegMain |= 0x10;
        this.statusRegMain |= 0x40;
        this.statusRegMain |= 0x80;
    }

    private void startFormatTrack() {
        this.setExecutionMode();
        this.clearRegs012();
        this.clearSectorID();
        boolean bl = false;
        FloppyDiskDrive floppyDiskDrive = this.getArgDrive();
        if (floppyDiskDrive != null && floppyDiskDrive.isReady()) {
            if (floppyDiskDrive.isReadOnly()) {
                this.statusReg0 |= 0x40;
                this.statusReg1 |= 2;
            } else {
                this.setDataBuf(this.args[3] * 4);
                this.dataPos = -1;
                this.formatStatus = FormatStatus.WAIT_FOR_HOLE;
                this.executingDrive = floppyDiskDrive;
                bl = true;
            }
        }
        if (!bl) {
            if ((this.statusReg0 & 0xC0) == 0) {
                this.statusReg0 |= 0x40;
                this.statusReg0 |= 0x10;
                this.statusReg0 |= 8;
            }
            this.statusReg0 |= this.args[1] & 7;
            this.stopExecution();
        }
    }

    private void startIOReqTimer() {
        this.tStatesTillIOReq = Math.min(this.tStatesPerMilli / 100, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIOTask(IOTaskCmd iOTaskCmd, int n) {
        Thread thread = this.ioTaskThread;
        synchronized (thread) {
            this.ioTaskCmd = iOTaskCmd;
            this.tStatesTillIOStart = n;
            if (n == 0) {
                try {
                    this.ioTaskThread.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    this.ioTaskNoWait = true;
                }
            }
        }
    }

    private void startOverrunTimer() {
        this.tStatesTillOverrun = this.tStatesPerRotation;
    }

    private void startReadDataOrScan() {
        this.setExecutionMode();
        this.clearRegs012();
        this.sectorIdCyl = this.args[2];
        this.sectorIdHead = this.args[3];
        this.sectorIdRec = this.args[4];
        this.sectorIdSizeCode = this.args[5];
        this.curSectorReader = null;
        this.tcEnabled = true;
        boolean bl = false;
        FloppyDiskDrive floppyDiskDrive = this.getArgDrive();
        if (floppyDiskDrive != null && floppyDiskDrive.isReady()) {
            if (this.curCmd == Command.SCAN_EQUAL || this.curCmd == Command.SCAN_LOW_OR_EQUAL || this.curCmd == Command.SCAN_HIGH_OR_EQUAL) {
                this.dataLen = 128;
                this.args[5] = this.args[5] & 0xF;
                if (this.args[5] > 0) {
                    this.dataLen = 128 << this.args[5];
                }
                this.statusReg2 |= 8;
            } else {
                this.dataLen = this.getArgDataLen();
            }
            this.executingDrive = floppyDiskDrive;
            this.startIOTask(IOTaskCmd.READ_SECTOR_BY_ID, 0);
            bl = true;
        }
        if (!bl) {
            this.statusReg0 |= 0x40;
            this.statusReg0 |= 0x10;
            this.statusReg0 |= 8;
            this.statusReg0 |= this.args[1] & 7;
            this.stopExecution();
        }
    }

    private void startReadID() {
        int n;
        this.setExecutionMode();
        this.clearRegs012();
        this.clearSectorID();
        boolean bl = false;
        FloppyDiskDrive floppyDiskDrive = this.getArgDrive();
        if (floppyDiskDrive != null && floppyDiskDrive.isReady() && (n = this.getSectorIndexByCurHeadPos(floppyDiskDrive)) >= 0) {
            this.executingDrive = floppyDiskDrive;
            this.sectorIdRec = n + 1;
            this.startIOTask(IOTaskCmd.READ_SECTOR_BY_INDEX, 0);
            bl = true;
        }
        if (!bl) {
            this.statusReg0 |= 0x40;
            this.statusReg0 |= 0x10;
            this.statusReg0 |= 8;
            this.statusReg0 |= this.args[1] & 7;
            this.stopExecution();
        }
    }

    private void startReadTrack() {
        this.setExecutionMode();
        this.clearRegs012();
        this.sectorIdCyl = this.args[2];
        this.sectorIdHead = this.args[3];
        this.sectorIdRec = 1;
        this.sectorIdSizeCode = this.args[5];
        this.curSectorReader = null;
        this.curSectorIdx = 0;
        this.tcEnabled = true;
        boolean bl = false;
        FloppyDiskDrive floppyDiskDrive = this.getArgDrive();
        if (floppyDiskDrive != null && floppyDiskDrive.isReady()) {
            this.dataLen = this.getArgDataLen();
            this.executingDrive = floppyDiskDrive;
            this.startIOTask(IOTaskCmd.READ_SECTOR_BY_INDEX, Math.max(this.tStatesPerRotation - this.tStateRotationCounter, 0));
            bl = true;
        }
        if (!bl) {
            this.statusReg0 |= 0x40;
            this.statusReg0 |= 0x10;
            this.statusReg0 |= 8;
            this.statusReg0 |= this.args[1] & 7;
            this.stopExecution();
        }
    }

    private void startWriteData() {
        this.setExecutionMode();
        this.clearRegs012();
        this.sectorIdCyl = this.args[2];
        this.sectorIdHead = this.args[3];
        this.sectorIdRec = this.args[4];
        this.sectorIdSizeCode = this.args[5];
        this.curSector = null;
        this.tcEnabled = true;
        boolean bl = false;
        FloppyDiskDrive floppyDiskDrive = this.getArgDrive();
        if (floppyDiskDrive != null && floppyDiskDrive.isReady()) {
            if (floppyDiskDrive.isReadOnly()) {
                this.statusReg0 |= 0x40;
                this.statusReg1 |= 2;
            } else {
                if (!this.dmaMode) {
                    this.statusRegMain |= 0x20;
                }
                this.setDataBuf(this.getArgDataLen());
                this.dataPos = -1;
                this.executingDrive = floppyDiskDrive;
                this.startIOTask(IOTaskCmd.READ_SECTOR_FOR_WRITE, 0);
                bl = true;
            }
        }
        if (!bl) {
            if ((this.statusReg0 & 0xC0) == 0) {
                this.statusReg0 |= 0x40;
                this.statusReg0 |= 0x10;
                this.statusReg0 |= 8;
            }
            this.statusReg0 |= this.args[1] & 7;
            this.stopExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopExecution() {
        Object object = this.ioLock;
        synchronized (object) {
            if (!this.eotReached) {
                this.tcEnabled = false;
            }
            this.ioTaskCmd = IOTaskCmd.IDLE;
            this.ioTaskNoWait = false;
            this.tcFired = false;
            this.executingDrive = null;
            this.formatStatus = FormatStatus.IDLE;
            this.results[0] = this.sectorIdSizeCode;
            this.results[1] = this.sectorIdRec;
            this.results[2] = this.sectorIdHead;
            this.results[3] = this.sectorIdCyl;
            this.results[4] = this.statusReg2;
            this.results[5] = this.statusReg1;
            this.results[6] = this.statusReg0;
            this.resultIdx = 6;
            this.statusReg0 &= 0xFFFFFFF8;
            this.statusReg0 |= this.args[1] & 7;
            this.interruptReq = true;
            this.setResultMode();
        }
    }

    private void writeCmd(int n) {
        this.statusRegMain |= 0x10;
        if (this.argIdx == 0) {
            this.executingDrive = null;
            this.resultIdx = -1;
            this.args[this.argIdx++] = n;
            this.curCmd = (n &= 0x1F) < cmds.length ? cmds[n] : Command.INVALID;
            if (this.curCmd == Command.INVALID) {
                if (this.debugLevel > 0) {
                    System.out.println("FDC: INVALID");
                }
                this.curCmd = Command.INVALID;
                this.interruptReq = false;
                this.results[0] = this.statusReg0 = 128;
                this.resultIdx = 0;
                this.setResultMode();
            } else {
                if (this.debugLevel > 0) {
                    System.out.println("FDC: " + (Object)((Object)this.curCmd));
                }
                if (this.curCmd == Command.SENSE_INTERRUPT_STATUS) {
                    this.execSenseInterruptStatus();
                }
            }
        } else if (this.executingDrive == null && this.resultIdx < 0) {
            if (this.argIdx < this.args.length) {
                this.args[this.argIdx++] = n;
            }
            switch (this.curCmd) {
                case FORMAT_TRACK: {
                    if (this.argIdx != 6) break;
                    this.startFormatTrack();
                    break;
                }
                case READ_DATA: 
                case READ_DELETED_DATA: 
                case SCAN_EQUAL: 
                case SCAN_LOW_OR_EQUAL: 
                case SCAN_HIGH_OR_EQUAL: {
                    if (this.argIdx != 9) break;
                    this.startReadDataOrScan();
                    break;
                }
                case READ_ID: {
                    if (this.argIdx != 2) break;
                    this.startReadID();
                    break;
                }
                case READ_TRACK: {
                    if (this.argIdx != 9) break;
                    this.startReadTrack();
                    break;
                }
                case RECALIBRATE: {
                    if (this.argIdx != 2) break;
                    this.seek(this.args[1] & 3, 0, 0);
                    this.setIdle();
                    break;
                }
                case SEEK: {
                    if (this.argIdx != 3) break;
                    this.seek(this.args[1] & 3, this.args[1] >> 2 & 1, this.args[2]);
                    this.setIdle();
                    break;
                }
                case SENSE_DRIVE_STATUS: {
                    if (this.argIdx != 2) break;
                    this.execSenseDriveStatus();
                    break;
                }
                case SPECIFY: {
                    if (this.argIdx != 3) break;
                    this.stepRateMillis = 16 - (this.args[1] >> 4 & 0xF);
                    this.dmaMode = (this.args[2] & 1) == 0;
                    this.calcTStatesPerStep();
                    this.setIdle();
                    break;
                }
                case WRITE_DATA: 
                case WRITE_DELETED_DATA: {
                    if (this.argIdx != 9) break;
                    this.startWriteData();
                    break;
                }
                default: {
                    this.setIdle();
                }
            }
        }
    }

    private void writeToDrive(int n) {
        n &= 0xFF;
        this.statusRegMain &= 0xFFFFFF7F;
        FloppyDiskDrive floppyDiskDrive = this.executingDrive;
        if (floppyDiskDrive != null) {
            if (this.curCmd == Command.SCAN_EQUAL || this.curCmd == Command.SCAN_LOW_OR_EQUAL || this.curCmd == Command.SCAN_HIGH_OR_EQUAL) {
                this.tStatesTillOverrun = 0;
                int n2 = -1;
                SectorData sectorData = this.curSector;
                SectorData.Reader reader = this.curSectorReader;
                if (sectorData != null && reader != null) {
                    if (this.remainBytes > 0) {
                        n2 = reader.read();
                        --this.remainBytes;
                    }
                    if (n2 < 0 || (this.statusReg0 & 0xC0) != 0) {
                        this.stopExecution();
                    } else {
                        if (n2 != n) {
                            this.statusReg2 &= 0xFFFFFFF7;
                        }
                        if (this.curCmd == Command.SCAN_LOW_OR_EQUAL) {
                            if (n2 > n) {
                                this.statusReg2 |= 4;
                            }
                        } else if (this.curCmd == Command.SCAN_HIGH_OR_EQUAL) {
                            if (n2 < n) {
                                this.statusReg2 |= 4;
                            }
                        } else if (n2 != n) {
                            this.statusReg2 |= 4;
                        }
                        if (this.remainBytes > 0 && this.curSectorReader.isByteAvailable()) {
                            this.startIOReqTimer();
                        } else if ((this.statusReg0 & 0xC0) != 0) {
                            this.stopExecution();
                        } else {
                            this.curSector = null;
                            this.curSectorReader = null;
                            this.addSectorNum(this.args[8]);
                            this.startIOTask(IOTaskCmd.READ_SECTOR_BY_ID, this.tStatesPerRotation / 5);
                        }
                    }
                }
            } else if (this.dataBuf != null && this.dataPos >= 0 && this.dataPos < this.dataBuf.length && this.dataPos < this.dataLen) {
                if (this.curCmd == Command.FORMAT_TRACK) {
                    this.dataBuf[this.dataPos++] = (byte)n;
                    this.startIOReqTimer();
                } else if (this.curCmd == Command.WRITE_DATA || this.curCmd == Command.WRITE_DELETED_DATA) {
                    this.tStatesTillOverrun = 0;
                    this.dataBuf[this.dataPos++] = (byte)n;
                    if (this.dataPos < this.dataBuf.length && this.dataPos < this.dataLen) {
                        this.startIOReqTimer();
                    } else {
                        this.startIOTask(IOTaskCmd.WRITE_SECTOR, 0);
                    }
                }
            }
        }
    }

    private static enum IOTaskCmd {
        IDLE,
        FORMAT_TRACK,
        READ_SECTOR_BY_ID,
        READ_SECTOR_BY_INDEX,
        READ_SECTOR_FOR_WRITE,
        WRITE_SECTOR;

    }

    private static enum FormatStatus {
        IDLE,
        WAIT_FOR_HOLE,
        RECEIVE_DATA,
        BUSY;

    }

    private static enum Command {
        FORMAT_TRACK,
        READ_DATA,
        READ_DELETED_DATA,
        READ_ID,
        READ_TRACK,
        RECALIBRATE,
        SCAN_EQUAL,
        SCAN_LOW_OR_EQUAL,
        SCAN_HIGH_OR_EQUAL,
        SEEK,
        SENSE_DRIVE_STATUS,
        SENSE_INTERRUPT_STATUS,
        SPECIFY,
        WRITE_DATA,
        WRITE_DELETED_DATA,
        INVALID;

    }

    public static interface DriveSelector {
        public FloppyDiskDrive getFloppyDiskDrive(int var1);
    }
}

