/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.util.Properties;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.FloppyDiskStationFrm;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;

public class FloppyDiskDrive {
    public static final String PROP_SKIP_ODD_CYLS = "skip_odd_cylinders";
    private FloppyDiskStationFrm owner;
    private volatile AbstractFloppyDisk disk;
    private boolean skipOddCyls;
    private int lastFormattedCyl;
    private int head;
    private int pcn;
    private int ncn;

    public FloppyDiskDrive(FloppyDiskStationFrm floppyDiskStationFrm) {
        this.owner = floppyDiskStationFrm;
        this.disk = null;
        this.reset();
    }

    public boolean formatTrack(int n, SectorID[] sectorIDArray, byte[] byArray) {
        boolean bl = false;
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        this.fireDriveAccess();
        if (abstractFloppyDisk != null && sectorIDArray != null && sectorIDArray.length > 0) {
            if (this.pcn == 0) {
                this.skipOddCyls = false;
            } else if (this.pcn == 2 && this.lastFormattedCyl == 0 && abstractFloppyDisk.getCylinders() < 2) {
                this.skipOddCyls = true;
            } else if (this.pcn % 2 != 0) {
                this.skipOddCyls = false;
            }
            if (abstractFloppyDisk.formatTrack(this.getDiskCyl(), n, sectorIDArray, byArray)) {
                this.lastFormattedCyl = this.pcn;
                bl = true;
            }
        }
        this.head = n;
        return bl;
    }

    public synchronized int getCylinder() {
        return this.pcn;
    }

    public synchronized int getHead() {
        return this.head;
    }

    public synchronized AbstractFloppyDisk getDisk() {
        return this.disk;
    }

    public boolean getSkipOddCylinders() {
        return this.skipOddCyls;
    }

    public synchronized boolean isReadOnly() {
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        return abstractFloppyDisk != null ? abstractFloppyDisk.isReadOnly() : true;
    }

    public synchronized boolean isReady() {
        return this.disk != null;
    }

    public synchronized boolean isSeekMode() {
        return this.isReady() && this.pcn != this.ncn;
    }

    public synchronized void putSettingsTo(Properties properties, String string) {
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        if (properties != null && abstractFloppyDisk != null) {
            abstractFloppyDisk.putSettingsTo(properties, string);
            properties.setProperty(string + PROP_SKIP_ODD_CYLS, Boolean.toString(this.skipOddCyls));
        }
    }

    public synchronized SectorData readSectorByID(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        SectorData sectorData = null;
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        this.fireDriveAccess();
        if (abstractFloppyDisk != null && (sectorData = abstractFloppyDisk.getSectorByID(n7 = this.getDiskCyl(), n, n3, n4, n5, n6)) != null && sectorData.getIndexOnCylinder() < n2) {
            while ((sectorData = abstractFloppyDisk.getSectorByIndex(n7, n, n2)) != null && (sectorData.getCylinder() != n3 || sectorData.getHead() != n4 || sectorData.getSectorNum() != n5 || sectorData.getSizeCode() != n6)) {
                ++n2;
                sectorData = null;
                if (sectorData == null) continue;
            }
        }
        this.head = n4;
        return sectorData;
    }

    public synchronized SectorData readSectorByIndex(int n, int n2) {
        this.fireDriveAccess();
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        return abstractFloppyDisk != null ? abstractFloppyDisk.getSectorByIndex(this.getDiskCyl(), n, n2) : null;
    }

    public synchronized void removeDisk() {
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        if (abstractFloppyDisk != null) {
            abstractFloppyDisk.closeSilent();
            this.disk = null;
        }
    }

    public synchronized void reset() {
        this.skipOddCyls = false;
        this.lastFormattedCyl = 0;
        this.head = 0;
        this.pcn = 0;
        this.ncn = 0;
    }

    public synchronized boolean seekStep() {
        this.fireDriveAccess();
        if (this.pcn < this.ncn) {
            ++this.pcn;
        } else if (this.pcn > this.ncn) {
            --this.pcn;
        }
        return this.pcn == this.ncn;
    }

    public synchronized void setDisk(AbstractFloppyDisk abstractFloppyDisk, boolean bl) {
        this.disk = abstractFloppyDisk;
        this.skipOddCyls = bl;
    }

    public synchronized void setSeekMode(int n, int n2) {
        this.fireDriveAccess();
        this.head = n;
        this.ncn = n2;
    }

    public synchronized boolean writeSector(int n, SectorData sectorData, byte[] byArray, int n2, boolean bl) {
        boolean bl2 = false;
        AbstractFloppyDisk abstractFloppyDisk = this.disk;
        this.fireDriveAccess();
        if (abstractFloppyDisk != null) {
            bl2 = abstractFloppyDisk.writeSector(this.getDiskCyl(), n, sectorData, byArray, n2, bl);
        }
        return bl2;
    }

    private void fireDriveAccess() {
        this.owner.fireDriveAccess(this);
    }

    private int getDiskCyl() {
        int n = this.pcn;
        if (this.disk != null && this.skipOddCyls) {
            n /= 2;
        }
        return n;
    }
}

