/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.disk.FloppyDiskFormat;

public class FloppyDiskFormatSelectFld
extends JPanel {
    private List<ChangeListener> changeListeners = null;
    private JRadioButton btnFmt800Ki4;
    private JRadioButton btnFmt780K;
    private JRadioButton btnFmt780Ki2;
    private JRadioButton btnFmt780Ki3;
    private JRadioButton btnFmt780Ki3ds;
    private JRadioButton btnFmt780Ki4;
    private JRadioButton btnFmt720K;
    private JRadioButton btnFmt711Ki5;
    private JRadioButton btnFmt624K;
    private JRadioButton btnFmt400K;
    private JRadioButton btnFmtEtc;
    private JLabel labelSides;
    private JLabel labelCyls;
    private JLabel labelSysTracks;
    private JLabel labelSectPerCyl;
    private JLabel labelInterleave;
    private JLabel labelSectorSize;
    private JLabel labelSectorSizeUnit;
    private JLabel labelBlockSize;
    private JLabel labelBlockSizeUnit;
    private JLabel labelBlockNumSize;
    private JLabel labelBlockNumSizeUnit;
    private JLabel labelDirBlocks;
    private JLabel labelDirEntriesInfo;
    private JComboBox<Integer> comboSides;
    private JComboBox<Integer> comboCyls;
    private JSpinner spinnerSysTracks;
    private JSpinner spinnerInterleave;
    private SpinnerNumberModel modelInterleave;
    private JComboBox<Integer> comboSectPerCyl;
    private JComboBox<Integer> comboSectorSize;
    private JComboBox<Integer> comboBlockSizeKB;
    private JComboBox<Integer> comboBlockNumSize;
    private JSpinner spinnerDirBlocks;
    private JCheckBox btnDateStamper;

    public FloppyDiskFormatSelectFld(boolean bl) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnFmt800Ki4 = new JRadioButton(FloppyDiskFormat.FMT_800K_I4.toString(), false);
        buttonGroup.add(this.btnFmt800Ki4);
        this.add((Component)this.btnFmt800Ki4, gridBagConstraints);
        this.btnFmt780K = new JRadioButton(FloppyDiskFormat.FMT_780K.toString(), false);
        buttonGroup.add(this.btnFmt780K);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt780K, gridBagConstraints);
        this.btnFmt780Ki2 = new JRadioButton(FloppyDiskFormat.FMT_780K_I2.toString(), false);
        buttonGroup.add(this.btnFmt780Ki2);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt780Ki2, gridBagConstraints);
        this.btnFmt780Ki3 = new JRadioButton(FloppyDiskFormat.FMT_780K_I3.toString(), false);
        buttonGroup.add(this.btnFmt780Ki3);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt780Ki3, gridBagConstraints);
        this.btnFmt780Ki3ds = new JRadioButton(FloppyDiskFormat.FMT_780K_I3_DATESTAMPER.toString(), false);
        buttonGroup.add(this.btnFmt780Ki3ds);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt780Ki3ds, gridBagConstraints);
        this.btnFmt720K = new JRadioButton(FloppyDiskFormat.FMT_720K.toString(), false);
        buttonGroup.add(this.btnFmt720K);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt720K, gridBagConstraints);
        this.btnFmt711Ki5 = new JRadioButton(FloppyDiskFormat.FMT_711K_I5_BASDOS.toString(), false);
        buttonGroup.add(this.btnFmt711Ki5);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt711Ki5, gridBagConstraints);
        this.btnFmt624K = new JRadioButton(FloppyDiskFormat.FMT_624K.toString(), false);
        buttonGroup.add(this.btnFmt624K);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt624K, gridBagConstraints);
        this.btnFmt400K = new JRadioButton(FloppyDiskFormat.FMT_400K.toString(), false);
        buttonGroup.add(this.btnFmt400K);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmt400K, gridBagConstraints);
        this.btnFmtEtc = new JRadioButton("Sonstiges Format:", true);
        buttonGroup.add(this.btnFmtEtc);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnFmtEtc, gridBagConstraints);
        this.labelSides = new JLabel("Seiten:");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelSides, gridBagConstraints);
        this.comboSides = FloppyDiskFormatSelectFld.createJComboBox(1, 2);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboSides, gridBagConstraints);
        this.labelCyls = new JLabel("Spuren:");
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelCyls, gridBagConstraints);
        this.comboCyls = FloppyDiskFormatSelectFld.createJComboBox(40, 80);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboCyls, gridBagConstraints);
        this.labelSysTracks = new JLabel("davon Systemspuren:");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx += 2;
        this.add((Component)this.labelSysTracks, gridBagConstraints);
        this.spinnerSysTracks = new JSpinner(new SpinnerNumberModel(0, 0, 9, 1));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerSysTracks, gridBagConstraints);
        this.labelSectPerCyl = new JLabel("Sektoren pro Spur:");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelSectPerCyl, gridBagConstraints);
        this.comboSectPerCyl = FloppyDiskFormatSelectFld.createJComboBox(5, 8, 9, 15, 16, 18, 36);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboSectPerCyl, gridBagConstraints);
        this.labelInterleave = null;
        this.modelInterleave = null;
        this.spinnerInterleave = null;
        if (bl) {
            this.labelInterleave = new JLabel("Interleave (1 = kein Interleave):");
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx += 2;
            this.add((Component)this.labelInterleave, gridBagConstraints);
            this.modelInterleave = new SpinnerNumberModel(1, 1, 1, 1);
            this.spinnerInterleave = new JSpinner(this.modelInterleave);
            gridBagConstraints.anchor = 17;
            ++gridBagConstraints.gridx;
            this.add((Component)this.spinnerInterleave, gridBagConstraints);
        }
        this.labelSectorSize = new JLabel("Sektorgr\u00f6\u00dfe:");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelSectorSize, gridBagConstraints);
        this.comboSectorSize = FloppyDiskFormatSelectFld.createJComboBox(256, 512, 1024);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboSectorSize, gridBagConstraints);
        this.labelSectorSizeUnit = new JLabel("Byte");
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelSectorSizeUnit, gridBagConstraints);
        this.labelBlockSize = new JLabel("Blockgr\u00f6\u00dfe:");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelBlockSize, gridBagConstraints);
        this.comboBlockSizeKB = FloppyDiskFormatSelectFld.createJComboBox(1, 2, 4, 8, 16);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboBlockSizeKB, gridBagConstraints);
        this.labelBlockSizeUnit = new JLabel("KByte");
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelBlockSizeUnit, gridBagConstraints);
        this.labelBlockNumSize = new JLabel("Blocknummern:");
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelBlockNumSize, gridBagConstraints);
        this.comboBlockNumSize = FloppyDiskFormatSelectFld.createJComboBox(8, 16);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboBlockNumSize, gridBagConstraints);
        this.labelBlockNumSizeUnit = new JLabel("Bit");
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelBlockNumSizeUnit, gridBagConstraints);
        this.labelDirBlocks = new JLabel("Directory:");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelDirBlocks, gridBagConstraints);
        this.spinnerDirBlocks = new JSpinner(new SpinnerNumberModel(2, 1, 9, 1));
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerDirBlocks, gridBagConstraints);
        this.labelDirEntriesInfo = new JLabel("Bl\u00f6cke");
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelDirEntriesInfo, gridBagConstraints);
        this.btnDateStamper = new JCheckBox("Dateien mit Zeitstempel versehen (DateStamper)");
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnDateStamper, gridBagConstraints);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloppyDiskFormatSelectFld.this.updFmtDetailsFields();
                FloppyDiskFormatSelectFld.this.fireFormatChanged();
            }
        };
        this.btnFmt800Ki4.addActionListener(actionListener);
        this.btnFmt780K.addActionListener(actionListener);
        this.btnFmt780Ki2.addActionListener(actionListener);
        this.btnFmt780Ki3.addActionListener(actionListener);
        this.btnFmt780Ki3ds.addActionListener(actionListener);
        this.btnFmt720K.addActionListener(actionListener);
        this.btnFmt711Ki5.addActionListener(actionListener);
        this.btnFmt624K.addActionListener(actionListener);
        this.btnFmt400K.addActionListener(actionListener);
        this.btnFmtEtc.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloppyDiskFormatSelectFld.this.fireFormatChanged();
            }
        };
        this.comboSides.addActionListener(actionListener2);
        this.comboCyls.addActionListener(actionListener2);
        this.comboSectorSize.addActionListener(actionListener2);
        this.comboBlockSizeKB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloppyDiskFormatSelectFld.this.updDirEntriesInfo();
                FloppyDiskFormatSelectFld.this.fireFormatChanged();
            }
        });
        this.comboSectPerCyl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloppyDiskFormatSelectFld.this.updDirEntriesInfo();
                FloppyDiskFormatSelectFld.this.updMaxInterleave();
                FloppyDiskFormatSelectFld.this.fireFormatChanged();
            }
        });
        this.spinnerDirBlocks.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FloppyDiskFormatSelectFld.this.updDirEntriesInfo();
                FloppyDiskFormatSelectFld.this.fireFormatChanged();
            }
        });
        this.spinnerSysTracks.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FloppyDiskFormatSelectFld.this.fireFormatChanged();
            }
        });
        this.setFmtDetailsFields(FloppyDiskFormat.FMT_780K);
        this.updFmtDetailsFields();
        this.updDirEntriesInfo();
        this.updMaxInterleave();
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    public int getBlockSize() {
        return this.getIntValue(this.comboBlockSizeKB) * 1024;
    }

    public int getCylinders() {
        return this.getIntValue(this.comboCyls);
    }

    public int getDirBlocks() {
        return this.getIntValue(this.spinnerDirBlocks);
    }

    public FloppyDiskFormat getFormat() {
        FloppyDiskFormat floppyDiskFormat = null;
        floppyDiskFormat = this.btnFmt800Ki4.isSelected() ? FloppyDiskFormat.FMT_800K_I4 : (this.btnFmt780K.isSelected() ? FloppyDiskFormat.FMT_780K : (this.btnFmt780Ki2.isSelected() ? FloppyDiskFormat.FMT_780K_I2 : (this.btnFmt780Ki3.isSelected() ? FloppyDiskFormat.FMT_780K_I3 : (this.btnFmt780Ki3ds.isSelected() ? FloppyDiskFormat.FMT_780K_I3_DATESTAMPER : (this.btnFmt720K.isSelected() ? FloppyDiskFormat.FMT_720K : (this.btnFmt711Ki5.isSelected() ? FloppyDiskFormat.FMT_711K_I5_BASDOS : (this.btnFmt624K.isSelected() ? FloppyDiskFormat.FMT_624K : (this.btnFmt400K.isSelected() ? FloppyDiskFormat.FMT_400K : new FloppyDiskFormat(this.getSides(), this.getCylinders(), this.getSectorsPerCylinder(), this.getSectorSize(), this.getInterleave(), this.getSysTracks(), this.getDirBlocks(), this.getBlockSize(), this.isBlockNum16Bit(), this.isDateStamperEnabled(), null)))))))));
        return floppyDiskFormat;
    }

    public int getInterleave() {
        return this.getIntValue(this.spinnerInterleave);
    }

    public int getSectorsPerCylinder() {
        return this.getIntValue(this.comboSectPerCyl);
    }

    public int getSectorSize() {
        return this.getIntValue(this.comboSectorSize);
    }

    public int getSides() {
        return this.getIntValue(this.comboSides);
    }

    public int getSysTracks() {
        return this.getIntValue(this.spinnerSysTracks);
    }

    public boolean isBlockNum16Bit() {
        return this.getIntValue(this.comboBlockNumSize) == 16;
    }

    public boolean isDateStamperEnabled() {
        return this.btnDateStamper.isSelected();
    }

    public void setBlockSize(int n) {
        if (this.getBlockSize() != n) {
            this.btnFmtEtc.setSelected(true);
            this.updFmtDetailsFieldsEnabled();
            FloppyDiskFormatSelectFld.setValue(this.comboBlockSizeKB, n / 1024);
        }
    }

    public void setBlockNum16Bit(boolean bl) {
        if (this.isBlockNum16Bit() != bl) {
            this.btnFmtEtc.setSelected(true);
            this.updFmtDetailsFieldsEnabled();
            FloppyDiskFormatSelectFld.setValue(this.comboBlockNumSize, bl ? 16 : 8);
        }
    }

    public void setDateStamperEnabled(boolean bl) {
        this.btnDateStamper.setSelected(bl);
    }

    public void setDirBlocks(int n) {
        if (this.getDirBlocks() != n) {
            this.btnFmtEtc.setSelected(true);
            this.updFmtDetailsFieldsEnabled();
            FloppyDiskFormatSelectFld.setValue(this.spinnerDirBlocks, n);
        }
    }

    public void setFormat(FloppyDiskFormat floppyDiskFormat) {
        if (floppyDiskFormat != null) {
            if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_800K_I4)) {
                this.btnFmt800Ki4.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_780K)) {
                this.btnFmt780K.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_780K_I2)) {
                this.btnFmt780Ki2.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_780K_I3)) {
                this.btnFmt780Ki3.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_780K_I3_DATESTAMPER)) {
                this.btnFmt780Ki3ds.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_720K)) {
                this.btnFmt720K.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_711K_I5_BASDOS)) {
                this.btnFmt711Ki5.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_624K)) {
                this.btnFmt624K.setSelected(true);
            } else if (floppyDiskFormat.equals(FloppyDiskFormat.FMT_400K)) {
                this.btnFmt400K.setSelected(true);
            } else {
                this.btnFmtEtc.setSelected(true);
                this.setFmtDetailsFields(floppyDiskFormat);
            }
            this.updFmtDetailsFieldsEnabled();
        }
    }

    public void setSysTracks(int n) {
        if (this.getSysTracks() != n) {
            this.btnFmtEtc.setSelected(true);
            this.updFmtDetailsFieldsEnabled();
            FloppyDiskFormatSelectFld.setValue(this.spinnerSysTracks, n);
        }
    }

    private static JComboBox<Integer> createJComboBox(int ... nArray) {
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        jComboBox.setEditable(false);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                jComboBox.addItem(nArray[i]);
            }
        }
        return jComboBox;
    }

    private synchronized void fireFormatChanged() {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    private int getIntValue(JComboBox jComboBox) {
        Object object;
        int n = 0;
        if (jComboBox != null && (object = jComboBox.getSelectedItem()) != null && object instanceof Number) {
            n = ((Number)object).intValue();
        }
        return n;
    }

    private int getIntValue(JSpinner jSpinner) {
        Object object;
        int n = 0;
        if (jSpinner != null && (object = jSpinner.getValue()) != null && object instanceof Number) {
            n = ((Number)object).intValue();
        }
        return n;
    }

    private void setFmtDetailsFields(FloppyDiskFormat floppyDiskFormat) {
        FloppyDiskFormatSelectFld.setValue(this.comboSides, floppyDiskFormat.getSides());
        FloppyDiskFormatSelectFld.setValue(this.comboCyls, floppyDiskFormat.getCylinders());
        FloppyDiskFormatSelectFld.setValue(this.comboSectPerCyl, floppyDiskFormat.getSectorsPerCylinder());
        FloppyDiskFormatSelectFld.setValue(this.comboSectorSize, floppyDiskFormat.getSectorSize());
        FloppyDiskFormatSelectFld.setValue(this.spinnerInterleave, floppyDiskFormat.getInterleave());
        int n = floppyDiskFormat.getSysTracks();
        int n2 = floppyDiskFormat.getDirBlocks();
        int n3 = floppyDiskFormat.getBlockSize();
        if (n >= 0 && n3 > 0 && n2 > 0) {
            FloppyDiskFormatSelectFld.setValue(this.spinnerSysTracks, n);
            FloppyDiskFormatSelectFld.setValue(this.spinnerDirBlocks, n2);
            FloppyDiskFormatSelectFld.setValue(this.comboBlockSizeKB, n3 / 1024);
            FloppyDiskFormatSelectFld.setValue(this.comboBlockNumSize, floppyDiskFormat.isBlockNum16Bit() ? 16 : 8);
        }
        this.setDateStamperEnabled(floppyDiskFormat.isDateStamperEnabled());
        this.updMaxInterleave();
    }

    private static void setValue(JComboBox jComboBox, int n) {
        if (jComboBox != null) {
            jComboBox.setSelectedItem(n);
        }
    }

    private static void setValue(JSpinner jSpinner, int n) {
        if (jSpinner != null) {
            try {
                jSpinner.setValue(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void updDirEntriesInfo() {
        if (this.labelDirEntriesInfo != null) {
            this.labelDirEntriesInfo.setText(String.format("Bl\u00f6cke (%d Eintr\u00e4ge)", this.getIntValue(this.comboBlockSizeKB) * 1024 * this.getIntValue(this.spinnerDirBlocks) / 32));
        }
    }

    private void updFmtDetailsFields() {
        FloppyDiskFormat floppyDiskFormat = null;
        if (this.btnFmt800Ki4.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_800K_I4;
        } else if (this.btnFmt780K.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_780K;
        } else if (this.btnFmt780Ki2.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_780K_I2;
        } else if (this.btnFmt780Ki3.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_780K_I3;
        } else if (this.btnFmt780Ki3ds.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_780K_I3_DATESTAMPER;
        } else if (this.btnFmt720K.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_720K;
        } else if (this.btnFmt711Ki5.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_711K_I5_BASDOS;
        } else if (this.btnFmt624K.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_624K;
        } else if (this.btnFmt400K.isSelected()) {
            floppyDiskFormat = FloppyDiskFormat.FMT_400K;
        }
        if (floppyDiskFormat != null) {
            this.setFmtDetailsFields(floppyDiskFormat);
        }
        this.updFmtDetailsFieldsEnabled();
    }

    private void updFmtDetailsFieldsEnabled() {
        boolean bl = this.btnFmtEtc.isSelected();
        this.labelSides.setEnabled(bl);
        this.comboSides.setEnabled(bl);
        this.labelCyls.setEnabled(bl);
        this.comboCyls.setEnabled(bl);
        this.labelSysTracks.setEnabled(bl);
        this.spinnerSysTracks.setEnabled(bl);
        this.labelSectPerCyl.setEnabled(bl);
        this.comboSectPerCyl.setEnabled(bl);
        if (this.labelInterleave != null) {
            this.labelInterleave.setEnabled(bl);
        }
        if (this.spinnerInterleave != null) {
            this.spinnerInterleave.setEnabled(bl);
        }
        this.labelSectorSize.setEnabled(bl);
        this.comboSectorSize.setEnabled(bl);
        this.labelSectorSizeUnit.setEnabled(bl);
        this.labelBlockSize.setEnabled(bl);
        this.comboBlockSizeKB.setEnabled(bl);
        this.labelBlockSizeUnit.setEnabled(bl);
        this.labelBlockNumSize.setEnabled(bl);
        this.comboBlockNumSize.setEnabled(bl);
        this.labelBlockNumSize.setEnabled(bl);
        this.labelBlockNumSizeUnit.setEnabled(bl);
        this.labelDirBlocks.setEnabled(bl);
        this.labelDirEntriesInfo.setEnabled(bl);
        this.spinnerDirBlocks.setEnabled(bl);
        this.labelDirEntriesInfo.setEnabled(bl);
        this.btnDateStamper.setEnabled(bl);
    }

    private void updMaxInterleave() {
        if (this.modelInterleave != null) {
            int n;
            int n2 = this.getIntValue(this.comboSectPerCyl) - 1;
            if (n2 < 1) {
                n2 = 1;
            }
            if ((n = this.getIntValue(this.spinnerInterleave)) > n2) {
                this.modelInterleave.setValue(1);
            }
            this.modelInterleave.setMaximum(Integer.valueOf(n2));
        }
    }
}

