/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.EventObject;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.disk.HardDiskDetailsDlg;
import jkcemu.disk.HardDiskInfo;
import jkcemu.disk.HardDiskTableModel;
import jkcemu.text.TextUtil;

public class HardDiskListDlg
extends BaseDlg
implements ListSelectionListener {
    public static final String HARDDISKS_FILE = "harddisks.csv";
    private boolean dataChangedInfoShown = false;
    private HardDiskInfo selectedRow = null;
    private HardDiskTableModel tableModel;
    private JTable table;
    private JScrollPane scrollPane;
    private JButton btnSelect;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnSave;
    private JButton btnCancel;

    public static HardDiskInfo showHardDiskListDlg(Window window) {
        HardDiskListDlg hardDiskListDlg = new HardDiskListDlg(window);
        hardDiskListDlg.setVisible(true);
        return hardDiskListDlg.selectedRow;
    }

    public void setDataChanged() {
        this.btnSelect.setEnabled(false);
        this.btnSave.setEnabled(true);
        if (!this.dataChangedInfoShown) {
            this.dataChangedInfoShown = true;
            BaseDlg.showInfoDlg(this, "Sie m\u00fcssen das Festplattenverzeichnis erst speichern,\nbevor Sie wieder eine Festplatte ausw\u00e4hlen k\u00f6nnen.");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updActionButtons();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnSelect) {
                bl = true;
                this.doSelect();
            } else if (object == this.btnAdd) {
                bl = true;
                this.doAdd();
            } else if (object == this.btnRemove) {
                bl = true;
                this.doRemove();
            } else if (object == this.btnSave) {
                bl = true;
                this.doSave();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = false;
        if (this.btnSave.isEnabled()) {
            switch (JOptionPane.showConfirmDialog(this, "Das Festplattenverzeichnis wurde ge\u00e4ndert, aber nicht gespeichert.\nM\u00f6chten Sie es speichern, bevor das Fenster geschlossen wird?", "Daten ge\u00e4ndert", 1, 2)) {
                case 0: {
                    bl = this.doSave();
                    break;
                }
                case 1: {
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            bl = super.doClose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowOpened(WindowEvent windowEvent) {
        BufferedReader bufferedReader = null;
        try {
            block13: {
                try {
                    Object object;
                    File file = Main.getConfigDir();
                    if (file != null && ((File)(object = new File(file, HARDDISKS_FILE))).exists()) {
                        bufferedReader = new BufferedReader(new FileReader((File)object));
                    }
                    if (bufferedReader == null && (object = this.getClass().getResourceAsStream("/disks/harddisks.csv")) != null) {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                    }
                    if (bufferedReader == null) break block13;
                    object = bufferedReader.readLine();
                    while (object != null) {
                        try {
                            String[] stringArray = ((String)object).split("\t", 6);
                            if (stringArray != null && stringArray.length >= 5) {
                                int n = Integer.parseInt(stringArray[2]);
                                int n2 = Integer.parseInt(stringArray[3]);
                                int n3 = Integer.parseInt(stringArray[4]);
                                if (!stringArray[1].isEmpty() && n > 0 && n2 > 0 && n3 > 0) {
                                    this.tableModel.addRow(new HardDiskInfo(stringArray[0], stringArray[1], n, n2, n3));
                                }
                            }
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        object = bufferedReader.readLine();
                    }
                    this.tableModel.sort();
                    this.tableModel.fireTableDataChanged();
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(bufferedReader);
                    throw throwable;
                }
            }
            EmuUtil.closeSilent(bufferedReader);
        }
        catch (IOException iOException) {
            String string = "Lesen der Festplattenstammdaten fehlgeschlagen";
            String string2 = iOException.getMessage();
            if (string2 != null && !string2.isEmpty()) {
                string = string + ":\n" + string2;
            }
            HardDiskListDlg.showErrorDlg((Component)this, string);
        }
    }

    private HardDiskListDlg(Window window) {
        super(window, "JKCEMU Festplattenverzeichnis");
        JComponent jComponent;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tableModel = new HardDiskTableModel(this);
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(560, 300));
        this.table.setRowSelectionAllowed(true);
        this.table.setRowSorter(null);
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setSelectionMode(2);
        this.table.addMouseListener(this);
        EmuUtil.setTableColWidths(this.table, 120, 120, 70, 70, 70, 100);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (tableColumnModel != null) {
            jComponent = new DefaultTableCellRenderer();
            ((JLabel)jComponent).setHorizontalAlignment(4);
            int n = tableColumnModel.getColumnCount();
            for (int i = 2; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn == null) continue;
                tableColumn.setCellRenderer((TableCellRenderer)((Object)jComponent));
            }
        }
        this.scrollPane = new JScrollPane(this.table, 20, 30);
        this.add((Component)this.scrollPane, gridBagConstraints);
        jComponent = new JPanel(new GridLayout(1, 5, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)jComponent, gridBagConstraints);
        this.btnSelect = new JButton("Ausw\u00e4hlen");
        this.btnSelect.addActionListener(this);
        jComponent.add(this.btnSelect);
        this.btnAdd = new JButton("Hinzuf\u00fcgen...");
        this.btnAdd.addActionListener(this);
        jComponent.add(this.btnAdd);
        this.btnRemove = new JButton("Entfernen");
        this.btnRemove.addActionListener(this);
        jComponent.add(this.btnRemove);
        this.btnSave = new JButton("Speichern");
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(this);
        jComponent.add(this.btnSave);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jComponent.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
            this.updActionButtons();
        }
        this.updBgColor();
    }

    private void doAdd() {
        String string;
        EmuUtil.stopCellEditing(this.table);
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            HardDiskInfo hardDiskInfo = this.tableModel.getRow(i);
            if (hardDiskInfo == null || (string = TextUtil.emptyToNull(hardDiskInfo.getProducer())) == null) continue;
            treeSet.add(string);
        }
        HardDiskInfo hardDiskInfo = HardDiskDetailsDlg.showHardDiskDetailsDlg(this, "Neue Festplatte", treeSet);
        if (hardDiskInfo != null) {
            int n2 = -1;
            string = null;
            for (int i = 0; i < n; ++i) {
                HardDiskInfo hardDiskInfo2 = this.tableModel.getRow(i);
                if (hardDiskInfo2 == null || !TextUtil.equals(hardDiskInfo.getProducer(), hardDiskInfo2.getProducer()) || !TextUtil.equals(hardDiskInfo.getDiskModel(), hardDiskInfo2.getDiskModel())) continue;
                if (hardDiskInfo.getCylinders() != hardDiskInfo2.getCylinders() || hardDiskInfo.getHeads() != hardDiskInfo2.getHeads() || hardDiskInfo.getSectorsPerTrack() != hardDiskInfo2.getSectorsPerTrack()) {
                    string = "Die Festplatte wurde bereits erfasst,\nallerdings mit anderen Geometriedaten.\nBei Bedarf k\u00f6nnen Sie die Geometriedaten\ndirekt in der Tabelle \u00e4ndern.";
                }
                n2 = i;
            }
            if (n2 < 0) {
                this.tableModel.addRow(hardDiskInfo);
                this.tableModel.sort();
                n2 = this.tableModel.indexOf(hardDiskInfo);
                if (n2 >= 0) {
                    this.tableModel.fireTableRowsInserted(n2, n2);
                } else {
                    this.tableModel.fireTableDataChanged();
                }
                this.setDataChanged();
            }
            if (n2 >= 0) {
                EmuUtil.fireSelectRow(this.table, this.table.convertRowIndexToView(n2));
            }
            if (string != null) {
                BaseDlg.showErrorDlg((Component)this, string);
            }
        }
    }

    private void doRemove() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null) {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.table.convertRowIndexToModel(nArray[n]);
            }
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                int n2 = nArray[n];
                this.tableModel.removeRow(n2);
                this.tableModel.fireTableRowsDeleted(n2, n2);
                this.setDataChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSave() {
        EmuUtil.stopCellEditing(this.table);
        boolean bl = false;
        File file = Main.getConfigDir();
        if (file != null) {
            try {
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(new File(file, HARDDISKS_FILE));
                    int n = this.tableModel.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        HardDiskInfo hardDiskInfo = this.tableModel.getRow(i);
                        if (hardDiskInfo == null) continue;
                        String string = hardDiskInfo.getProducer();
                        String string2 = hardDiskInfo.getDiskModel();
                        fileWriter.write(String.format("%s\t%s\t%d\t%d\t%d\n", string != null ? string : "", string2 != null ? string2 : "", hardDiskInfo.getCylinders(), hardDiskInfo.getHeads(), hardDiskInfo.getSectorsPerTrack()));
                    }
                    ((Writer)fileWriter).close();
                    fileWriter = null;
                    bl = true;
                    this.btnSave.setEnabled(false);
                    this.updActionButtons();
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileWriter);
                    throw throwable;
                }
                EmuUtil.closeSilent(fileWriter);
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        } else {
            BaseDlg.showErrorDlg((Component)this, "Speichern nicht m\u00f6glich, da das\nJKCEMU-Konfigurationsverzeichnis nicht bekannt ist.");
        }
        return bl;
    }

    private void doSelect() {
        HardDiskInfo hardDiskInfo;
        int n;
        EmuUtil.stopCellEditing(this.table);
        if (this.table.getSelectedRowCount() == 1 && (n = this.table.getSelectedRow()) >= 0 && (n = this.table.convertRowIndexToModel(n)) >= 0 && (hardDiskInfo = this.tableModel.getRow(n)) != null) {
            this.selectedRow = hardDiskInfo;
            if (!this.doClose()) {
                this.selectedRow = null;
            }
        }
    }

    private void updActionButtons() {
        int n = this.table.getSelectedRowCount();
        this.btnSelect.setEnabled(n == 1 && !this.btnSave.isEnabled());
        this.btnRemove.setEnabled(n > 0);
    }

    private void updBgColor() {
        Color color = this.table.getBackground();
        JViewport jViewport = this.scrollPane.getViewport();
        if (color != null && jViewport != null) {
            jViewport.setBackground(color);
        }
    }
}

