/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.SectorData;
import jkcemu.text.CharConverter;

public class ImageDisk
extends AbstractFloppyDisk {
    private String fileName;
    private String remark;
    private Date diskDate;
    private Map<Integer, List<SectorData>> side0;
    private Map<Integer, List<SectorData>> side1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(AbstractFloppyDisk abstractFloppyDisk, File file, String string) throws IOException {
        Object object;
        int n;
        StringBuilder stringBuilder = null;
        boolean bl = false;
        int n2 = abstractFloppyDisk.getCylinders();
        int n3 = abstractFloppyDisk.getSides();
        int n4 = 1024;
        for (int i = 0; !bl && i < n2; ++i) {
            block4: for (int j = 0; !bl && j < n3; ++j) {
                n = abstractFloppyDisk.getSectorsOfCylinder(i, j);
                for (int k = 0; k < n; ++k) {
                    object = abstractFloppyDisk.getSectorByIndex(i, j, k);
                    if (object == null) continue;
                    if (((SectorData)object).getDataLength() > n4) {
                        n4 = ((SectorData)object).getDataLength();
                    }
                    if (!((SectorData)object).checkError() && !((SectorData)object).isDeleted()) continue;
                    bl = true;
                    continue block4;
                }
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = abstractFloppyDisk.getDiskDate();
        if (date != null) {
            gregorianCalendar.clear();
            gregorianCalendar.setTime(date);
        }
        n = 5;
        if (abstractFloppyDisk.getDiskSize() >= 0x100000) {
            n = 3;
        }
        OutputStream outputStream = null;
        try {
            int n5;
            int n6;
            outputStream = EmuUtil.createOptionalGZipOutputStream(file);
            EmuUtil.writeASCII(outputStream, String.format("IMD 1.1%c: %02d/%02d/%04d %02d:%02d:%02d", Character.valueOf(bl ? (char)'7' : '6'), gregorianCalendar.get(5), gregorianCalendar.get(2) + 1, gregorianCalendar.get(1), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13)));
            if (string == null) {
                string = abstractFloppyDisk.getRemark();
            }
            if (string != null) {
                char c;
                object = new CharConverter(CharConverter.Encoding.CP850);
                n6 = string.length();
                for (n5 = 0; n5 < n6 && (c = string.charAt(n5)) != '\u0000' && c != '\u001a'; ++n5) {
                    if ((c = (char)((CharConverter)object).toCharsetByte(c)) <= '\u0000') continue;
                    outputStream.write(c);
                }
            }
            outputStream.write(26);
            for (int i = 0; i < n2; ++i) {
                for (n6 = 0; n6 < n3; ++n6) {
                    int n7;
                    n5 = abstractFloppyDisk.getSectorsOfCylinder(i, n6);
                    if (n5 <= 0) continue;
                    SectorData[] sectorDataArray = new SectorData[n5];
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n8 = 0;
                    for (n7 = 0; n7 < n5; ++n7) {
                        SectorData[] sectorDataArray2 = abstractFloppyDisk.getSectorByIndex(i, n6, n7);
                        if (sectorDataArray2 == null) {
                            throw new IOException(String.format("Seite %d, Spur %d: Sektor %d nicht gefunden", n6 + 1, i, n7 + 1));
                        }
                        if (sectorDataArray2.getCylinder() != i) {
                            bl2 = true;
                        }
                        if (sectorDataArray2.getHead() != n6) {
                            bl3 = true;
                        }
                        if (sectorDataArray2.getSizeCode() > n8) {
                            n8 = sectorDataArray2.getSizeCode();
                        }
                        sectorDataArray[n7] = sectorDataArray2;
                    }
                    n7 = n6;
                    if (bl2) {
                        n7 |= 0x80;
                    }
                    if (bl3) {
                        n7 |= 0x40;
                    }
                    outputStream.write(n);
                    outputStream.write(i);
                    outputStream.write(n7);
                    outputStream.write(n5);
                    outputStream.write(n8);
                    for (SectorData sectorData : sectorDataArray) {
                        outputStream.write(sectorData.getSectorNum());
                    }
                    if (bl2) {
                        for (SectorData sectorData : sectorDataArray) {
                            outputStream.write(sectorData.getCylinder());
                        }
                    }
                    if (bl3) {
                        for (SectorData sectorData : sectorDataArray) {
                            outputStream.write(sectorData.getHead());
                        }
                    }
                    int n9 = 128;
                    if (n8 > 0) {
                        n9 <<= n8;
                    }
                    for (SectorData sectorData : sectorDataArray) {
                        if (sectorData.hasBogusID()) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(1024);
                            }
                            stringBuilder.append(String.format("Seite %d, Spur %d, Sektor %d: Sektor-ID generiert\n", n6 + 1, i, sectorData.getSectorNum()));
                        }
                        int n10 = -1;
                        boolean bl4 = sectorData.isDeleted();
                        boolean bl5 = sectorData.checkError();
                        int n11 = sectorData.getDataLength();
                        if (n11 > 0) {
                            int n12;
                            n10 = sectorData.getDataByte(0);
                            if (n10 >= 0) {
                                for (n12 = 1; n12 < n11; ++n12) {
                                    if (sectorData.getDataByte(n12) == n10) continue;
                                    n10 = -1;
                                    break;
                                }
                            }
                            n12 = 1;
                            if (bl5) {
                                n12 = bl4 ? 7 : 5;
                            } else if (bl4) {
                                n12 = 3;
                            }
                            if (n10 >= 0) {
                                outputStream.write(n12 + 1);
                                outputStream.write(n10);
                                continue;
                            }
                            outputStream.write(n12);
                            for (int j = sectorData.writeTo(outputStream, n9); j < n9; ++j) {
                                outputStream.write(0);
                            }
                            continue;
                        }
                        outputStream.write(0);
                    }
                }
            }
            outputStream.close();
            outputStream = null;
            if (stringBuilder != null) {
                stringBuilder.append("\nDie angezeigten Informationen k\u00f6nnen in einer ImageDisk-Datei nicht gespeichert werden\nund sind deshalb in der erzeugten Datei nicht mehr enthalten.\n");
            }
        }
        finally {
            EmuUtil.closeSilent(outputStream);
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static boolean isImageDiskFileHeader(byte[] byArray) {
        boolean bl = false;
        if (byArray != null && byArray.length >= 4 && byArray[0] == 73 && byArray[1] == 77 && byArray[2] == 68 && byArray[3] == 32) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageDisk readFile(Frame frame, File file) throws IOException {
        ImageDisk imageDisk = null;
        InputStream inputStream = null;
        Object var4_4 = null;
        try {
            Serializable serializable;
            Object object;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            inputStream = new FileInputStream(file);
            if (EmuUtil.isGZipFile(file)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            if (n5 != 73 || n6 != 77 || n7 != 68 || n8 != 32) {
                ImageDisk.throwNoImageDiskFile();
            }
            for (int i = 0; i < 6; ++i) {
                ImageDisk.readMandatoryByte(inputStream);
            }
            Date date = null;
            char[] cArray = new char[19];
            int n9 = 0;
            while (n9 < cArray.length) {
                cArray[n9++] = (char)ImageDisk.readMandatoryByte(inputStream);
            }
            try {
                date = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US).parse(new String(cArray));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            String string = null;
            int n10 = ImageDisk.readMandatoryByte(inputStream);
            if (n10 != 26) {
                object = new CharConverter(CharConverter.Encoding.CP850);
                serializable = new StringBuilder(1024);
                while (n10 != 26) {
                    if ((n10 = (int)((CharConverter)object).toUnicode((char)n10)) > 0) {
                        serializable.append((char)n10);
                    }
                    n10 = ImageDisk.readMandatoryByte(inputStream);
                }
                string = serializable.toString();
            }
            if (n10 != 26) {
                ImageDisk.throwNoImageDiskFile();
            }
            object = null;
            serializable = null;
            int n11 = inputStream.read();
            while (n11 >= 0) {
                int n12;
                int n13 = ImageDisk.readMandatoryByte(inputStream);
                int n14 = ImageDisk.readMandatoryByte(inputStream);
                int n15 = ImageDisk.readMandatoryByte(inputStream);
                int n16 = ImageDisk.readMandatoryByte(inputStream);
                if (n16 > 6) {
                    throw new IOException(String.format("Sektorgr\u00f6\u00dfe Nr. %d nicht unterst\u00fctzt", n16));
                }
                int n17 = 128;
                if (n16 > 0) {
                    n17 <<= n16;
                }
                int[] nArray = new int[n15];
                for (int i = 0; i < n15; ++i) {
                    nArray[i] = ImageDisk.readMandatoryByte(inputStream);
                }
                int[] nArray2 = null;
                if ((n14 & 0x80) != 0) {
                    nArray2 = new int[n15];
                    for (int i = 0; i < n15; ++i) {
                        nArray2[i] = ImageDisk.readMandatoryByte(inputStream);
                    }
                }
                int[] nArray3 = null;
                if ((n14 & 0x40) != 0) {
                    nArray3 = new int[n15];
                    for (n12 = 0; n12 < n15; ++n12) {
                        nArray3[n12] = ImageDisk.readMandatoryByte(inputStream);
                    }
                }
                n14 &= 1;
                for (n12 = 0; n12 < n15; ++n12) {
                    boolean bl = false;
                    boolean bl2 = false;
                    byte[] byArray = null;
                    int n18 = 0;
                    int n19 = nArray[n12];
                    int n20 = ImageDisk.readMandatoryByte(inputStream);
                    switch (n20) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 7: {
                            byArray = new byte[n17];
                            if (EmuUtil.read(inputStream, byArray) == byArray.length) break;
                            ImageDisk.throwUnexpectedEOF();
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 6: 
                        case 8: {
                            byArray = new byte[n17];
                            n18 = ImageDisk.readMandatoryByte(inputStream);
                            Arrays.fill(byArray, (byte)n18);
                            break;
                        }
                        default: {
                            throw new IOException(String.format("Sektor C=%d, H=%d R=%d: Typ %02h nicht unterst\u00fctzt", n13, n14, n19, n20));
                        }
                    }
                    if (byArray != null) {
                        if (n20 == 3 || n20 == 4 || n20 == 7 || n20 == 8) {
                            bl2 = true;
                        }
                        if (n20 >= 5 && n20 <= 8) {
                            bl = true;
                        }
                    }
                    Object object2 = null;
                    if (n14 == 0) {
                        if (object == null) {
                            object = new HashMap();
                        }
                        object2 = object;
                    } else if (n14 == 1) {
                        if (serializable == null) {
                            serializable = new HashMap();
                        }
                        object2 = serializable;
                    }
                    if (object2 == null) continue;
                    ArrayList<SectorData> arrayList = (ArrayList<SectorData>)object2.get(n13);
                    if (arrayList == null) {
                        arrayList = new ArrayList<SectorData>(n15 > 0 ? n15 : 1);
                        object2.put(n13, arrayList);
                    }
                    int n21 = n13;
                    if (nArray2 != null && n12 < nArray2.length) {
                        n21 = nArray2[n12];
                    }
                    int n22 = n14;
                    if (nArray3 != null && n12 < nArray3.length) {
                        n22 = nArray3[n12];
                    }
                    SectorData sectorData = new SectorData(n12, n21, n22, n19, n16, byArray, 0, byArray != null ? byArray.length : 0);
                    sectorData.setError(bl);
                    sectorData.setDeleted(bl2);
                    arrayList.add(sectorData);
                    if (n13 >= n2) {
                        n2 = n13 + 1;
                    }
                    if (n14 >= n) {
                        n = n14 + 1;
                    }
                    if (n12 >= n3) {
                        n3 = n12 + 1;
                    }
                    if (n17 <= n4) continue;
                    n4 = n17;
                }
                n11 = inputStream.read();
            }
            imageDisk = new ImageDisk(frame, n, n2, n3, n4, file.getPath(), string, date, (Map<Integer, List<SectorData>>)object, (Map<Integer, List<SectorData>>)((Object)serializable));
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(inputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(inputStream);
        return imageDisk;
    }

    @Override
    public Date getDiskDate() {
        return this.diskDate;
    }

    @Override
    public String getFileFormatText() {
        return "ImageDisk-Datei";
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public SectorData getSectorByIndex(int n, int n2, int n3) {
        SectorData sectorData = null;
        List<SectorData> list = this.getSectorList(n, n2);
        if (list != null && n3 >= 0 && n3 < list.size()) {
            sectorData = list.get(n3);
        }
        return sectorData;
    }

    @Override
    public int getSectorsOfCylinder(int n, int n2) {
        List<SectorData> list = this.getSectorList(n, n2);
        return list != null ? list.size() : 0;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        if (properties != null && this.fileName != null) {
            properties.setProperty(string + "file", this.fileName);
            properties.setProperty(string + "readonly", EmuUtil.VALUE_TRUE);
        }
    }

    @Override
    public boolean supportsDeletedSectors() {
        return true;
    }

    private ImageDisk(Frame frame, int n, int n2, int n3, int n4, String string, String string2, Date date, Map<Integer, List<SectorData>> map, Map<Integer, List<SectorData>> map2) {
        super(frame, n, n2, n3, n4);
        this.fileName = string;
        this.remark = string2;
        this.diskDate = date;
        this.side0 = map;
        this.side1 = map2;
    }

    private List<SectorData> getSectorList(int n, int n2) {
        Map<Integer, List<SectorData>> map;
        List<SectorData> list = null;
        Map<Integer, List<SectorData>> map2 = map = (n2 & 1) != 0 ? this.side1 : this.side0;
        if (map != null) {
            list = map.get(n);
        }
        return list;
    }

    private static int readMandatoryByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            ImageDisk.throwUnexpectedEOF();
        }
        return n;
    }

    private static void throwNoImageDiskFile() throws IOException {
        throw new IOException("Datei ist keine ImageDisk-Datei.");
    }
}

