/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.SectorID;

public class SectorData
extends SectorID {
    private int dataOffs;
    private int dataLen;
    private byte[] dataBuf;
    private boolean shared;
    private boolean bogusID;
    private boolean err;
    private boolean deleted;
    private long filePos;
    private int filePortionLen;
    private int idxOnCyl;
    private AbstractFloppyDisk disk;

    public SectorData(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) {
        super(n2, n3, n4, n5);
        this.idxOnCyl = n;
        this.dataBuf = byArray;
        this.dataOffs = n6;
        this.dataLen = n7;
        this.shared = true;
        this.bogusID = false;
        this.err = false;
        this.deleted = false;
        this.filePos = -1L;
        this.filePortionLen = 0;
        this.disk = null;
        if (n5 < 0 && this.dataLen > 0) {
            this.setSizeCode(SectorData.getSizeCode(this.dataLen));
        }
    }

    public boolean checkError() {
        return this.err;
    }

    public boolean equalsData(byte[] byArray, int n, int n2) {
        boolean bl = false;
        if (n2 == this.dataLen) {
            bl = true;
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4 = 0;
                if (byArray != null && (n3 = n + i) >= 0 && n3 < byArray.length) {
                    n4 = byArray[n3] & 0xFF;
                }
                if (n4 == this.getDataByte(i)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public synchronized int getDataByte(int n) {
        int n2 = -1;
        if (n >= 0 && n < this.dataLen) {
            n2 = 0;
            if (this.dataBuf != null && (n += this.dataOffs) < this.dataBuf.length) {
                n2 = this.dataBuf[n] & 0xFF;
            }
        }
        return n2;
    }

    public int getDataLength() {
        return this.dataLen;
    }

    public AbstractFloppyDisk getDisk() {
        return this.disk;
    }

    public int getFilePortionLen() {
        return this.filePortionLen;
    }

    public long getFilePos() {
        return this.filePos;
    }

    public int getIndexOnCylinder() {
        return this.idxOnCyl;
    }

    public static int getSizeCode(int n) {
        int n2 = -1;
        if (n >= 0) {
            if (n > 128) {
                int n3;
                int n4 = 0;
                for (n3 = 128; n3 > 0 && n3 < n; n3 <<= 1) {
                    ++n4;
                }
                if (n3 == n) {
                    n2 = n4;
                }
            } else {
                n2 = 0;
            }
        }
        return n2;
    }

    public boolean hasBogusID() {
        return this.bogusID;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isEmpty() {
        return this.dataLen == 0;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (byArray != null) {
            if (this.dataBuf != null) {
                int n4 = this.dataOffs;
                int n5 = this.dataLen;
                while (n4 < this.dataBuf.length && n5 > 0 && n < byArray.length && n2 > 0) {
                    byArray[n++] = this.dataBuf[n4++];
                    --n5;
                    --n2;
                    ++n3;
                }
            }
            while (n < byArray.length && n2 > 0) {
                byArray[n++] = 0;
                --n2;
                ++n3;
            }
        }
        return n3;
    }

    public synchronized Reader reader() {
        return new Reader(this.dataBuf, this.dataOffs, this.dataLen, this.deleted);
    }

    public void setBogusID(boolean bl) {
        this.bogusID = bl;
    }

    public synchronized void setData(boolean bl, byte[] byArray, int n) {
        this.deleted = bl;
        this.dataOffs = 0;
        if (byArray != null) {
            int n2 = Math.min(byArray.length, n);
            int n3 = 0;
            if (this.dataBuf != null) {
                n3 = Math.min(this.dataBuf.length, this.dataLen);
            }
            if (this.shared || this.dataBuf == null || n3 != n2) {
                this.dataBuf = (byte[])(n2 > 0 ? new byte[n2] : null);
                this.shared = false;
            }
            if (this.dataBuf != null) {
                int n4 = Math.min(n2, n3);
                if (n4 > 0) {
                    System.arraycopy(byArray, 0, this.dataBuf, 0, n4);
                }
                if (n4 < this.dataBuf.length) {
                    Arrays.fill(this.dataBuf, n4, this.dataBuf.length, (byte)0);
                }
            }
            this.dataLen = n;
        } else {
            this.dataBuf = null;
            this.dataLen = 0;
            this.shared = false;
        }
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public void setDisk(AbstractFloppyDisk abstractFloppyDisk) {
        this.disk = abstractFloppyDisk;
    }

    public void setError(boolean bl) {
        this.err = bl;
    }

    public void setFilePortionLen(int n) {
        this.filePortionLen = n;
    }

    public void setFilePos(long l) {
        this.filePos = l;
    }

    @Override
    public void setSectorID(int n, int n2, int n3) {
        super.setSectorID(n, n2, n3);
    }

    public int writeTo(OutputStream outputStream, int n) throws IOException {
        int n2 = 0;
        if (this.dataBuf != null && (n2 = Math.min(this.dataLen, this.dataBuf.length - this.dataOffs)) > 0) {
            if (n >= 0 && n < n2) {
                n2 = n;
            }
            outputStream.write(this.dataBuf, this.dataOffs, n2);
        }
        while ((n < 0 || n2 < n) && n2 < this.dataLen) {
            outputStream.write(0);
            ++n2;
        }
        return n2;
    }

    public int writeTo(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2 = 0;
        if (this.dataBuf != null && (n2 = Math.min(this.dataLen, this.dataBuf.length - this.dataOffs)) > 0) {
            if (n >= 0 && n < n2) {
                n2 = n;
            }
            randomAccessFile.write(this.dataBuf, this.dataOffs, n2);
        }
        while ((n < 0 || n2 < n) && n2 < this.dataLen) {
            randomAccessFile.write(0);
            ++n2;
        }
        return n2;
    }

    public class Reader {
        private byte[] buf;
        private int pos;
        private int len;
        private boolean deleted;

        private Reader(byte[] byArray, int n, int n2, boolean bl) {
            this.buf = byArray;
            this.pos = n;
            this.len = n2;
            this.deleted = bl;
        }

        public boolean isByteAvailable() {
            return this.len > 0;
        }

        public boolean isSectorDeleted() {
            return this.deleted;
        }

        public int read() {
            int n = -1;
            if (this.buf != null && this.len > 0 && this.pos >= 0 && this.pos < this.buf.length) {
                n = this.buf[this.pos++] & 0xFF;
                --this.len;
            }
            if (n == -1 && this.len > 0) {
                n = 0;
                --this.len;
            }
            return n;
        }
    }
}

