/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.SectorData;
import jkcemu.etc.CRC16;
import jkcemu.text.CharConverter;

public class TeleDisk
extends AbstractFloppyDisk {
    private static final int CRC_POLYNOM = 41111;
    private static final int CRC_INIT = 0;
    private String fileName;
    private String remark;
    private Date diskDate;
    private Map<Integer, List<SectorData>> side0;
    private Map<Integer, List<SectorData>> side1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(AbstractFloppyDisk abstractFloppyDisk, File file, String string) throws IOException {
        int n;
        int n2;
        Object object;
        int n3;
        byte[] byArray = null;
        if (string == null) {
            string = abstractFloppyDisk.getRemark();
        }
        if (string != null && (n3 = string.length()) > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 8);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            object = abstractFloppyDisk.getDiskDate();
            if (object != null) {
                gregorianCalendar.clear();
                gregorianCalendar.setTime((Date)object);
            }
            byteArrayOutputStream.write(gregorianCalendar.get(1) - 1900);
            byteArrayOutputStream.write(gregorianCalendar.get(2));
            byteArrayOutputStream.write(gregorianCalendar.get(5));
            byteArrayOutputStream.write(gregorianCalendar.get(11));
            byteArrayOutputStream.write(gregorianCalendar.get(12));
            byteArrayOutputStream.write(gregorianCalendar.get(13));
            CharConverter charConverter = new CharConverter(CharConverter.Encoding.CP850);
            for (n2 = 0; n2 < n3 && (n = string.charAt(n2)) != 0 && n != 26; ++n2) {
                if ((n = (int)((char)charConverter.toCharsetByte((char)n))) <= 0 || byteArrayOutputStream.size() >= 126) continue;
                byteArrayOutputStream.write(n);
            }
            if (byteArrayOutputStream.size() > 6) {
                byteArrayOutputStream.write(0);
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        OutputStream outputStream = null;
        try {
            int n4;
            int n5;
            int n6 = abstractFloppyDisk.getCylinders();
            int n7 = abstractFloppyDisk.getSides();
            if (n6 < 1 || n7 < 1) {
                throw new IOException("Kein Inhalt vorhanden");
            }
            outputStream = EmuUtil.createOptionalGZipOutputStream(file);
            object = new CRC16(41111, 0);
            TeleDisk.writeByte(outputStream, 84, (CRC16)object);
            TeleDisk.writeByte(outputStream, 68, (CRC16)object);
            TeleDisk.writeByte(outputStream, 0, (CRC16)object);
            TeleDisk.writeByte(outputStream, new Random(System.currentTimeMillis()).nextInt(256), (CRC16)object);
            TeleDisk.writeByte(outputStream, 21, (CRC16)object);
            int n8 = 0;
            if (abstractFloppyDisk.getDiskSize() >= 0x100000) {
                n8 = 2;
            }
            TeleDisk.writeByte(outputStream, n8, (CRC16)object);
            n2 = 1;
            if (abstractFloppyDisk.getDiskSize() >= 368640) {
                n2 = 2;
            }
            if (abstractFloppyDisk.getCylinders() >= 50 && abstractFloppyDisk.getSectorSize() == 512) {
                n = abstractFloppyDisk.getSectorsPerCylinder();
                if (n >= 8 && n <= 10) {
                    n2 = 3;
                } else if (n >= 17) {
                    n2 = 4;
                }
            }
            TeleDisk.writeByte(outputStream, n2, (CRC16)object);
            TeleDisk.writeByte(outputStream, byArray != null ? 128 : 0, (CRC16)object);
            TeleDisk.writeByte(outputStream, 0, (CRC16)object);
            TeleDisk.writeByte(outputStream, abstractFloppyDisk.getSides(), (CRC16)object);
            long l = ((CRC16)object).getValue();
            outputStream.write((int)l);
            outputStream.write((int)(l >> 8));
            if (byArray != null) {
                n5 = byArray.length - 6;
                ((CRC16)object).reset();
                ((CRC16)object).update(n5);
                ((CRC16)object).update(n5 >> 8);
                ((CRC16)object).update(byArray, 0, byArray.length);
                n4 = (int)((CRC16)object).getValue();
                outputStream.write(n4);
                outputStream.write(n4 >> 8);
                outputStream.write(n5);
                outputStream.write(n5 >> 8);
                outputStream.write(byArray);
            }
            n5 = -1;
            n4 = -1;
            int n9 = -1;
            for (int i = 0; i < n6; ++i) {
                n5 = i;
                for (int j = 0; j < n7; ++j) {
                    n4 = j;
                    int n10 = abstractFloppyDisk.getSectorsOfCylinder(i, j);
                    if (n10 <= 0) continue;
                    ArrayList<SectorData> arrayList = new ArrayList<SectorData>(n10);
                    for (int k = 0; k < n10; ++k) {
                        SectorData sectorData = abstractFloppyDisk.getSectorByIndex(i, j, k);
                        if (sectorData == null) continue;
                        arrayList.add(sectorData);
                    }
                    n10 = arrayList.size();
                    if (n10 <= 0) continue;
                    ((CRC16)object).reset();
                    TeleDisk.writeByte(outputStream, n10, (CRC16)object);
                    TeleDisk.writeByte(outputStream, i, (CRC16)object);
                    TeleDisk.writeByte(outputStream, j, (CRC16)object);
                    n9 = (int)((CRC16)object).getValue();
                    outputStream.write(n9);
                    for (SectorData sectorData : arrayList) {
                        int n11 = sectorData.getDataLength();
                        ((CRC16)object).reset();
                        TeleDisk.writeByte(outputStream, sectorData.getCylinder(), (CRC16)object);
                        TeleDisk.writeByte(outputStream, sectorData.getHead(), (CRC16)object);
                        TeleDisk.writeByte(outputStream, sectorData.getSectorNum(), (CRC16)object);
                        TeleDisk.writeByte(outputStream, sectorData.getSizeCode(), (CRC16)object);
                        int n12 = 0;
                        if (sectorData.checkError()) {
                            n12 |= 2;
                        }
                        if (sectorData.isDeleted()) {
                            n12 |= 4;
                        }
                        if (sectorData.hasBogusID()) {
                            n12 |= 0x40;
                        }
                        if (n11 <= 0) {
                            n12 |= 0x20;
                        }
                        TeleDisk.writeByte(outputStream, n12, (CRC16)object);
                        if (n11 > 0) {
                            int n13;
                            int n14;
                            ((CRC16)object).reset();
                            boolean bl = true;
                            int n15 = sectorData.getDataByte(0);
                            ((CRC16)object).update(n15);
                            for (n14 = 1; n14 < n11; ++n14) {
                                n13 = sectorData.getDataByte(n14);
                                ((CRC16)object).update(n13);
                                if (n13 == n15) continue;
                                bl = false;
                            }
                            outputStream.write((int)((CRC16)object).getValue());
                            if (bl) {
                                int n16;
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
                                for (n13 = n11; n13 > 5; n13 -= n16 * 2) {
                                    n16 = n13 / 2;
                                    if (n16 > 255) {
                                        n16 = 255;
                                    }
                                    byteArrayOutputStream.write(1);
                                    byteArrayOutputStream.write(n16);
                                    byteArrayOutputStream.write(n15);
                                    byteArrayOutputStream.write(n15);
                                }
                                byteArrayOutputStream.write(0);
                                byteArrayOutputStream.write(n13);
                                while (n13 > 0) {
                                    byteArrayOutputStream.write(n15);
                                    --n13;
                                }
                                n16 = byteArrayOutputStream.size() + 1;
                                outputStream.write(n16);
                                outputStream.write(n16 >> 8);
                                outputStream.write(2);
                                byteArrayOutputStream.writeTo(outputStream);
                                continue;
                            }
                            n14 = n11 + 1;
                            outputStream.write(n14);
                            outputStream.write(n14 >> 8);
                            outputStream.write(0);
                            sectorData.writeTo(outputStream, n11);
                            continue;
                        }
                        outputStream.write((int)((CRC16)object).getValue());
                    }
                }
            }
            outputStream.write(255);
            outputStream.write(n5);
            outputStream.write(n4);
            outputStream.write(n9);
            outputStream.close();
            outputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(outputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(outputStream);
        return null;
    }

    public static boolean isTeleDiskFileHeader(byte[] byArray) {
        boolean bl = false;
        if (byArray != null && byArray.length >= 3 && (byArray[0] == 84 && byArray[1] == 68 || byArray[0] == 116 && byArray[1] == 100) && byArray[2] == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static TeleDisk readFile(Frame var0, File var1_1, boolean var2_2) throws IOException {
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        try {
            var4_4 = new FileInputStream(var1_1);
            if (EmuUtil.isGZipFile(var1_1)) {
                var4_4 = new GZIPInputStream(var4_4);
            }
            var6_6 = false;
            var7_7 = var4_4.read();
            var8_8 = var4_4.read();
            var9_9 = var4_4.read();
            if (var7_7 == 116 && var8_8 == 100) {
                TeleDisk.throwUnsupportedTeleDiskFmt("Advanced Compression nicht unterst\u00fctzt");
            }
            if (var7_7 != 84 || var8_8 != 68 || var9_9 != 0) {
                throw new IOException("Datei ist keine TeleDisk-Datei.");
            }
            TeleDisk.readMandatoryByte(var4_4);
            var10_10 = TeleDisk.readMandatoryByte(var4_4);
            if (var10_10 != 21) {
                TeleDisk.throwUnsupportedTeleDiskFmt(String.format("Formatversion %02X nicht unterst\u00fctzt", new Object[]{var10_10}));
            }
            TeleDisk.readMandatoryByte(var4_4);
            TeleDisk.readMandatoryByte(var4_4);
            var11_11 = (TeleDisk.readMandatoryByte(var4_4) & 128) != 0;
            TeleDisk.readMandatoryByte(var4_4);
            var12_12 = TeleDisk.readMandatoryByte(var4_4);
            if (var12_12 != 1) {
                var12_12 = 2;
            }
            TeleDisk.readMandatoryWord(var4_4);
            var13_13 = null;
            var14_14 = null;
            var15_15 = null;
            if (var11_11) {
                var16_16 = TeleDisk.readMandatoryWord(var4_4);
                var17_18 = TeleDisk.readMandatoryWord(var4_4);
                var18_20 = TeleDisk.readMandatoryByte(var4_4) + 1900;
                var19_21 = TeleDisk.readMandatoryByte(var4_4);
                var20_22 = TeleDisk.readMandatoryByte(var4_4);
                var21_23 = TeleDisk.readMandatoryByte(var4_4);
                var22_24 = TeleDisk.readMandatoryByte(var4_4);
                var23_25 = TeleDisk.readMandatoryByte(var4_4);
                if (var19_21 < 12 && var20_22 >= true && var20_22 <= 31 != 0 && var21_23 < 24 && var22_24 < 60 && var23_25 < 60) {
                    var15_15 = new GregorianCalendar(var18_20, var19_21, (int)var20_22, var21_23, var22_24, var23_25).getTime();
                }
                if (var17_18 < 0) {
                    var17_18 = 0;
                }
                var24_26 = new StringBuilder(var17_18 + 32);
                var25_28 = new CharConverter(CharConverter.Encoding.CP850);
                if (var17_18 > 0) {
                    var26_29 = -1;
                    while (var17_18 > 0) {
                        var27_31 = TeleDisk.readMandatoryByte(var4_4);
                        if (var27_31 == 0) {
                            var27_31 = 10;
                            if (var26_29 < 0) {
                                var26_29 = var24_26.length();
                            }
                        } else {
                            var26_29 = -1;
                        }
                        if ((var27_31 = (int)var25_28.toUnicode(var27_31)) > 0) {
                            var24_26.append((char)var27_31);
                        }
                        --var17_18;
                    }
                    if (var26_29 >= 0) {
                        var24_26.setLength(var26_29);
                    }
                }
                var13_13 = var24_26.toString().trim();
            }
            var16_17 = null;
            var17_19 = null;
            var18_20 = 0;
            var19_21 = 0;
            var20_22 = false;
            while (true) {
                var21_23 = var4_4.read();
                var22_24 = var4_4.read();
                var23_25 = var4_4.read();
                var4_4.read();
                if (var21_23 == 255 || var21_23 < 0 || var22_24 < 0 || var23_25 < 0) break;
                if (var21_23 <= 0) continue;
                var23_25 &= 1;
                if (var22_24 >= var18_20) {
                    var18_20 = var22_24 + 1;
                }
                if (var19_21 == 0) {
                    var19_21 = var21_23;
                }
                var24_27 = false;
                var25_28 = null;
                for (var26_29 = 0; var26_29 < var21_23; ++var26_29) {
                    var27_33 = TeleDisk.readMandatoryByte(var4_4);
                    var28_35 = TeleDisk.readMandatoryByte(var4_4);
                    var29_37 = TeleDisk.readMandatoryByte(var4_4);
                    var30_39 = TeleDisk.readMandatoryByte(var4_4);
                    var31_42 = TeleDisk.readMandatoryByte(var4_4);
                    var32_45 = TeleDisk.readMandatoryByte(var4_4);
                    var33_46 = null;
                    if (var30_39 >= 0 && var30_39 <= 6) {
                        var34_47 = 128 != 0;
                        if (var30_39 > 0) {
                            var34_47 <<= var30_39;
                        }
                        var33_46 = new byte[var34_47];
                        Arrays.fill(var33_46, (byte)0);
                        if (var34_47 > var20_22) {
                            var20_22 = var34_47;
                        }
                    }
                    if (var33_46 == null) {
                        TeleDisk.throwUnsupportedTeleDiskFmt(String.format("Code=%02X f\u00fcr Sektorgr\u00f6\u00dfe nicht unterst\u00fctzt", new Object[]{var30_39}));
                    }
                    var34_47 = (var31_42 & 2) != 0;
                    var35_48 = (var31_42 & 4) != 0;
                    v0 = var36_49 = (var31_42 & 64) != 0;
                    if (!(var36_49 || var27_33 == var22_24 && var28_35 == var23_25)) {
                        var24_27 = true;
                    }
                    if ((var31_42 & 48) == 0 && (var37_51 = TeleDisk.readMandatoryWord(var4_4)) > 0) {
                        var38_52 = TeleDisk.readMandatoryByte(var4_4);
                        --var37_51;
                        var39_54 = 0;
                        switch (var38_52) {
                            case 0: {
                                while (var37_51 > 0) {
                                    var40_55 = TeleDisk.readMandatoryByte(var4_4);
                                    if (var39_54 < var33_46.length) {
                                        var33_46[var39_54++] = (byte)var40_55;
                                    }
                                    --var37_51;
                                }
                                break;
                            }
                            case 1: {
                                if (var37_51 < 4) break;
                                var41_56 = TeleDisk.readMandatoryByte(var4_4);
                                var42_59 = TeleDisk.readMandatoryByte(var4_4);
                                var37_51 -= 4;
                                for (var40_55 = TeleDisk.readMandatoryWord(var4_4); var40_55 > 0; --var40_55) {
                                    if (var39_54 < var33_46.length) {
                                        var33_46[var39_54++] = (byte)var41_56;
                                    }
                                    if (var39_54 >= var33_46.length) continue;
                                    var33_46[var39_54++] = (byte)var42_59;
                                }
                                break;
                            }
                            case 2: {
                                block20: while (var37_51 >= 2) {
                                    var40_55 = TeleDisk.readMandatoryByte(var4_4);
                                    var37_51 -= 2;
                                    switch (var40_55) {
                                        case 0: {
                                            for (var41_56 = TeleDisk.readMandatoryByte(var4_4); var37_51 > 0 && var41_56 > 0; --var41_56, --var37_51) {
                                                var42_59 = TeleDisk.readMandatoryByte(var4_4);
                                                if (var39_54 >= var33_46.length) continue;
                                                var33_46[var39_54++] = (byte)var42_59;
                                            }
                                            if (var41_56 <= 0) continue block20;
                                            TeleDisk.throwLengthMismatch();
                                            break;
                                        }
                                        case 1: {
                                            if (var37_51 < 2) continue block20;
                                            var42_59 = TeleDisk.readMandatoryByte(var4_4);
                                            var43_61 = TeleDisk.readMandatoryByte(var4_4);
                                            var37_51 -= 2;
                                            while (var41_56 > 0) {
                                                if (var39_54 < var33_46.length) {
                                                    var33_46[var39_54++] = (byte)var42_59;
                                                }
                                                if (var39_54 < var33_46.length) {
                                                    var33_46[var39_54++] = (byte)var43_61;
                                                }
                                                --var41_56;
                                            }
                                            continue block20;
                                        }
                                        default: {
                                            TeleDisk.throwUnsupportedTeleDiskFmt(String.format("Sektorunterkodierung %02X nicht unterst\u00fctzt", new Object[]{var40_55}));
                                        }
                                    }
                                }
                                while (var37_51 > 0) {
                                    TeleDisk.readMandatoryByte(var4_4);
                                    --var37_51;
                                }
                                break;
                            }
                            default: {
                                TeleDisk.throwUnsupportedTeleDiskFmt(String.format("Sektorkodierung %02Xh nicht unterst\u00fctzt", new Object[]{var38_52}));
                            }
                        }
                        if (var37_51 > 0) {
                            TeleDisk.throwLengthMismatch();
                        }
                    }
                    var37_50 = null;
                    if (var23_25 == 0) {
                        if (var16_17 == null) {
                            var16_17 = new HashMap<Integer, ArrayList<E>>();
                        }
                        var37_50 = var16_17;
                    } else if (var23_25 == 1) {
                        if (var17_19 == null) {
                            var17_19 = new HashMap<K, V>();
                        }
                        var37_50 = var17_19;
                    }
                    if (var37_50 == null) continue;
                    var38_53 = (ArrayList<SectorData>)var37_50.get(var22_24);
                    if (var38_53 == null) {
                        var38_53 = new ArrayList<SectorData>(var21_23 > 0 ? var21_23 : 1);
                        var37_50.put(var22_24, var38_53);
                    }
                    var39_54 = 0;
                    v1 = var40_55 = var33_46 != null ? var33_46.length : 0;
                    if (var2_2) {
                        for (SectorData var42_60 : var38_53) {
                            if (!var42_60.equalsSectorID(var27_33, var28_35, var29_37, var30_39)) continue;
                            var39_54 = 1;
                            if (var42_60.equalsData(var33_46, 0, var40_55)) {
                                if (!var34_47) {
                                    var42_60.setError(false);
                                }
                                if (var35_48) continue;
                                var42_60.setDeleted(false);
                                continue;
                            }
                            if (!var42_60.checkError() || var34_47) continue;
                            if (var35_48 && !var42_60.isDeleted()) {
                                var35_48 = false;
                                var6_6 = true;
                            }
                            var42_60.setData(var35_48, var33_46, var40_55);
                            var42_60.setError(false);
                        }
                    }
                    if (var39_54 != 0) continue;
                    var41_58 = new SectorData(var38_53.size(), var27_33, var28_35, var29_37, var30_39, var33_46, 0, var40_55);
                    var41_58.setBogusID(var36_49);
                    var41_58.setError(var34_47);
                    var41_58.setDeleted(var35_48);
                    var38_53.add(var41_58);
                    if (!var36_49 || var24_27) continue;
                    if (var25_28 == null) {
                        var25_28 = new ArrayList<E>();
                    }
                    var25_28.add(var41_58);
                }
                if (!var2_2 || var25_28 == null || var24_27 || var25_28.size() != 1) continue;
                var26_30 = (SectorData)var25_28.get(0);
                var27_34 = null;
                var28_36 = null;
                if (var23_25 == 0) {
                    var27_34 = var16_17;
                } else if (var23_25 == 1) {
                    var27_34 = var17_19;
                }
                if (var27_34 != null) {
                    var28_36 = (List)var27_34.get(var22_24);
                }
                if (var28_36 == null || var28_36.size() != var21_23 || !var28_36.contains(var26_30)) continue;
                var29_38 = new TreeSet<Integer>();
                for (SectorData var31_43 : var28_36) {
                    if (var31_43 == var26_30) continue;
                    var29_38.add(var31_43.getSectorNum());
                }
                if (var29_38.isEmpty() || var29_38.size() + 1 != var21_23) continue;
                var30_41 = (Integer)var29_38.last() - (Integer)var29_38.first() + 1;
                if (var30_41 == var21_23 - 1) {
                    switch ((Integer)var29_38.first()) {
                        case 1: {
                            var26_30.setSectorID(var22_24, var23_25, (Integer)var29_38.last() + 1);
                            var26_30.setBogusID(false);
                            var6_6 = true;
                            break;
                        }
                        case 2: {
                            var26_30.setSectorID(var22_24, var23_25, 1);
                            var26_30.setBogusID(false);
                            var6_6 = true;
                        }
                    }
                    continue;
                }
                if (var30_41 != var21_23) continue;
                var31_44 = (Integer)var29_38.first() + 1;
                var32_45 = (Integer)var29_38.last();
                while (true) {
                    if (var31_44 > var32_45) ** break;
                    if (!var29_38.contains(var31_44)) {
                        var26_30.setSectorID(var22_24, var23_25, var31_44);
                        var26_30.setBogusID(false);
                        var6_6 = true;
                    }
                    ++var31_44;
                }
                break;
            }
            var3_3 = new TeleDisk(var0, var12_12, var18_20, var19_21, (int)var20_22, var1_1.getPath(), var13_13, var15_15, var16_17, var17_19);
            if (var6_6) {
                var3_3.setWarningText("JKCEMU hat Sektoren repariert, die beim Erzeugen der\nTeledisk-Datei nicht korrekt gelesen werden konnten.");
            }
        }
        catch (Throwable var44_62) {
            EmuUtil.closeSilent(var4_4);
            throw var44_62;
        }
        EmuUtil.closeSilent(var4_4);
        return var3_3;
    }

    @Override
    public Date getDiskDate() {
        return this.diskDate;
    }

    @Override
    public String getFileFormatText() {
        return "TeleDisk-Datei";
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public SectorData getSectorByIndex(int n, int n2, int n3) {
        SectorData sectorData = null;
        List<SectorData> list = this.getSectorList(n, n2);
        if (list != null && n3 >= 0 && n3 < list.size()) {
            sectorData = list.get(n3);
        }
        return sectorData;
    }

    @Override
    public int getSectorsOfCylinder(int n, int n2) {
        List<SectorData> list = this.getSectorList(n, n2);
        return list != null ? list.size() : 0;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        if (properties != null && this.fileName != null) {
            properties.setProperty(string + "file", this.fileName);
            properties.setProperty(string + "readonly", EmuUtil.VALUE_TRUE);
        }
    }

    @Override
    public boolean supportsDeletedSectors() {
        return true;
    }

    private TeleDisk(Frame frame, int n, int n2, int n3, int n4, String string, String string2, Date date, Map<Integer, List<SectorData>> map, Map<Integer, List<SectorData>> map2) {
        super(frame, n, n2, n3, n4);
        this.fileName = string;
        this.remark = string2;
        this.diskDate = date;
        this.side0 = map;
        this.side1 = map2;
    }

    private List<SectorData> getSectorList(int n, int n2) {
        Map<Integer, List<SectorData>> map;
        List<SectorData> list = null;
        Map<Integer, List<SectorData>> map2 = map = (n2 & 1) != 0 ? this.side1 : this.side0;
        if (map != null) {
            list = map.get(n);
        }
        return list;
    }

    private static int readMandatoryByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            TeleDisk.throwUnexpectedEOF();
        }
        return n;
    }

    private static int readMandatoryWord(InputStream inputStream) throws IOException {
        int n = TeleDisk.readMandatoryByte(inputStream);
        int n2 = TeleDisk.readMandatoryByte(inputStream);
        return n2 << 8 | n;
    }

    private static void throwLengthMismatch() throws IOException {
        throw new IOException("In der Datei passen einzelne L\u00e4ngenangaben nicht zusammen.");
    }

    private static void throwUnsupportedTeleDiskFmt(String string) throws IOException {
        throw new IOException("Die Datei enth\u00e4lt ein nicht unterst\u00fctztes TeleDisk-Format:\n" + string);
    }

    private static void writeByte(OutputStream outputStream, int n, CRC16 cRC16) throws IOException {
        cRC16.update(n);
        outputStream.write(n);
    }
}

