/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.LoadData;
import jkcemu.base.OptionDlg;
import jkcemu.base.RAMFloppy;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.base.UserCancelException;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.GIDE;
import jkcemu.emusys.ac1_llc2.AbstractSCCHSys;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIO;

public class AC1
extends AbstractSCCHSys
implements FDC8272.DriveSelector {
    public static final String SYSNAME = "AC1";
    public static final String PROP_PREFIX = "jkcemu.ac1.";
    public static final String PROP_2010_PIO2ROM_PREFIX = "2010.prop2rom.";
    public static final String PROP_2010_ROMBANK_PREFIX = "2010.rombank.";
    public static final String PROP_M1_TO_CTC_CLK2 = "m1_to_ctc_clk2";
    public static final String VALUE_MON_31_64X16 = "3.1_64x16";
    public static final String VALUE_MON_31_64X32 = "3.1_64x32";
    public static final String VALUE_MON_SCCH80 = "SCCH8.0";
    public static final String VALUE_MON_SCCH1088 = "SCCH10/88";
    public static final String VALUE_MON_2010 = "2010";
    public static final int FUNCTION_KEY_COUNT = 2;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static int V24_TSTATES_PER_BIT_INTERN = 248;
    private static int V24_TSTATES_PER_BIT_EXTERN = 208;
    private static final String[] ac1_8kTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "RENUMBER", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "POINT", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "SET", "RESET", "WINDOW", "SCREEN", "EDIT", "ASAVE", "ALOAD", "TRON", "TROFF"};
    private static final String[] ac1_12kTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GO TO", "RUN", "IF", "RESTORE", "GO SUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "BEEP", "AUTO", "?", "CLS", "WIDTH", "FNEND", "RENUMBER", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "USING", "POINT", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "SET", "RESET", "LPOS", "INSTR", "EDIT", "LVAR", "LLVAR", "TRACE", "LTRACE", "FNRETURN", "!", "ELSE", "LPRINT", "RANDOMIZE", "LWIDTH", "LNULL", "'", "PRECISION", "KILL", "EXCHANGE", "LINE", "CLOAD", "COPY", "LLIST", "DELETE", "SWITCH", "SCREEN"};
    private static final String[] bacobas2Tokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "RENUMBER", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "POINT", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "SET", "RESET", "WINDOW", "SCREEN", "EDIT", "DSAVE", "DLOAD", "TRON", "TROFF", "POS", "BEEP", "BRON", "BROFF", "LPRINT", "LLIST", "BACO", "CONV", "TRANS", "BLIST", "BEDIT", "BSAVE", "BLOAD", "DELETE", "DIR"};
    private static final String[] bacobas3Tokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "KEY", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "LOAD", "SAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "POINT", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "SET", "RESET", "RENUMBER", "LOCATE", "SOUND", "INKEY", "MODE", "TRON", "TROFF", "HELP", "EDIT", "BRON", "BROFF", "LPRINT", "LLIST", "BACO", "CONV", "TRANS", "ALIST", "AEDIT", "ASAVE", "ALOAD", "DIR", "CD", "BEEP", "DRAW"};
    private static final String[] basic6Tokens = new String[]{"END", "FOR", "NEXT", "DATA", "COLOR", "BLOAD", "INPUT", "DIM", "READ", "LET", "GOTO", "FNEND", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "KEY", "WAIT", "DEF", "POKE", "PRINT", "CLEAR", "FNRETURN", "SAVE", "!", "ELSE", "LPRINT", "TRACE", "BSAVE", "RANDOMIZE", "LINES", "LWIDTH", "LNULL", "WIDTH", "LVAR", "WINDOW", "'", "PRECISION", "CALL", "ERASE", "SWAP", "LINE", "RUN", "LOAD", "NEW", "AUTO", "COPY", "DIR", "MODE", "SOUND", "LIST", "LLIST", "RENUMBER", "DELETE", "EDIT", "DEG", "RAD", "WHILE", "WEND", "REPEAT", "UNTIL", "ERROR", "RESUME", "PAUSE", "DOKE", "CLS", "CURSOR", "DRAW", "CIRCLE", "SET", "RESET", "CD", "BYE", "CONT", "USING", "PI", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "DIV", "MOD", "^", "AND", "OR", "XOR", ">", "=", "<"};
    private static final String[] basic6TokensFF = new String[]{"SGN", "INT", "FIX", "ABS", "USR", "FRE", "INP", "POS", "LPOS", "GETCL", "SQR", "RND", "LOG", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "FRAC", "LGT", "SQU", "BIN$", "HEX$", "LEN", "STR$", "VAL", "ASC", "SPACE$", "CHR$", "LEFT$", "RIGHT$", "MID$", "INKEY$", "STRING$", "ERR", "ERL", "POINT", "INSTR", "TIME$", "JOY", "DEEK", "VARPTR"};
    private static final int[] ccdCharToUnicode = new int[]{32, 9624, 9629, 9600, 9622, 9612, 9630, 9627, 9623, 9626, 9616, 9628, 9604, 9625, 9631, 9608, -1, -1, -1, -1, 178, 179, 167, 196, 214, 220, 228, 246, 252, 223, 181, 937, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 9618, 32, 9624, 9629, 9600, 9622, 9612, 9630, 9627, 9623, 9626, 9616, 9628, 9604, 9625, 9631, 9608, 9585, 9586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9587, 9620, 32, 9475, 9531, 9507, 9523, 9515, 9547, 9495, 9487, 9491, 9499, -1, -1, -1, -1, 9473, 8593, 8595, 8592, 8594, 9698, 9700, 9699, 9701, 9633, -1, 9679, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9830, 9827, 9829, 9824, -1, -1, -1, 9472, 9474, 9524, 9500, 9516, 9508, 9532, 9492, 9484, 9488, 9496, 9618, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9865, -1, -1, -1, -1, -1, 9675, -1, -1, 32, -1, -1, 9615, 9614, 9613, 9612, 9611, 9610, 9608, 9607, 9606, 9605, 9604, 9603, 9602, 9601};
    private static final int[] ac1_2010CharToUnicode = new int[]{32, 9624, 9629, 9600, 9622, 9612, 9630, 9627, 9623, 9626, 9616, 9628, 9604, 9625, 9631, 9608, -1, -1, -1, -1, 178, 179, 9865, -1, -1, -1, 91, 93, 123, 125, 181, 937, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 220, 94, 95, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9675, 9688, 9711, -1, 9700, 9699, 9585, 9586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9473, 9475, 9531, 9507, 9523, 9515, 9547, 9495, 9487, 9491, 9499, -1, -1, -1, -1, 9587, 9624, 9629, 9623, 9622, 9612, 9616, 9600, 9604, 9626, 9630, 9631, 9625, 9627, 9628, 9698, 9701, -1, -1, -1, -1, 9823, -1, -1, 9618, -1, 9830, 9827, 9829, 9824, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9601, 9602, 9603, 9604, 9605, 9606, 9607, 9608};
    private static final int[] romBank2010SegLengths = new int[]{8192, 8192, 8192, 8192, 4096, 4096, 2048, 2048, 8192, 8192, 8192, 8192, 4096, 4096, 2048, 2048};
    private static byte[] mon31_64x16 = null;
    private static byte[] mon31_64x32 = null;
    private static byte[] monSCCH80 = null;
    private static byte[] monSCCH1088 = null;
    private static byte[] mon2010c = null;
    private static byte[] minibasic = null;
    private static byte[] pio2Rom2010 = null;
    private static byte[] font2010 = null;
    private static byte[] fontACC = null;
    private static byte[] fontSCCH = null;
    private static byte[] fontU402 = null;
    private Color[] colors;
    private byte[] ramColor;
    private byte[] ramVideo;
    private byte[] ramStatic;
    private byte[] fontBytes;
    private byte[] osBytes;
    private byte[] pio2Rom2010Bytes;
    private byte[] romBank2010Bytes;
    private String fontFile;
    private String osFile;
    private String osVersion;
    private String pio2Rom2010File;
    private String romBank2010File;
    private BasicType lastBasicType;
    private RAMFloppy ramFloppy;
    private Z80CTC ctc;
    private Z80PIO pio2;
    private GIDE gide;
    private FDC8272 fdc;
    private FloppyDiskDrive[] fdDrives;
    private KCNet kcNet;
    private VDIP vdip;
    private boolean audioInPhase;
    private boolean fdcWaitEnabled;
    private boolean tcEnabled;
    private boolean mode64x16 = false;
    private boolean mode2010 = false;
    private boolean modeSCCH = false;
    private boolean fontSwitchable = false;
    private boolean inverseBySW;
    private boolean inverseByKey;
    private boolean extFont;
    private boolean lastMemReadM1;
    private boolean ctcM1ToClk2;
    private boolean ctcWritten;
    private boolean pio1B3State;
    private boolean keyboardUsed;
    private volatile boolean graphicKeyState;
    private boolean lowerDRAMEnabled;
    private boolean osRomEnabled;
    private int regF0;
    private int pio2Rom2010Offs;
    private int romBank2010Offs;
    private int romBank2010Len;
    private int fontOffs;
    private int m1Cnt;

    public AC1(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.pasteFast = false;
        this.ctcM1ToClk2 = this.emulatesM1ToCtcClk2(properties);
        this.osVersion = EmuUtil.getProperty(properties, this.propPrefix + "os.version");
        if (this.osVersion.equals(VALUE_MON_31_64X16)) {
            this.mode64x16 = true;
        } else if (this.osVersion.equals(VALUE_MON_SCCH80)) {
            this.modeSCCH = true;
        } else if (this.osVersion.equals(VALUE_MON_SCCH1088)) {
            this.modeSCCH = true;
            this.fontSwitchable = true;
        } else if (this.osVersion.equals(VALUE_MON_2010)) {
            this.mode2010 = true;
        }
        this.osBytes = null;
        this.osFile = null;
        this.pio2Rom2010Bytes = null;
        this.pio2Rom2010File = null;
        this.romBank2010Bytes = null;
        this.romBank2010File = null;
        this.pio2Rom2010Offs = -1;
        this.romBank2010Offs = -1;
        this.romBank2010Len = 0;
        this.regF0 = 0;
        this.lastBasicType = null;
        if (this.emulatesColors(properties)) {
            this.fontSwitchable = true;
            this.mode64x16 = false;
            this.ramColor = new byte[2048];
            this.colors = new Color[16];
            this.createColors(properties);
        } else {
            this.ramColor = null;
            this.colors = null;
        }
        if (this.mode64x16) {
            this.ramStatic = new byte[1024];
            this.ramVideo = new byte[1024];
        } else {
            this.ramStatic = new byte[2048];
            this.ramVideo = new byte[2048];
        }
        if (this.modeSCCH) {
            this.ramModule3 = this.emuThread.getExtendedRAM(0x100000);
        }
        this.ramFloppy = RAMFloppy.prepare(this.emuThread.getRAMFloppy1(), SYSNAME, RAMFloppy.RFType.MP_3_1988, "RAM-Floppy E/A-Adressen E0h-E7h", properties, this.propPrefix + "ramfloppy.");
        this.fdDrives = null;
        this.fdc = null;
        if (this.emulatesFloppyDisk(properties)) {
            this.fdDrives = new FloppyDiskDrive[4];
            Arrays.fill(this.fdDrives, null);
            this.fdc = new FDC8272(this, 4);
        }
        this.kcNet = null;
        if (this.emulatesKCNet(properties)) {
            this.kcNet = new KCNet("Netzwerk-PIO (E/A-Adressen C0-C3)");
        }
        this.vdip = null;
        if (this.emulatesUSB(properties)) {
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen FC-FF)");
        }
        this.gide = GIDE.getGIDE(this.screenFrm, properties, this.propPrefix);
        ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
        this.ctc = new Z80CTC("CTC (E/A-Adressen 00-03)");
        this.pio1 = new Z80PIO("PIO (E/A-Adressen 04-07)");
        arrayList.add(this.ctc);
        arrayList.add(this.pio1);
        if (this.modeSCCH || this.mode2010) {
            this.pio2 = new Z80PIO("V24-PIO (E/A-Adressen 08-0B)");
            arrayList.add(this.pio2);
        }
        if (this.kcNet != null) {
            arrayList.add(this.kcNet);
        }
        if (this.vdip != null) {
            arrayList.add(this.vdip);
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        try {
            z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        this.ctc.setTimerConnection(0, 1);
        if (!this.ctcM1ToClk2) {
            this.ctc.setTimerConnection(1, 2);
        }
        this.ctc.setTimerConnection(2, 3);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        this.checkAddPCListener(properties);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static String getBasicProgram(Window window, LoadData loadData) throws UserCancelException {
        String string = null;
        int n = loadData.getBegAddr();
        if (n == 24823) {
            int n2;
            String string2;
            String string3;
            String string4;
            ArrayList<String> arrayList = new ArrayList<String>(4);
            ArrayList<String> arrayList2 = new ArrayList<String>(4);
            String string5 = SourceUtil.getBasicProgram(loadData, n, ac1_8kTokens);
            if (string5 != null) {
                arrayList.add("AC1-8K-BASIC");
                arrayList2.add(string5);
            }
            if ((string4 = SourceUtil.getBasicProgram(loadData, n, scchTokens)) != null) {
                arrayList.add("SCCH-BASIC");
                arrayList2.add(string4);
            }
            if ((string3 = SourceUtil.getBasicProgram(loadData, n, bacobas2Tokens)) != null) {
                arrayList.add("BACOBAS 2");
                arrayList2.add(string3);
            }
            if ((string2 = SourceUtil.getBasicProgram(loadData, n, bacobas3Tokens)) != null) {
                arrayList.add("BACOBAS 3");
                arrayList2.add(string2);
            }
            int n3 = Math.min(arrayList.size(), arrayList2.size());
            for (int i = 0; i < n3 - 1; ++i) {
                n2 = 1;
                while (n2 < n3 && n2 < n3) {
                    if (((String)arrayList2.get(i)).equals(arrayList2.get(n2))) {
                        arrayList.set(i, (String)arrayList.get(i) + ", " + (String)arrayList.get(n2));
                        arrayList.remove(n2);
                        arrayList2.remove(n2);
                        continue;
                    }
                    ++n2;
                }
            }
            n3 = Math.min(arrayList.size(), arrayList2.size());
            if (n3 == 1) {
                string = (String)arrayList2.get(0);
            } else if (n3 > 1) {
                try {
                    n2 = OptionDlg.showOptionDlg(window, "Das BASIC-Programm enth\u00e4lt Tokens, die von den einzelnen Interpretern\nals unterschiedliche Anweisungen verstanden werden.\nW\u00e4hlen Sie bitte den Interpreter aus, entsprechend dem die Tokens\ndekodiert werden sollen.", "BASIC-Interpreter", -1, arrayList.toArray(new String[n3]));
                    if (n2 >= 0 && n2 < arrayList2.size()) {
                        string = (String)arrayList2.get(n2);
                    }
                    if (string == null) {
                        throw new UserCancelException();
                    }
                }
                catch (ArrayStoreException arrayStoreException) {
                    EmuUtil.exitSysError(window, null, arrayStoreException);
                }
            }
        } else if (n == 25344) {
            string = SourceUtil.getBasicProgram(loadData, n, basic6Tokens, basic6TokensFF);
        } else if (n == 28599) {
            string = SourceUtil.getBasicProgram(loadData, n, ac1_12kTokens);
        }
        return string;
    }

    @Override
    public int getBorderColorIndex() {
        int n = 0;
        if (this.colors != null) {
            n = this.inverseBySW != this.inverseByKey ? this.colors.length - 1 : 0;
        } else if (this.inverseBySW != this.inverseByKey) {
            n = 1;
        }
        return n;
    }

    public static int getDefaultSpeedKHz() {
        return 2000;
    }

    public static String getTinyBasicProgram(EmuMemView emuMemView) {
        return SourceUtil.getTinyBasicProgram(emuMemView, 6480, emuMemView.getMemWord(6377));
    }

    protected void loadROMs(Properties properties) {
        if (this.modeSCCH) {
            super.loadROMs(properties, "/rom/ac1/gsbasic.bin");
        } else {
            this.scchBasicRomFile = null;
            this.scchBasicRomBytes = null;
            this.scchPrgXRomFile = null;
            this.scchPrgXRomBytes = null;
            this.scchRomdiskFile = null;
            this.scchRomdiskBytes = null;
        }
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.osBytes = this.readROMFile(this.osFile, 4096, "Monitorprogramm");
        if (this.osBytes == null) {
            if (this.modeSCCH) {
                if (this.osVersion.startsWith(VALUE_MON_SCCH80)) {
                    if (monSCCH80 == null) {
                        monSCCH80 = this.readResource("/rom/ac1/scchmon_80g.bin");
                    }
                    this.osBytes = monSCCH80;
                } else {
                    if (monSCCH1088 == null) {
                        monSCCH1088 = this.readResource("/rom/ac1/scchmon_1088g.bin");
                    }
                    this.osBytes = monSCCH1088;
                }
            } else if (this.mode2010) {
                if (mon2010c == null) {
                    mon2010c = this.readResource("/rom/ac1/mon2010c.bin");
                }
                this.osBytes = mon2010c;
            } else if (this.mode64x16) {
                if (mon31_64x16 == null) {
                    mon31_64x16 = this.readResource("/rom/ac1/mon_31_64x16.bin");
                }
                this.osBytes = mon31_64x16;
            } else {
                if (mon31_64x32 == null) {
                    mon31_64x32 = this.readResource("/rom/ac1/mon_31_64x32.bin");
                }
                this.osBytes = mon31_64x32;
            }
        }
        if (!this.modeSCCH && minibasic == null) {
            minibasic = this.readResource("/rom/ac1/minibasic.bin");
        }
        if (this.mode2010) {
            this.pio2Rom2010File = EmuUtil.getProperty(properties, this.propPrefix + PROP_2010_PIO2ROM_PREFIX + "file");
            this.pio2Rom2010Bytes = this.readROMFile(this.pio2Rom2010File, 8192, "AC1-2010 PIO2 ROM");
            if (this.pio2Rom2010Bytes == null) {
                if (pio2Rom2010 == null) {
                    pio2Rom2010 = this.readResource("/rom/ac1/pio2rom2010.bin");
                }
                this.pio2Rom2010Bytes = pio2Rom2010;
            }
            this.romBank2010File = EmuUtil.getProperty(properties, this.propPrefix + PROP_2010_ROMBANK_PREFIX + "file");
            this.romBank2010Bytes = this.readROMFile(this.romBank2010File, 131072, "AC1-2010 ROM-Bank");
        } else {
            this.pio2Rom2010File = null;
            this.pio2Rom2010Bytes = null;
            this.romBank2010File = null;
            this.romBank2010Bytes = null;
        }
        this.loadFont(properties);
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.fdDrives != null && n >= 0 && n < this.fdDrives.length) {
            floppyDiskDrive = this.fdDrives[n];
        }
        return floppyDiskDrive;
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        if (!this.mode64x16) {
            stringBuilder.append("<h1>AC1 Status</h1>\n<table border=\"1\">\n<tr><td>Monitor ROM:</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, !this.lowerDRAMEnabled && this.osRomEnabled);
            stringBuilder.append("</td></tr>\n<tr><td>SRAM / BWS</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, !this.lowerDRAMEnabled);
            stringBuilder.append("</td></tr>\n");
            if (this.modeSCCH) {
                stringBuilder.append("<tr><td>ROM-Disk:</td><td>");
                EmuUtil.appendOnOffText(stringBuilder, this.scchRomdiskEnabled);
                stringBuilder.append("</td></tr>\n<tr><td>ROM-Disk Bank:</td><td>");
                if (this.scchRomdiskBegAddr == 32768) {
                    stringBuilder.append(this.scchRomdiskBankAddr >> 15);
                } else {
                    stringBuilder.append(this.scchRomdiskBankAddr >> 14);
                }
                stringBuilder.append("</td></tr>\n<tr><td>Programmpaket X ROM:</td><td>");
                EmuUtil.appendOnOffText(stringBuilder, this.scchPrgXRomEnabled);
                stringBuilder.append("</td></tr>\n<tr><td>SCCH-BASIC ROM:</td><td>");
                EmuUtil.appendOnOffText(stringBuilder, this.scchBasicRomEnabled);
                stringBuilder.append("</td></tr>\n");
            }
            if (this.mode2010) {
                stringBuilder.append("<tr><td>PIO2 ROM:</td><td>");
                if (this.pio2Rom2010Offs >= 0) {
                    stringBuilder.append("ein (2000h-27FFh)</td></tr>\n<tr><td>PIO2 ROM Segment-Offset:</td><td>");
                    stringBuilder.append(String.format("%Xh", this.pio2Rom2010Offs));
                } else {
                    stringBuilder.append("aus");
                }
                stringBuilder.append("</td></tr>\n<tr><td>ROM-Bank:</td><td>");
                if (this.romBank2010Len > 0 && this.romBank2010Offs >= 0) {
                    stringBuilder.append("ein (A000h-");
                    stringBuilder.append(String.format("%04Xh)", 40960 + this.romBank2010Len));
                    stringBuilder.append("</td></tr><tr><td>ROM-Bank Segment-Offset:</td><td>");
                    stringBuilder.append(String.format("%Xh", this.romBank2010Offs));
                } else {
                    stringBuilder.append("aus");
                }
                stringBuilder.append("</td></tr>\n");
            }
        }
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.createColors(properties);
        this.loadFont(properties);
        this.checkAddPCListener(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.osVersion, EmuUtil.getProperty(properties, this.propPrefix + "os.version"));
        }
        if (bl) {
            bl = TextUtil.equals(this.osFile, EmuUtil.getProperty(properties, this.propPrefix + "os.version"));
        }
        if (bl) {
            if (this.modeSCCH) {
                bl = super.canApplySettings(properties);
            } else if (bl && this.emulatesJoystick(properties) != this.joystickEnabled) {
                bl = false;
            }
        }
        if (this.mode2010) {
            if (bl) {
                bl = TextUtil.equals(this.pio2Rom2010File, EmuUtil.getProperty(properties, this.propPrefix + PROP_2010_PIO2ROM_PREFIX + "file"));
            }
            if (bl) {
                bl = TextUtil.equals(this.romBank2010File, EmuUtil.getProperty(properties, this.propPrefix + PROP_2010_ROMBANK_PREFIX + "file"));
            }
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy, SYSNAME, RAMFloppy.RFType.MP_3_1988, properties, this.propPrefix + "ramfloppy.");
        }
        if (bl) {
            bl = GIDE.complies(this.gide, properties, this.propPrefix);
        }
        if (bl && this.emulatesFloppyDisk(properties) != (this.fdc != null)) {
            bl = false;
        }
        if (bl && this.emulatesColors(properties) != (this.ramColor != null)) {
            bl = false;
        }
        if (bl && this.emulatesM1ToCtcClk2(properties) != this.ctcM1ToClk2) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        if (this.ramColor != null && this.colors != null) {
            if (n >= 0 && n < this.colors.length) {
                color = this.colors[n];
            }
        } else if (n > 0) {
            color = Color.white;
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return this.ramColor != null ? 16 : 2;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public void die() {
        if (this.gide != null) {
            this.gide.die();
        }
        if (this.ramFloppy != null) {
            this.ramFloppy.deinstall();
        }
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.pasteFast) {
            z80CPU.removePCListener(this);
            this.pasteFast = false;
        }
        if (this.fdc != null) {
            this.fdc.die();
        }
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    public boolean emulates2010Mode() {
        return this.mode2010;
    }

    public boolean emulatesSCCHMode() {
        return this.modeSCCH;
    }

    @Override
    public int getAppStartStackInitValue() {
        return 8192;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return this.mode64x16 ? new CharRaster(64, 16, 16, 8, 6, 0) : new CharRaster(64, 32, 8, 8, 6, 0);
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 100L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 250L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 100L;
    }

    @Override
    public String getHelpPage() {
        return "/help/ac1.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        n &= 0xFFFF;
        int n3 = 255;
        boolean bl2 = false;
        if (this.modeSCCH) {
            n3 = this.getScchMemByte(n, bl);
            if (n3 < 0) {
                n3 = 255;
            } else {
                bl2 = true;
            }
        }
        if (!bl2 && this.mode2010) {
            if (n >= 8192 && n < 10240 && this.pio2Rom2010Offs >= 0) {
                if (this.pio2Rom2010Bytes != null && (n2 = n - 8192 + this.pio2Rom2010Offs) >= 0 && n2 < this.pio2Rom2010Bytes.length) {
                    n3 = this.pio2Rom2010Bytes[n2] & 0xFF;
                }
                bl2 = true;
            } else if (n >= 32768 && this.romBank2010Offs >= 0) {
                if (n >= 40960 && n < 40960 + this.romBank2010Len && this.romBank2010Bytes != null && (n2 = n - 40960 + this.romBank2010Offs) < this.romBank2010Bytes.length) {
                    n3 = this.romBank2010Bytes[n2] & 0xFF;
                }
                bl2 = true;
            }
        }
        if (!bl2 && !this.lowerDRAMEnabled && n < 8192) {
            if (this.osRomEnabled && n < 4096) {
                if (this.osBytes != null && n < this.osBytes.length) {
                    n3 = this.osBytes[n] & 0xFF;
                    bl2 = true;
                }
                if (!(bl2 || this.modeSCCH || this.mode2010 || n < 2048 || minibasic == null)) {
                    n2 = n - 2048;
                    if (n2 < minibasic.length) {
                        n3 = minibasic[n2] & 0xFF;
                    }
                    bl2 = true;
                }
            } else if (n >= 4096 && n < 6144) {
                n2 = n - 4096;
                if (this.ramColor != null && (this.regF0 & 4) != 0) {
                    if (n2 < this.ramColor.length) {
                        n3 = this.ramColor[n2] & 0xFF;
                    }
                } else if (n2 < this.ramVideo.length) {
                    n3 = this.ramVideo[n2] & 0xFF;
                }
                bl2 = true;
            } else if (n >= 6144) {
                n2 = n - 6144;
                if (n2 < this.ramStatic.length) {
                    n3 = this.ramStatic[n2] & 0xFF;
                }
                bl2 = true;
            }
        }
        if (!bl2 && !this.mode64x16) {
            n3 = this.emuThread.getRAMByte(n);
        }
        return n3;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        int n4 = (this.mode64x16 ? 1023 : 2047) - n2 * 64 - n;
        if (n4 >= 0 && n4 < this.ramVideo.length) {
            int n5 = this.ramVideo[n4] & 0xFF;
            if (this.mode64x16 && !this.fontSwitchable) {
                n3 = ((n5 &= 0x3F) & 0x20) == 0 ? n5 | 0x40 : n5;
            } else {
                int[] nArray = ccdCharToUnicode;
                if (this.fontSwitchable) {
                    if (this.fontOffs > 0) {
                        nArray = scchCharToUnicode;
                    }
                } else if (this.modeSCCH) {
                    nArray = scchCharToUnicode;
                } else if (this.mode2010) {
                    nArray = ac1_2010CharToUnicode;
                }
                if (n5 < nArray.length) {
                    n3 = nArray[n5];
                }
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return this.mode64x16 ? 248 : 256;
    }

    @Override
    public int getScreenWidth() {
        return 384;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.fdDrives != null ? this.fdDrives.length : 0;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 112: {
                this.inverseByKey = !this.inverseByKey;
                this.screenFrm.setScreenDirty(true);
                bl3 = true;
                break;
            }
            case 113: {
                if (this.modeSCCH || this.mode2010) {
                    this.graphicKeyState = !this.graphicKeyState;
                }
                bl3 = true;
                break;
            }
            case 8: {
                n2 = this.modeSCCH || this.mode2010 ? 127 : 8;
                break;
            }
            case 127: {
                n2 = this.modeSCCH || this.mode2010 ? 4 : 127;
                break;
            }
            default: {
                bl3 = super.keyPressed(n, bl, bl2);
            }
        }
        if (n2 > 0) {
            this.setKeyboardValue(n2 | 0x80);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        switch (c) {
            case '\u00f1': {
                this.inverseByKey = !this.inverseByKey;
                this.screenFrm.setScreenDirty(true);
                bl = true;
                break;
            }
            case '\u00f2': {
                if (this.modeSCCH || this.mode2010) {
                    this.graphicKeyState = !this.graphicKeyState;
                }
                bl = true;
                break;
            }
            default: {
                bl = super.keyTyped(c);
            }
        }
        return bl;
    }

    @Override
    public void openBasicProgram() {
        boolean bl = false;
        BasicType basicType = null;
        String string = null;
        int n = -1;
        if (this.lastBasicType != null) {
            switch (this.lastBasicType) {
                case AC1_MINI: {
                    n = 0;
                    break;
                }
                case AC1_8K: {
                    n = 1;
                    break;
                }
                case AC1_12K: {
                    n = 2;
                    break;
                }
                case AC1_BASIC6: {
                    n = 3;
                    break;
                }
                case SCCH: {
                    n = 4;
                    break;
                }
                case BACOBAS2: {
                    n = 5;
                    break;
                }
                case BACOBAS3: {
                    n = 6;
                }
            }
        }
        if (n < 0 && (this.modeSCCH || this.mode2010)) {
            n = 4;
        }
        switch (OptionDlg.showOptionDlg(this.screenFrm, "W\u00e4hlen Sie bitte den BASIC-Interpreter aus,\ndessen BASIC-Programm ge\u00f6ffnet werden soll.\nDie Auswahl des Interpreters ist auch deshalb notwendig,\ndamit die Tokens richtig dekodiert werden.", "BASIC-Interpreter", n, "Mini-BASIC", "AC1-8K-BASIC", "AC1-12K-BASIC", "AC1-BASIC6", "SCCH-BASIC", "BACOBAS 2", "BACOBAS 3")) {
            case 0: {
                basicType = BasicType.AC1_MINI;
                string = AC1.getTinyBasicProgram(this.emuThread);
                break;
            }
            case 1: {
                basicType = BasicType.AC1_8K;
                string = SourceUtil.getBasicProgram(this.emuThread, 24823, ac1_8kTokens);
                break;
            }
            case 2: {
                basicType = BasicType.AC1_12K;
                string = SourceUtil.getBasicProgram(this.emuThread, 28599, ac1_12kTokens);
                break;
            }
            case 3: {
                basicType = BasicType.AC1_BASIC6;
                string = SourceUtil.getBasicProgram(this.emuThread, 25344, basic6Tokens, basic6TokensFF);
                break;
            }
            case 4: {
                basicType = BasicType.SCCH;
                string = SourceUtil.getBasicProgram(this.emuThread, 24823, scchTokens);
                break;
            }
            case 5: {
                basicType = BasicType.BACOBAS2;
                string = SourceUtil.getBasicProgram(this.emuThread, 24823, bacobas2Tokens);
                break;
            }
            case 6: {
                basicType = BasicType.BACOBAS3;
                string = SourceUtil.getBasicProgram(this.emuThread, 24823, bacobas3Tokens);
                break;
            }
            default: {
                bl = true;
            }
        }
        if (!bl) {
            if (string != null) {
                this.lastBasicType = basicType;
                this.screenFrm.openText(string);
            } else {
                this.showNoBasic();
            }
        }
    }

    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        if (this.fontBytes != null) {
            int n4 = this.getBorderColorIndex();
            int n5 = this.getScreenWidth();
            int n6 = this.getScreenHeight();
            if (n > 0 || n2 > 0) {
                graphics.translate(n, n2);
            }
            for (int i = 0; i < n6; ++i) {
                int n7 = -1;
                int n8 = -1;
                boolean bl = false;
                for (int j = 0; j < n5; ++j) {
                    int n9;
                    boolean bl2;
                    int n10;
                    int n11;
                    int n12 = j / 6;
                    int n13 = 0;
                    int n14 = 0;
                    if (this.mode64x16) {
                        n13 = i / 16;
                        n14 = i % 16;
                    } else {
                        n13 = i / 8;
                        n14 = i % 8;
                    }
                    if (n14 < 0 || n14 >= 8 || (n11 = this.ramVideo.length - 1 - n13 * 64 - n12) < 0 || n11 >= this.ramVideo.length) continue;
                    int n15 = this.ramVideo[n11] & 0xFF;
                    if (this.modeSCCH || this.mode2010) {
                        if (n15 == 16) {
                            bl = false;
                        } else if (n15 == 17) {
                            bl = true;
                        }
                    }
                    if ((n10 = n15 * 8 + n14 + this.fontOffs) < 0 || n10 >= this.fontBytes.length) continue;
                    int n16 = 1;
                    int n17 = j % 6;
                    if (n17 > 0) {
                        n16 <<= n17;
                    }
                    boolean bl3 = (this.fontBytes[n10] & n16) != 0;
                    boolean bl4 = bl2 = this.inverseBySW != this.inverseByKey;
                    if (bl != bl2) {
                        bl3 = !bl3;
                    }
                    int n18 = n9 = bl3 ? 1 : 0;
                    if (this.ramColor != null) {
                        byte by = this.ramColor[n11];
                        n9 = bl3 ? by & 0xF : by >> 4 & 0xF;
                    }
                    if (n9 == n7) continue;
                    if (n7 >= 0 && n7 != n4 && n8 >= 0) {
                        graphics.setColor(this.getColor(n7));
                        graphics.fillRect(n8 * n3, i * n3, (j - n8) * n3, n3);
                    }
                    n8 = j;
                    n7 = n9;
                }
                if (n7 < 0 || n7 == n4 || n8 < 0) continue;
                graphics.setColor(this.getColor(n7));
                graphics.fillRect(n8 * n3, i * n3, (n5 - n8) * n3, n3);
            }
            if (n > 0 || n2 > 0) {
                graphics.translate(-n, -n2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if (this.gide != null && (n & 0xF0) == 128) {
            int n4 = this.gide.read(n);
            if (n4 >= 0) {
                n3 = n4;
            }
        } else if ((n & 0xF8) == 224) {
            if (this.ramFloppy != null) {
                n3 = this.ramFloppy.readByte(n & 7);
            }
        } else {
            switch (n & 0xFF) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    n3 = this.ctc.read(n & 3, n2);
                    break;
                }
                case 4: {
                    Z80PIO z80PIO = this.pio1;
                    synchronized (z80PIO) {
                        if (!(this.keyboardUsed || this.joystickEnabled && this.joystickSelected)) {
                            this.pio1.putInValuePortA(0, 255);
                            this.keyboardUsed = true;
                        }
                    }
                    n3 = this.pio1.readDataA();
                    break;
                }
                case 5: {
                    this.pio1.putInValuePortB(this.graphicKeyState ? 0 : 4, 4);
                    n3 = this.pio1.readDataB();
                    break;
                }
                case 6: {
                    n3 = this.pio1.readControlA();
                    break;
                }
                case 7: {
                    n3 = this.pio1.readControlB();
                    break;
                }
                case 8: {
                    if (this.pio2 == null) break;
                    this.pio2.putInValuePortA(0, 4);
                    n3 = this.pio2.readDataA();
                    break;
                }
                case 9: {
                    if (this.pio2 == null) break;
                    n3 = this.pio2.readDataB();
                    break;
                }
                case 10: {
                    if (this.pio2 == null) break;
                    n3 = this.pio2.readControlA();
                    break;
                }
                case 11: {
                    if (this.pio2 == null) break;
                    n3 = this.pio2.readControlB();
                    break;
                }
                case 64: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readMainStatusReg();
                    this.tcEnabled = true;
                    break;
                }
                case 65: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readData();
                    this.tcEnabled = true;
                    break;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    if (this.kcNet == null) break;
                    n3 = this.kcNet.read(n);
                    break;
                }
                case 240: {
                    if (this.ramColor == null) break;
                    n3 = this.regF0;
                    break;
                }
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    if (this.vdip == null) break;
                    n3 = this.vdip.read(n);
                }
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        if (this.ctcM1ToClk2) {
            if (bl) {
                if (!this.lastMemReadM1) {
                    this.m1Cnt = 0;
                }
                ++this.m1Cnt;
            }
            this.lastMemReadM1 = bl;
        }
        return this.getMemByte(n, bl);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            this.initSRAM(this.ramStatic, properties);
            this.fillRandom(this.ramVideo);
        }
        if (this.ramColor != null) {
            if (this.osBytes == mon31_64x16 || this.osBytes == mon31_64x32 || this.osBytes == monSCCH80 || this.osBytes == monSCCH1088) {
                Arrays.fill(this.ramColor, (byte)15);
            } else if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
                this.fillRandom(this.ramColor);
            }
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.ctc.reset(true);
            this.pio1.reset(true);
            if (this.pio2 != null) {
                this.pio2.reset(true);
            }
        } else {
            this.ctc.reset(false);
            this.pio1.reset(false);
            if (this.pio2 != null) {
                this.pio2.reset(false);
            }
        }
        if (this.gide != null) {
            this.gide.reset();
        }
        if (this.fdc != null) {
            this.fdc.reset(resetLevel == EmuThread.ResetLevel.POWER_ON);
        }
        if (this.fdDrives != null) {
            for (int i = 0; i < this.fdDrives.length; ++i) {
                FloppyDiskDrive floppyDiskDrive = this.fdDrives[i];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        this.audioInPhase = this.emuThread.readTapeInPhase();
        this.inverseBySW = false;
        this.pio1B3State = false;
        this.fdcWaitEnabled = false;
        this.tcEnabled = true;
        this.keyboardUsed = false;
        this.graphicKeyState = false;
        this.lowerDRAMEnabled = false;
        this.osRomEnabled = true;
        this.regF0 = 0;
        this.pio2Rom2010Offs = -1;
        this.romBank2010Offs = -1;
        this.fontOffs = 0;
        this.m1Cnt = 0;
        this.lastMemReadM1 = false;
        this.ctcWritten = false;
        this.v24TStatesPerBit = this.osBytes == monSCCH80 || this.osBytes == monSCCH1088 || this.osBytes == mon2010c ? V24_TSTATES_PER_BIT_INTERN : V24_TSTATES_PER_BIT_EXTERN;
        this.pio1.putInValuePortB(0, 4);
    }

    @Override
    public void saveBasicProgram() {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        BasicType basicType = null;
        SaveDlg.BasicType basicType2 = SaveDlg.BasicType.NO_BASIC;
        String string = "BASIC-Programm speichern";
        int n3 = -1;
        if (this.lastBasicType != null) {
            switch (this.lastBasicType) {
                case AC1_MINI: {
                    string = "Mini-BASIC-Programm speichern";
                    n3 = 0;
                    break;
                }
                case AC1_8K: 
                case SCCH: 
                case ADDR_60F7: {
                    n3 = 1;
                    break;
                }
                case AC1_12K: {
                    n3 = 2;
                    break;
                }
                case AC1_BASIC6: {
                    n3 = 3;
                    break;
                }
                case BACOBAS2: 
                case BACOBAS3: {
                    n3 = 4;
                }
            }
        }
        if (n3 < 0 && this.modeSCCH) {
            n3 = 1;
        }
        String string2 = null;
        FileFilter fileFilter = null;
        switch (OptionDlg.showOptionDlg(this.screenFrm, "W\u00e4hlen Sie bitte den BASIC-Interpreter aus,\ndessen BASIC-Programm gespeichert werden soll.", "BASIC-Interpreter", n3, "Mini-BASIC", "AC1-8K-BASIC oder SCCH-BASIC", "AC1-12K-BASIC", "AC1-BASIC6", "BACOBAS")) {
            case 0: {
                basicType = BasicType.AC1_MINI;
                basicType2 = SaveDlg.BasicType.TINYBASIC;
                n = 6336;
                n2 = this.emuThread.getMemWord(6377);
                break;
            }
            case 1: {
                basicType = this.lastBasicType;
                if (basicType != BasicType.AC1_8K && basicType != BasicType.SCCH) {
                    basicType = BasicType.ADDR_60F7;
                }
                basicType2 = SaveDlg.BasicType.MS_DERIVED_BASIC;
                n = 24823;
                n2 = SourceUtil.getBasicEndAddr(this.emuThread, n);
                string2 = "BASIC-Programmdatei (*.bas)";
                fileFilter = EmuUtil.getBasicFileFilter();
                break;
            }
            case 2: {
                basicType = BasicType.AC1_12K;
                basicType2 = SaveDlg.BasicType.MS_DERIVED_BASIC;
                n = 28599;
                n2 = SourceUtil.getBasicEndAddr(this.emuThread, n);
                string2 = "BASIC-Programmdatei (*.bas)";
                fileFilter = EmuUtil.getBasicFileFilter();
                break;
            }
            case 3: {
                basicType = BasicType.AC1_BASIC6;
                basicType2 = SaveDlg.BasicType.MS_DERIVED_BASIC;
                n = 25344;
                n2 = SourceUtil.getBasicEndAddr(this.emuThread, n);
                string2 = "AC1-BASIC6-Programmdatei (*.abc)";
                fileFilter = EmuUtil.getAC1Basic6FileFilter();
                break;
            }
            case 4: {
                basicType = BasicType.BACOBAS3;
                basicType2 = SaveDlg.BasicType.MS_DERIVED_BASIC;
                n = 24823;
                n2 = SourceUtil.getBasicEndAddr(this.emuThread, n);
                string2 = "BASIC-Programmdatei (*.bas)";
                fileFilter = EmuUtil.getBasicFileFilter();
                break;
            }
            default: {
                bl = true;
            }
        }
        if (!bl) {
            if (n > 0 && n2 > n) {
                this.lastBasicType = basicType;
                new SaveDlg(this.screenFrm, n, n2, "BASIC-Programm speichern", basicType2, fileFilter).setVisible(true);
            } else {
                this.showNoBasic();
            }
        }
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.fdDrives != null && n >= 0 && n < this.fdDrives.length) {
            this.fdDrives[n] = floppyDiskDrive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJoystickAction(int n, int n2) {
        if (this.joystickEnabled && n == 0) {
            int n3 = 0;
            if ((n2 & 4) != 0) {
                n3 |= 1;
            }
            if ((n2 & 8) != 0) {
                n3 |= 2;
            }
            if ((n2 & 1) != 0) {
                n3 |= 4;
            }
            if ((n2 & 2) != 0) {
                n3 |= 8;
            }
            if ((n2 & 0x30) != 0) {
                n3 |= 0x10;
            }
            this.joystickValue = n3;
            Z80PIO z80PIO = this.pio1;
            synchronized (z80PIO) {
                if (this.joystickSelected) {
                    this.pio1.putInValuePortA(this.joystickValue, 255);
                }
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        n &= 0xFFFF;
        boolean bl = false;
        boolean bl2 = false;
        if (this.modeSCCH) {
            n3 = this.setScchMemByte(n, n2);
            bl2 = n3 >= 0;
            boolean bl3 = bl = n3 > 0;
            if (!bl2 && n < 4096) {
                this.emuThread.setRAMByte(n, n2);
                bl2 = true;
                bl = true;
            }
        }
        if (!bl2 && !this.lowerDRAMEnabled && n < 8192) {
            if (n < 4096) {
                if (!this.osRomEnabled) {
                    this.emuThread.setRAMByte(n, n2);
                    bl = true;
                }
            } else if (n >= 4096 && n < 6144) {
                n3 = n - 4096;
                if (this.ramColor != null && (this.regF0 & 4) != 0) {
                    if (n3 < this.ramColor.length) {
                        this.ramColor[n3] = (byte)n2;
                        this.screenFrm.setScreenDirty(true);
                        bl = true;
                    }
                } else if (n3 < this.ramVideo.length) {
                    this.ramVideo[n3] = (byte)n2;
                    this.screenFrm.setScreenDirty(true);
                    bl = true;
                }
            } else if (n >= 6144 && n < 8192 && (n3 = n - 6144) < this.ramStatic.length) {
                this.ramStatic[n3] = (byte)n2;
                bl = true;
            }
            bl2 = true;
        }
        if (!bl2 && !this.mode64x16) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.extFont;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return this.pio2 != null;
    }

    @Override
    public boolean supportsRAMFloppy1() {
        return this.ramFloppy != null;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        if (fileFormat != null) {
            int n4;
            if ((fileFormat.equals(FileFormat.BASIC_PRG) && n == 24823 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 24823 && n + n2 > 24830) && (n4 = SourceUtil.getBasicEndAddr(this.emuThread, 24823) + 1) > 24823) {
                this.emuThread.setMemWord(24786, n4);
                this.emuThread.setMemWord(24788, n4);
                this.emuThread.setMemWord(24790, n4);
            }
            if (fileFormat.equals(FileFormat.BASIC_PRG) && n == 25344 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 25344 && n + n2 > 25351) {
                n4 = SourceUtil.getBasicEndAddr(this.emuThread, 25344) + 1;
                if (n4 > 25344) {
                    this.emuThread.setMemWord(24744, n4);
                    this.emuThread.setMemWord(24746, n4);
                    this.emuThread.setMemWord(24748, n4);
                }
            } else if ((fileFormat.equals(FileFormat.BASIC_PRG) && n == 28599 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n > 24823 && n <= 28599 && n + n2 > 28606) && (n4 = SourceUtil.getBasicEndAddr(this.emuThread, 28599) + 1) > 28599) {
                this.emuThread.setMemWord(16734, n4);
                this.emuThread.setMemWord(16736, n4);
                this.emuThread.setMemWord(16738, n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        n2 &= 0xFF;
        if (this.gide != null && (n & 0xF0) == 128) {
            this.gide.write(n, n2);
        } else if ((n & 0xF8) == 224) {
            if (this.ramFloppy != null) {
                this.ramFloppy.writeByte(n & 7, n2);
            }
        } else {
            block4 : switch (n & 0xFF) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.ctc.write(n & 3, n2, n3);
                    this.ctcWritten = true;
                    break;
                }
                case 4: {
                    this.pio1.writeDataA(n2);
                    break;
                }
                case 5: {
                    this.pio1.writeDataB(n2);
                    Z80PIO z80PIO = this.pio1;
                    synchronized (z80PIO) {
                        boolean bl;
                        int n4 = this.pio1.fetchOutValuePortB(false);
                        this.soundOutPhase = (n4 & 1) != 0;
                        boolean bl2 = this.tapeOutPhase = (n4 & 0x40) != 0;
                        if (this.joystickEnabled) {
                            boolean bl3 = bl = (n4 & 2) == 0;
                            if (bl != this.joystickSelected) {
                                this.joystickSelected = bl;
                                this.pio1.putInValuePortA(bl ? this.joystickValue : this.keyboardValue, 255);
                            }
                        }
                        if (this.fontSwitchable) {
                            boolean bl4 = bl = (n4 & 8) != 0;
                            if (this.colors != null) {
                                boolean bl5 = bl = (n2 & 8) != 0;
                            }
                            if (bl != this.pio1B3State) {
                                int n5 = 0;
                                if (this.fontBytes != null && bl && this.fontBytes.length > 2048) {
                                    n5 = 2048;
                                }
                                if (n5 != this.fontOffs) {
                                    this.fontOffs = n5;
                                    this.screenFrm.setScreenDirty(true);
                                }
                                this.pio1B3State = bl;
                            }
                        } else if (this.mode2010) {
                            boolean bl6 = bl = (n4 & 8) != 0;
                            if (bl != this.pio1B3State) {
                                this.inverseBySW = bl;
                                this.pio1B3State = bl;
                                this.screenFrm.setScreenDirty(true);
                            }
                        }
                        break;
                    }
                }
                case 6: {
                    this.pio1.writeControlA(n2);
                    break;
                }
                case 7: {
                    this.pio1.writeControlB(n2);
                    break;
                }
                case 8: {
                    if (this.pio2 == null) break;
                    this.pio2.writeDataA(n2);
                    AC1 aC1 = this;
                    synchronized (aC1) {
                        boolean bl;
                        boolean bl7 = bl = (this.pio2.fetchOutValuePortA(false) & 2) != 0;
                        if (!bl && this.v24BitOut && this.v24BitNum == 0) {
                            this.v24ShiftBuf = 0;
                            this.v24TStateCounter = 3 * this.v24TStatesPerBit / 2;
                            ++this.v24BitNum;
                        }
                        this.v24BitOut = bl;
                    }
                    this.pio2.writeDataA(n2);
                    break;
                }
                case 9: {
                    if (this.pio2 == null) break;
                    this.pio2.writeDataB(n2);
                    break;
                }
                case 10: {
                    if (this.pio2 == null) break;
                    this.pio2.writeControlA(n2);
                    break;
                }
                case 11: {
                    if (this.pio2 == null) break;
                    this.pio2.writeControlB(n2);
                    break;
                }
                case 14: {
                    if (!this.mode2010) break;
                    if (n2 >= 240) {
                        int n6 = n2 & 0xF;
                        int n7 = 0;
                        for (int i = 0; i < n6; ++i) {
                            n7 += romBank2010SegLengths[i];
                        }
                        this.romBank2010Len = romBank2010SegLengths[n6];
                        this.romBank2010Offs = n7;
                        break;
                    }
                    this.romBank2010Len = 0;
                    this.romBank2010Offs = -1;
                    break;
                }
                case 15: {
                    if (!this.mode2010) break;
                    switch (n2 & 0x70) {
                        case 16: {
                            this.pio2Rom2010Offs = 0;
                            break block4;
                        }
                        case 32: {
                            this.pio2Rom2010Offs = 2048;
                            break block4;
                        }
                        case 64: {
                            this.pio2Rom2010Offs = 4096;
                            break block4;
                        }
                        case 96: {
                            this.pio2Rom2010Offs = 6144;
                            break block4;
                        }
                    }
                    this.pio2Rom2010Offs = -1;
                    break;
                }
                case 20: {
                    if (!this.modeSCCH) break;
                    this.scchBasicRomEnabled = (n2 & 2) != 0;
                    this.lowerDRAMEnabled = (n2 & 4) != 0;
                    boolean bl = this.scchRomdiskEnabled = (n2 & 8) != 0;
                    if (this.scchRomdiskEnabled) {
                        int n8 = n2 & 1 | n2 >> 3 & 0xE;
                        this.scchRomdiskBankAddr = this.scchRomdiskBegAddr == 32768 ? n8 << 15 : n8 << 14;
                        this.scchPrgXRomEnabled = false;
                        break;
                    }
                    this.scchPrgXRomEnabled = (n2 & 1) != 0;
                    break;
                }
                case 21: {
                    if (!this.modeSCCH) break;
                    this.rfAddr16to19 = n2 << 16 & 0xF0000;
                    this.rf32NegA15 = (n2 & 0x10) != 0;
                    this.rf32KActive = (n2 & 0x20) != 0;
                    this.rfReadEnabled = (n2 & 0x40) != 0;
                    this.rfWriteEnabled = (n2 & 0x80) != 0;
                    break;
                }
                case 22: {
                    if (!this.modeSCCH) break;
                    this.osRomEnabled = false;
                    break;
                }
                case 23: {
                    if (!this.modeSCCH) break;
                    this.osRomEnabled = true;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    if (this.mode64x16) break;
                    this.lowerDRAMEnabled = (n2 & 1) != 0;
                    break;
                }
                case 65: {
                    if (this.fdc == null) break;
                    this.fdc.write(n2);
                    this.tcEnabled = true;
                    break;
                }
                case 66: 
                case 67: {
                    if (this.fdc == null || !this.fdcWaitEnabled) break;
                    Z80CPU z80CPU = this.emuThread.getZ80CPU();
                    for (int i = z80CPU.getMaxSpeedKHz() / 50; !this.fdc.isInterruptRequest() && i > 0; i -= 4) {
                        this.z80TStatesProcessed(z80CPU, 4);
                    }
                    break;
                }
                case 68: 
                case 69: {
                    if (this.fdc == null) break;
                    boolean bl = this.fdcWaitEnabled = (n2 & 2) != 0;
                    if ((n2 & 0x10) == 0 || !this.tcEnabled) break;
                    this.fdc.fireTC();
                    this.tcEnabled = false;
                    break;
                }
                case 72: 
                case 73: {
                    if (this.fdc == null || !this.tcEnabled) break;
                    this.fdc.fireTC();
                    this.tcEnabled = false;
                    break;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    if (this.kcNet == null) break;
                    this.kcNet.write(n, n2);
                    break;
                }
                case 240: {
                    if (this.colors == null) break;
                    Z80CPU z80CPU = this.emuThread.getZ80CPU();
                    if ((n2 & 1) != 0) {
                        if ((this.regF0 & 1) == 0 && z80CPU.getMaxSpeedKHz() == 2000) {
                            z80CPU.setMaxSpeedKHz(4000);
                        }
                    } else if ((this.regF0 & 1) != 0 && z80CPU.getMaxSpeedKHz() == 4000) {
                        z80CPU.setMaxSpeedKHz(2000);
                    }
                    if ((n2 & 2) != (this.regF0 & 2)) {
                        this.inverseBySW = (n2 & 2) != 0;
                        this.screenFrm.setScreenDirty(true);
                    }
                    this.regF0 = n2;
                    break;
                }
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    if (this.vdip == null) break;
                    this.vdip.write(n, n2);
                }
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.audioInPhase) {
            this.audioInPhase = bl;
            this.pio1.putInValuePortB(this.audioInPhase ? 128 : 0, 128);
        }
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
        if (this.v24BitNum > 0) {
            AC1 aC1 = this;
            synchronized (aC1) {
                this.v24TStateCounter -= n;
                if (this.v24TStateCounter < 0) {
                    if (this.v24BitNum > 8) {
                        this.emuThread.getPrintMngr().putByte(this.v24ShiftBuf);
                        this.v24BitNum = 0;
                    } else {
                        this.v24ShiftBuf >>= 1;
                        if (this.v24BitOut) {
                            this.v24ShiftBuf |= 0x80;
                        }
                        this.v24TStateCounter = this.v24TStatesPerBit;
                        ++this.v24BitNum;
                    }
                }
            }
        }
        if (this.ctcM1ToClk2 && !this.ctcWritten) {
            while (n > 0 && this.m1Cnt > 0) {
                this.ctc.externalUpdate(2, false);
                int n2 = Math.min(n, 3);
                if (n2 > 0) {
                    this.ctc.z80TStatesProcessed(z80CPU, n2);
                    n -= n2;
                }
                this.ctc.externalUpdate(2, true);
                if (n > 0) {
                    this.ctc.z80TStatesProcessed(z80CPU, 1);
                    --n;
                }
                --this.m1Cnt;
            }
            if (n > 0) {
                this.ctc.z80TStatesProcessed(z80CPU, n);
            }
            this.m1Cnt = 0;
        } else {
            this.ctc.z80TStatesProcessed(z80CPU, n);
            this.ctcWritten = false;
        }
    }

    private void createColors(Properties properties) {
        float f = AC1.getBrightness(properties);
        if (this.colors != null && f >= 0.0f && f <= 1.0f) {
            for (int i = 0; i < this.colors.length; ++i) {
                int n = Math.round((float)((i & 8) != 0 ? 255 : 160) * f);
                this.colors[i] = new Color((i & 1) != 0 ? n : 0, (i & 2) != 0 ? n : 0, (i & 4) != 0 ? n : 0);
            }
        }
    }

    private boolean emulatesColors(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "color", false);
    }

    private boolean emulatesM1ToCtcClk2(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_M1_TO_CTC_CLK2, false);
    }

    private void loadFont(Properties properties) {
        this.extFont = true;
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", this.fontSwitchable ? 4096 : 2048);
        if (this.fontBytes == null) {
            this.extFont = false;
            if (this.fontSwitchable) {
                byte[] byArray = null;
                if (this.mode2010) {
                    if (font2010 == null) {
                        font2010 = this.readResource("/rom/ac1/font2010.bin");
                    }
                    byArray = font2010;
                } else {
                    if (fontSCCH == null) {
                        fontSCCH = this.readResource("/rom/ac1/scchfont.bin");
                    }
                    byArray = fontSCCH;
                }
                if (fontACC == null) {
                    fontACC = this.readResource("/rom/ac1/accfont.bin");
                }
                if (byArray != null && fontACC != null) {
                    byte[] byArray2 = new byte[4096];
                    Arrays.fill(byArray2, (byte)0);
                    System.arraycopy(fontACC, 0, byArray2, 0, Math.min(fontACC.length, 2048));
                    System.arraycopy(byArray, 0, byArray2, 2048, Math.min(byArray.length, 2048));
                    this.fontBytes = byArray2;
                } else {
                    this.fontBytes = byArray != null ? byArray : fontACC;
                }
            } else if (this.mode64x16) {
                if (fontU402 == null) {
                    fontU402 = this.readResource("/rom/ac1/u402bm513x4.bin");
                }
                this.fontBytes = fontU402;
            } else if (this.modeSCCH) {
                if (fontSCCH == null) {
                    fontSCCH = this.readResource("/rom/ac1/scchfont.bin");
                }
                this.fontBytes = fontSCCH;
            } else if (this.mode2010) {
                if (font2010 == null) {
                    font2010 = this.readResource("/rom/ac1/font2010.bin");
                }
                this.fontBytes = font2010;
            } else {
                if (fontACC == null) {
                    fontACC = this.readResource("/rom/ac1/accfont.bin");
                }
                this.fontBytes = fontACC;
            }
        }
    }

    private static enum BasicType {
        AC1_MINI,
        AC1_8K,
        AC1_12K,
        AC1_BASIC6,
        SCCH,
        BACOBAS2,
        BACOBAS3,
        ADDR_60F7;

    }
}

