/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.SaveDlg;
import jkcemu.emusys.bcs3.BCS3KeyboardFld;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;

public class BCS3
extends EmuSys
implements Z80CTCListener {
    public static final String SYSNAME = "BCS3";
    public static final String PROP_PREFIX = "jkcemu.bcs3.";
    public static final String PROP_RAM_KBYTE = "ram.kbyte";
    public static final String PROP_REMOVE_HSYNC_FROM_AUDIO = "remove_hsync_from_audio";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 300;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    public static final String VALUE_OS_VERSION_24 = "2.4";
    public static final String VALUE_OS_VERSION_31_29 = "3.1_29";
    public static final String VALUE_OS_VERSION_31_40 = "3.1_40";
    public static final String VALUE_OS_VERSION_33 = "3.3";
    private static final String[] se24Tokens = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "THEN", "AND", null, null, null, "OR", "PEEK(", null, "IN(", "RND(", null, null, "BYTE", "END", null, "REM", null, "GOSUB", null, "CLEAR", null, "IF", null, "INPUT", null, "PRINT", null, "RETURN", null, "GOTO", null, "RUN", null, "LIST", null, "LET", null, "LOAD", null, "SAVE", null, "POKE", null, "OUT", null, "NEW", null};
    private static final String[] se31Tokens = new String[]{"LEN(", null, "INT(", null, "USR(", null, null, null, "INKEY$", null, "STEP", null, "TO", null, "CHR$", null, "THEN", null, "AND", null, "OR", null, "PEEK(", null, "IN(", null, "RND", null, null, null, "END", null, "REM", null, "GOSUB", null, "CLS", null, "IF", null, "INPUT", null, "PRINT", null, "RESTORE", null, "RETURN", null, "GOTO", null, "RUN", null, "LIST", null, "LET", null, "LOAD", null, "SAVE", null, "POKE", null, "OUT", null, "FOR", null, "NEXT", null, "DIM", null, "PLOT", null, "UNPLOT", null, "NEW", null, "READ", null, "DATA", null};
    private static final String[] sp33Tokens = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, "USR(", "RND(", "PEEK(", "LEN(", "INT(", "INKEY$", "IN(", "CHR$(", "ASC(", "OR", "AND", "THEN", "STEP", "TO", "END", null, "REM", null, "GOSUB", null, "CLS", null, "IF", null, "INPUT", null, "PRINT", null, "RESTORE", null, "RETURN", null, "GOTO", null, "CALL", null, "RUN", null, "LIST", null, "LET", null, "LOAD", null, "SAVE", null, "POKE", null, "OUT", null, "FOR", null, "NEXT", null, "DIM", null, "PLOT", null, "UNPLOT", null, "NEW", null, "RANDOMIZE", null, "READ", null, "DATA", null};
    private static int SCREEN_CHARS_PER_ROW_MAX = 42;
    private static int SCREEN_HIDDEN_LINES = 60;
    private static int SCREEN_HEIGHT = 320;
    private static int[] endInstBytesSE24 = new int[]{15, 39, 222, 30};
    private static int[] endInstBytesSE31 = new int[]{15, 39, 206, 30};
    private static int[] endInstBytesSP33 = new int[]{0, 39, 202, 30};
    private static byte[] fontBytesSE24 = null;
    private static byte[] fontBytesSE31 = null;
    private static byte[] fontBytesSP33 = null;
    private static byte[] osBytesSE24 = null;
    private static byte[] osBytesSE31_29 = null;
    private static byte[] osBytesSE31_40 = null;
    private static byte[] osBytesSP33_29 = null;
    private static byte[] mcEdtitorSE31 = null;
    private Z80CTC ctc;
    private String osFile = null;
    private byte[] osBytes = null;
    private byte[] fontBytes = null;
    private byte[] screenChars;
    private byte[] screenPixelsWriting;
    private byte[] screenPixelsVisible;
    private byte[] romF000 = null;
    private byte[] ram;
    private int ramEndAddr;
    private int osVersion;
    private int screenActiveTStates;
    private int screenColCnt;
    private int screenColNum;
    private int screenRowNum;
    private int screenLineNum;
    private int screenLineInChar;
    private int screenChar0Y;
    private int screenChar1Y;
    private int[] kbMatrix;
    private long lastTapeOutTStates;
    private boolean lastTapeOutPhase;
    private boolean removeHSyncFromAudio;
    private volatile boolean screenEnabled;
    private CharRaster charRaster;
    private BCS3KeyboardFld keyboardFld;

    public BCS3(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        String string;
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        if ((string = EmuUtil.getProperty(properties, this.propPrefix + "os.version")).equals(VALUE_OS_VERSION_31_29)) {
            this.osVersion = 31;
            if (this.osBytes == null) {
                if (osBytesSE31_29 == null) {
                    osBytesSE31_29 = this.readResource("/rom/bcs3/se31_29.bin");
                }
                this.osBytes = osBytesSE31_29;
            }
            if (this.romF000 == null) {
                if (mcEdtitorSE31 == null) {
                    mcEdtitorSE31 = this.readResource("/rom/bcs3/se31mceditor.bin");
                }
                this.romF000 = mcEdtitorSE31;
            }
        } else if (string.equals(VALUE_OS_VERSION_31_40)) {
            this.osVersion = 31;
            if (this.osBytes == null) {
                if (osBytesSE31_40 == null) {
                    osBytesSE31_40 = this.readResource("/rom/bcs3/se31_40.bin");
                }
                this.osBytes = osBytesSE31_40;
            }
        } else if (string.equals(VALUE_OS_VERSION_33)) {
            this.osVersion = 33;
            if (this.osBytes == null) {
                if (osBytesSP33_29 == null) {
                    osBytesSP33_29 = this.readResource("/rom/bcs3/sp33_29.bin");
                }
                this.osBytes = osBytesSP33_29;
            }
        } else {
            this.osVersion = 24;
            if (this.osBytes == null) {
                if (osBytesSE24 == null) {
                    osBytesSE24 = this.readResource("/rom/bcs3/se24.bin");
                }
                this.osBytes = osBytesSE24;
            }
        }
        this.ram = new byte[1024];
        this.ramEndAddr = BCS3.getRAMEndAddr(properties);
        this.kbMatrix = new int[10];
        this.screenEnabled = false;
        this.screenActiveTStates = 0;
        this.screenColCnt = 0;
        this.screenColNum = 0;
        this.screenRowNum = -1;
        this.screenLineNum = 0;
        this.screenLineInChar = 0;
        this.screenChar0Y = -1;
        this.screenChar1Y = -1;
        this.lastTapeOutTStates = 0L;
        this.lastTapeOutPhase = false;
        this.removeHSyncFromAudio = BCS3.getRemoveHSyncFromAudio(properties);
        this.charRaster = null;
        this.keyboardFld = null;
        this.screenPixelsVisible = new byte[(SCREEN_HEIGHT - SCREEN_HIDDEN_LINES) * SCREEN_CHARS_PER_ROW_MAX];
        this.screenPixelsWriting = new byte[this.screenPixelsVisible.length];
        this.screenChars = new byte[this.screenPixelsWriting.length / 8];
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.ctc = new Z80CTC("CTC");
        z80CPU.setInterruptSources(this.ctc);
        this.ctc.setTimerConnection(0, 1);
        this.ctc.setTimerConnection(1, 2);
        this.ctc.addCTCListener(this);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
    }

    public static String getBasicProgram(byte[] byArray) {
        String string = null;
        if (byArray != null) {
            int n;
            String[] stringArray = null;
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < byArray.length - 3) {
                if (BCS3.equalsRange(byArray, n4, endInstBytesSE24)) {
                    stringArray = se24Tokens;
                    n2 = 9999;
                    break;
                }
                if (BCS3.equalsRange(byArray, n4, endInstBytesSE31)) {
                    stringArray = se31Tokens;
                    n2 = 9999;
                    break;
                }
                if (BCS3.equalsRange(byArray, n4, endInstBytesSP33)) {
                    stringArray = sp33Tokens;
                    n2 = 9984;
                    break;
                }
                n = EmuUtil.getWord(byArray, n4);
                if (n <= n3) break;
                n4 += 2;
                boolean bl = false;
                while (!bl && n4 < byArray.length) {
                    if (byArray[n4++] != 30) continue;
                    bl = true;
                }
                if (!bl) break;
                n3 = n;
            }
            if (stringArray != null && n2 > 0 && (n = EmuUtil.getWord(byArray, n4 = 0)) >= 0 && n < n2) {
                StringBuilder stringBuilder = new StringBuilder(8192);
                while (n >= 0 && n <= n2) {
                    stringBuilder.append(n);
                    n4 += 2;
                    boolean bl = false;
                    boolean bl2 = true;
                    int n5 = byArray[n4++] & 0xFF;
                    while (n5 != 0 && n5 != 30) {
                        String string2;
                        int n6;
                        if (bl2) {
                            stringBuilder.append(' ');
                            bl = false;
                            bl2 = false;
                        }
                        if (n5 >= 176 && (n6 = n5 - 176) >= 0 && n6 < stringArray.length && (string2 = stringArray[n6]) != null) {
                            int n7 = string2.length();
                            if (n7 > 0) {
                                if (BCS3.isIdentifierChar(stringBuilder.charAt(stringBuilder.length() - 1)) && BCS3.isIdentifierChar(string2.charAt(0))) {
                                    stringBuilder.append(' ');
                                }
                                stringBuilder.append(string2);
                                bl = BCS3.isIdentifierChar(string2.charAt(n7 - 1));
                            }
                            n5 = 0;
                        }
                        if (n5 != 0) {
                            if (bl && (BCS3.isIdentifierChar(n5) || n5 == 39 || n5 == 34)) {
                                stringBuilder.append(' ');
                            }
                            stringBuilder.append((char)n5);
                            bl = false;
                        }
                        n5 = byArray[n4++] & 0xFF;
                    }
                    stringBuilder.append('\n');
                    if (n5 == 0 || n == n2) break;
                    n = EmuUtil.getWord(byArray, n4);
                }
                if (stringBuilder.length() > 0) {
                    string = stringBuilder.toString();
                }
            }
        }
        return string;
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.bcs3.os.version").equals(VALUE_OS_VERSION_31_40) ? 3500 : 2500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc) {
            switch (n) {
                case 0: {
                    if (this.screenLineNum == 0 && this.screenRowNum >= 0) {
                        int n2 = this.screenRowNum * SCREEN_CHARS_PER_ROW_MAX + this.screenColNum;
                        while (n2 < this.screenChars.length && this.screenColNum < SCREEN_CHARS_PER_ROW_MAX) {
                            this.screenChars[n2++] = 32;
                            ++this.screenColNum;
                        }
                    }
                    this.screenColNum = 0;
                    if (this.screenLineNum < SCREEN_HEIGHT) {
                        ++this.screenLineNum;
                    }
                    this.screenLineInChar = this.screenLineInChar < 7 ? ++this.screenLineInChar : 0;
                    this.updTapeOutPhase((this.screenLineInChar & 1) != 0);
                    this.emuThread.getZ80CPU().setWaitMode(false);
                    break;
                }
                case 1: {
                    this.screenLineInChar = 0;
                    this.updTapeOutPhase((this.screenLineInChar & 1) != 0);
                    break;
                }
                case 2: {
                    int n3;
                    if (this.screenRowNum >= 0) {
                        n3 = this.screenRowNum * SCREEN_CHARS_PER_ROW_MAX + this.screenColNum;
                        if (n3 < this.screenChars.length) {
                            Arrays.fill(this.screenChars, n3, this.screenChars.length, (byte)32);
                        }
                    } else {
                        Arrays.fill(this.screenChars, (byte)32);
                    }
                    n3 = 0;
                    int n4 = this.screenRowNum + 1;
                    int n5 = this.screenChar1Y - this.screenChar0Y;
                    int n6 = this.screenChar0Y - SCREEN_HIDDEN_LINES - 6;
                    BCS3 bCS3 = this;
                    synchronized (bCS3) {
                        byte[] byArray = this.screenPixelsVisible;
                        this.screenPixelsVisible = this.screenPixelsWriting;
                        this.screenPixelsWriting = byArray;
                        if (this.charRaster != null && (this.charRaster.getColCount() != this.screenColCnt || this.charRaster.getRowCount() != n4 || this.charRaster.getRowHeight() != n5 || this.charRaster.getTopLine() != n6)) {
                            n3 = 1;
                        }
                        if ((n3 != 0 || this.charRaster == null) && this.screenColCnt > 0 && n4 > 0 && n5 > 0) {
                            if (this.charRaster == null) {
                                n3 = 1;
                            }
                            this.charRaster = new CharRaster(this.screenColCnt, n4, n5, Math.min(n5, 8), 8, n6);
                        }
                    }
                    this.screenColCnt = 0;
                    this.screenColNum = 0;
                    this.screenRowNum = -1;
                    this.screenLineNum = 0;
                    this.screenChar0Y = -1;
                    this.screenChar1Y = -1;
                    Arrays.fill(this.screenPixelsWriting, (byte)0);
                    this.screenActiveTStates = 100000;
                    this.screenEnabled = true;
                    this.screenFrm.setScreenDirty(true);
                    if (n3 == 0) break;
                    this.screenFrm.clearScreenSelection();
                    this.screenFrm.fireUpdScreenTextActionsEnabled();
                }
            }
        }
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.loadFont(properties);
        this.removeHSyncFromAudio = BCS3.getRemoveHSyncFromAudio(properties);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.osFile, EmuUtil.getProperty(properties, this.propPrefix + "os.file"));
        }
        if (bl) {
            String string = EmuUtil.getProperty(properties, this.propPrefix + "os.version");
            if (string.equals(VALUE_OS_VERSION_31_29)) {
                if (this.osBytes != osBytesSE31_29) {
                    bl = false;
                }
            } else if (string.equals(VALUE_OS_VERSION_31_40)) {
                if (this.osBytes != osBytesSE31_40) {
                    bl = false;
                }
            } else if (string.equals(VALUE_OS_VERSION_33)) {
                if (this.osBytes != osBytesSP33_29) {
                    bl = false;
                }
            } else if (this.osBytes != osBytesSE24) {
                bl = false;
            }
        }
        if (bl && BCS3.getRAMEndAddr(properties) != this.ramEndAddr) {
            bl = false;
        }
        return bl;
    }

    @Override
    public synchronized boolean canExtractScreenText() {
        return this.charRaster != null;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new BCS3KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        this.ctc.removeCTCListener(this);
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
    }

    @Override
    public int getAppStartStackInitValue() {
        return this.osBytes == osBytesSE24 ? 15440 : 15488;
    }

    @Override
    public int getBorderColorIndex() {
        return this.screenEnabled ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 1;
        if (this.screenEnabled) {
            BCS3 bCS3 = this;
            synchronized (bCS3) {
                int n4 = n / 8;
                int n5 = n2 * SCREEN_CHARS_PER_ROW_MAX + n4;
                if (n5 >= 0 && n5 < this.screenPixelsVisible.length) {
                    int n6 = 128;
                    int n7 = n % 8;
                    if (n7 > 0) {
                        n6 >>= n7;
                    }
                    if ((this.screenPixelsVisible[n5] & n6) != 0) {
                        n3 = 0;
                    }
                }
            }
        } else {
            n3 = 0;
        }
        return n3;
    }

    @Override
    public synchronized CharRaster getCurScreenCharRaster() {
        return this.charRaster;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 80L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 200L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 60L;
    }

    @Override
    public String getHelpPage() {
        return "/help/bcs3.htm";
    }

    @Override
    public Integer getLoadAddr() {
        Integer n = null;
        if (this.osBytes == osBytesSE24) {
            n = 15777;
        } else if (this.osBytes == osBytesSE31_29 || this.osBytes == osBytesSE31_40 || this.osBytes == osBytesSP33_29) {
            n = this.getMemWord(15360);
        }
        return n;
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        int n3 = 15;
        if ((n &= 0xFFFF) < 16384) {
            if ((n &= 0xDFFF) >= 4096 && n < 5120) {
                n3 = 0;
                int n4 = ~n;
                int n5 = 1;
                for (int i = 0; i < this.kbMatrix.length; ++i) {
                    if ((n4 & n5) != 0) {
                        n3 |= this.kbMatrix[i];
                    }
                    n5 <<= 1;
                }
                n3 = this.emuThread.readTapeInPhase() ? (n3 |= 0x80) : (n3 &= 0x7F);
            } else if (n >= 6144 && n < 7168) {
                int n6;
                n3 = 0;
                int n7 = n - 6144;
                if (n7 >= 0 && n7 < this.ram.length && ((n6 = this.ram[n7] & 0xFF) & 0x80) != 0) {
                    n3 = n6;
                }
            } else if (n >= 7168 && n < 8192) {
                int n8 = n - 7168;
                if (n8 >= 0 && n8 < this.ram.length) {
                    n3 = this.ram[n8] & 0xFF;
                }
            } else if (this.osBytes != null && n < this.osBytes.length) {
                n3 = this.osBytes[n] & 0xFF;
            }
        } else if (n <= this.ramEndAddr) {
            n3 = this.emuThread.getRAMByte(n);
        } else if (n >= 61440 && this.romF000 != null && (n2 = n - 61440) < this.romF000.length) {
            n3 = this.romF000[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = n2 * SCREEN_CHARS_PER_ROW_MAX + n;
        if (n5 >= 0 && n5 < this.screenChars.length) {
            n4 = this.screenChars[n5] & 0xFF;
        }
        if (n4 >= 0 && n4 < 16) {
            if (this.osVersion < 32) {
                n3 = 32;
            }
        } else if (n4 >= 10 && n4 < 32) {
            if (this.osVersion < 32) {
                n3 = 32;
            } else {
                switch (n4) {
                    case 20: {
                        n3 = 9829;
                        break;
                    }
                    case 21: {
                        n3 = 9824;
                        break;
                    }
                    case 22: {
                        n3 = 9830;
                        break;
                    }
                    case 23: {
                        n3 = 9827;
                        break;
                    }
                    case 24: {
                        n3 = 9679;
                        break;
                    }
                    case 25: {
                        n3 = 9698;
                        break;
                    }
                    case 26: {
                        n3 = 9701;
                        break;
                    }
                    case 27: {
                        n3 = 9700;
                        break;
                    }
                    case 28: {
                        n3 = 9699;
                        break;
                    }
                    case 29: {
                        n3 = 9633;
                        break;
                    }
                    case 30: {
                        n3 = 32;
                        break;
                    }
                    case 31: {
                        n3 = 937;
                    }
                }
            }
        } else if (n4 >= 32 && n4 <= 127) {
            switch (n4) {
                case 93: {
                    if (this.osVersion < 32) break;
                    n3 = 93;
                    break;
                }
                case 95: {
                    break;
                }
                case 96: {
                    if (this.osVersion < 32) {
                        n3 = 32;
                        break;
                    }
                    n3 = n4;
                    break;
                }
                case 123: {
                    n3 = 228;
                    break;
                }
                case 124: {
                    n3 = 246;
                    break;
                }
                case 125: {
                    n3 = 252;
                    break;
                }
                case 126: {
                    n3 = 124;
                    break;
                }
                case 127: {
                    if (this.osVersion < 32) {
                        n3 = 9632;
                        break;
                    }
                    n3 = 183;
                    break;
                }
                default: {
                    n3 = n4;
                }
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return SCREEN_HEIGHT - SCREEN_HIDDEN_LINES;
    }

    @Override
    public int getScreenWidth() {
        return SCREEN_CHARS_PER_ROW_MAX * 8;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 8: 
            case 37: {
                this.kbMatrix[7] = 1;
                bl3 = true;
                break;
            }
            case 10: {
                this.kbMatrix[8] = 1;
                bl3 = true;
                break;
            }
            case 32: {
                this.kbMatrix[6] = 1;
                bl3 = true;
            }
        }
        if (bl3) {
            this.updKeyboardFld();
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        Arrays.fill(this.kbMatrix, 0);
        this.updKeyboardFld();
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = 0;
        if (c >= ' ' && c <= ')') {
            n = c - 32;
            n2 = 8;
            bl2 = true;
        } else if (c >= ')' && c <= '/') {
            n = c - 38;
            n2 = 4;
            bl2 = true;
        } else if (c >= '0' && c <= '9') {
            n = c - 48;
            n2 = 8;
        } else if (c >= ':' && c <= '@') {
            n = c - 58;
            n2 = 2;
            bl2 = true;
        } else {
            if (c >= 'a' && c <= 'z') {
                c = Character.toUpperCase(c);
            }
            if (c >= 'A' && c <= 'J') {
                n = c - 65;
                n2 = 4;
            } else if (c >= 'K' && c <= 'T') {
                n = c - 75;
                n2 = 2;
            } else if (c >= 'U' && c <= 'Z') {
                n = c - 85;
                n2 = 1;
            }
        }
        if (n >= 0 && n < this.kbMatrix.length) {
            if (bl2 && n == 9) {
                this.kbMatrix[n] = n2 | 1;
            } else {
                if (bl2) {
                    this.kbMatrix[9] = 1;
                }
                this.kbMatrix[n] = n2;
            }
            bl = true;
        }
        if (bl) {
            this.updKeyboardFld();
        }
        return bl;
    }

    @Override
    public void openBasicProgram() {
        int n;
        String string = null;
        String[] stringArray = null;
        int n2 = -1;
        int n3 = -1;
        if (this.osBytes == osBytesSE24) {
            n2 = 15777;
            n3 = 9999;
            stringArray = se24Tokens;
        } else if (this.osBytes == osBytesSE31_29 || this.osBytes == osBytesSE31_40) {
            n2 = this.getMemWord(15360);
            n3 = 9999;
            stringArray = se31Tokens;
        } else if (this.osBytes == osBytesSP33_29) {
            n2 = this.getMemWord(15360);
            n3 = 9984;
            stringArray = sp33Tokens;
        }
        if (n2 >= 0 && n3 >= 0 && stringArray != null && (n = this.getMemWord(n2)) >= 0 && n < n3) {
            StringBuilder stringBuilder = new StringBuilder(8192);
            while (n >= 0 && n <= n3) {
                stringBuilder.append(n);
                n2 += 2;
                boolean bl = false;
                boolean bl2 = true;
                int n4 = this.emuThread.getMemByte(n2++, false);
                while (n4 != 0 && n4 != 30) {
                    String string2;
                    int n5;
                    if (bl2) {
                        stringBuilder.append(' ');
                        bl = false;
                        bl2 = false;
                    }
                    if (n4 >= 176 && (n5 = n4 - 176) >= 0 && n5 < stringArray.length && (string2 = stringArray[n5]) != null) {
                        int n6 = string2.length();
                        if (n6 > 0) {
                            char c = stringBuilder.charAt(stringBuilder.length() - 1);
                            if (c != ':' && c != ' ' && BCS3.isIdentifierChar(string2.charAt(0))) {
                                stringBuilder.append(' ');
                            }
                            stringBuilder.append(string2);
                            bl = BCS3.isIdentifierChar(string2.charAt(n6 - 1));
                        }
                        n4 = 0;
                    }
                    if (n4 != 0) {
                        if (bl && (BCS3.isIdentifierChar(n4) || n4 == 39 || n4 == 34)) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append((char)n4);
                        bl = false;
                    }
                    n4 = this.emuThread.getMemByte(n2++, false);
                }
                stringBuilder.append('\n');
                if (n4 == 0 || n == n3) break;
                n = this.getMemWord(n2);
            }
            if (stringBuilder.length() > 0) {
                string = stringBuilder.toString();
            }
        }
        if (string != null) {
            this.screenFrm.openText(string);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if ((n & 4) == 0) {
            n3 = this.ctc.read(n & 3, n2);
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = this.getMemByte(n, bl);
        if ((n &= 0xDFFF) >= 5120 && n < 6144) {
            this.emuThread.getZ80CPU().setWaitMode(true);
        } else if (n >= 6144 && n < 7168 && (n3 = n - 6144) >= 0 && n3 < this.ram.length && ((n2 = this.ram[n3] & 0xFF) & 0x80) == 0 && this.screenLineNum >= SCREEN_HIDDEN_LINES) {
            int n5;
            int n6;
            if (this.fontBytes != null && (n6 = (this.screenLineNum - SCREEN_HIDDEN_LINES) * SCREEN_CHARS_PER_ROW_MAX + this.screenColNum) < this.screenPixelsWriting.length && (n5 = n2 * 8 + (this.screenLineInChar - 1 & 7)) >= 0 && n5 < this.fontBytes.length) {
                this.screenPixelsWriting[n6] = this.fontBytes[n5];
                if (this.screenLineInChar == 0) {
                    if (this.screenColNum == 0) {
                        ++this.screenRowNum;
                    }
                    if (this.screenChar0Y <= 0) {
                        this.screenChar0Y = this.screenLineNum;
                    } else if (this.screenChar0Y > 0 && this.screenLineNum > this.screenChar0Y && this.screenChar1Y <= 0) {
                        this.screenChar1Y = this.screenLineNum;
                    }
                    int n7 = this.screenRowNum * SCREEN_CHARS_PER_ROW_MAX + this.screenColNum;
                    if (n7 >= 0 && n7 < this.screenChars.length) {
                        this.screenChars[n7] = (byte)n2;
                    }
                    if (this.screenColNum >= this.screenColCnt) {
                        this.screenColCnt = this.screenColNum + 1;
                    }
                }
            }
            if (this.screenColNum < SCREEN_CHARS_PER_ROW_MAX) {
                ++this.screenColNum;
            }
        }
        return n4;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON && this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.initSRAM(this.ram, properties);
            this.ctc.reset(true);
        } else {
            this.ctc.reset(false);
        }
        this.screenEnabled = false;
        this.screenActiveTStates = 0;
        this.screenColCnt = 0;
        this.screenColNum = 0;
        this.screenRowNum = -1;
        this.screenLineNum = 0;
        this.screenLineInChar = 0;
        this.screenChar0Y = -1;
        this.screenChar1Y = -1;
        this.lastTapeOutTStates = 0L;
        this.lastTapeOutPhase = false;
        this.charRaster = null;
        Arrays.fill(this.kbMatrix, 0);
        Arrays.fill(this.screenChars, (byte)32);
    }

    @Override
    public void saveBasicProgram() {
        int n;
        int n2 = -1;
        int n3 = -1;
        if (this.osBytes == osBytesSE24) {
            n2 = 15777;
            n3 = 9999;
        } else if (this.osBytes == osBytesSE31_29 || this.osBytes == osBytesSE31_40) {
            n2 = this.getMemWord(15360);
            n3 = 9999;
        } else if (this.osBytes == osBytesSP33_29) {
            n2 = this.getMemWord(15360);
            n3 = 9984;
        }
        int n4 = n2;
        if (n2 >= 0 && n3 >= 0 && (n = this.getMemWord(n2)) >= 0 && n < n3) {
            int n5 = n2;
            while (n >= 0 && n <= n3) {
                n5 += 2;
                int n6 = this.emuThread.getMemByte(n5++, false);
                while (n6 != 0 && n6 != 30) {
                    n6 = this.emuThread.getMemByte(n5++, false);
                }
                if (n6 != 30) break;
                n4 = n5;
                n = this.getMemWord(n5);
            }
        }
        if (n4 > n2 + 1) {
            new SaveDlg(this.screenFrm, n2, n4 - 1, "BASIC-Programm speichern", SaveDlg.BasicType.OTHER_BASIC, EmuUtil.getBinaryFileFilter()).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if ((n &= 0xFFFF) < 16384) {
            if ((n &= 0xDFFF) >= 5120 && n < 6144) {
                this.emuThread.getZ80CPU().setWaitMode(true);
            } else if (n >= 7168 && n < 8192) {
                int n3 = n - 7168;
                if (n3 >= 0 && n3 < this.ram.length) {
                    this.ram[n3] = (byte)n2;
                }
                bl = true;
            }
        } else if (n <= this.ramEndAddr) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != fontBytesSE24 && this.fontBytes != fontBytesSE31 && this.fontBytes != fontBytesSP33;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.kbMatrix;
        synchronized (this.kbMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.kbMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.kbMatrix[n] = nArray[n];
            }
            while (n < this.kbMatrix.length) {
                this.kbMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        int n4 = -1;
        int[] nArray = null;
        if (this.osBytes == osBytesSE24) {
            n4 = 15777;
            nArray = endInstBytesSE24;
        } else if (this.osBytes == osBytesSE31_29 || this.osBytes == osBytesSE31_40) {
            n4 = this.getMemWord(15360);
            nArray = endInstBytesSE31;
        } else if (this.osBytes == osBytesSP33_29) {
            n4 = this.getMemWord(15360);
            nArray = endInstBytesSP33;
        }
        if (n4 >= 0 && n == n4 && nArray != null) {
            boolean bl = false;
            if (fileFormat != null) {
                if (fileFormat.equals(FileFormat.HEADERSAVE)) {
                    if (n3 == 66) {
                        bl = true;
                    }
                } else if (fileFormat.equals(FileFormat.BASIC_PRG) || fileFormat.equals(FileFormat.KCC) || fileFormat.equals(FileFormat.INTELHEX) || fileFormat.equals(FileFormat.BIN)) {
                    bl = true;
                }
            }
            if (bl) {
                for (int i = n; i < 65536; ++i) {
                    int n5;
                    int n6 = i;
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        if ((nArray[n5] & 0xFF) != this.emuThread.getMemByte(n6, false)) {
                            n5 = -1;
                            break;
                        }
                        ++n6;
                    }
                    if (n5 != nArray.length) continue;
                    int n7 = i - n + nArray.length;
                    if (this.osBytes == osBytesSE24) {
                        this.emuThread.setMemWord(15366, n7);
                        break;
                    }
                    this.emuThread.setMemWord(15362, n7);
                    break;
                }
            }
        }
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if ((n & 4) == 0) {
            this.ctc.write(n & 3, n2, n3);
        }
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.setMemByte(n, n2);
        if ((n &= 0xDFFF) >= 5120 && n < 6144) {
            this.emuThread.getZ80CPU().setWaitMode(true);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        this.ctc.z80TStatesProcessed(z80CPU, n);
        if (this.screenActiveTStates > 0) {
            this.screenActiveTStates -= n;
            if (this.screenActiveTStates <= 0 && this.screenEnabled) {
                this.screenEnabled = false;
                this.screenFrm.setScreenDirty(true);
            }
        }
    }

    private static boolean equalsRange(byte[] byArray, int n, int[] nArray) {
        int n2;
        for (n2 = 0; n < byArray.length && n2 < nArray.length && (byArray[n] & 0xFF) == nArray[n2]; ++n, ++n2) {
        }
        return n2 == nArray.length;
    }

    private static int getRAMEndAddr(Properties properties) {
        int n = 16383;
        try {
            int n2 = Integer.parseInt(EmuUtil.getProperty(properties, "jkcemu.bcs3.ram.kbyte"));
            if (n2 > 1 && (n += (n2 - 1) * 1024) > 61439) {
                n = 61439;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private static boolean getRemoveHSyncFromAudio(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.bcs3.remove_hsync_from_audio", true);
    }

    private static boolean isIdentifierChar(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57;
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 1024);
        if (this.fontBytes == null) {
            if (this.osVersion == 31) {
                if (fontBytesSE31 == null) {
                    fontBytesSE31 = this.readResource("/rom/bcs3/se31font.bin");
                }
                this.fontBytes = fontBytesSE31;
            } else if (this.osVersion == 33) {
                if (fontBytesSP33 == null) {
                    fontBytesSP33 = this.readResource("/rom/bcs3/sp33font.bin");
                }
                this.fontBytes = fontBytesSP33;
            } else {
                if (fontBytesSE24 == null) {
                    fontBytesSE24 = this.readResource("/rom/bcs3/se24font.bin");
                }
                this.fontBytes = fontBytesSE24;
            }
        }
    }

    private void loadROMs(Properties properties) {
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.osBytes = this.readROMFile(this.osFile, 4096, "Betriebssystem");
        this.loadFont(properties);
    }

    private void updTapeOutPhase(boolean bl) {
        if (this.removeHSyncFromAudio) {
            Z80CPU z80CPU = this.emuThread.getZ80CPU();
            long l = z80CPU.getProcessedTStates();
            long l2 = Z80CPU.calcTStatesDiff(this.lastTapeOutTStates, l);
            this.lastTapeOutTStates = l;
            if (l2 > 300L && l2 < 40000L) {
                this.tapeOutPhase = bl;
            }
        } else {
            this.tapeOutPhase = bl;
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.kbMatrix);
        }
    }
}

