/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.util.Properties;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.huebler.AbstractHueblerMC;
import z80emu.Z80MemView;
import z80emu.Z80PIO;

public class HueblerEvertMC
extends AbstractHueblerMC {
    public static final String SYSNAME = "HueblerEvertMC";
    public static final String SYSTEXT = "H\u00fcbler/Evert-MC";
    public static final String PROP_PREFIX = "jkcemu.hemc.";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 4000;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static final String[] sysCallNames = new String[]{"BEGIN", "CI", "RI", "COE", "POE", "LOE", "CSTS", "CRI", "CPOE", "MEMSI", "MAIN", "EXT"};
    private static final int[] charToUnicode = new int[]{9664, 8214, -1, 61, 241, 945, 946, 948, 8962, 951, 952, 955, 956, -1, 963, 931, -1, 966, 937, 197, 229, 196, 228, 214, 246, 220, 252, 8594, 8730, 178, 163, 165};
    private static byte[] hemcFont = null;
    private static byte[] mon21 = null;
    private byte[] fontBytes;
    private byte[] ramVideo = new byte[2048];
    private byte[] ramStatic = new byte[1024];
    private byte[] osBytes = null;
    private String osFile = null;
    private Z80PIO pio2 = new Z80PIO("PIO (E/A-Adressen 10h-13h)");

    public HueblerEvertMC(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.createIOSystem();
        this.emuThread.getZ80CPU().setInterruptSources(this.ctc, this.pio, this.pio2);
        this.checkAddPCListener(properties);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public static int getDefaultSpeedKHz() {
        return 2500;
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.checkAddPCListener(properties);
        this.loadFont(properties);
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public int getAppStartStackInitValue() {
        return 65278;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (this.fontBytes != null) {
            byte by;
            int n4;
            int n5;
            int n6;
            int n7 = n2 % 10;
            int n8 = n2 / 10;
            if (n7 < 8 && n8 >= 0 && n8 < 24 && (n6 = n8 * 64 + (n5 = n / 6)) >= 0 && n6 < this.ramVideo.length && (n4 = ((by = this.ramVideo[n6]) & 0x7F) * 8 + n7) >= 0 && n4 < this.fontBytes.length) {
                int n9 = 128;
                int n10 = n % 6;
                if (n10 > 0) {
                    n9 >>= n10;
                }
                if ((this.fontBytes[n4] & n9) != 0) {
                    if ((by & 0x80) == 0) {
                        n3 = 1;
                    }
                } else if ((by & 0x80) != 0) {
                    n3 = 1;
                }
            }
        }
        return n3;
    }

    @Override
    protected boolean getConvertKeyCharToISO646DE() {
        return false;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return new CharRaster(64, 24, 10, 8, 6, 0);
    }

    @Override
    public String getHelpPage() {
        return "/help/hemc.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        int n3 = 255;
        if ((n &= 0xFFFF) < 59392) {
            n3 = this.emuThread.getRAMByte(n);
        } else if (n >= 59392 && n < 61440) {
            int n4 = n - 59392;
            if (n4 < this.ramVideo.length) {
                n3 = this.ramVideo[n4] & 0xFF;
            }
        } else if (n >= 61440 && n < 64512) {
            int n5;
            if (this.osBytes != null && (n5 = n - 61440) < this.osBytes.length) {
                n3 = this.osBytes[n5] & 0xFF;
            }
        } else if (n >= 64512 && (n2 = n - 64512) < this.ramStatic.length) {
            n3 = this.ramStatic[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 61440;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        int n4 = n2 * 64 + n;
        if (n4 >= 0 && n4 < this.ramVideo.length) {
            if (this.fontBytes == hemcFont) {
                int n5 = this.ramVideo[n4] & 0x7F;
                if (n5 >= 0 && n5 < charToUnicode.length) {
                    n3 = charToUnicode[n5];
                } else if (n5 >= 32 && n5 < 127) {
                    n3 = n5;
                } else if (n5 == 127) {
                    n3 = 9618;
                }
            } else {
                int n6 = this.ramVideo[n4] & 0xFF;
                if (n6 >= 32 && n6 < 127) {
                    n3 = n6;
                }
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 238;
    }

    @Override
    public int getScreenWidth() {
        return 384;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 8: 
            case 37: {
                n2 = 8;
                break;
            }
            case 39: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 38: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 13;
                break;
            }
            case 32: {
                n2 = 32;
                break;
            }
            case 127: {
                n2 = 127;
            }
        }
        if (n2 > 0) {
            this.keyTyped((char)n2);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000') {
            switch (c) {
                case '\u00df': {
                    this.keyChar = 6;
                    break;
                }
                case '\u00c4': {
                    this.keyChar = 21;
                    break;
                }
                case '\u00e4': {
                    this.keyChar = 22;
                    break;
                }
                case '\u00d6': {
                    this.keyChar = 23;
                    break;
                }
                case '\u00f6': {
                    c = (char)246;
                    this.keyChar = 24;
                    break;
                }
                case '\u00dc': {
                    this.keyChar = 25;
                    break;
                }
                case '\u00fc': {
                    this.keyChar = 26;
                    break;
                }
                case '\u00b2': {
                    this.keyChar = 29;
                    break;
                }
                case '\u00a3': {
                    this.keyChar = 30;
                    break;
                }
                case '\u00a5': {
                    this.keyChar = 31;
                    break;
                }
                default: {
                    this.keyChar = c;
                }
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 0;
        switch (n &= 0x3F) {
            case 16: {
                n3 = this.pio2.readDataA();
                break;
            }
            case 17: {
                n3 = this.pio2.readControlA();
                break;
            }
            case 18: {
                n3 = this.pio2.readDataB();
                break;
            }
            case 19: {
                n3 = this.pio2.readControlB();
                break;
            }
            default: {
                n3 = super.readIOByte(n, n2);
            }
        }
        return n3;
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        return this.reassSysCallTable(z80MemView, n, 61440, sysCallNames, stringBuilder, bl, n2, n3, n4);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            this.initSRAM(this.ramStatic, properties);
            this.fillRandom(this.ramVideo);
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n &= 0xFFFF) < 59392) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        } else if (n >= 59392 && n < 61440) {
            int n4 = n - 59392;
            if (n4 < this.ramVideo.length) {
                this.ramVideo[n4] = (byte)n2;
                this.screenFrm.setScreenDirty(true);
                bl = true;
            }
        } else if (n >= 64512 && (n3 = n - 64512) < this.ramStatic.length) {
            this.ramStatic[n3] = (byte)n2;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != hemcFont;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n &= 0x3F) {
            case 16: {
                this.pio2.writeDataA(n2);
                break;
            }
            case 17: {
                this.pio2.writeControlA(n2);
                break;
            }
            case 18: {
                this.pio2.writeDataB(n2);
                break;
            }
            case 19: {
                this.pio2.writeControlB(n2);
                break;
            }
            default: {
                super.writeIOByte(n, n2, n3);
            }
        }
    }

    private void checkAddPCListener(Properties properties) {
        this.checkAddPCListener(properties, this.propPrefix + "catch_print_calls");
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font." + "file", 2048);
        if (this.fontBytes == null) {
            if (hemcFont == null) {
                hemcFont = this.readResource("/rom/huebler/hemcfont.bin");
            }
            this.fontBytes = hemcFont;
        }
    }

    private void loadROMs(Properties properties) {
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "os." + "file");
        this.osBytes = this.readROMFile(this.osFile, 3072, "Monitorprogramm");
        if (this.osBytes == null) {
            if (mon21 == null) {
                mon21 = this.readResource("/rom/huebler/mon21.bin");
            }
            this.osBytes = mon21;
        }
        this.loadFont(properties);
    }
}

