/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80MemView;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;

public class KramerMC
extends EmuSys
implements Z80PCListener {
    public static final String SYSNAME = "KramerMC";
    public static final String SYSTEXT = "Kramer-MC";
    public static final String PROP_PREFIX = "jkcemu.kramermc.";
    public static final String PROP_ROM0_PREFIX = "rom.0000.";
    public static final String PROP_ROM8_PREFIX = "rom.8000.";
    public static final String PROP_ROMC_PREFIX = "rom.c000.";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 300;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static final int[][] kbMatrixNormal = new int[][]{{0, 0, 59, 60, 3, 0, 0, 58}, {80, 79, 0, 75, 0, 76, 48, 57}, {73, 85, 78, 72, 77, 74, 56, 55}, {90, 84, 86, 70, 66, 71, 54, 53}, {82, 69, 88, 83, 67, 68, 52, 51}, {87, 81, 0, 0, 89, 65, 50, 49}, {0, 0, 0, 0, 0, 62, 63, 61}};
    private static final int[][] kbMatrixShift = new int[][]{{0, 0, 43, 44, 0, 0, 0, 42}, {112, 111, 0, 107, 0, 108, 32, 41}, {105, 117, 110, 104, 109, 106, 40, 39}, {122, 116, 118, 102, 98, 103, 38, 37}, {114, 101, 120, 115, 99, 100, 36, 35}, {119, 113, 0, 0, 121, 97, 34, 33}, {0, 0, 0, 0, 0, 46, 47, 45}};
    private static final String[] basicTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GO TO", "FNEND", "IF", "RESTORE", "GO SUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "PRINT", "?", "LISTEN", "CLEAR", "FNRETURN", "SAVE", "!", "USING", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LOG", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "LPOS", "INSTR", "ELSE", "LPRINT", "TRACE", "LTRACE", "RANDOMIZE", "SWITCH", "LWIDTH", "LNULL", "WIDTH", "LVAR", "LLVAL", "SPEAK", "'", "PRECISION", "CALL", "KILL", "EXCHANGE", "LINE", "LOADGO", "RUN", "LOAD", "NEW", "AUTO", "COPY", "ALOADC", "AMERGEC", "ALOAD", "AMERGE", "ASAVE", "LIST", "LLIST", "RENUMBER", "DELETE", "EDIT", "CONT"};
    private static final String[] sysCallNames = new String[]{"CI", "RI", "CO", "WO", "LO", "CSTS", "IOCHK", "IOSET"};
    private static byte[] rom0000 = null;
    private static byte[] rom8000 = null;
    private static byte[] romC000 = null;
    private static byte[] romFont = null;
    private String rom0000File = null;
    private String rom8000File = null;
    private String romC000File = null;
    private byte[] fontBytes;
    private byte[] ramVideo = new byte[1024];
    private byte[] rom0000Bytes = null;
    private byte[] rom8000Bytes = null;
    private byte[] romC000Bytes = null;
    private int[] kbMatrix = new int[8];
    private int kbRow;
    private int kbTStates;
    private int kbTStateCounter;
    private volatile int kbStatus;
    private boolean shiftPressed;
    private boolean ctrlPressed;
    private boolean printerSupported;
    private boolean pcListenerAdded;
    private Z80PIO pio;

    public KramerMC(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.pio = new Z80PIO("PIO (E/A-Adressen FC-FF)");
        z80CPU.setInterruptSources(this.pio);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.pcListenerAdded = false;
        this.checkAddPCListener(properties);
        this.z80MaxSpeedChanged(z80CPU);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public static String getBasicProgram(EmuMemView emuMemView) {
        return SourceUtil.getBasicProgram(emuMemView, 4097, basicTokens);
    }

    public static int getDefaultSpeedKHz() {
        return 1500;
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        if (n == 236) {
            this.emuThread.getPrintMngr().putByte(z80CPU.getRegC());
            z80CPU.setRegPC(z80CPU.doPop());
        }
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.checkAddPCListener(properties);
        this.loadFont(properties);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.rom0000File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM0_PREFIX + "file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.rom8000File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM8_PREFIX + "file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.romC000File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROMC_PREFIX + "file"));
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.pcListenerAdded) {
            z80CPU.removePCListener(this);
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 4046;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        if (this.fontBytes != null && (n5 = this.emuThread.getMemByte(64512 + (n4 = n2 / 8) * 64 + (n3 = n / 6), false) * 8 + n2 % 8) >= 0 && n5 < this.fontBytes.length) {
            int n7 = 128;
            int n8 = n % 6;
            if (n8 > 0) {
                n7 >>= n8;
            }
            if ((this.fontBytes[n5] & n7) != 0) {
                n6 = 1;
            }
        }
        return n6;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return new CharRaster(64, 16, 8, 8, 6, 0);
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 150L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 250L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 150L;
    }

    @Override
    public String getHelpPage() {
        return "/help/kramermc.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        int n3 = 255;
        boolean bl2 = false;
        if ((n &= 0xFFFF) < 3072 && this.rom0000Bytes != null && n < this.rom0000Bytes.length) {
            n3 = this.rom0000Bytes[n] & 0xFF;
            bl2 = true;
        }
        if (!bl2 && n >= 32768 && n < 45056 && this.rom8000Bytes != null && (n2 = n - 32768) < this.rom8000Bytes.length) {
            n3 = this.rom8000Bytes[n2] & 0xFF;
            bl2 = true;
        }
        if (!bl2 && n >= 49152 && n < 57344 && this.romC000Bytes != null && (n2 = n - 49152) < this.romC000Bytes.length) {
            n3 = this.romC000Bytes[n2] & 0xFF;
            bl2 = true;
        }
        if (!bl2 && n >= 64512 && (n2 = n - 64512) < this.ramVideo.length) {
            n3 = this.ramVideo[n2] & 0xFF;
            bl2 = true;
        }
        if (!bl2) {
            n3 = this.emuThread.getRAMByte(n);
        }
        return n3;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = n2 * 64 + n;
        if (n5 >= 0 && n5 < this.ramVideo.length && (n3 = this.ramVideo[n5] & 0xFF) >= 32 && n3 < 127) {
            n4 = n3;
        }
        return n4;
    }

    @Override
    public int getScreenHeight() {
        return 128;
    }

    @Override
    public int getScreenWidth() {
        return 384;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            if (this.kbStatus == 0) {
                switch (n) {
                    case 8: 
                    case 37: {
                        this.kbMatrix[1] = 1;
                        bl3 = true;
                        break;
                    }
                    case 39: {
                        this.kbMatrix[0] = 64;
                        bl3 = true;
                        break;
                    }
                    case 40: {
                        this.kbMatrix[6] = 1;
                        bl3 = true;
                        break;
                    }
                    case 38: {
                        this.kbMatrix[0] = 1;
                        bl3 = true;
                        break;
                    }
                    case 10: {
                        this.kbMatrix[4] = 2;
                        bl3 = true;
                        break;
                    }
                    case 32: {
                        this.kbMatrix[1] = 64;
                        bl3 = true;
                        break;
                    }
                    case 127: {
                        this.kbMatrix[2] = 2;
                        bl3 = true;
                    }
                }
                if (bl3) {
                    this.kbTStateCounter = 0;
                    this.kbStatus = 1;
                    this.shiftPressed = false;
                    this.ctrlPressed = false;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            if (c >= '\u0001' && c <= ' ' && c != '\u0003') {
                if (this.setCharInKBMatrix(c + 64, kbMatrixShift)) {
                    this.kbTStateCounter = 0;
                    this.kbStatus = 3;
                    this.shiftPressed = false;
                    this.ctrlPressed = true;
                    bl = true;
                }
            } else if (this.setCharInKBMatrix(c, kbMatrixNormal)) {
                this.kbTStateCounter = 0;
                this.kbStatus = 1;
                this.shiftPressed = false;
                this.ctrlPressed = false;
                bl = true;
            } else if (this.setCharInKBMatrix(c, kbMatrixShift)) {
                this.kbTStateCounter = 0;
                this.kbStatus = 3;
                this.shiftPressed = true;
                this.ctrlPressed = false;
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bl;
        }
    }

    @Override
    public void openBasicProgram() {
        String string = SourceUtil.getBasicProgram(this.emuThread, 4097, basicTokens);
        if (string != null) {
            this.screenFrm.openText(string);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        switch (c) {
            case '\n': 
            case '\r': {
                bl = this.keyPressed(10, false, false);
                break;
            }
            case ' ': {
                bl = this.keyPressed(32, false, false);
                break;
            }
            default: {
                bl = this.keyTyped(c);
            }
        }
        if (bl) {
            while (this.kbStatus > 0) {
                Thread.sleep(50L);
            }
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        switch (n & 0xFF) {
            case 252: {
                n3 = this.pio.readDataA();
                break;
            }
            case 253: {
                this.updKBColValue();
                n3 = this.pio.readDataB();
                break;
            }
            case 254: {
                n3 = this.pio.readControlA();
                break;
            }
            case 255: {
                n3 = this.pio.readControlB();
            }
        }
        return n3;
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        return this.reassSysCallTable(z80MemView, n, 224, sysCallNames, stringBuilder, bl, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            this.fillRandom(this.ramVideo);
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.pio.reset(true);
        } else {
            this.pio.reset(false);
        }
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            Arrays.fill(this.kbMatrix, 0);
            this.kbRow = 0;
            this.kbTStateCounter = 0;
            this.kbStatus = 0;
            this.shiftPressed = false;
            this.ctrlPressed = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void saveBasicProgram() {
        int n = SourceUtil.getBasicEndAddr(this.emuThread, 4097);
        if (n >= 4097) {
            new SaveDlg(this.screenFrm, 4097, n, "BASIC-Programm speichern", SaveDlg.BasicType.MS_DERIVED_BASIC, EmuUtil.getBasicFileFilter()).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n &= 0xFFFF) >= 3072 && n < 32768 || n >= 45056 && n < 49152 || n >= 57344 && n < 64512) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        } else if (n >= 64512 && (n3 = n - 64512) < this.ramVideo.length) {
            this.ramVideo[n3] = (byte)n2;
            this.screenFrm.setScreenDirty(true);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != romFont;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return this.pcListenerAdded;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        int n4;
        if (fileFormat != null && (fileFormat.equals(FileFormat.BASIC_PRG) && n == 4097 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 4097 && n + n2 > 4103) && (n4 = SourceUtil.getBasicEndAddr(this.emuThread, 4097) + 1) > 4097) {
            this.emuThread.setMemWord(3166, n4);
            this.emuThread.setMemWord(3168, n4);
            this.emuThread.setMemWord(3170, n4);
        }
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 0xFF) {
            case 252: {
                this.pio.writeDataA(n2);
                this.kbRow = this.pio.fetchOutValuePortA(false) >> 1 & 7;
                break;
            }
            case 253: {
                this.pio.writeDataB(n2);
                break;
            }
            case 254: {
                this.pio.writeControlA(n2);
                break;
            }
            case 255: {
                this.pio.writeControlB(n2);
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.kbTStates = z80CPU.getMaxSpeedKHz() * 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        if (this.kbStatus <= 0) return;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            if (this.kbStatus <= 0) return;
            this.kbTStateCounter += n;
            if (this.kbTStateCounter <= this.kbTStates) return;
            this.kbTStateCounter = 0;
            this.shiftPressed = false;
            this.ctrlPressed = false;
            --this.kbStatus;
            if (this.kbStatus != 0) return;
            Arrays.fill(this.kbMatrix, 0);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private synchronized void checkAddPCListener(Properties properties) {
        boolean bl = EmuUtil.getBooleanProperty(properties, this.propPrefix + "catch_print_calls", false);
        if (bl != this.pcListenerAdded) {
            Z80CPU z80CPU = this.emuThread.getZ80CPU();
            if (bl) {
                z80CPU.addPCListener(this, 236);
            } else {
                z80CPU.removePCListener(this);
            }
            this.pcListenerAdded = bl;
        }
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 2048);
        if (this.fontBytes == null) {
            if (romFont == null) {
                romFont = this.readResource("/rom/kramermc/kramermcfont.bin");
            }
            this.fontBytes = romFont;
        }
    }

    private void loadROMs(Properties properties) {
        this.rom0000File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM0_PREFIX + "file");
        this.rom0000Bytes = this.readROMFile(this.rom0000File, 3072, "ROM (0000-0BFF)");
        if (this.rom0000Bytes == null) {
            if (rom0000 == null) {
                rom0000 = this.readResource("/rom/kramermc/rom_0000.bin");
            }
            this.rom0000Bytes = rom0000;
        }
        this.rom8000File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM8_PREFIX + "file");
        this.rom8000Bytes = this.readROMFile(this.rom8000File, 12288, "ROM (8000-AFFF)");
        if (this.rom8000Bytes == null) {
            if (rom8000 == null) {
                rom8000 = this.readResource("/rom/kramermc/rom_8000.bin");
            }
            this.rom8000Bytes = rom8000;
        }
        this.romC000File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROMC_PREFIX + "file");
        this.romC000Bytes = this.readROMFile(this.romC000File, 8192, "ROM (C000-DFFF)");
        if (this.romC000Bytes == null) {
            if (romC000 == null) {
                romC000 = this.readResource("/rom/kramermc/rom_c000.bin");
            }
            this.romC000Bytes = romC000;
        }
        this.loadFont(properties);
    }

    private boolean setCharInKBMatrix(int n, int[][] nArray) {
        boolean bl = false;
        int n2 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length && j < this.kbMatrix.length; ++j) {
                if (nArray[i][j] != n) continue;
                this.kbMatrix[j] = n2;
                bl = true;
                break;
            }
            n2 <<= 1;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updKBColValue() {
        int n = 255;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            if (this.kbStatus == 1) {
                int n2;
                int n3 = 1;
                for (n2 = 0; n2 < this.kbRow; ++n2) {
                    n3 <<= 1;
                }
                n2 = 254;
                for (int i = 0; i < this.kbMatrix.length; ++i) {
                    if ((this.kbMatrix[i] & n3) != 0) {
                        n &= n2;
                    }
                    n2 = n2 << 1 | 1;
                }
            } else if (this.kbStatus == 3) {
                if (this.kbRow == 6 && this.ctrlPressed) {
                    n &= 0xF7;
                }
                if (this.kbRow == 0 && this.shiftPressed) {
                    n &= 0xDF;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.pio.putInValuePortB(n, 255);
            return;
        }
    }
}

