/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.emusys.lc80.LC80KeyboardFld;
import jkcemu.emusys.lc80.TVTerminal;
import jkcemu.etc.VDIP;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80HaltStateListener;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;
import z80emu.Z80SIO;
import z80emu.Z80SIOChannelListener;

public class LC80
extends EmuSys
implements Z80HaltStateListener,
Z80PCListener,
Z80SIOChannelListener {
    public static final String SYSNAME = "LC80";
    public static final String SYSNAME_LC80_U505 = "LC80_U505";
    public static final String SYSNAME_LC80_2716 = "LC80_2716";
    public static final String SYSNAME_LC80_2 = "LC80_2";
    public static final String SYSNAME_LC80_E = "LC80_E";
    public static final String SYSNAME_LC80_EX = "LC80_EX";
    public static final String SYSNAME_LC80 = "LC80";
    public static final String SYSTEXT = "LC-80";
    public static final String SYSTEXT_LC80_2 = "LC-80.2";
    public static final String SYSTEXT_LC80_E = "LC-80e";
    public static final String SYSTEXT_LC80_EX = "LC-80ex";
    public static final String PROP_PREFIX = "jkcemu.lc80.";
    public static final String PROP_ROM_A000_PREFIX = "rom_a000.";
    public static final String PROP_ROM_C000_PREFIX = "rom_c000.";
    public static final int FUNCTION_KEY_COUNT = 4;
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 15000;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static final String[] basicTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", null, "CALL", "PRINT", "CONT", "LIST", "CLEAR", "LOAD", "SAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", null, "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", null, null, "RENUMBER", "LOCATE", "SOUND", "INKEY", "MODE", "TRON", "TROFF", "FILES", "LFILES", "LLIST", "LPRINT", "TIME$", "DATE$", "EDIT"};
    private static byte[] lc80_u505 = null;
    private static byte[] lc80_2716 = null;
    private static byte[] lc80_2 = null;
    private static byte[] lc80e_0000 = null;
    private static byte[] lc80e_c000 = null;
    private static byte[] lc80ex_a000 = null;
    private static byte[] lc80ex_c000 = null;
    private String romOSFile = null;
    private String romA000File = null;
    private String romC000File = null;
    private byte[] romOS = null;
    private byte[] romA000 = null;
    private byte[] romC000;
    private byte[] ram;
    private int[] kbMatrix;
    private int[] digitStatus;
    private int[] digitValues;
    private int curDigitValue;
    private int sioTStatesCounter;
    private volatile int pioSysBValue;
    private long curDisplayTStates;
    private long displayCheckTStates;
    private boolean tapeInPhase;
    private boolean tapeOutLED;
    private volatile boolean tapeOutState;
    private boolean chessComputer;
    private boolean chessMode;
    private boolean haltState;
    private boolean tvTermFired;
    private TVTerminal tvTerm;
    private VDIP vdip;
    private LC80KeyboardFld keyboardFld;
    private Z80CTC ctc;
    private Z80PIO pioSys;
    private Z80PIO pioUser;
    private Z80SIO sio;
    private String sysName;

    public LC80(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.sysName = EmuUtil.getProperty(properties, "jkcemu.system");
        this.ram = this.sysName.equals(SYSNAME_LC80_U505) ? new byte[1024] : (this.sysName.equals(SYSNAME_LC80_EX) ? new byte[28672] : new byte[4096]);
        this.chessComputer = this.sysName.equals(SYSNAME_LC80_E);
        this.tapeInPhase = false;
        this.tapeOutLED = false;
        this.tapeOutState = false;
        this.chessMode = false;
        this.haltState = false;
        this.curDisplayTStates = 0L;
        this.displayCheckTStates = 0L;
        this.pioSysBValue = 255;
        this.curDigitValue = 255;
        this.digitValues = new int[6];
        this.digitStatus = new int[6];
        this.kbMatrix = new int[6];
        this.keyboardFld = null;
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.pioSys = new Z80PIO("System-PIO");
        this.pioUser = new Z80PIO("User-PIO");
        this.ctc = new Z80CTC("CTC");
        this.sio = null;
        this.vdip = null;
        this.tvTerm = null;
        this.tvTermFired = false;
        if (this.sysName.equals(SYSNAME_LC80_EX)) {
            this.tvTerm = new TVTerminal(this, properties);
            this.sio = new Z80SIO("SIO");
            z80CPU.setInterruptSources(this.ctc, this.pioUser, this.pioSys, this.sio);
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO");
        } else {
            z80CPU.setInterruptSources(this.ctc, this.pioUser, this.pioSys);
        }
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addHaltStateListener(this);
        z80CPU.addTStatesListener(this);
        if (this.sio != null) {
            this.sio.addChannelListener(this, 0);
            this.sio.addChannelListener(this, 1);
        }
        if (this.chessComputer) {
            z80CPU.addPCListener(this, 0, 51200);
        }
        this.z80MaxSpeedChanged(z80CPU);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public static String getBasicProgram(EmuMemView emuMemView) {
        return SourceUtil.getBasicProgram(emuMemView, 9216, basicTokens);
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        int n = 900;
        String string = EmuUtil.getProperty(properties, "jkcemu.system");
        if (string.equals(SYSNAME_LC80_E)) {
            n = 1800;
        } else if (string.equals(SYSNAME_LC80_EX)) {
            n = 1843;
        }
        return n;
    }

    public boolean isChessMode() {
        return this.chessMode;
    }

    public void putToSIOChannelB(int n) {
        if (this.sio != null) {
            this.sio.putToReceiverB(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.kbMatrix;
        synchronized (this.kbMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.kbMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.kbMatrix[n] = nArray[n];
            }
            while (n < this.kbMatrix.length) {
                this.kbMatrix[n] = 0;
                ++n;
            }
            this.putKBMatrixRowValueToPort();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void z80HaltStateChanged(Z80CPU z80CPU, boolean bl) {
        if (bl != this.haltState) {
            this.haltState = bl;
            this.screenFrm.setScreenDirty(true);
        }
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        switch (n) {
            case 0: {
                this.setChessMode(false);
                break;
            }
            case 51200: {
                this.setChessMode(true);
            }
        }
    }

    @Override
    public void z80SIOByteSent(Z80SIO z80SIO, int n, int n2) {
        if (z80SIO == this.sio && this.sio != null) {
            if (n == 0) {
                this.emuThread.getPrintMngr().putByte(n2);
                this.sio.setClearToSendA(false);
                this.sio.setClearToSendA(true);
            } else if (n == 1 && this.tvTerm != null) {
                this.tvTerm.write(n2);
                this.sio.setClearToSendB(false);
                this.sio.setClearToSendB(true);
            }
        }
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(this.sysName);
        if (bl) {
            bl = TextUtil.equals(this.romOSFile, EmuUtil.getProperty(properties, this.propPrefix + "os.file"));
        }
        if (bl && this.sysName.equals(SYSNAME_LC80_EX)) {
            bl = TextUtil.equals(this.romA000File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM_A000_PREFIX + "file"));
        }
        if (bl && (this.sysName.equals(SYSNAME_LC80_E) || this.sysName.equals(SYSNAME_LC80_EX))) {
            bl = TextUtil.equals(this.romC000File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM_C000_PREFIX + "file"));
        }
        return bl;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new LC80KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeHaltStateListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.chessComputer) {
            z80CPU.removePCListener(this);
        }
        if (this.sio != null) {
            this.sio.removeChannelListener(this, 0);
            this.sio.removeChannelListener(this, 1);
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 9194;
    }

    @Override
    public boolean getAutoLoadInputOnSoftReset() {
        return false;
    }

    @Override
    public EmuSys.Chessman getChessman(int n, int n2) {
        EmuSys.Chessman chessman = null;
        if (this.chessMode && n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
            switch (this.getMemByte(10005 + n * 10 + n2, false) & 0x8F) {
                case 1: {
                    chessman = EmuSys.Chessman.WHITE_PAWN;
                    break;
                }
                case 2: {
                    chessman = EmuSys.Chessman.WHITE_KNIGHT;
                    break;
                }
                case 3: {
                    chessman = EmuSys.Chessman.WHITE_BISHOP;
                    break;
                }
                case 4: {
                    chessman = EmuSys.Chessman.WHITE_ROOK;
                    break;
                }
                case 5: {
                    chessman = EmuSys.Chessman.WHITE_QUEEN;
                    break;
                }
                case 6: {
                    chessman = EmuSys.Chessman.WHITE_KING;
                    break;
                }
                case 129: {
                    chessman = EmuSys.Chessman.BLACK_PAWN;
                    break;
                }
                case 130: {
                    chessman = EmuSys.Chessman.BLACK_KNIGHT;
                    break;
                }
                case 131: {
                    chessman = EmuSys.Chessman.BLACK_BISHOP;
                    break;
                }
                case 132: {
                    chessman = EmuSys.Chessman.BLACK_ROOK;
                    break;
                }
                case 133: {
                    chessman = EmuSys.Chessman.BLACK_QUEEN;
                    break;
                }
                case 134: {
                    chessman = EmuSys.Chessman.BLACK_KING;
                }
            }
        }
        return chessman;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorGreenDark;
                break;
            }
            case 2: {
                color = this.colorGreenLight;
                break;
            }
            case 3: {
                color = this.colorRedDark;
                break;
            }
            case 4: {
                color = this.colorRedLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 5;
    }

    @Override
    public String getHelpPage() {
        return "/help/lc80.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        n = this.romA000 != null || this.romC000 != null ? (n &= 0xFFFF) : (n &= 0x3FFF);
        int n3 = 255;
        if (n < 8192) {
            if (this.romOS != null && n < this.romOS.length) {
                n3 = this.romOS[n] & 0xFF;
            }
        } else if (n >= 8192 && n < 40960) {
            int n4 = n - 8192;
            if (n4 < this.ram.length) {
                if (n4 >= 24569 && n4 < 24576 && (this.ram[24568] & 0x40) == 0) {
                    this.updTimekeeperRAM();
                }
                n3 = this.ram[n4] & 0xFF;
            }
        } else if (n >= 40960 && n < 49152) {
            int n5;
            if (this.romA000 != null && (n5 = n - 40960) < this.romA000.length) {
                n3 = this.romA000[n5] & 0xFF;
            }
        } else if (n >= 49152 && this.romC000 != null && (n2 = n - 49152) < this.romC000.length) {
            n3 = this.romC000[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        return 85;
    }

    @Override
    public int getScreenWidth() {
        return 39 + 65 * this.digitValues.length;
    }

    @Override
    public TVTerminal getSecondScreenDevice() {
        return this.tvTerm;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        String string = SYSTEXT;
        switch (this.sysName) {
            case "LC80_2": {
                string = SYSTEXT_LC80_2;
                break;
            }
            case "LC80_E": {
                string = SYSTEXT_LC80_E;
                break;
            }
            case "LC80_EX": {
                string = SYSTEXT_LC80_EX;
            }
        }
        return string;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            switch (n) {
                case 112: {
                    this.kbMatrix[5] = 128;
                    bl3 = true;
                    break;
                }
                case 113: {
                    this.kbMatrix[5] = 64;
                    bl3 = true;
                    break;
                }
                case 114: {
                    this.kbMatrix[0] = 32;
                    bl3 = true;
                    break;
                }
                case 115: {
                    this.kbMatrix[0] = 64;
                    bl3 = true;
                    break;
                }
                case 10: {
                    this.kbMatrix[0] = 128;
                    bl3 = true;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.putKBMatrixRowValueToPort();
                this.updKeyboardFld();
            } else if (n == 27) {
                this.emuThread.fireReset(EmuThread.ResetLevel.WARM_RESET);
                bl3 = true;
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            Arrays.fill(this.kbMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.putKBMatrixRowValueToPort();
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            switch (c) {
                case '\u00f1': {
                    this.kbMatrix[5] = 128;
                    bl = true;
                    break;
                }
                case '\u00f2': {
                    this.kbMatrix[5] = 64;
                    bl = true;
                    break;
                }
                case '\u00f3': {
                    this.kbMatrix[0] = 32;
                    bl = true;
                    break;
                }
                case '\u00f4': {
                    this.kbMatrix[0] = 64;
                    bl = true;
                }
            }
            if (!bl) {
                switch (Character.toUpperCase(c)) {
                    case '\u001b': {
                        this.emuThread.fireReset(EmuThread.ResetLevel.WARM_RESET);
                        bl = true;
                        break;
                    }
                    case '0': {
                        this.kbMatrix[1] = 128;
                        bl = true;
                        break;
                    }
                    case '1': {
                        this.kbMatrix[1] = 64;
                        bl = true;
                        break;
                    }
                    case '2': {
                        this.kbMatrix[1] = 32;
                        bl = true;
                        break;
                    }
                    case '3': {
                        this.kbMatrix[1] = 16;
                        bl = true;
                        break;
                    }
                    case '4': {
                        this.kbMatrix[2] = 128;
                        bl = true;
                        break;
                    }
                    case '5': {
                        this.kbMatrix[2] = 64;
                        bl = true;
                        break;
                    }
                    case '6': {
                        this.kbMatrix[5] = 32;
                        bl = true;
                        break;
                    }
                    case '7': {
                        this.kbMatrix[2] = 16;
                        bl = true;
                        break;
                    }
                    case '8': {
                        this.kbMatrix[3] = 128;
                        bl = true;
                        break;
                    }
                    case '9': {
                        this.kbMatrix[3] = 64;
                        bl = true;
                        break;
                    }
                    case '-': {
                        this.kbMatrix[5] = 16;
                        bl = true;
                        break;
                    }
                    case '+': {
                        this.kbMatrix[2] = 32;
                        bl = true;
                        break;
                    }
                    case 'A': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[1] = 64;
                        } else {
                            this.kbMatrix[4] = 32;
                        }
                        bl = true;
                        break;
                    }
                    case 'B': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[1] = 32;
                        } else {
                            this.kbMatrix[3] = 16;
                        }
                        bl = true;
                        break;
                    }
                    case 'C': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[1] = 16;
                        } else {
                            this.kbMatrix[4] = 128;
                        }
                        bl = true;
                        break;
                    }
                    case 'D': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[2] = 128;
                        } else {
                            this.kbMatrix[4] = 64;
                        }
                        bl = true;
                        break;
                    }
                    case 'E': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[2] = 64;
                        } else {
                            this.kbMatrix[3] = 32;
                        }
                        bl = true;
                        break;
                    }
                    case 'F': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[5] = 32;
                        } else {
                            this.kbMatrix[4] = 16;
                        }
                        bl = true;
                        break;
                    }
                    case 'G': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[2] = 16;
                        bl = true;
                        break;
                    }
                    case 'H': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[3] = 128;
                        } else {
                            this.kbMatrix[5] = 64;
                        }
                        bl = true;
                        break;
                    }
                    case 'K': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[4] = 16;
                        bl = true;
                        break;
                    }
                    case 'L': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[4] = 128;
                        } else {
                            this.kbMatrix[0] = 32;
                        }
                        bl = true;
                        break;
                    }
                    case 'M': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[3] = 32;
                        } else {
                            this.kbMatrix[5] = 128;
                        }
                        bl = true;
                        break;
                    }
                    case 'N': {
                        this.emuThread.getZ80CPU().fireNMI();
                        bl = true;
                        break;
                    }
                    case 'O': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[2] = 32;
                        bl = true;
                        break;
                    }
                    case 'P': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[5] = 64;
                        bl = true;
                        break;
                    }
                    case 'R': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[0] = 32;
                        bl = true;
                        break;
                    }
                    case 'S': {
                        if (this.chessComputer && this.chessMode) {
                            this.kbMatrix[3] = 16;
                        } else {
                            this.kbMatrix[0] = 64;
                        }
                        bl = true;
                        break;
                    }
                    case 'T': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[4] = 64;
                        bl = true;
                        break;
                    }
                    case 'U': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[4] = 32;
                        bl = true;
                        break;
                    }
                    case 'V': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[5] = 128;
                        bl = true;
                        break;
                    }
                    case 'W': {
                        if (!this.chessComputer || !this.chessMode) break;
                        this.kbMatrix[5] = 16;
                        bl = true;
                        break;
                    }
                    case 'X': {
                        this.kbMatrix[0] = 128;
                        bl = true;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.putKBMatrixRowValueToPort();
                this.updKeyboardFld();
            }
            return bl;
        }
    }

    @Override
    public void openBasicProgram() {
        String string = SourceUtil.getBasicProgram(this.emuThread, 9216, basicTokens);
        if (string != null) {
            this.screenFrm.openText(string);
        } else {
            this.showNoBasic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        if (this.tapeOutLED || !this.tapeOutPhase && !this.tapeOutState) {
            graphics.setColor(this.colorGreenLight);
        } else {
            graphics.setColor(this.colorGreenDark);
        }
        graphics.fillArc(n, n2, 20 * n3, 20 * n3, 0, 360);
        graphics.setColor(this.haltState ? this.colorRedLight : this.colorRedDark);
        graphics.fillArc(n, n2 + 30 * n3, 20 * n3, 20 * n3, 0, 360);
        n += 50 * n3;
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                LC80.paint7SegDigit(graphics, n, n2, this.digitValues[i], this.colorGreenDark, this.colorGreenLight, n3);
                n += 65 * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if (((n &= 0xFF) & 4) == 0) {
            switch (n & 3) {
                case 0: {
                    n3 &= this.pioUser.readDataA();
                    break;
                }
                case 1: {
                    n3 &= this.pioUser.readDataB();
                    break;
                }
                case 2: {
                    n3 &= this.pioUser.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.pioUser.readControlB();
                }
            }
        }
        if ((n & 8) == 0) {
            switch (n & 3) {
                case 0: {
                    n3 &= this.pioSys.readDataA();
                    break;
                }
                case 1: {
                    n3 &= this.pioSys.readDataB();
                    break;
                }
                case 2: {
                    n3 &= this.pioSys.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.pioSys.readControlB();
                }
            }
        }
        if ((n & 0x10) == 0) {
            n3 &= this.ctc.read(n & 3, n2);
        }
        if ((n & 0x20) == 0 && this.sio != null) {
            switch (n & 3) {
                case 0: {
                    n3 &= this.sio.readDataA();
                    break;
                }
                case 1: {
                    n3 &= this.sio.readDataB();
                    if (this.sio.availableB() != 0 || this.tvTerm == null) break;
                    this.tvTerm.keyCharQueueEmpty();
                    break;
                }
                case 2: {
                    n3 &= this.sio.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.sio.readControlB();
                }
            }
        }
        if ((n & 0x40) == 0 && this.vdip != null) {
            n3 &= this.vdip.read(n & 3);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            this.initSRAM(this.ram, properties);
            if (this.sio != null && this.ram.length >= 24576) {
                this.ram[24568] = 0;
            }
        }
        boolean bl = resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET;
        this.pioSys.reset(bl);
        this.pioUser.reset(bl);
        this.ctc.reset(bl);
        if (this.sio != null) {
            this.sio.reset(bl);
            this.sio.setClearToSendA(true);
            this.sio.setClearToSendB(true);
        }
        if (this.tvTerm != null) {
            this.tvTerm.reset();
        }
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            Arrays.fill(this.kbMatrix, 0);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            nArray = this.digitValues;
            synchronized (this.digitValues) {
                Arrays.fill(this.digitStatus, 0);
                Arrays.fill(this.digitValues, 0);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                this.setChessMode(false);
                this.tapeInPhase = this.emuThread.readTapeInPhase();
                this.sioTStatesCounter = 0;
                return;
            }
        }
    }

    @Override
    public void saveBasicProgram() {
        int n = SourceUtil.getBasicEndAddr(this.emuThread, 9216);
        if (n >= 9216) {
            new SaveDlg(this.screenFrm, 9216, n, "LC-80ex-BASIC-Programm speichern", SaveDlg.BasicType.MS_DERIVED_BASIC_HS, EmuUtil.getHeadersaveFileFilter()).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        n = this.romC000 != null ? (n &= 0xFFFF) : (n &= 0x3FFF);
        boolean bl = false;
        if (n >= 8192 && n < 49152 && (n3 = n - 8192) < this.ram.length) {
            if (n3 < 24568 || n3 > 24576) {
                this.ram[n3] = (byte)n2;
            } else if (n3 == 24568) {
                if ((this.ram[24568] & 0x40) == 0 && (n2 & 0x40) != 0) {
                    this.updTimekeeperRAM();
                }
                this.ram[n3] = (byte)n2;
            }
            if (this.chessComputer && n >= 10005 && n < 10083) {
                this.screenFrm.setChessboardDirty(true);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsSaveBasic() {
        return this.sio != null;
    }

    @Override
    public boolean supportsChessboard() {
        return this.chessComputer;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return this.sio != null;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        if (fileFormat != null && (fileFormat.equals(FileFormat.BASIC_PRG) && n == 9216 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 9216 && n + n2 > 9223)) {
            int n4 = SourceUtil.getBasicEndAddr(this.emuThread, 9216) + 1;
            this.emuThread.setMemWord(8402, n4);
            this.emuThread.setMemWord(8404, n4);
            this.emuThread.setMemWord(8406, n4);
        }
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if (((n &= 0xFF) & 4) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pioUser.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.pioUser.writeDataB(n2);
                    break;
                }
                case 2: {
                    this.pioUser.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pioUser.writeControlB(n2);
                }
            }
        }
        if ((n & 8) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pioSys.writeDataA(n2);
                    this.curDigitValue = this.toDigitValue(this.pioSys.fetchOutValuePortA(false));
                    this.putKBMatrixRowValueToPort();
                    this.updDisplay();
                    break;
                }
                case 1: {
                    boolean bl;
                    this.pioSys.writeDataB(n2);
                    this.pioSysBValue = this.pioSys.fetchOutValuePortB(false);
                    boolean bl2 = bl = (this.pioSysBValue & 2) != 0;
                    if (bl != this.tapeOutPhase) {
                        this.tapeOutPhase = bl;
                        this.tapeOutState = true;
                        this.screenFrm.setScreenDirty(true);
                    }
                    this.putKBMatrixRowValueToPort();
                    this.updDisplay();
                    break;
                }
                case 2: {
                    this.pioSys.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pioSys.writeControlB(n2);
                }
            }
        }
        if ((n & 0x10) == 0) {
            this.ctc.write(n & 3, n2, n3);
        }
        if ((n & 0x20) == 0 && this.sio != null) {
            switch (n & 3) {
                case 0: {
                    this.sio.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.sio.writeDataB(n2);
                    if (this.tvTermFired) break;
                    this.screenFrm.fireOpenSecondScreen();
                    this.tvTermFired = true;
                    break;
                }
                case 2: {
                    this.sio.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.sio.writeControlB(n2);
                }
            }
        }
        if ((n & 0x40) == 0 && this.vdip != null) {
            this.vdip.write(n & 3, n2);
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.displayCheckTStates = z80CPU.getMaxSpeedKHz() * 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pioSys.putInValuePortB(this.tapeInPhase ? 1 : 0, false);
        }
        this.ctc.z80TStatesProcessed(z80CPU, n);
        if (this.displayCheckTStates > 0L) {
            this.curDisplayTStates += (long)n;
            if (this.curDisplayTStates > this.displayCheckTStates) {
                boolean bl2 = false;
                int[] nArray = this.digitValues;
                // MONITORENTER : this.digitValues
                for (int i = 0; i < this.digitValues.length; ++i) {
                    if (this.digitStatus[i] > 0) {
                        int n2 = i;
                        this.digitStatus[n2] = this.digitStatus[n2] - 1;
                        continue;
                    }
                    if (this.digitValues[i] == 0) continue;
                    this.digitValues[i] = 0;
                    bl2 = true;
                }
                // MONITOREXIT : nArray
                if (this.tapeOutState) {
                    this.tapeOutLED = !this.tapeOutLED;
                    bl2 = true;
                } else if (this.tapeOutLED) {
                    this.tapeOutLED = false;
                    bl2 = true;
                }
                if (bl2) {
                    this.screenFrm.setScreenDirty(true);
                }
                this.tapeOutState = false;
                this.curDisplayTStates = 0L;
            }
        }
        if (this.sio == null) return;
        this.sioTStatesCounter += n;
        while (this.sioTStatesCounter >= 12) {
            this.sioTStatesCounter -= 12;
            this.sio.clockPulseSenderA();
            this.sio.clockPulseSenderB();
            this.sio.clockPulseReceiverB();
        }
    }

    private void loadROMs(Properties properties) {
        this.romOSFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.romOS = this.readROMFile(this.romOSFile, 8192, "Monitorprogramm");
        if (this.romOS == null) {
            if (this.sysName.equals(SYSNAME_LC80_U505)) {
                if (lc80_u505 == null) {
                    lc80_u505 = this.readResource("/rom/lc80/lc80_u505.bin");
                }
                this.romOS = lc80_u505;
            } else if (this.sysName.equals(SYSNAME_LC80_2)) {
                if (lc80_2 == null) {
                    lc80_2 = this.readResource("/rom/lc80/lc80_2.bin");
                }
                this.romOS = lc80_2;
            } else if (this.sysName.equals(SYSNAME_LC80_E) || this.sysName.equals(SYSNAME_LC80_EX)) {
                if (lc80e_0000 == null) {
                    lc80e_0000 = this.readResource("/rom/lc80/lc80e_0000.bin");
                }
                this.romOS = lc80e_0000;
            } else {
                if (lc80_2716 == null) {
                    lc80_2716 = this.readResource("/rom/lc80/lc80_2716.bin");
                }
                this.romOS = lc80_2716;
            }
        }
        if (this.sysName.equals(SYSNAME_LC80_EX)) {
            this.romA000File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM_A000_PREFIX + "file");
            this.romA000 = this.readROMFile(this.romA000File, 8192, "ROM A000h / LLCTOOLS");
            if (this.romA000 == null) {
                if (lc80ex_a000 == null) {
                    lc80ex_a000 = this.readResource("/rom/lc80/lc80ex_a000.bin");
                }
                this.romA000 = lc80ex_a000;
            }
        } else {
            this.romA000 = null;
        }
        if (this.sysName.equals(SYSNAME_LC80_E) || this.sysName.equals(SYSNAME_LC80_EX)) {
            this.romC000File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM_C000_PREFIX + "file");
            this.romC000 = this.readROMFile(this.romC000File, 16384, "ROM C0000");
            if (this.romC000 == null) {
                if (this.sysName.equals(SYSNAME_LC80_E)) {
                    if (lc80e_c000 == null) {
                        lc80e_c000 = this.readResource("/rom/lc80/lc80e_c000.bin");
                    }
                    this.romC000 = lc80e_c000;
                } else if (this.sysName.equals(SYSNAME_LC80_EX)) {
                    if (lc80ex_c000 == null) {
                        lc80ex_c000 = this.readResource("/rom/lc80/lc80ex_c000.bin");
                    }
                    this.romC000 = lc80ex_c000;
                }
            }
        } else {
            this.romC000 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putKBMatrixRowValueToPort() {
        int n = 0;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            int n2 = 4;
            for (int i = 0; i < this.kbMatrix.length; ++i) {
                if ((this.pioSysBValue & n2) == 0) {
                    n |= this.kbMatrix[i];
                }
                n2 <<= 1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.pioUser.putInValuePortB(~n, 240);
            return;
        }
    }

    private void setChessMode(boolean bl) {
        if (bl != this.chessMode) {
            this.chessMode = bl;
            if (this.keyboardFld != null) {
                this.keyboardFld.repaint();
            }
        }
    }

    private static byte toBcdByte(int n) {
        return (byte)(n / 10 % 10 << 4 & 0xF0 | n % 10 & 0xF);
    }

    private int toDigitValue(int n) {
        int n2 = 0;
        if ((n & 1) == 0) {
            n2 |= 2;
        }
        if ((n & 2) == 0) {
            n2 |= 0x20;
        }
        if ((n & 4) == 0) {
            n2 |= 1;
        }
        if ((n & 8) == 0) {
            n2 |= 0x40;
        }
        if ((n & 0x10) == 0) {
            n2 |= 0x80;
        }
        if ((n & 0x20) == 0) {
            n2 |= 4;
        }
        if ((n & 0x40) == 0) {
            n2 |= 0x10;
        }
        if ((n & 0x80) == 0) {
            n2 |= 8;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updDisplay() {
        boolean bl = false;
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            int n = 128;
            for (int i = 0; i < this.digitValues.length; ++i) {
                if ((this.pioSysBValue & n) == 0) {
                    this.digitStatus[i] = 2;
                    if (this.digitValues[i] != this.curDigitValue) {
                        this.digitValues[i] = this.curDigitValue;
                        bl = true;
                    }
                }
                n >>= 1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl) {
                this.screenFrm.setScreenDirty(true);
            }
            return;
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.kbMatrix);
        }
    }

    private void updTimekeeperRAM() {
        if (this.ram.length >= 24576) {
            Calendar calendar = Calendar.getInstance();
            this.ram[24569] = LC80.toBcdByte(calendar.get(13));
            this.ram[24570] = LC80.toBcdByte(calendar.get(12));
            this.ram[24571] = LC80.toBcdByte(calendar.get(11));
            this.ram[24572] = LC80.toBcdByte(calendar.get(7));
            this.ram[24573] = LC80.toBcdByte(calendar.get(5));
            this.ram[24574] = LC80.toBcdByte(calendar.get(2) + 1);
            this.ram[24575] = LC80.toBcdByte(calendar.get(1) % 100);
        }
    }
}

