/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.poly880.Poly880KeyboardFld;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80PIO;

public class Poly880
extends EmuSys
implements Z80CTCListener {
    public static final String SYSNAME = "Poly880";
    public static final String SYSTEXT = "Poly-880";
    public static final String PROP_PREFIX = "jkcemu.poly880.";
    public static final String PROP_NEGATED = "negated";
    public static final String PROP_RAM8000_ENABLED = "ram_8000.enabled";
    public static final String PROP_ROM0000_PREFIX = "rom_0000.";
    public static final String PROP_ROM1000_PREFIX = "rom_1000.";
    public static final String PROP_ROM2000_PREFIX = "rom_2000.";
    public static final String PROP_ROM3000_PREFIX = "rom_3000.";
    private static final int[] key4 = new int[]{71, -1, 88, 45, 82, -1, 83, 77};
    private static final int[] key5 = new int[]{48, 50, 51, 49, 56, 57, 66, 65};
    private static final int[] key7 = new int[]{52, 54, 55, 53, 67, 68, 70, 69};
    private static byte[] mon0000 = null;
    private static byte[] mon1000 = null;
    private byte[] ram = new byte[1024];
    private byte[] rom0Bytes = null;
    private byte[] rom1Bytes = null;
    private byte[] rom2Bytes = null;
    private byte[] rom3Bytes = null;
    private String rom0File = null;
    private String rom1File = null;
    private String rom2File = null;
    private String rom3File = null;
    private int[] keyboardMatrix;
    private int[] digitStatus;
    private int[] digitValues;
    private int colMask;
    private long curDisplayTStates;
    private long displayCheckTStates;
    private boolean tapeInPhase;
    private boolean nmiEnabled;
    private boolean nmiTrigger;
    private boolean ram8000;
    private boolean extRomsNegated;
    private Z80CTC ctc;
    private Z80PIO pio1;
    private Z80PIO pio2;
    private Poly880KeyboardFld keyboardFld;

    public Poly880(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.ram8000 = this.emulatesRAM8000(properties);
        this.extRomsNegated = this.emulatesNegatedROMs(properties);
        this.curDisplayTStates = 0L;
        this.displayCheckTStates = 0L;
        this.digitStatus = new int[8];
        this.digitValues = new int[8];
        this.keyboardMatrix = new int[8];
        this.keyboardFld = null;
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.pio1 = new Z80PIO("PIO (80-83)");
        this.pio2 = new Z80PIO("PIO (84-87)");
        this.ctc = new Z80CTC("CTC (88-8B)");
        z80CPU.setInterruptSources(this.pio1, this.pio2, this.ctc);
        this.ctc.setTimerConnection(2, 3);
        this.ctc.addCTCListener(this);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public void fireMonKey() {
        if (this.nmiEnabled) {
            this.emuThread.getZ80CPU().fireNMI();
        }
    }

    public static int getDefaultSpeedKHz() {
        return 922;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc && n == 0 && this.nmiEnabled) {
            this.nmiEnabled = false;
            this.nmiTrigger = true;
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = TextUtil.equals(this.rom0File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM0000_PREFIX + "file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.rom1File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM1000_PREFIX + "file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.rom2File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM2000_PREFIX + "file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.rom3File, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM3000_PREFIX + "file"));
        }
        if (bl && (this.rom0File != null || this.rom1File != null || this.rom2File != null || this.rom3File != null) && this.emulatesNegatedROMs(properties) != this.extRomsNegated) {
            bl = false;
        }
        if (bl && this.emulatesRAM8000(properties) != this.ram8000) {
            bl = false;
        }
        return bl;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new Poly880KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        this.ctc.removeCTCListener(this);
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
    }

    @Override
    public int getAppStartStackInitValue() {
        return 17314;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorGreenDark;
                break;
            }
            case 2: {
                color = this.colorGreenLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 3;
    }

    @Override
    public String getHelpPage() {
        return "/help/poly880.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if ((n &= 0xFFFF) < 32768) {
            int n3;
            if ((n &= 0xF3FF) < 4096 && this.rom0Bytes != null) {
                if (n < this.rom0Bytes.length) {
                    n2 = this.rom0Bytes[n] & 0xFF;
                }
            } else if (n >= 4096 && n < 8192 && this.rom1Bytes != null) {
                int n4 = n - 4096;
                if (n4 < this.rom1Bytes.length) {
                    n2 = this.rom1Bytes[n4] & 0xFF;
                }
            } else if (n >= 8192 && n < 12288 && this.rom2Bytes != null) {
                int n5 = n - 8192;
                if (n5 < this.rom2Bytes.length) {
                    n2 = this.rom2Bytes[n5] & 0xFF;
                }
            } else if (n >= 12288 && n < 16384 && this.rom3Bytes != null) {
                int n6 = n - 12288;
                if (n6 < this.rom3Bytes.length) {
                    n2 = this.rom3Bytes[n6] & 0xFF;
                }
            } else if (n >= 16384 && (n3 = n - 16384) < this.ram.length) {
                n2 = this.ram[n3] & 0xFF;
            }
        } else if (this.ram8000) {
            n2 = this.emuThread.getRAMByte(n);
        }
        return n2;
    }

    @Override
    public int getScreenHeight() {
        return 85;
    }

    @Override
    public int getScreenWidth() {
        return this.digitValues.length * 65 - 15;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            switch (n) {
                case 8: {
                    this.keyboardMatrix[3] = this.keyboardMatrix[3] | 0x10;
                    bl3 = true;
                    break;
                }
                case 10: {
                    this.keyboardMatrix[2] = this.keyboardMatrix[2] | 0x10;
                    bl3 = true;
                    break;
                }
                case 27: {
                    this.emuThread.fireReset(EmuThread.ResetLevel.WARM_RESET);
                    bl3 = true;
                    break;
                }
                case 112: {
                    this.keyboardMatrix[5] = this.keyboardMatrix[5] | 0x10;
                    bl3 = true;
                    break;
                }
                case 113: {
                    this.fireMonKey();
                    bl3 = true;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000') {
            char c2 = Character.toUpperCase(c);
            bl = this.setKeyMatrixValue(key4, c2, 16);
            if (!bl) {
                bl = this.setKeyMatrixValue(key5, c2, 32);
            }
            if (!bl) {
                bl = this.setKeyMatrixValue(key7, c2, 128);
            }
        }
        if (bl) {
            this.updKeyboardFld();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                Poly880.paint7SegDigit(graphics, n, n2, this.digitValues[i], this.colorGreenDark, this.colorGreenLight, n3);
                n += 65 * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        switch (n & 0x8F) {
            case 128: {
                n3 = this.pio1.readDataA();
                break;
            }
            case 129: {
                n3 = this.pio1.readControlA();
                break;
            }
            case 130: {
                int n4 = 0;
                int[] nArray = this.keyboardMatrix;
                synchronized (this.keyboardMatrix) {
                    int n5 = 1;
                    for (int i = 0; i < this.keyboardMatrix.length; ++i) {
                        if ((this.colMask & n5) != 0) {
                            n4 |= this.keyboardMatrix[i];
                        }
                        n5 <<= 1;
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    this.pio1.putInValuePortB(n4 & 0xB0, 253);
                    n3 = this.pio1.readDataB();
                    break;
                }
            }
            case 131: {
                n3 = this.pio1.readControlB();
                break;
            }
            case 132: {
                n3 = this.pio2.readDataA();
                break;
            }
            case 133: {
                n3 = this.pio2.readControlA();
                break;
            }
            case 134: {
                n3 = this.pio2.readDataB();
                break;
            }
            case 135: {
                n3 = this.pio2.readControlB();
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                n3 = this.ctc.read(n & 3, n2);
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        int n2 = this.getMemByte(n, bl);
        if (bl && this.nmiTrigger) {
            this.nmiTrigger = false;
            this.emuThread.getZ80CPU().fireNMI();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            this.initSRAM(this.ram, properties);
        }
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            Arrays.fill(this.digitStatus, 0);
            Arrays.fill(this.digitValues, 0);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            nArray = this.keyboardMatrix;
            synchronized (this.keyboardMatrix) {
                Arrays.fill(this.keyboardMatrix, 0);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.colMask = 0;
                this.tapeInPhase = this.emuThread.readTapeInPhase();
                this.nmiEnabled = true;
                this.nmiTrigger = false;
                return;
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if ((n &= 0xFFFF) < 32768) {
            int n3;
            if ((n &= 0xF3FF) >= 16384 && (n3 = n - 16384) < this.ram.length) {
                this.ram[n3] = (byte)n2;
                bl = true;
            }
        } else if (this.ram8000) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        int n4 = 0;
        switch (n & 0x8F) {
            case 128: {
                this.pio1.writeDataA(n2);
                break;
            }
            case 129: {
                this.pio1.writeControlA(n2);
                break;
            }
            case 130: {
                this.pio1.writeDataB(n2);
                n4 = this.pio1.fetchOutValuePortB(false);
                this.soundOutPhase = (n4 & 1) != 0;
                this.tapeOutPhase = (n4 & 4) != 0;
                this.nmiEnabled = (n4 & 0x40) == 0;
                break;
            }
            case 131: {
                this.pio1.writeControlB(n2);
                break;
            }
            case 132: {
                this.pio2.writeDataA(n2);
                break;
            }
            case 133: {
                this.pio2.writeControlA(n2);
                break;
            }
            case 134: {
                this.pio2.writeDataB(n2);
                break;
            }
            case 135: {
                this.pio2.writeControlB(n2);
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                this.ctc.write(n & 3, n2, n3);
            }
        }
        if ((n & 0xB0) != 176) return;
        this.colMask = n2;
        boolean bl = false;
        n4 = this.toDigitValue(this.pio1.fetchOutValuePortA(false));
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            int n5 = 128;
            for (int i = 0; i < this.digitValues.length; ++i) {
                if ((n2 & n5) != 0) {
                    this.digitStatus[i] = 2;
                    if (this.digitValues[i] != n4) {
                        this.digitValues[i] = n4;
                        bl = true;
                    }
                }
                n5 >>= 1;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (!bl) return;
            this.screenFrm.setScreenDirty(true);
            return;
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.displayCheckTStates = z80CPU.getMaxSpeedKHz() * 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pio1.putInValuePortB(this.tapeInPhase ? 2 : 0, 2);
        }
        this.ctc.z80TStatesProcessed(z80CPU, n);
        if (this.displayCheckTStates <= 0L) return;
        this.curDisplayTStates += (long)n;
        if (this.curDisplayTStates <= this.displayCheckTStates) return;
        boolean bl2 = false;
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                if (this.digitStatus[i] > 0) {
                    int n2 = i;
                    this.digitStatus[n2] = this.digitStatus[n2] - 1;
                    continue;
                }
                if (this.digitValues[i] == 0) continue;
                this.digitValues[i] = 0;
                bl2 = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl2) {
                this.screenFrm.setScreenDirty(true);
            }
            this.curDisplayTStates = 0L;
            return;
        }
    }

    private boolean emulatesNegatedROMs(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom." + PROP_NEGATED, false);
    }

    private boolean emulatesRAM8000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_RAM8000_ENABLED, false);
    }

    private void loadROMs(Properties properties) {
        this.rom0File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM0000_PREFIX + "file");
        this.rom0Bytes = this.readPoly880ROMFile(this.rom0File, "ROM 0");
        if (this.rom0Bytes == null) {
            if (mon0000 == null) {
                mon0000 = this.readResource("/rom/poly880/poly880_0000.bin");
            }
            this.rom0Bytes = mon0000;
        }
        this.rom1File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM1000_PREFIX + "file");
        this.rom1Bytes = this.readPoly880ROMFile(this.rom1File, "ROM 1");
        if (this.rom1Bytes == null) {
            if (mon1000 == null) {
                mon1000 = this.readResource("/rom/poly880/poly880_1000.bin");
            }
            this.rom1Bytes = mon1000;
        }
        this.rom2File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM2000_PREFIX + "file");
        this.rom2Bytes = this.readPoly880ROMFile(this.rom2File, "ROM 2");
        this.rom3File = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROM3000_PREFIX + "file");
        this.rom3Bytes = this.readPoly880ROMFile(this.rom3File, "ROM 3");
    }

    private byte[] readPoly880ROMFile(String string, String string2) {
        byte[] byArray = this.readROMFile(string, 1024, string2);
        if (byArray != null && this.extRomsNegated) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = ~byArray[i];
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setKeyMatrixValue(int[] nArray, int n, int n2) {
        boolean bl = false;
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n3 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (int i = 0; i < n3; ++i) {
                if (n != nArray[i]) continue;
                int n4 = i;
                this.keyboardMatrix[n4] = this.keyboardMatrix[n4] | n2;
                bl = true;
                break;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return bl;
        }
    }

    private int toDigitValue(int n) {
        int n2 = n & 4;
        if ((n & 1) != 0) {
            n2 |= 0x10;
        }
        if ((n & 2) != 0) {
            n2 |= 8;
        }
        if ((n & 8) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x20) != 0) {
            n2 |= 1;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0x80) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

