/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.OptionDlg;
import jkcemu.base.RAMFloppy;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.disk.GIDE;
import jkcemu.emusys.Z9001;
import jkcemu.emusys.z1013.GraphicCCJ;
import jkcemu.emusys.z1013.KeyboardMatrix;
import jkcemu.emusys.z1013.KeyboardMatrix8x4;
import jkcemu.emusys.z1013.KeyboardMatrix8x8;
import jkcemu.emusys.z1013.Z1013Keyboard;
import jkcemu.emusys.z1013.Z1013KeyboardFld8x4;
import jkcemu.emusys.z1013.Z1013KeyboardFld8x8;
import jkcemu.etc.RTC7242X;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.print.PrintMngr;
import jkcemu.text.TextUtil;
import z80emu.Z80AddressListener;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;
import z80emu.Z80MemView;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;

public class Z1013
extends EmuSys
implements FDC8272.DriveSelector,
Z80AddressListener,
Z80PCListener {
    public static final String SYSNAME = "Z1013";
    public static final String SYSNAME_Z1013_01 = "Z1013.01";
    public static final String SYSNAME_Z1013_12 = "Z1013.12";
    public static final String SYSNAME_Z1013_16 = "Z1013.16";
    public static final String SYSNAME_Z1013_64 = "Z1013.64";
    public static final String PROP_PREFIX = "jkcemu.z1013.";
    public static final String PROP_CATCH_JOY_CALLS = "catch_joystick_calls";
    public static final String PROP_GCCJ_FONT_FILE = "graphic_ccj.font.file";
    public static final String PROP_GCCJ_ENABLED = "graphic_ccj.enabled";
    public static final String PROP_GRAPHIC_ENABLED = "graphic.enabled";
    public static final String PROP_MONITOR = "monitor";
    public static final String PROP_ROMBASIC_PREFIX = "rom_basic.";
    public static final String PROP_ROMMEGA_PREFIX = "rom_mega.";
    public static final String PROP_USERPORT = "userport";
    public static final String VALUE_MON_202 = "2.02";
    public static final String VALUE_MON_A2 = "A.2";
    public static final String VALUE_MON_RB_K7659 = "RB_K7659";
    public static final String VALUE_MON_RB_S6009 = "RB_S6009";
    public static final String VALUE_MON_INCOM_K7669 = "INCOM_K7669";
    public static final String VALUE_MON_JM_1992 = "JM_1992";
    public static final String VALUE_MON_BL4_K7659 = "BL4_K7659";
    public static final String VALUE_CEN7_PRAC0289 = "centronics7:practic0289";
    public static final String VALUE_CEN8_FA1090 = "centronics8:fa1090";
    public static final String VALUE_JOY_JUTE0687 = "joystick:jute0687";
    public static final String VALUE_JOY_PRAC0487 = "joystick:practic0487";
    public static final String VALUE_JOY_PRAC0188 = "joystick:practic0188";
    public static final String PROP_ROMBASIC_ENABLED = "rom_basic.enabled";
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    public static final int FUNCTION_KEY_COUNT = 4;
    public static final int MEM_ARG1 = 27;
    public static final int MEM_HEAD = 224;
    public static final String[] basicTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "!", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "PI", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "LOAD", "TRON", "TROFF", "EDIT", "ELSE", "INKEY$", "JOYST", "STRING$", "INSTR", "RENUMBER", "DELETE", "PAUSE", "BEEP", "WINDOW", "BORDER", "INK", "PAPER", "AT", "HSAVE", "HLOAD", "PSET", "PRES"};
    private static final String[] sysCallNames = new String[]{"OUTCH", "INCH", "PRST7", "INHEX", "INKEY", "INLIN", "OUTHX", "OUTHL", "CSAVE", "CLOAD", "MEM", "WIND", "OTHLS", "OUTDP", "OUTSP", "TRANS", "INSTR", "KILL", "HEXUM", "ALPHA"};
    private static final int[] char14ToUnicode = new int[]{9823, 9820, 9822, 32, 9821, 32, 9819, 9818, 32, 9817, 9814, 9816, 32, 9815, 32, 9813, 9812, 32};
    private static final FloppyDiskInfo cpm64x16FloppyDisk = new FloppyDiskInfo("/disks/z1013/z1013cpm64x16.dump.gz", "Z1013 CP/M Boot-Diskette (64x16 Zeichen)", 2, 2048, true);
    private static final FloppyDiskInfo cpm80x25FloppyDisk = new FloppyDiskInfo("/disks/z1013/z1013cpm80x25.dump.gz", "Z1013 CP/M Boot-Diskette (80x25 Zeichen)", 2, 2048, true);
    private static final FloppyDiskInfo[] availableFloppyDisks = new FloppyDiskInfo[]{cpm64x16FloppyDisk, cpm80x25FloppyDisk};
    private static byte[] mon202 = null;
    private static byte[] monA2 = null;
    private static byte[] monRB_K7659 = null;
    private static byte[] monRB_S6009 = null;
    private static byte[] monINCOM_K7669 = null;
    private static byte[] monJM_1992 = null;
    private static byte[] bl4_K7659 = null;
    private static byte[] modBasic = null;
    private static byte[] fontStd = null;
    private static byte[] fontAlt = null;
    private Z80PIO pio;
    private GIDE gide;
    private FDC8272 fdc;
    private RTC7242X rtc;
    private GraphicCCJ graphCCJ;
    private Z1013Keyboard keyboard;
    private AbstractKeyboardFld keyboardFld;
    private KCNet kcNet;
    private VDIP vdip;
    private RAMFloppy ramFloppy1;
    private RAMFloppy ramFloppy2;
    private int ramPixelBank = 0;
    private int ramEndAddr;
    private byte[][] ramPixel;
    private byte[] ramStatic;
    private byte[] ramVideo;
    private byte[] romBasic = null;
    private byte[] romMega = null;
    private byte[] stdFontBytes = null;
    private byte[] altFontBytes = null;
    private byte[] osBytes = null;
    private String osFile = null;
    private String romBasicFile = null;
    private String romMegaFile = null;
    private String monCode = null;
    private String sysName;
    private boolean tapeInPhase;
    private boolean romDisabled = false;
    private boolean altFontEnabled = false;
    private boolean graphCCJActive = false;
    private boolean catchPrintCalls;
    private boolean mode4MHz = false;
    private boolean mode64x16 = false;
    private volatile boolean modeGraph = false;
    private volatile boolean pasteFast = false;
    private volatile int charToPaste = 0;
    private int centrTStatesToAck = 0;
    private int romMegaSeg = 0;
    private int lastWrittenAddr = -1;
    private int[] pcListenerAddrs = null;
    private FloppyDiskDrive[] floppyDiskDrives;
    private BasicType lastBasicType = null;
    private UserPort userPort = UserPort.NONE;
    private volatile int joy0ActionMask;
    private volatile int joy1ActionMask;
    private volatile boolean catchJoyCalls;

    public Z1013(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        this.ramEndAddr = Z1013.getRAMEndAddr(properties);
        this.ramVideo = new byte[1024];
        this.ramStatic = null;
        if (this.ramEndAddr == 1023) {
            this.ramStatic = new byte[1024];
        }
        this.sysName = EmuUtil.getProperty(properties, "jkcemu.system");
        this.ramPixel = null;
        if (this.emulatesGraphic(properties)) {
            this.ramPixel = new byte[8][];
            for (int i = 0; i < this.ramPixel.length; ++i) {
                this.ramPixel[i] = new byte[1024];
            }
        }
        this.ramFloppy1 = RAMFloppy.prepare(this.emuThread.getRAMFloppy1(), SYSNAME, RAMFloppy.RFType.MP_3_1988, "RAM-Floppy an E/A-Adressen 98h-9Fh", properties, "jkcemu.z1013.ramfloppy.1.");
        this.ramFloppy2 = RAMFloppy.prepare(this.emuThread.getRAMFloppy2(), SYSNAME, RAMFloppy.RFType.MP_3_1988, "RAM-Floppy an E/A-Adressen 58h-5Fh", properties, "jkcemu.z1013.ramfloppy.2.");
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        this.pio = new Z80PIO("PIO (E/A-Adressen 00-03)");
        z80CPU.addAddressListener(this);
        z80CPU.addMaxSpeedListener(this);
        this.checkAddPCListener(properties);
        if (this.emulatesFloppyDisk(properties)) {
            this.floppyDiskDrives = new FloppyDiskDrive[4];
            Arrays.fill(this.floppyDiskDrives, null);
            this.fdc = new FDC8272(this, 4);
        } else {
            this.floppyDiskDrives = null;
            this.fdc = null;
        }
        z80CPU.addTStatesListener(this);
        this.rtc = this.emulatesRTC(properties) ? new RTC7242X() : null;
        this.graphCCJ = this.emulatesGraphCCJ(properties) ? new GraphicCCJ(this.screenFrm, EmuUtil.getProperty(properties, this.propPrefix + PROP_GCCJ_FONT_FILE)) : null;
        this.kcNet = this.emulatesKCNet(properties) ? new KCNet("Netzwerk-PIO (E/A-Adressen C0-C3)") : null;
        this.vdip = this.emulatesUSB(properties) ? new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen FC-FF)") : null;
        this.gide = GIDE.getGIDE(this.screenFrm, properties, this.propPrefix);
        ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
        arrayList.add(this.pio);
        if (this.kcNet != null) {
            arrayList.add(this.kcNet);
        }
        if (this.vdip != null) {
            arrayList.add(this.vdip);
        }
        try {
            z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        this.keyboardFld = null;
        this.keyboard = new Z1013Keyboard(this.pio);
        this.keyboard.applySettings(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
        this.z80MaxSpeedChanged(z80CPU);
        this.applyUserPortSettings(properties);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return availableFloppyDisks;
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").startsWith(SYSNAME_Z1013_01) ? 1000 : 2000;
    }

    public static String getTinyBasicProgram(EmuMemView emuMemView) {
        return SourceUtil.getTinyBasicProgram(emuMemView, 4434, emuMemView.getMemWord(4127));
    }

    public Z1013Keyboard getZ1013Keyboard() {
        return this.keyboard;
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            floppyDiskDrive = this.floppyDiskDrives[n];
        }
        return floppyDiskDrive;
    }

    @Override
    public void z80AddressChanged(int n) {
        this.pio.putInValuePortB(n << 5 & 0x20, 32);
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        boolean bl = false;
        switch (n) {
            case 61721: 
            case 61744: 
            case 62042: {
                if (!this.pasteFast || this.charToPaste == 0) break;
                z80CPU.setRegA(this.charToPaste & 0xFF);
                this.charToPaste = 0;
                bl = true;
                break;
            }
            case 65467: {
                int[] nArray = new int[]{this.joy1ActionMask, this.joy0ActionMask};
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    n2 <<= 8;
                    int n3 = nArray[i];
                    if ((n3 & 1) != 0) {
                        n2 |= 1;
                    }
                    if ((n3 & 2) != 0) {
                        n2 |= 2;
                    }
                    if ((n3 & 8) != 0) {
                        n2 |= 4;
                    }
                    if ((n3 & 4) != 0) {
                        n2 |= 8;
                    }
                    if ((n3 & 0x30) == 0) continue;
                    n2 |= 0x10;
                }
                z80CPU.setRegBC(n2);
                z80CPU.setFlagZero(n2 == 0);
                z80CPU.setFlagCarry(false);
                bl = true;
                break;
            }
            case 65482: 
            case 65512: {
                this.emuThread.getPrintMngr().putByte(z80CPU.getRegA());
                bl = true;
                break;
            }
            case 65485: 
            case 65515: {
                this.emuThread.getPrintMngr().reset();
                bl = true;
                break;
            }
            case 65503: {
                this.emuThread.getPrintMngr().putByte(this.getMemByte(27, false));
                bl = true;
                break;
            }
            case 65509: {
                PrintMngr printMngr = this.emuThread.getPrintMngr();
                int n4 = 60416;
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        printMngr.putByte(this.getMemByte(n4++, false));
                    }
                    printMngr.putByte(13);
                    printMngr.putByte(10);
                }
                bl = true;
            }
        }
        if (bl) {
            z80CPU.setRegPC(z80CPU.doPop());
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        int n;
        stringBuilder.append("<h1>Z1013 Status</h1>\n<table border=\"1\">\n<tr><td>Monitor-ROM");
        byte[] byArray = this.osBytes;
        if (byArray != null && byArray.length > 0) {
            stringBuilder.append(String.format(" (F000h-F%03X)", Math.min(byArray.length, 4096) - 1));
        }
        stringBuilder.append(":</td><td>");
        EmuUtil.appendOnOffText(stringBuilder, !this.romDisabled);
        stringBuilder.append("</td></tr>\n");
        if (this.romMega != null) {
            stringBuilder.append("<tr><td>Mega-ROM (C000h-E7FFh):</td><td>Bank ");
            stringBuilder.append(this.romMegaSeg);
            stringBuilder.append("</td></tr>\n");
        }
        if (this.ramPixel != null) {
            stringBuilder.append("<tr><td>KRT-Grafik:</td><td>");
            if (this.modeGraph) {
                n = this.ramPixelBank;
                if (n >= 0 && n < this.ramPixel.length) {
                    stringBuilder.append("Bank ");
                    stringBuilder.append(n);
                    stringBuilder.append(" ein");
                }
            } else {
                stringBuilder.append("aus (Standard-BWS ein)");
            }
            stringBuilder.append("</td></tr>\n");
        }
        stringBuilder.append("</td></tr>\n<tr><td>Bildausgabe:</td><td>");
        n = 0;
        if (this.ramPixel != null || this.graphCCJ != null) {
            if (this.graphCCJActive) {
                stringBuilder.append("Grafikkarte CC Jena");
                n = 1;
            } else if (this.modeGraph) {
                stringBuilder.append("KRT-Grafik");
                if (this.mode64x16) {
                    stringBuilder.append(" (64x16 Modus aktiv)");
                }
                n = 1;
            } else {
                stringBuilder.append("Standard-BWS, ");
            }
        }
        if (n == 0) {
            stringBuilder.append(this.mode64x16 ? "64x16" : "32x32");
            stringBuilder.append(" Zeichen");
            if (this.altFontEnabled) {
                stringBuilder.append(", alternativer Zeichensatz");
            }
        }
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.checkAddPCListener(properties);
        this.loadFonts(properties);
        this.applyUserPortSettings(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(this.sysName);
        if (bl) {
            bl = TextUtil.equals(this.osFile, EmuUtil.getProperty(properties, this.propPrefix + "os.file"));
        }
        if (bl) {
            bl = TextUtil.equals(this.monCode, EmuUtil.getProperty(properties, this.propPrefix + PROP_MONITOR));
        }
        if (bl && Z1013.getRAMEndAddr(properties) != this.ramEndAddr) {
            bl = false;
        }
        if (bl && this.emulatesModuleBasic(properties) == (this.romBasic != null)) {
            if (this.romBasic != null && !TextUtil.equals(this.romBasicFile, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROMBASIC_PREFIX + "file"))) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl && this.emulatesModuleMegaROM(properties) == (this.romMega != null)) {
            if (this.romMega != null && !TextUtil.equals(this.romMegaFile, EmuUtil.getProperty(properties, this.propPrefix + PROP_ROMMEGA_PREFIX + "file"))) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            bl = GIDE.complies(this.gide, properties, this.propPrefix);
        }
        if (bl && this.emulatesFloppyDisk(properties) != (this.fdc != null)) {
            bl = false;
        }
        if (bl && this.emulatesRTC(properties) != (this.rtc != null)) {
            bl = false;
        }
        if (bl && this.emulatesGraphCCJ(properties) != (this.graphCCJ != null)) {
            bl = false;
        }
        if (bl && this.emulatesGraphic(properties) != (this.ramPixel != null)) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy1, SYSNAME, RAMFloppy.RFType.MP_3_1988, properties, "jkcemu.z1013.ramfloppy.1.");
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy2, SYSNAME, RAMFloppy.RFType.MP_3_1988, properties, "jkcemu.z1013.ramfloppy.2.");
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        boolean bl;
        boolean bl2 = bl = !this.modeGraph;
        if (this.graphCCJ != null && this.graphCCJActive) {
            bl = this.graphCCJ.canExtractScreenText();
        }
        return bl;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() throws UnsupportedOperationException {
        AbstractKeyboardFld abstractKeyboardFld = null;
        KeyboardMatrix keyboardMatrix = this.keyboard.getKeyboardMatrix();
        if (keyboardMatrix != null) {
            if (keyboardMatrix instanceof KeyboardMatrix8x4) {
                abstractKeyboardFld = new Z1013KeyboardFld8x4(this);
            } else if (keyboardMatrix instanceof KeyboardMatrix8x8) {
                abstractKeyboardFld = new Z1013KeyboardFld8x8(this);
            }
        }
        this.keyboardFld = abstractKeyboardFld;
        if (abstractKeyboardFld == null) {
            throw new UnsupportedOperationException();
        }
        return abstractKeyboardFld;
    }

    @Override
    public void die() {
        if (this.gide != null) {
            this.gide.die();
        }
        if (this.ramFloppy1 != null) {
            this.ramFloppy1.deinstall();
        }
        if (this.ramFloppy2 != null) {
            this.ramFloppy2.deinstall();
        }
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeAddressListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.removeTStatesListener(this);
        if (this.fdc != null) {
            this.fdc.die();
        }
        z80CPU.setInterruptSources(null);
        if (this.pcListenerAddrs != null) {
            z80CPU.removePCListener(this);
        }
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getAppStartStackInitValue() {
        return 176;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (this.graphCCJ != null && this.graphCCJActive) {
            if (this.graphCCJ.getPixel(n, n2)) {
                n3 = 1;
            }
        } else {
            int n4;
            int n5 = 0;
            if (this.ramPixel != null && this.modeGraph) {
                byte[] byArray;
                n4 = n2 % (this.mode64x16 ? 16 : 8);
                if (n4 >= 0 && n4 < this.ramPixel.length && (byArray = this.ramPixel[n4]) != null) {
                    int n6 = -1;
                    int n7 = n / 8;
                    if (this.mode64x16) {
                        int n8 = n2 % 16;
                        if (n8 < 8) {
                            int n9 = n2 / 16;
                            n6 = n9 * 64 + n7;
                        }
                    } else {
                        int n10 = n2 / 8;
                        n6 = n10 * 32 + n7;
                    }
                    if (n6 >= 0 && n6 < byArray.length) {
                        n5 = (byte)(~byArray[n6]) & 0xFF;
                    }
                }
            } else {
                byte[] byArray = null;
                byArray = this.altFontEnabled ? this.altFontBytes : this.stdFontBytes;
                if (byArray != null) {
                    int n11;
                    int n12 = n / 8;
                    int n13 = -1;
                    int n14 = 0;
                    if (this.mode64x16) {
                        n11 = n2 / 16;
                        n13 = n11 * 64 + n12;
                        n14 = n2 % 16;
                    } else {
                        n11 = n2 / 8;
                        n13 = n11 * 32 + n12;
                        n14 = n2 % 8;
                    }
                    if (n14 < 8 && n13 >= 0 && n13 < this.ramVideo.length && (n11 = (this.ramVideo[n13] & 0xFF) * 8 + n14) >= 0 && n11 < byArray.length) {
                        n5 = byArray[n11];
                    }
                }
            }
            if (n5 != 0) {
                n4 = 128;
                int n15 = n % 8;
                if (n15 > 0) {
                    n4 >>= n15;
                }
                if ((n5 & n4) != 0) {
                    n3 = 1;
                }
            }
        }
        return n3;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        charRaster = this.graphCCJ != null && this.graphCCJActive ? this.graphCCJ.getCharRaster() : (this.mode64x16 ? new CharRaster(64, 16, 16, 8, 8, 0) : new CharRaster(32, 32, 8, 8, 8, 0));
        return charRaster;
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_780K;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return this.pasteFast ? 0L : 150L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return this.pasteFast ? 0L : 200L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return this.pasteFast ? 0L : 80L;
    }

    @Override
    public String getHelpPage() {
        return "/help/z1013.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        byte[] byArray;
        int n3 = 255;
        boolean bl2 = false;
        if ((n &= 0xFFFF) >= 49152 && n < 60416) {
            byte[] byArray2 = this.romBasic;
            if (byArray2 != null) {
                int n4 = n - 49152;
                if (n4 < byArray2.length) {
                    n3 = byArray2[n4] & 0xFF;
                    bl2 = true;
                }
            } else {
                byArray2 = this.romMega;
                if (byArray2 != null && n < 59392) {
                    int n5 = 0;
                    n5 = n < 51200 ? n - 49152 + this.romMegaSeg * 2048 : (n < 53248 ? n - 51200 + (256 + this.romMegaSeg) * 2048 : (n < 55296 ? n - 53248 + (512 + this.romMegaSeg) * 2048 : (n < 57344 ? n - 55296 + (768 + this.romMegaSeg) * 2048 : n - 57344 + (1024 + this.romMegaSeg) * 2048)));
                    if (n5 >= 0 && n5 < this.romMega.length) {
                        n3 = byArray2[n5] & 0xFF;
                    }
                    bl2 = true;
                }
            }
        } else if (n >= 60416 && n < 60416 + this.ramVideo.length) {
            int n6;
            byte[] byArray3 = null;
            if (this.ramPixel != null && this.modeGraph) {
                if (this.ramPixelBank >= 0 && this.ramPixelBank < this.ramPixel.length) {
                    byArray3 = this.ramPixel[this.ramPixelBank];
                }
            } else {
                byArray3 = this.ramVideo;
            }
            if (byArray3 != null && (n6 = n - 60416) >= 0 && n6 < byArray3.length) {
                n3 = byArray3[n6] & 0xFF;
            }
            bl2 = true;
        } else if (n >= 61440 && !this.romDisabled && (byArray = this.osBytes) != null && (n2 = n - 61440) < byArray.length) {
            n3 = byArray[n2] & 0xFF;
            bl2 = true;
        }
        if (!bl2 && this.ramStatic != null && n < this.ramStatic.length) {
            n3 = this.ramStatic[n] & 0xFF;
            bl2 = true;
        }
        if (!bl2 && n <= this.ramEndAddr) {
            n3 = this.emuThread.getRAMByte(n);
        }
        return n3;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 61440;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        if (this.graphCCJ != null && this.graphCCJActive) {
            n3 = this.graphCCJ.getScreenChar(n, n2);
        } else {
            int n4 = n2 * (this.mode64x16 ? 64 : 32) + n;
            if (n4 >= 0 && n4 < this.ramVideo.length) {
                int n5 = this.ramVideo[n4] & 0xFF;
                if (n5 >= 32 && n5 < 127) {
                    n3 = n5;
                } else if (this.altFontEnabled) {
                    if (n5 >= 160 && n5 < 255) {
                        n3 = n5 & 0x7F;
                    }
                } else if (n5 >= 14 && n5 < 32) {
                    n4 = n5 - 14;
                    if (n4 >= 0 && n4 < char14ToUnicode.length) {
                        n3 = char14ToUnicode[n4];
                    }
                } else {
                    n3 = Z9001.toUnicode(n5);
                }
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        int n = 256;
        if (this.graphCCJ != null && this.graphCCJActive) {
            n = this.graphCCJ.getScreenHeight();
        } else if (this.mode64x16) {
            n = 248;
        }
        return n;
    }

    @Override
    public int getScreenWidth() {
        int n = 256;
        if (this.graphCCJ != null && this.graphCCJActive) {
            n = this.graphCCJ.getScreenWidth();
        } else if (this.mode64x16) {
            n = 512;
        }
        return n;
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        FloppyDiskInfo[] floppyDiskInfoArray = null;
        if (this.fdc != null) {
            floppyDiskInfoArray = this.graphCCJ != null ? availableFloppyDisks : new FloppyDiskInfo[]{cpm64x16FloppyDisk};
        }
        return floppyDiskInfoArray;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.floppyDiskDrives != null ? this.floppyDiskDrives.length : 0;
    }

    @Override
    public int getSupportedJoystickCount() {
        int n = 0;
        if (this.catchJoyCalls) {
            n = 2;
        } else {
            switch (this.userPort) {
                case JOY_JUTE_6_1987: {
                    n = 1;
                    break;
                }
                case JOY_PRACTIC_4_1987: 
                case JOY_PRACTIC_1_1988: {
                    n = 2;
                }
            }
        }
        return n;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.sysName;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = this.keyboard.setKeyCode(n);
        if (bl3) {
            this.updKeyboardFld();
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        this.keyboard.setKeyReleased();
        this.updKeyboardFld();
    }

    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (this.osBytes == mon202) {
            bl = this.getMemByte(66, false) == 72;
        } else if (this.osBytes == monJM_1992) {
            bl = this.getMemByte(62, false) == 72;
        }
        boolean bl2 = this.keyboard.setKeyChar(c, bl);
        if (bl2) {
            this.updKeyboardFld();
        }
        return bl2;
    }

    @Override
    public void openBasicProgram() {
        boolean bl = false;
        BasicType basicType = null;
        String string = null;
        int n = -1;
        if (this.lastBasicType != null) {
            switch (this.lastBasicType) {
                case Z1013_TINY: {
                    n = 0;
                    break;
                }
                case KC_RAM: {
                    n = 1;
                    break;
                }
                case KC_ROM: {
                    n = 2;
                }
            }
        }
        switch (OptionDlg.showOptionDlg(this.screenFrm, "W\u00e4hlen Sie bitte den BASIC-Interpreter aus,\ndessen BASIC-Programm ge\u00f6ffnet werden soll.", "BASIC-Interpreter", n, "Z1013-Tiny-BASIC", "KC-BASIC (RAM-Version)", "KC-BASIC (ROM-Version)")) {
            case 0: {
                basicType = BasicType.Z1013_TINY;
                string = Z1013.getTinyBasicProgram(this.emuThread);
                break;
            }
            case 1: {
                basicType = BasicType.KC_RAM;
                string = SourceUtil.getBasicProgram(this.emuThread, 11265, basicTokens);
                break;
            }
            case 2: {
                basicType = BasicType.KC_ROM;
                string = SourceUtil.getBasicProgram(this.emuThread, 1025, basicTokens);
                break;
            }
            default: {
                bl = true;
            }
        }
        if (!bl) {
            if (string != null) {
                this.lastBasicType = basicType;
                this.screenFrm.openText(string);
            } else {
                this.showNoBasic();
            }
        }
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        if (this.pasteFast) {
            if (c > '\u0000' && c <= '\u00ff') {
                if (c == '\n') {
                    c = (char)13;
                }
                while (this.charToPaste != 0) {
                    Thread.sleep(10L);
                }
                this.charToPaste = c;
                bl = true;
            }
        } else {
            bl = super.pasteChar(c);
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 15;
        if ((n &= 0xFF) == 4) {
            n3 = 0;
            if (this.romDisabled) {
                n3 |= 0x10;
            }
            if (this.altFontEnabled) {
                n3 |= 0x20;
            }
            if (this.mode4MHz) {
                n3 |= 0x40;
            }
            if (this.mode64x16) {
                n3 |= 0x80;
            }
        } else if (n == 24 && this.graphCCJ != null) {
            n3 = this.graphCCJ.readStatus();
        } else if (n == 25 && this.graphCCJ != null) {
            n3 = this.graphCCJ.readData();
        }
        if (this.gide != null && ((n & 0xF0) == 64 || (n & 0xF0) == 128)) {
            int n4 = this.gide.read(n);
            if (n4 >= 0) {
                n3 = n4;
            }
        } else if ((n & 0xF0) == 112) {
            if (this.rtc != null) {
                n3 = this.rtc.read(n);
            }
        } else if ((n & 0xF8) == 152 && this.ramFloppy1 != null) {
            n3 = this.ramFloppy1.readByte(n & 7);
        } else if ((n & 0xF8) == 88 && this.ramFloppy2 != null) {
            n3 = this.ramFloppy2.readByte(n & 7);
        } else if ((n & 0xF0) == 192 && this.kcNet != null) {
            n3 = this.kcNet.read(n);
        } else if ((n & 0xFC) == 220 && this.vdip != null) {
            n3 = this.vdip.read(n);
        } else if (n >= 240 && n <= 255) {
            switch (n) {
                case 240: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readMainStatusReg();
                    break;
                }
                case 241: {
                    if (this.fdc == null) break;
                    n3 = this.fdc.readData();
                    break;
                }
                case 248: {
                    if (this.fdc == null) break;
                    this.fdc.fireTC();
                    break;
                }
                case 250: {
                    if (this.fdc == null) break;
                    this.fdc.reset(false);
                    break;
                }
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    if (this.romMega != null || this.vdip == null) break;
                    n3 = this.vdip.read(n);
                }
            }
        } else {
            switch (n & 0x1C) {
                case 0: {
                    switch (n & 3) {
                        case 0: {
                            n3 = this.pio.readDataA();
                            break;
                        }
                        case 1: {
                            n3 = this.pio.readControlA();
                            break;
                        }
                        case 2: {
                            n3 = this.pio.readDataB();
                            break;
                        }
                        case 3: {
                            n3 = this.pio.readControlB();
                        }
                    }
                    break;
                }
                case 12: {
                    this.modeGraph = true;
                    this.screenFrm.setScreenDirty(true);
                    break;
                }
                case 16: {
                    this.modeGraph = false;
                    this.screenFrm.setScreenDirty(true);
                }
            }
        }
        this.z80AddressChanged(n);
        return n3;
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = stringBuilder.length();
        int n7 = z80MemView.getMemByte(n, true);
        if (n7 == 231) {
            if (!bl) {
                stringBuilder.append(String.format("%04X  E7", n));
            }
            Z1013.appendSpacesToCol(stringBuilder, n6, n2);
            stringBuilder.append("RST");
            Z1013.appendSpacesToCol(stringBuilder, n6, n3);
            stringBuilder.append("20H\n");
            n5 = 1;
        } else if (n7 == 205 && z80MemView.getMemWord(n + 1) == 32) {
            if (!bl) {
                stringBuilder.append(String.format("%04X  CD 00 20", n));
            }
            Z1013.appendSpacesToCol(stringBuilder, n6, n2);
            stringBuilder.append("CALL");
            Z1013.appendSpacesToCol(stringBuilder, n6, n3);
            stringBuilder.append("0020H\n");
            n5 = 3;
        }
        if (n5 > 0) {
            n6 = stringBuilder.length();
            n7 = z80MemView.getMemByte(n += n5, false);
            if (!bl) {
                stringBuilder.append(String.format("%04X  %02X", n, n7));
            }
            Z1013.appendSpacesToCol(stringBuilder, n6, n2);
            stringBuilder.append("DB");
            Z1013.appendSpacesToCol(stringBuilder, n6, n3);
            if (n7 >= 160) {
                stringBuilder.append('0');
            }
            stringBuilder.append(String.format("%02XH", n7));
            if (n7 >= 0 && n7 < sysCallNames.length) {
                Z1013.appendSpacesToCol(stringBuilder, n6, n4);
                stringBuilder.append(';');
                stringBuilder.append(sysCallNames[n7]);
            }
            stringBuilder.append('\n');
            ++n5;
            if (n7 == 2) {
                n5 += Z1013.reassStringBit7(z80MemView, n + 1, stringBuilder, bl, n2, n3);
            }
        }
        return n5;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        int n;
        super.reset(resetLevel, properties);
        boolean bl = this.mode64x16;
        this.centrTStatesToAck = 0;
        this.joy0ActionMask = 0;
        this.joy1ActionMask = 0;
        this.romMegaSeg = 0;
        this.lastWrittenAddr = -1;
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.romDisabled = false;
        this.altFontEnabled = false;
        this.modeGraph = false;
        if (this.mode64x16 || this.graphCCJActive) {
            this.graphCCJActive = false;
            this.mode64x16 = false;
            this.screenFrm.fireScreenSizeChanged();
        }
        if (this.mode4MHz) {
            this.emuThread.updCPUSpeed(Main.getProperties());
            this.mode4MHz = false;
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            if (this.ramPixel != null) {
                for (n = 0; n < this.ramPixel.length; ++n) {
                    this.fillRandom(this.ramPixel[n]);
                }
            }
            if (this.ramStatic != null) {
                this.initSRAM(this.ramStatic, properties);
            }
            this.fillRandom(this.ramVideo);
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.pio.reset(true);
        } else {
            this.pio.reset(false);
        }
        this.keyboard.reset();
        if (this.gide != null) {
            this.gide.reset();
        }
        if (this.fdc != null) {
            this.fdc.reset(resetLevel == EmuThread.ResetLevel.POWER_ON);
        }
        if (this.floppyDiskDrives != null) {
            for (n = 0; n < this.floppyDiskDrives.length; ++n) {
                FloppyDiskDrive floppyDiskDrive = this.floppyDiskDrives[n];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        if (this.userPort == UserPort.CENTR7_PRACTIC_2_1989) {
            this.pio.putInValuePortA(0, 128);
        }
    }

    @Override
    public void saveBasicProgram() {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        BasicType basicType = null;
        SaveDlg.BasicType basicType2 = SaveDlg.BasicType.NO_BASIC;
        String string = "KC-BASIC-Programm speichern";
        int n3 = -1;
        if (this.lastBasicType != null) {
            switch (this.lastBasicType) {
                case Z1013_TINY: {
                    string = "Tiny-BASIC-Programm speichern";
                    n3 = 0;
                    break;
                }
                case KC_RAM: {
                    n3 = 1;
                    break;
                }
                case KC_ROM: {
                    n3 = 2;
                }
            }
        }
        switch (OptionDlg.showOptionDlg(this.screenFrm, "W\u00e4hlen Sie bitte den BASIC-Interpreter aus,\ndessen BASIC-Programm gespeichert werden soll.", "BASIC-Interpreter", n3, "Z1013-Tiny-BASIC", "KC-BASIC (RAM-Version)", "KC-BASIC (ROM-Version)")) {
            case 0: {
                n2 = this.emuThread.getMemWord(4127);
                if (n2 <= 4434 || this.emuThread.getMemByte(n2 - 1, false) != 13) break;
                basicType = BasicType.Z1013_TINY;
                basicType2 = SaveDlg.BasicType.TINYBASIC;
                n = 4096;
                break;
            }
            case 1: {
                n2 = SourceUtil.getBasicEndAddr(this.emuThread, 11265);
                if (n2 <= 11265) break;
                basicType = BasicType.KC_RAM;
                basicType2 = SaveDlg.BasicType.KCBASIC;
                n = 11265;
                break;
            }
            case 2: {
                n2 = SourceUtil.getBasicEndAddr(this.emuThread, 1025);
                if (n2 <= 1025) break;
                basicType = BasicType.KC_ROM;
                basicType2 = SaveDlg.BasicType.KCBASIC;
                n = 1025;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (!bl) {
            if (n > 0 && n2 > n) {
                this.lastBasicType = basicType;
                new SaveDlg(this.screenFrm, n, n2, string, basicType2, null).setVisible(true);
            } else {
                this.showNoBasic();
            }
        }
    }

    @Override
    public void setJoystickAction(int n, int n2) {
        if (n == 0) {
            this.joy0ActionMask = n2;
        } else if (n == 1) {
            this.joy1ActionMask = n2;
        }
        switch (this.userPort) {
            case JOY_JUTE_6_1987: {
                this.putJoyJuTe0687ValuesToPort();
                break;
            }
            case JOY_PRACTIC_4_1987: {
                this.putJoyPractic0487ValuesToPort();
                break;
            }
            case JOY_PRACTIC_1_1988: {
                this.putJoyPractic0188ValuesToPort();
            }
        }
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            this.floppyDiskDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if ((n &= 0xFFFF) >= 49152 && n < 60416) {
            if (this.romBasic != null || this.romMega != null && n < 59392) {
                bl2 = false;
            }
        } else if (n >= 60416 && n < 60416 + this.ramVideo.length) {
            int n3;
            byte[] byArray = null;
            if (this.ramPixel != null && this.modeGraph) {
                if (this.ramPixelBank >= 0 && this.ramPixelBank < this.ramPixel.length) {
                    byArray = this.ramPixel[this.ramPixelBank];
                }
            } else {
                byArray = this.ramVideo;
            }
            if (byArray != null && (n3 = n - 60416) >= 0 && n3 < byArray.length) {
                byArray[n3] = (byte)n2;
                this.screenFrm.setScreenDirty(true);
                bl = true;
            }
            bl2 = true;
        } else if (n >= 61440 && !this.romDisabled && this.osBytes != null && n < 61440 + this.osBytes.length) {
            bl2 = true;
        }
        if (!bl2 && this.ramStatic != null && n < this.ramStatic.length) {
            this.ramStatic[n] = (byte)n2;
            bl = true;
            bl2 = true;
        }
        if (!bl2 && n <= this.ramEndAddr) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        boolean bl = true;
        if (this.graphCCJ != null && this.graphCCJActive) {
            bl = this.graphCCJ.shouldAskConvertScreenChar();
        } else if (this.altFontEnabled) {
            if (this.altFontBytes == fontAlt) {
                bl = false;
            }
        } else if (this.stdFontBytes == fontStd) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        boolean bl = false;
        KeyboardMatrix keyboardMatrix = this.keyboard.getKeyboardMatrix();
        if (keyboardMatrix != null && (keyboardMatrix instanceof KeyboardMatrix8x4 || keyboardMatrix instanceof KeyboardMatrix8x8)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return this.catchPrintCalls || this.userPort == UserPort.CENTR7_PRACTIC_2_1989 || this.userPort == UserPort.CENTR8_FA_10_1990;
    }

    @Override
    public boolean supportsRAMFloppy1() {
        return this.ramFloppy1 != null;
    }

    @Override
    public boolean supportsRAMFloppy2() {
        return this.ramFloppy2 != null;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        SourceUtil.updKCBasicSysCells(this.emuThread, n, n2, fileFormat, n3);
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if ((n &= 0xFF) == 4) {
            boolean bl = this.altFontEnabled;
            boolean bl2 = this.mode64x16;
            this.romDisabled = (n2 & 0x10) != 0;
            this.altFontEnabled = (n2 & 0x20) != 0;
            this.mode64x16 = (n2 & 0x80) != 0;
            Z80CPU z80CPU = this.emuThread.getZ80CPU();
            if ((n2 & 0x40) != 0) {
                if (!this.mode4MHz && z80CPU.getMaxSpeedKHz() == 2000) {
                    z80CPU.setMaxSpeedKHz(4000);
                    this.mode4MHz = true;
                }
            } else {
                if (this.mode4MHz && z80CPU.getMaxSpeedKHz() == 4000) {
                    z80CPU.setMaxSpeedKHz(2000);
                }
                this.mode4MHz = false;
            }
            if (this.altFontEnabled != bl || this.mode64x16 != bl2) {
                this.screenFrm.setScreenDirty(true);
            }
            if (this.mode64x16 != bl2) {
                this.screenFrm.clearScreenSelection();
                this.screenFrm.fireScreenSizeChanged();
            }
        } else if (n == 24 && this.graphCCJ != null) {
            this.graphCCJ.writeArg(n2);
        } else if (n == 25 && this.graphCCJ != null) {
            this.graphCCJ.writeCmd(n2);
            if (!this.graphCCJActive) {
                this.graphCCJActive = true;
                this.screenFrm.fireScreenSizeChanged();
            }
        }
        if (this.gide != null && ((n & 0xF0) == 64 || (n & 0xF0) == 128)) {
            this.gide.write(n, n2);
        } else if ((n & 0xF0) == 112) {
            if (this.rtc != null) {
                this.rtc.write(n, n2);
            }
        } else if ((n & 0xF8) == 152 && this.ramFloppy1 != null) {
            this.ramFloppy1.writeByte(n & 7, n2);
        } else if ((n & 0xF8) == 88 && this.ramFloppy2 != null) {
            this.ramFloppy2.writeByte(n & 7, n2);
        } else if ((n & 0xF0) == 192 && this.kcNet != null) {
            this.kcNet.write(n, n2);
        } else if ((n & 0xFC) == 220 && this.vdip != null) {
            this.vdip.write(n, n2);
        } else if (n >= 240 && n <= 255) {
            switch (n) {
                case 241: {
                    if (this.fdc == null) break;
                    this.fdc.write(n2);
                    break;
                }
                case 248: {
                    if (this.fdc == null) break;
                    this.fdc.fireTC();
                    break;
                }
                case 250: {
                    if (this.fdc == null) break;
                    this.fdc.reset(false);
                    break;
                }
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    if (this.romMega != null) {
                        if (n != 255) break;
                        this.romMegaSeg = n2;
                        break;
                    }
                    if (this.vdip == null) break;
                    this.vdip.write(n, n2);
                }
            }
        } else {
            switch (n & 0x1C) {
                case 0: {
                    switch (n & 3) {
                        case 0: {
                            this.pio.writeDataA(n2);
                            if (this.userPort == UserPort.JOY_PRACTIC_1_1988) {
                                this.putJoyPractic0188ValuesToPort();
                                break;
                            }
                            if (this.userPort != UserPort.CENTR7_PRACTIC_2_1989 && this.userPort != UserPort.CENTR8_FA_10_1990 || this.pio.getModePortA() != Z80PIO.Mode.BYTE_OUT) break;
                            PrintMngr printMngr = this.emuThread.getPrintMngr();
                            if (this.userPort == UserPort.CENTR7_PRACTIC_2_1989) {
                                if (printMngr != null) {
                                    printMngr.putByte(n2 & 0x7F);
                                }
                                this.pio.putInValuePortA(128, 128);
                            } else if (printMngr != null) {
                                printMngr.putByte(n2);
                            }
                            this.centrTStatesToAck = 20000;
                            break;
                        }
                        case 1: {
                            this.pio.writeControlA(n2);
                            break;
                        }
                        case 2: {
                            this.pio.writeDataB(n2);
                            this.keyboard.putRowValuesToPIO();
                            this.tapeOutPhase = (this.pio.fetchOutValuePortB(false) & 0x80) != 0;
                            break;
                        }
                        case 3: {
                            this.pio.writeControlB(n2);
                        }
                    }
                    break;
                }
                case 8: {
                    this.keyboard.setSelectedCol(n2 & 0xF);
                    if (this.ramPixel == null) break;
                    if ((n2 &= 0xF) == 8) {
                        this.modeGraph = true;
                        this.screenFrm.setScreenDirty(true);
                    } else if (n2 == 9) {
                        this.modeGraph = false;
                        this.screenFrm.setScreenDirty(true);
                    }
                    this.ramPixelBank = n2 & 7;
                    break;
                }
                case 12: {
                    if (this.ramPixel == null) break;
                    this.modeGraph = true;
                    this.screenFrm.setScreenDirty(true);
                    break;
                }
                case 16: {
                    if (this.ramPixel == null) break;
                    this.modeGraph = false;
                    this.screenFrm.setScreenDirty(true);
                }
            }
        }
        this.z80AddressChanged(n);
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.setMemByte(n &= 0xFFFF, n2);
        if (n >= 60416 && n < 61440 && this.graphCCJActive) {
            if (n == 60416 || n > 60416 && n < 61439 && n == this.lastWrittenAddr + 1) {
                this.lastWrittenAddr = n;
            } else if (n == 61439 && n == this.lastWrittenAddr + 1) {
                this.graphCCJActive = false;
                this.screenFrm.fireScreenSizeChanged();
            } else {
                this.lastWrittenAddr = -1;
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        boolean bl = this.emuThread.readTapeInPhase();
        if (bl != this.tapeInPhase) {
            this.tapeInPhase = bl;
            this.pio.putInValuePortB(this.tapeInPhase ? 64 : 0, 64);
        }
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
        if (this.centrTStatesToAck > 0) {
            this.centrTStatesToAck -= n;
            if (this.centrTStatesToAck <= 0) {
                switch (this.userPort) {
                    case CENTR7_PRACTIC_2_1989: {
                        this.pio.putInValuePortA(0, 128);
                        break;
                    }
                    case CENTR8_FA_10_1990: {
                        this.pio.strobePortA();
                    }
                }
            }
        }
    }

    private void applyUserPortSettings(Properties properties) {
        String string = EmuUtil.getProperty(properties, this.propPrefix + PROP_USERPORT);
        if (string.equals(VALUE_JOY_JUTE0687)) {
            this.userPort = UserPort.JOY_JUTE_6_1987;
        } else if (string.equals(VALUE_JOY_PRAC0487)) {
            this.userPort = UserPort.JOY_PRACTIC_4_1987;
        } else if (string.equals(VALUE_JOY_PRAC0188)) {
            this.userPort = UserPort.JOY_PRACTIC_1_1988;
        } else if (string.equals(VALUE_CEN7_PRAC0289)) {
            this.userPort = UserPort.CENTR7_PRACTIC_2_1989;
            this.pio.putInValuePortA(0, 128);
        } else {
            this.userPort = string.equals(VALUE_CEN8_FA1090) ? UserPort.CENTR8_FA_10_1990 : UserPort.NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkAddPCListener(Properties properties) {
        int n;
        Object object;
        this.pasteFast = EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.pasteFast) {
            object = EmuUtil.getProperty(properties, this.propPrefix + PROP_MONITOR);
            if (((String)object).equals(VALUE_MON_A2)) {
                arrayList.add(61721);
            } else if (((String)object).equals(VALUE_MON_JM_1992)) {
                arrayList.add(62042);
            } else {
                arrayList.add(61744);
            }
        }
        this.catchPrintCalls = EmuUtil.getBooleanProperty(properties, this.propPrefix + "catch_print_calls", true);
        if (this.catchPrintCalls) {
            arrayList.add(65482);
            arrayList.add(65485);
            arrayList.add(65503);
            arrayList.add(65509);
            arrayList.add(65512);
            arrayList.add(65515);
        }
        this.catchJoyCalls = EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_CATCH_JOY_CALLS, true);
        if (this.catchJoyCalls) {
            arrayList.add(65467);
        }
        object = null;
        int n2 = arrayList.size();
        if (n2 > 0) {
            object = new int[n2];
            for (n = 0; n < n2; ++n) {
                object[n] = (Integer)arrayList.get(n);
            }
        }
        n = 0;
        if (object != null && this.pcListenerAddrs != null) {
            n = Arrays.equals((int[])object, this.pcListenerAddrs) ? 1 : 0;
        } else if (object == null && this.pcListenerAddrs == null) {
            n = 1;
        }
        if (n == 0) {
            Z80CPU z80CPU = this.emuThread.getZ80CPU();
            Z1013 z1013 = this;
            synchronized (z1013) {
                if (this.pcListenerAddrs != null) {
                    z80CPU.removePCListener(this);
                    this.pcListenerAddrs = null;
                }
                if (object != null) {
                    z80CPU.addPCListener(this, (int[])object);
                    this.pcListenerAddrs = (int[])object;
                }
            }
        }
    }

    private boolean emulatesFloppyDisk(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false);
    }

    private boolean emulatesGraphCCJ(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_GCCJ_ENABLED, false);
    }

    private boolean emulatesGraphic(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_GRAPHIC_ENABLED, false);
    }

    private boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false);
    }

    private boolean emulatesModuleBasic(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_ROMBASIC_ENABLED, false);
    }

    private boolean emulatesModuleMegaROM(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_mega.enabled", false);
    }

    private boolean emulatesRTC(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "rtc.enabled", false);
    }

    private boolean emulatesUSB(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false);
    }

    private static int getRAMEndAddr(Properties properties) {
        int n = 65535;
        switch (EmuUtil.getProperty(properties, "jkcemu.system")) {
            case "Z1013.01": 
            case "Z1013.16": {
                n = 16383;
                break;
            }
            case "Z1013.12": {
                n = 1023;
            }
        }
        return n;
    }

    private void loadFonts(Properties properties) {
        this.stdFontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 4096);
        if (this.stdFontBytes != null) {
            this.altFontBytes = this.stdFontBytes.length >= 4096 ? Arrays.copyOfRange(this.stdFontBytes, 2048, 4096) : this.stdFontBytes;
        } else {
            if (fontStd == null) {
                fontStd = this.readResource("/rom/z1013/z1013font.bin");
            }
            this.stdFontBytes = fontStd;
            if (fontAlt == null) {
                fontAlt = this.readResource("/rom/z1013/altfont.bin");
            }
            this.altFontBytes = fontAlt;
        }
        if (this.graphCCJ != null) {
            this.graphCCJ.loadFont(EmuUtil.getProperty(properties, this.propPrefix + PROP_GCCJ_FONT_FILE));
        }
    }

    private void loadROMs(Properties properties) {
        this.monCode = EmuUtil.getProperty(properties, this.propPrefix + PROP_MONITOR);
        this.osFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.osBytes = this.readROMFile(this.osFile, 4096, "Monitorprogramm");
        if (this.osBytes == null) {
            if (this.monCode.equals(VALUE_MON_A2)) {
                if (monA2 == null) {
                    monA2 = this.readResource("/rom/z1013/mon_a2.bin");
                }
                this.osBytes = monA2;
            } else if (this.monCode.equals(VALUE_MON_RB_K7659)) {
                if (monRB_K7659 == null) {
                    monRB_K7659 = this.readResource("/rom/z1013/mon_rb_k7659.bin");
                }
                this.osBytes = monRB_K7659;
            } else if (this.monCode.equals(VALUE_MON_RB_S6009)) {
                if (monRB_S6009 == null) {
                    monRB_S6009 = this.readResource("/rom/z1013/mon_rb_s6009.bin");
                }
                this.osBytes = monRB_S6009;
            } else if (this.monCode.equals(VALUE_MON_INCOM_K7669)) {
                if (monINCOM_K7669 == null) {
                    monINCOM_K7669 = this.readResource("/rom/z1013/mon_incom_k7669.bin");
                }
                this.osBytes = monINCOM_K7669;
            } else if (this.monCode.equals(VALUE_MON_JM_1992)) {
                if (monJM_1992 == null) {
                    monJM_1992 = this.readResource("/rom/z1013/mon_jm_1992.bin");
                }
                this.osBytes = monJM_1992;
            } else if (this.monCode.equals(VALUE_MON_BL4_K7659)) {
                if (bl4_K7659 == null) {
                    bl4_K7659 = this.readResource("/rom/z1013/bl4_k7659.bin");
                }
                this.osBytes = bl4_K7659;
            } else {
                if (mon202 == null) {
                    mon202 = this.readResource("/rom/z1013/mon_202.bin");
                }
                this.osBytes = mon202;
            }
        }
        if (this.emulatesModuleBasic(properties)) {
            this.romBasicFile = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROMBASIC_PREFIX + "file");
            this.romBasic = this.readROMFile(this.romBasicFile, 11264, "KC-BASIC-Modul");
            if (this.romBasic == null) {
                if (modBasic == null) {
                    modBasic = this.readResource("/rom/z1013/kcbasic.bin");
                }
                this.romBasic = modBasic;
            }
        } else if (this.emulatesModuleMegaROM(properties)) {
            this.romMegaFile = EmuUtil.getProperty(properties, this.propPrefix + PROP_ROMMEGA_PREFIX + "file");
            this.romMega = this.readROMFile(this.romMegaFile, 0x280000, "Mega-ROM-Modul");
        }
        this.loadFonts(properties);
    }

    private void putJoyJuTe0687ValuesToPort() {
        int n = 241;
        if ((this.joy0ActionMask & 0x30) != 0) {
            n ^= 0xF0;
        } else {
            if ((this.joy0ActionMask & 1) != 0) {
                n ^= 0x20;
            }
            if ((this.joy0ActionMask & 2) != 0) {
                n ^= 0x40;
            }
            if ((this.joy0ActionMask & 4) != 0) {
                n ^= 0x80;
            }
            if ((this.joy0ActionMask & 8) != 0) {
                n ^= 0x10;
            }
        }
        this.pio.putInValuePortA(n, 255);
    }

    private void putJoyPractic0487ValuesToPort() {
        int n = 0;
        if ((this.joy0ActionMask & 0x30) != 0) {
            n |= 0xF0;
        } else {
            if ((this.joy0ActionMask & 1) != 0) {
                n |= 0x20;
            }
            if ((this.joy0ActionMask & 2) != 0) {
                n |= 0x80;
            }
            if ((this.joy0ActionMask & 4) != 0) {
                n |= 0x10;
            }
            if ((this.joy0ActionMask & 8) != 0) {
                n |= 0x40;
            }
        }
        if ((this.joy1ActionMask & 0x30) != 0) {
            n |= 0xF;
        } else {
            if ((this.joy1ActionMask & 1) != 0) {
                n |= 2;
            }
            if ((this.joy1ActionMask & 2) != 0) {
                n |= 8;
            }
            if ((this.joy1ActionMask & 4) != 0) {
                n |= 1;
            }
            if ((this.joy1ActionMask & 8) != 0) {
                n |= 4;
            }
        }
        this.pio.putInValuePortA(~n, 255);
    }

    private void putJoyPractic0188ValuesToPort() {
        int n = 255;
        int n2 = ~this.pio.fetchOutValuePortA(false);
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            n3 |= this.joy0ActionMask;
        }
        if ((n2 & 0x40) != 0) {
            n3 |= this.joy1ActionMask;
        }
        if ((n3 & 1) != 0) {
            n ^= 1;
        }
        if ((n3 & 2) != 0) {
            n ^= 2;
        }
        if ((n3 & 8) != 0) {
            n ^= 4;
        }
        if ((n3 & 4) != 0) {
            n ^= 8;
        }
        if ((n3 & 0x30) != 0) {
            n ^= 0x10;
        }
        this.pio.putInValuePortA(n, 255);
    }

    private void updKeyboardFld() {
        KeyboardMatrix keyboardMatrix;
        if (this.keyboardFld != null && (keyboardMatrix = this.keyboard.getKeyboardMatrix()) != null) {
            keyboardMatrix.updKeyboardFld(this.keyboardFld);
        }
    }

    private static enum UserPort {
        NONE,
        JOY_JUTE_6_1987,
        JOY_PRACTIC_4_1987,
        JOY_PRACTIC_1_1988,
        CENTR7_PRACTIC_2_1989,
        CENTR8_FA_10_1990;

    }

    private static enum BasicType {
        Z1013_TINY,
        KC_RAM,
        KC_ROM;

    }
}

