/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.bcs3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class BCS3SettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private JPanel tabModel;
    private JPanel tabRam;
    private JPanel tabRom;
    private JPanel tabEtc;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;
    private JRadioButton btnSE24_27;
    private JRadioButton btnSE31_29;
    private JRadioButton btnSE31_40;
    private JRadioButton btnSP33_29;
    private JRadioButton btnRam1k;
    private JRadioButton btnRam17k;
    private JCheckBox btnRemoveHSyncFromAudio;
    private ROMFileSettingsFld fldAltOS;
    private ROMFileSettingsFld fldAltFont;

    public BCS3SettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabModel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Modell", this.tabModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnSE24_27 = new JRadioButton("2 KByte BASIC-SE 2.4, 2,5 MHz, 27 Zeichen pro Zeile", true);
        this.btnSE24_27.addActionListener(this);
        buttonGroup.add(this.btnSE24_27);
        this.tabModel.add((Component)this.btnSE24_27, gridBagConstraints);
        this.btnSE31_29 = new JRadioButton("4 KByte BASIC-SE 3.1, 2,5 MHz, 29 Zeichen pro Zeile", false);
        this.btnSE31_29.addActionListener(this);
        buttonGroup.add(this.btnSE31_29);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnSE31_29, gridBagConstraints);
        this.btnSE31_40 = new JRadioButton("4 KByte BASIC-SE 3.1, 3,5 MHz, 40 Zeichen pro Zeile", false);
        this.btnSE31_40.addActionListener(this);
        buttonGroup.add(this.btnSE31_40);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnSE31_40, gridBagConstraints);
        this.btnSP33_29 = new JRadioButton("4 KByte S/P-BASIC V3.3, 2,5 MHz, 29 Zeichen pro Zeile", false);
        this.btnSP33_29.addActionListener(this);
        buttonGroup.add(this.btnSP33_29);
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnSP33_29, gridBagConstraints);
        this.tabRam = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("RAM", this.tabRam);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnRam1k = new JRadioButton("1 KByte RAM", true);
        this.btnRam1k.addActionListener(this);
        buttonGroup2.add(this.btnRam1k);
        gridBagConstraints2.insets.top = 10;
        ++gridBagConstraints2.gridy;
        this.tabRam.add((Component)this.btnRam1k, gridBagConstraints2);
        this.btnRam17k = new JRadioButton("17 KByte RAM (16 KByte RAM-Erweiterung)", false);
        this.btnRam17k.addActionListener(this);
        buttonGroup2.add(this.btnRam17k);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        this.tabRam.add((Component)this.btnRam17k, gridBagConstraints2);
        this.tabRom = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("ROM", this.tabRom);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.fldAltOS = new ROMFileSettingsFld(settingsFrm, string + "os.", "Alternativer ROM-Inhalt (0000h-0FFFh):");
        ++gridBagConstraints3.gridy;
        this.tabRom.add((Component)this.fldAltOS, gridBagConstraints3);
        this.fldAltFont = new ROMFileSettingsFld(settingsFrm, string + "font.", "Alternativer Zeichensatz:");
        ++gridBagConstraints3.gridy;
        this.tabRom.add((Component)this.fldAltFont, gridBagConstraints3);
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnRemoveHSyncFromAudio = new JCheckBox("HSync-Signale aus Audioausgabe entfernen");
        this.btnRemoveHSyncFromAudio.addActionListener(this);
        this.tabEtc.add((Component)this.btnRemoveHSyncFromAudio, gridBagConstraints4);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 300, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, 300);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        JPanel jPanel = this.tabModel;
        try {
            String string = "2.4";
            if (this.btnSE31_29.isSelected()) {
                string = "3.1_29";
            } else if (this.btnSE31_40.isSelected()) {
                string = "3.1_40";
            } else if (this.btnSP33_29.isSelected()) {
                string = "3.3";
            }
            EmuUtil.setProperty(properties, this.propPrefix + "os.version", string);
            jPanel = this.tabRam;
            EmuUtil.setProperty(properties, this.propPrefix + "ram.kbyte", this.btnRam17k.isSelected() ? "17" : "1");
            jPanel = this.tabRom;
            this.fldAltOS.applyInput(properties, bl);
            this.fldAltFont.applyInput(properties, bl);
            jPanel = this.tabEtc;
            EmuUtil.setProperty(properties, this.propPrefix + "remove_hsync_from_audio", this.btnRemoveHSyncFromAudio.isSelected());
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            bl = this.tabAutoLoad.doAction(eventObject);
            if (!bl) {
                bl = this.tabAutoInput.doAction(eventObject);
            }
            if (!bl && object instanceof AbstractButton) {
                this.fireDataChanged();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltOS.lookAndFeelChanged();
        this.fldAltFont.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        String string = EmuUtil.getProperty(properties, this.propPrefix + "os.version");
        if (string.equals("3.1_29")) {
            this.btnSE31_29.setSelected(true);
        } else if (string.equals("3.1_40")) {
            this.btnSE31_40.setSelected(true);
        } else if (string.equals("3.3")) {
            this.btnSP33_29.setSelected(true);
        } else {
            this.btnSE24_27.setSelected(true);
        }
        if (EmuUtil.getProperty(properties, this.propPrefix + "ram.kbyte").equals("17")) {
            this.btnRam17k.setSelected(true);
        } else {
            this.btnRam1k.setSelected(true);
        }
        this.fldAltOS.updFields(properties);
        this.fldAltFont.updFields(properties);
        this.btnRemoveHSyncFromAudio.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "remove_hsync_from_audio", true));
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }
}

