/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.customsys;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.HexDocument;
import jkcemu.base.UserInputException;
import jkcemu.emusys.customsys.CustomSysROM;

public class CustomSysROMSettingsDlg
extends BaseDlg
implements DropTargetListener {
    private static final String LABEL_BEG_ADDR = "Anfangsadresse (hex):";
    private static final String LABEL_SIZE = "Gr\u00f6\u00dfe (hex):";
    private static final String LABEL_IO_ADDR = "E/A-Adresse (hex):";
    private Window owner;
    private CustomSysROM approvedROM;
    private HexDocument docBegAddr;
    private HexDocument docSize;
    private HexDocument docSwitchIOAddr;
    private FileNameFld fldFile;
    private JTextField fldBegAddr;
    private JTextField fldSize;
    private JTextField fldSwitchIOAddr;
    private JLabel labelSwitchIOAddr;
    private JLabel labelSwitchIOBit;
    private JComboBox<String> comboSwitchIOBit;
    private JCheckBox btnEnableOnReset;
    private JCheckBox btnBoot;
    private JRadioButton btnAlwaysSwitchedOn;
    private JRadioButton btnSwitchoffable;
    private JRadioButton btnSwitchableByBit;
    private JButton btnSelect;
    private JButton btnOK;
    private JButton btnCancel;

    public static CustomSysROM showDlg(Window window, CustomSysROM customSysROM) {
        CustomSysROMSettingsDlg customSysROMSettingsDlg = new CustomSysROMSettingsDlg(window, customSysROM, customSysROM.isBootROM());
        customSysROMSettingsDlg.setVisible(true);
        return customSysROMSettingsDlg.approvedROM;
    }

    public static CustomSysROM showNewROMDlg(Window window, boolean bl) {
        CustomSysROMSettingsDlg customSysROMSettingsDlg = new CustomSysROMSettingsDlg(window, null, bl);
        customSysROMSettingsDlg.setVisible(true);
        return customSysROMSettingsDlg.approvedROM;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file;
        boolean bl = false;
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        if (dropTargetContext != null && dropTargetContext.getComponent() == this.fldFile && (file = EmuUtil.fileDrop(this, dropTargetDropEvent)) != null) {
            this.setFile(file);
            bl = true;
        }
        if (bl) {
            dropTargetDropEvent.dropComplete(true);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.fldBegAddr) {
            bl = true;
            this.fldSize.requestFocus();
        } else if (object == this.fldSize) {
            bl = true;
            this.btnSelect.requestFocus();
        }
        if (object == this.btnSelect) {
            bl = true;
            this.doFileSelect();
        } else if (object == this.btnAlwaysSwitchedOn || object == this.btnSwitchoffable || object == this.btnSwitchableByBit) {
            bl = true;
            this.updSwitchableFieldsEnabled();
        } else if (object == this.fldSwitchIOAddr) {
            bl = true;
            if (this.comboSwitchIOBit.isEnabled()) {
                this.comboSwitchIOBit.requestFocus();
            } else {
                this.btnBoot.requestFocus();
            }
        } else if (object == this.btnOK) {
            bl = true;
            this.doApply();
        } else if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    private void doApply() {
        try {
            this.updRomSizeIfMissing();
            int n = -1;
            int n2 = this.docBegAddr.intValue();
            int n3 = this.docSize.intValue();
            if (n3 < 1) {
                throw new UserInputException("Ung\u00fcltige ROM-Gr\u00f6\u00dfe");
            }
            if (n2 + n3 > 65536) {
                throw new UserInputException(String.format("Der ROM-Bereich ragt \u00fcber die Adresse FFFFh hinaus.\nBei der Anfangsadresse %04Xh kann der ROM-Bereich maximal %04Xh Bytes gro\u00df sein.", n2, 65536 - n2));
            }
            boolean bl = true;
            File file = this.fldFile.getFile();
            if (file != null) {
                long l = file.length();
                if (l > (long)n3 && !CustomSysROMSettingsDlg.showConfirmDlg(this, "Die Datei ist gr\u00f6\u00dfer als der ROM-Bereich.\nEs sind somit nicht alle Bytes der Datei im Arbeitsspeicher sichtbar.")) {
                    bl = false;
                }
            } else if (!CustomSysROMSettingsDlg.showConfirmDlg(this, "Sie haben keine Datei ausgew\u00e4hlt.\nDer ROM-Bereich enth\u00e4lt somit nur FFh-Bytes.")) {
                bl = false;
            }
            if (bl) {
                boolean bl2 = this.btnSwitchableByBit.isSelected();
                boolean bl3 = this.btnEnableOnReset.isSelected();
                boolean bl4 = this.btnBoot.isSelected();
                if (this.btnSwitchoffable.isSelected() || bl2) {
                    Integer n4 = this.docSwitchIOAddr.getInteger();
                    if (n4 != null) {
                        n = n4;
                    }
                    if (n < 0) {
                        throw new UserInputException("Wenn der ROM ein- oder ausblendbar ist, muss auch\neine E/A-Adresse angegeben werden, \u00fcBer die das geschieht.");
                    }
                }
                if (bl2 && !bl3 && bl4) {
                    throw new UserInputException("Wenn der ROM ein schaltbarer Boot-ROM ist,\nmuss er nach RESET eingeblendet sein.");
                }
                int n5 = 0;
                int n6 = 0;
                if (bl2) {
                    int n7 = this.comboSwitchIOBit.getSelectedIndex();
                    n5 = 1 << n7 % 8;
                    if (n7 < 8) {
                        n6 = n5;
                    }
                }
                this.approvedROM = new CustomSysROM(n2, n3, file != null ? file.getPath() : null, n, n5, n6, bl3, bl4);
                this.doClose();
            }
        }
        catch (NumberFormatException | UserInputException exception) {
            CustomSysROMSettingsDlg.showErrorDlg((Component)this, exception);
        }
    }

    private void doFileSelect() {
        File file = this.fldFile.getFile();
        if (file == null) {
            file = Main.getLastDirFile("rom");
        }
        if ((file = EmuUtil.showFileOpenDlg(this.owner, "ROM-Datei ausw\u00e4hlen", file, EmuUtil.getROMFileFilter())) != null) {
            this.setFile(file);
            Main.setLastFile(file, "rom");
        }
    }

    private void setFile(File file) {
        this.fldFile.setFile(file);
        this.updRomSizeIfMissing();
    }

    private void updRomSizeIfMissing() {
        long l;
        File file = this.fldFile.getFile();
        if (file != null && this.docSize.getLength() == 0 && (l = file.length()) > 0L && l < 65536L) {
            this.docSize.setValue((int)l, 4);
        }
    }

    private void updSwitchableFieldsEnabled() {
        boolean bl = this.btnSwitchableByBit.isSelected();
        boolean bl2 = this.btnSwitchoffable.isSelected() || bl;
        this.labelSwitchIOAddr.setEnabled(bl2);
        this.fldSwitchIOAddr.setEnabled(bl2);
        this.labelSwitchIOBit.setEnabled(bl);
        this.comboSwitchIOBit.setEnabled(bl);
        this.btnEnableOnReset.setEnabled(bl);
    }

    private CustomSysROMSettingsDlg(Window window, CustomSysROM customSysROM, boolean bl) {
        super(window, customSysROM != null ? "ROM-Bereich bearbeiten" : "Neuer ROM-Bereich");
        int n;
        this.owner = window;
        this.approvedROM = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)new JLabel(LABEL_BEG_ADDR), gridBagConstraints2);
        this.docBegAddr = new HexDocument(4, LABEL_BEG_ADDR);
        this.fldBegAddr = new JTextField(this.docBegAddr, "", 5);
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldBegAddr, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)new JLabel(LABEL_SIZE), gridBagConstraints2);
        this.docSize = new HexDocument(4, LABEL_SIZE);
        this.fldSize = new JTextField(this.docSize, "", 5);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldSize, gridBagConstraints2);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("ROM-Inhalt:"), gridBagConstraints);
        this.fldFile = new FileNameFld();
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldFile, gridBagConstraints);
        this.btnSelect = this.createImageButton("/images/file/open.png", "ROM-Datei ausw\u00e4hlen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridx += 2;
        this.add((Component)this.btnSelect, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnAlwaysSwitchedOn = new JRadioButton("ROM ist nicht schaltbar, d.h. immer eingeblendet", true);
        buttonGroup.add(this.btnAlwaysSwitchedOn);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnAlwaysSwitchedOn, gridBagConstraints);
        this.btnSwitchoffable = new JRadioButton("ROM ist mit einem Ausgabebefehl ausblendbar");
        buttonGroup.add(this.btnSwitchoffable);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnSwitchoffable, gridBagConstraints);
        this.btnSwitchableByBit = new JRadioButton("ROM ist mit einem Ausgabebefehl \u00fcber ein Bit ein- und ausblendbar");
        buttonGroup.add(this.btnSwitchableByBit);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnSwitchableByBit, gridBagConstraints);
        this.labelSwitchIOAddr = new JLabel(LABEL_IO_ADDR);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelSwitchIOAddr, gridBagConstraints);
        this.docSwitchIOAddr = new HexDocument(2, LABEL_IO_ADDR);
        this.fldSwitchIOAddr = new JTextField(this.docSwitchIOAddr, "", 2);
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldSwitchIOAddr, gridBagConstraints);
        this.labelSwitchIOBit = new JLabel("ROM wird eingeblendet bei:");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelSwitchIOBit, gridBagConstraints);
        this.comboSwitchIOBit = new JComboBox();
        this.comboSwitchIOBit.setEditable(false);
        for (n = 0; n < 8; ++n) {
            this.comboSwitchIOBit.addItem(String.format("Bit %d = H", n));
        }
        for (n = 0; n < 8; ++n) {
            this.comboSwitchIOBit.addItem(String.format("Bit %d = L", n));
        }
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add(this.comboSwitchIOBit, gridBagConstraints);
        this.btnEnableOnReset = new JCheckBox("ROM ist nach RESET eingeblendet");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnEnableOnReset, gridBagConstraints);
        this.btnBoot = new JCheckBox("Nach RESET beginnt bei dem ROM die Programmausf\u00fchrung (Boot-ROM)");
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnBoot, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnOK = new JButton("OK");
        jPanel2.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        jPanel2.add(this.btnCancel);
        if (customSysROM != null) {
            this.docBegAddr.setValue(customSysROM.getBegAddr(), 4);
            this.docSize.setValue(customSysROM.getSize(), 4);
            this.fldFile.setFileName(customSysROM.getFileName());
            int n2 = customSysROM.getSwitchIOAddr();
            int n3 = customSysROM.getSwitchIOMask() & 0xFF;
            int n4 = customSysROM.getSwitchIOValue() & n3;
            if (n2 >= 0) {
                this.docSwitchIOAddr.setValue(n2, 2);
                if (n3 != 0) {
                    int n5;
                    for (n5 = 0; n5 < 8 && (n3 & 1) == 0; ++n5) {
                        n3 >>= 1;
                    }
                    if (n4 == 0) {
                        n5 += 8;
                    }
                    try {
                        this.comboSwitchIOBit.setSelectedIndex(n5);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    this.btnSwitchableByBit.setSelected(true);
                } else {
                    this.btnSwitchoffable.setSelected(true);
                }
            } else {
                this.btnAlwaysSwitchedOn.setSelected(true);
            }
            this.btnEnableOnReset.setSelected(customSysROM.getEnableOnReset());
            this.btnBoot.setSelected(customSysROM.isBootROM());
        } else {
            this.btnEnableOnReset.setSelected(bl);
            this.btnBoot.setSelected(bl);
        }
        this.updSwitchableFieldsEnabled();
        this.pack();
        this.setParentCentered();
        this.fldBegAddr.addActionListener(this);
        this.fldSize.addActionListener(this);
        this.btnSelect.addKeyListener(this);
        this.btnAlwaysSwitchedOn.addActionListener(this);
        this.btnSwitchoffable.addActionListener(this);
        this.btnSwitchableByBit.addActionListener(this);
        this.fldSwitchIOAddr.addActionListener(this);
        this.comboSwitchIOBit.addActionListener(this);
        this.btnOK.addActionListener(this);
        this.btnOK.addKeyListener(this);
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        new DropTarget(this.fldFile, this).setActive(true);
    }
}

