/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.customsys;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HexDocument;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserCancelException;
import jkcemu.base.UserInputException;
import jkcemu.disk.GIDESettingsFld;
import jkcemu.emusys.CustomSys;
import jkcemu.emusys.customsys.CustomSysROM;
import jkcemu.emusys.customsys.CustomSysROMSettingsDlg;
import jkcemu.emusys.customsys.CustomSysROMTableModel;

public class CustomSysSettingsFld
extends AbstractSettingsFld
implements DocumentListener,
ListSelectionListener,
MouseListener {
    private static final String TEXT_INVALID_ADDR = " Ung\u00fcltige Adresse";
    private static final String TEXT_INVALID_VALUE = " Ung\u00fcltiger Wert";
    private static final String LABEL_CLOCK_FREQUENCY = "Taktfrequenz:";
    private static final String LABEL_SCREEN_COLS = "Anzahl Textspalten:";
    private static final String LABEL_SCREEN_ROWS = "Anzahl Textzeilen:";
    private static final String LABEL_SCREEN_BEGADDR = "Anfangsadresse Bildspeicher (hex):";
    private static final String LABEL_FDC_DATA_IOADDR = "E/A-Adresse Datenregister (hex):";
    private static final String LABEL_FDC_STATUS_IOADDR = "E/A-Adresse Statusregister (hex):";
    private static final String LABEL_FDC_TC_IOADDR = "E/A-Adresse Terminal Count (hex):";
    private static final String LABEL_FDC_TC_IOBIT = "Terminal Count ausl\u00f6sen bei:";
    private static final String LABEL_UNUSED_PORT_VALUE = "Gelesener Wert von nicht belegten E/A-Adressen (hex):";
    private static final String[] SIO_CLOCK_ITEMS = new String[]{"CTC Ausgang 0", "CTC Ausgang 1", "CTC Ausgang 2"};
    private static final String[] SIO_OUT_ITEMS = new String[]{"nichts angeschlossen", "Drucker"};
    private JTabbedPane tabbedPane;
    private JButton btnRomAdd;
    private JButton btnRomEdit;
    private JButton btnRomRemove;
    private JButton btnRomUp;
    private JButton btnRomDown;
    private JTable tableRom;
    private CustomSysROMTableModel tableModelRom;
    private ListSelectionModel selModelRom;
    private Document docTitle;
    private Document docSpeedMHz;
    private HexDocument docScreenBegAddr;
    private HexDocument docKeyboardIOAddr;
    private HexDocument docCtcIOBaseAddr;
    private HexDocument docPioIOBaseAddr;
    private HexDocument docSioIOBaseAddr;
    private HexDocument docKCNetIOBaseAddr;
    private HexDocument docVdipIOBaseAddr;
    private HexDocument docFdcDataIOAddr;
    private HexDocument docFdcStatusIOAddr;
    private HexDocument docFdcTCIOAddr;
    private HexDocument docUnusedPortValue;
    private JTextField fldTitle;
    private JTextField fldScreenBegAddr;
    private JTextField fldSpeedMHz;
    private JTextField fldKeyboardIOAddr;
    private JTextField fldCtcIOBaseAddr;
    private JTextField fldPioIOBaseAddr;
    private JTextField fldSioIOBaseAddr;
    private JTextField fldKCNetIOBaseAddr;
    private JTextField fldVdipIOBaseAddr;
    private JTextField fldFdcDataIOAddr;
    private JTextField fldFdcStatusIOAddr;
    private JTextField fldFdcTCIOAddr;
    private JTextField fldUnusedPortValue;
    private JComboBox<String> comboScreenRows;
    private JComboBox<String> comboScreenCols;
    private JComboBox<String> comboSioClockA;
    private JComboBox<String> comboSioClockB;
    private JComboBox<String> comboSioOutA;
    private JComboBox<String> comboSioOutB;
    private JComboBox<String> comboFdcTCIOBit;
    private JCheckBox btnKeyboardSwapCase;
    private JCheckBox btnScreenEnabled;
    private JCheckBox btnCtcEnabled;
    private JCheckBox btnFdcEnabled;
    private JCheckBox btnPioEnabled;
    private JCheckBox btnSioEnabled;
    private JCheckBox btnKCNetEnabled;
    private JCheckBox btnVdipEnabled;
    private JRadioButton btnKeyboardNone;
    private JRadioButton btnKeyboardPortRaw;
    private JRadioButton btnKeyboardPioAhs;
    private JRadioButton btnKeyboardPioAbit7;
    private JRadioButton btnKeyboardPioBhs;
    private JRadioButton btnKeyboardPioBbit7;
    private JRadioButton btnKeyboardSioA;
    private JRadioButton btnKeyboardSioB;
    private JLabel labelFdcDataIOAddr;
    private JLabel labelFdcStatusIOAddr;
    private JLabel labelFdcTCIOAddr;
    private JLabel labelFdcTCBit;
    private JLabel labelScreenBegAddr;
    private JLabel labelScreenCols;
    private JLabel labelScreenRows;
    private JLabel labelSioClockA;
    private JLabel labelSioClockB;
    private JLabel labelSioOutA;
    private JLabel labelSioOutB;
    private JLabel labelVdipIOBaseAddr;
    private JPanel tabFDC;
    private JPanel tabGeneral;
    private JPanel tabIO;
    private JPanel tabKeyboard;
    private JPanel tabROM;
    private JPanel tabScreen;
    private GIDESettingsFld tabGIDE;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;
    private ROMFileSettingsFld fldAltFont;

    public CustomSysSettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        int n;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabGeneral = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Allgemein", this.tabGeneral);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.tabGeneral.add((Component)new JLabel("Bezeichnung des Computers:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.tabGeneral.add((Component)new JLabel(LABEL_CLOCK_FREQUENCY), gridBagConstraints);
        this.fldTitle = new JTextField(5);
        this.docTitle = this.fldTitle.getDocument();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.tabGeneral.add((Component)this.fldTitle, gridBagConstraints);
        this.fldSpeedMHz = new JTextField(5);
        this.docSpeedMHz = this.fldSpeedMHz.getDocument();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.tabGeneral.add((Component)this.fldSpeedMHz, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.tabGeneral.add((Component)new JLabel("MHz"), gridBagConstraints);
        if (this.docTitle != null) {
            this.docTitle.addDocumentListener(this);
        }
        if (this.docSpeedMHz != null) {
            this.docSpeedMHz.addDocumentListener(this);
        }
        this.tabROM = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("ROM", this.tabROM);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tableModelRom = new CustomSysROMTableModel();
        this.tableRom = new JTable(this.tableModelRom);
        this.tableRom.setAutoCreateRowSorter(false);
        this.tableRom.setAutoResizeMode(0);
        this.tableRom.setColumnSelectionAllowed(false);
        this.tableRom.setDragEnabled(false);
        this.tableRom.setFillsViewportHeight(false);
        this.tableRom.setPreferredScrollableViewportSize(new Dimension(1, 1));
        this.tableRom.setRowSelectionAllowed(true);
        this.tableRom.setSelectionMode(2);
        this.tableRom.addMouseListener(this);
        this.tabROM.add((Component)new JScrollPane(this.tableRom), gridBagConstraints2);
        EmuUtil.setTableColWidths(this.tableRom, 100, 70, 300);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        ++gridBagConstraints2.gridx;
        this.tabROM.add((Component)jPanel, gridBagConstraints2);
        this.btnRomUp = this.createImageButton("/images/nav/up.png", "Auf");
        jPanel.add(this.btnRomUp);
        this.btnRomDown = this.createImageButton("/images/nav/down.png", "Ab");
        jPanel.add(this.btnRomDown);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 5));
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        this.tabROM.add((Component)jPanel2, gridBagConstraints2);
        this.btnRomAdd = new JButton("Hinzuf\u00fcgen");
        this.btnRomAdd.addActionListener(this);
        this.btnRomAdd.addKeyListener(this);
        jPanel2.add(this.btnRomAdd);
        this.btnRomEdit = new JButton("Bearbeiten");
        this.btnRomEdit.addActionListener(this);
        this.btnRomEdit.addKeyListener(this);
        jPanel2.add(this.btnRomEdit);
        this.btnRomRemove = new JButton("Entfernen");
        this.btnRomRemove.addActionListener(this);
        this.btnRomRemove.addKeyListener(this);
        jPanel2.add(this.btnRomRemove);
        this.selModelRom = this.tableRom.getSelectionModel();
        if (this.selModelRom != null) {
            this.selModelRom.addListSelectionListener(this);
            this.btnRomUp.setEnabled(false);
            this.btnRomDown.setEnabled(false);
            this.btnRomEdit.setEnabled(false);
            this.btnRomRemove.setEnabled(false);
        }
        this.tabScreen = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Bildschirmausgabe", this.tabScreen);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnScreenEnabled = new JCheckBox("Bildschirmausgabe emulieren");
        this.tabScreen.add((Component)this.btnScreenEnabled, gridBagConstraints3);
        this.labelScreenCols = new JLabel(LABEL_SCREEN_COLS);
        gridBagConstraints3.insets.left = 50;
        gridBagConstraints3.gridwidth = 1;
        ++gridBagConstraints3.gridy;
        this.tabScreen.add((Component)this.labelScreenCols, gridBagConstraints3);
        this.comboScreenCols = new JComboBox<String>(new String[]{"32", "40", "64", "80"});
        this.comboScreenCols.setEditable(false);
        gridBagConstraints3.insets.left = 5;
        ++gridBagConstraints3.gridx;
        this.tabScreen.add(this.comboScreenCols, gridBagConstraints3);
        this.labelScreenRows = new JLabel(LABEL_SCREEN_ROWS);
        gridBagConstraints3.insets.left = 50;
        gridBagConstraints3.gridx = 0;
        ++gridBagConstraints3.gridy;
        this.tabScreen.add((Component)this.labelScreenRows, gridBagConstraints3);
        this.comboScreenRows = new JComboBox<String>(new String[]{"16", "24", "25", "32"});
        this.comboScreenRows.setEditable(false);
        gridBagConstraints3.insets.left = 5;
        ++gridBagConstraints3.gridx;
        this.tabScreen.add(this.comboScreenRows, gridBagConstraints3);
        this.labelScreenBegAddr = new JLabel(LABEL_SCREEN_BEGADDR);
        gridBagConstraints3.insets.left = 50;
        gridBagConstraints3.insets.bottom = 5;
        gridBagConstraints3.gridx = 0;
        ++gridBagConstraints3.gridy;
        this.tabScreen.add((Component)this.labelScreenBegAddr, gridBagConstraints3);
        this.docScreenBegAddr = new HexDocument(4, LABEL_SCREEN_BEGADDR);
        this.fldScreenBegAddr = new JTextField(this.docScreenBegAddr, "", 5);
        gridBagConstraints3.insets.left = 5;
        ++gridBagConstraints3.gridx;
        this.tabScreen.add((Component)this.fldScreenBegAddr, gridBagConstraints3);
        Font font = this.fldScreenBegAddr.getFont();
        if (font != null) {
            this.comboScreenCols.setFont(font);
            this.comboScreenRows.setFont(font);
        }
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets.top = 15;
        gridBagConstraints3.insets.bottom = 10;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridx = 0;
        ++gridBagConstraints3.gridy;
        this.tabScreen.add((Component)new JSeparator(), gridBagConstraints3);
        this.fldAltFont = new ROMFileSettingsFld(settingsFrm, string + "font.", "Alternativer Zeichensatz:");
        ++gridBagConstraints3.gridy;
        this.tabScreen.add((Component)this.fldAltFont, gridBagConstraints3);
        this.btnScreenEnabled.addActionListener(this);
        this.comboScreenCols.addActionListener(this);
        this.comboScreenRows.addActionListener(this);
        this.docScreenBegAddr.addDocumentListener(this);
        this.updScreenFieldsEnabled();
        this.tabKeyboard = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Tastatur", this.tabKeyboard);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.tabKeyboard.add((Component)new JLabel("Tastatur ist angeschlossen an:"), gridBagConstraints4);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnKeyboardPortRaw = new JRadioButton("Einfaches Eingabetor an E/A-Adresse (hex):");
        buttonGroup.add(this.btnKeyboardPortRaw);
        gridBagConstraints4.insets.left = 50;
        gridBagConstraints4.gridwidth = 1;
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardPortRaw, gridBagConstraints4);
        this.docKeyboardIOAddr = new HexDocument(2, this.btnKeyboardPortRaw.getText());
        this.fldKeyboardIOAddr = new JTextField(this.docKeyboardIOAddr, "", 3);
        gridBagConstraints4.insets.left = 5;
        ++gridBagConstraints4.gridx;
        this.tabKeyboard.add((Component)this.fldKeyboardIOAddr, gridBagConstraints4);
        this.btnKeyboardPioAhs = new JRadioButton("PIO Port A mit Ready/Strobe-Handshake");
        buttonGroup.add(this.btnKeyboardPioAhs);
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.insets.top = 0;
        gridBagConstraints4.insets.left = 50;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardPioAhs, gridBagConstraints4);
        this.btnKeyboardPioAbit7 = new JRadioButton("PIO Port A mit Strobe an Bit 7");
        buttonGroup.add(this.btnKeyboardPioAbit7);
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardPioAbit7, gridBagConstraints4);
        this.btnKeyboardPioBhs = new JRadioButton("PIO Port B mit Ready/Strobe-Handshake");
        buttonGroup.add(this.btnKeyboardPioBhs);
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardPioBhs, gridBagConstraints4);
        this.btnKeyboardPioBbit7 = new JRadioButton("PIO Port B mit Strobe an Bit 7");
        buttonGroup.add(this.btnKeyboardPioBbit7);
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardPioBbit7, gridBagConstraints4);
        this.btnKeyboardSioA = new JRadioButton("SIO Kanal A");
        buttonGroup.add(this.btnKeyboardSioA);
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardSioA, gridBagConstraints4);
        this.btnKeyboardSioB = new JRadioButton("SIO Kanal B");
        buttonGroup.add(this.btnKeyboardSioB);
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardSioB, gridBagConstraints4);
        this.btnKeyboardNone = new JRadioButton("Keine Tastatur emulieren");
        buttonGroup.add(this.btnKeyboardNone);
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardNone, gridBagConstraints4);
        this.btnKeyboardSwapCase = new JCheckBox("Gro\u00df-/Kleinschreibung umkehren");
        gridBagConstraints4.insets.top = 10;
        gridBagConstraints4.insets.left = 5;
        gridBagConstraints4.insets.bottom = 5;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        this.tabKeyboard.add((Component)this.btnKeyboardSwapCase, gridBagConstraints4);
        this.btnKeyboardNone.addActionListener(this);
        this.btnKeyboardPortRaw.addActionListener(this);
        this.btnKeyboardPioAhs.addActionListener(this);
        this.btnKeyboardPioAbit7.addActionListener(this);
        this.btnKeyboardPioBhs.addActionListener(this);
        this.btnKeyboardPioBbit7.addActionListener(this);
        this.btnKeyboardSioA.addActionListener(this);
        this.btnKeyboardSioB.addActionListener(this);
        this.btnKeyboardSwapCase.addActionListener(this);
        this.docKeyboardIOAddr.addDocumentListener(this);
        this.updKeyboardFieldsEnabled();
        this.tabIO = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("E/A-Bausteine", this.tabIO);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnPioEnabled = new JCheckBox("PIO emulieren an E/A-Basisadresse (hex):");
        this.tabIO.add((Component)this.btnPioEnabled, gridBagConstraints5);
        this.docPioIOBaseAddr = new HexDocument(2, this.btnPioEnabled.getText());
        this.fldPioIOBaseAddr = new JTextField(this.docPioIOBaseAddr, "", 3);
        gridBagConstraints5.insets.top = 2;
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridx += 2;
        this.tabIO.add((Component)this.fldPioIOBaseAddr, gridBagConstraints5);
        this.btnSioEnabled = new JCheckBox("SIO emulieren an E/A-Basisadresse (hex):");
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.btnSioEnabled, gridBagConstraints5);
        this.docSioIOBaseAddr = new HexDocument(2, this.btnSioEnabled.getText());
        this.fldSioIOBaseAddr = new JTextField(this.docSioIOBaseAddr, "", 3);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridx += 2;
        this.tabIO.add((Component)this.fldSioIOBaseAddr, gridBagConstraints5);
        this.labelSioClockA = new JLabel("Kanal A getaktet durch:");
        gridBagConstraints5.insets.left = 50;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.labelSioClockA, gridBagConstraints5);
        this.comboSioClockA = new JComboBox<String>(SIO_CLOCK_ITEMS);
        this.comboSioClockA.setEditable(false);
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        this.tabIO.add(this.comboSioClockA, gridBagConstraints5);
        this.labelSioClockB = new JLabel("Kanal B getaktet durch:");
        gridBagConstraints5.insets.left = 50;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.labelSioClockB, gridBagConstraints5);
        this.comboSioClockB = new JComboBox<String>(SIO_CLOCK_ITEMS);
        this.comboSioClockB.setEditable(false);
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        this.tabIO.add(this.comboSioClockB, gridBagConstraints5);
        this.labelSioOutA = new JLabel("Kanal A Ausgang:");
        gridBagConstraints5.insets.left = 50;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.labelSioOutA, gridBagConstraints5);
        this.comboSioOutA = new JComboBox<String>(SIO_OUT_ITEMS);
        this.comboSioOutA.setEditable(false);
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        this.tabIO.add(this.comboSioOutA, gridBagConstraints5);
        this.labelSioOutB = new JLabel("Kanal B Ausgang:");
        gridBagConstraints5.insets.left = 50;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.labelSioOutB, gridBagConstraints5);
        this.comboSioOutB = new JComboBox<String>(SIO_OUT_ITEMS);
        this.comboSioOutB.setEditable(false);
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        this.tabIO.add(this.comboSioOutB, gridBagConstraints5);
        this.btnCtcEnabled = new JCheckBox("CTC emulieren an E/A-Basisadresse (hex):");
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.btnCtcEnabled, gridBagConstraints5);
        this.docCtcIOBaseAddr = new HexDocument(2, this.btnCtcEnabled.getText());
        this.fldCtcIOBaseAddr = new JTextField(this.docCtcIOBaseAddr, "", 3);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridx += 2;
        this.tabIO.add((Component)this.fldCtcIOBaseAddr, gridBagConstraints5);
        this.btnKCNetEnabled = new JCheckBox("KCNet emulieren an E/A-Basisadresse (hex):");
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.btnKCNetEnabled, gridBagConstraints5);
        this.docKCNetIOBaseAddr = new HexDocument(2, this.btnKCNetEnabled.getText());
        this.fldKCNetIOBaseAddr = new JTextField(this.docKCNetIOBaseAddr, "", 3);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridx += 2;
        this.tabIO.add((Component)this.fldKCNetIOBaseAddr, gridBagConstraints5);
        this.btnVdipEnabled = new JCheckBox("USB (VDIP) emulieren an E/A-Basisadresse (hex):");
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)this.btnVdipEnabled, gridBagConstraints5);
        this.docVdipIOBaseAddr = new HexDocument(2, this.btnVdipEnabled.getText());
        this.fldVdipIOBaseAddr = new JTextField(this.docVdipIOBaseAddr, "", 3);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridx += 2;
        this.tabIO.add((Component)this.fldVdipIOBaseAddr, gridBagConstraints5);
        gridBagConstraints5.insets.top = 10;
        gridBagConstraints5.insets.bottom = 5;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridx = 0;
        ++gridBagConstraints5.gridy;
        this.tabIO.add((Component)new JLabel(LABEL_UNUSED_PORT_VALUE), gridBagConstraints5);
        this.docUnusedPortValue = new HexDocument(2, LABEL_UNUSED_PORT_VALUE);
        this.fldUnusedPortValue = new JTextField(this.docUnusedPortValue, "", 3);
        gridBagConstraints5.gridx += 2;
        this.tabIO.add((Component)this.fldUnusedPortValue, gridBagConstraints5);
        this.btnPioEnabled.addActionListener(this);
        this.btnSioEnabled.addActionListener(this);
        this.btnCtcEnabled.addActionListener(this);
        this.btnKCNetEnabled.addActionListener(this);
        this.btnVdipEnabled.addActionListener(this);
        this.comboSioClockA.addActionListener(this);
        this.comboSioClockB.addActionListener(this);
        this.comboSioOutA.addActionListener(this);
        this.comboSioOutB.addActionListener(this);
        this.docPioIOBaseAddr.addDocumentListener(this);
        this.docSioIOBaseAddr.addDocumentListener(this);
        this.docCtcIOBaseAddr.addDocumentListener(this);
        this.docKCNetIOBaseAddr.addDocumentListener(this);
        this.docVdipIOBaseAddr.addDocumentListener(this);
        this.docUnusedPortValue.addDocumentListener(this);
        this.updPioFieldsEnabled();
        this.updSioFieldsEnabled();
        this.updCtcFieldsEnabled();
        this.updKCNetFieldsEnabled();
        this.updVdipFieldsEnabled();
        this.tabFDC = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("FDC", this.tabFDC);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnFdcEnabled = new JCheckBox("Floppy Disk Controller (FDC) mit 4 Diskettenlaufwerken emulieren");
        this.tabFDC.add((Component)this.btnFdcEnabled, gridBagConstraints6);
        this.labelFdcDataIOAddr = new JLabel(LABEL_FDC_DATA_IOADDR);
        gridBagConstraints6.insets.left = 50;
        gridBagConstraints6.gridwidth = 1;
        ++gridBagConstraints6.gridy;
        this.tabFDC.add((Component)this.labelFdcDataIOAddr, gridBagConstraints6);
        this.labelFdcStatusIOAddr = new JLabel(LABEL_FDC_STATUS_IOADDR);
        ++gridBagConstraints6.gridy;
        this.tabFDC.add((Component)this.labelFdcStatusIOAddr, gridBagConstraints6);
        this.labelFdcTCIOAddr = new JLabel(LABEL_FDC_TC_IOADDR);
        ++gridBagConstraints6.gridy;
        this.tabFDC.add((Component)this.labelFdcTCIOAddr, gridBagConstraints6);
        this.labelFdcTCBit = new JLabel(LABEL_FDC_TC_IOBIT);
        ++gridBagConstraints6.gridy;
        this.tabFDC.add((Component)this.labelFdcTCBit, gridBagConstraints6);
        this.docFdcDataIOAddr = new HexDocument(2, LABEL_FDC_DATA_IOADDR);
        this.fldFdcDataIOAddr = new JTextField(this.docFdcDataIOAddr, "", 3);
        gridBagConstraints6.insets.left = 5;
        gridBagConstraints6.gridy = 1;
        ++gridBagConstraints6.gridx;
        this.tabFDC.add((Component)this.fldFdcDataIOAddr, gridBagConstraints6);
        this.docFdcStatusIOAddr = new HexDocument(2, LABEL_FDC_STATUS_IOADDR);
        this.fldFdcStatusIOAddr = new JTextField(this.docFdcStatusIOAddr, "", 3);
        ++gridBagConstraints6.gridy;
        this.tabFDC.add((Component)this.fldFdcStatusIOAddr, gridBagConstraints6);
        this.docFdcTCIOAddr = new HexDocument(2, LABEL_FDC_TC_IOADDR);
        this.fldFdcTCIOAddr = new JTextField(this.docFdcTCIOAddr, "", 3);
        ++gridBagConstraints6.gridy;
        this.tabFDC.add((Component)this.fldFdcTCIOAddr, gridBagConstraints6);
        this.comboFdcTCIOBit = new JComboBox();
        this.comboFdcTCIOBit.setEditable(false);
        this.comboFdcTCIOBit.addItem("jedem Ausgabebefehl");
        for (n = 0; n < 8; ++n) {
            this.comboFdcTCIOBit.addItem(String.format("Bit %d \u2192 H", n));
        }
        for (n = 0; n < 8; ++n) {
            this.comboFdcTCIOBit.addItem(String.format("Bit %d \u2192 L", n));
        }
        ++gridBagConstraints6.gridy;
        this.tabFDC.add(this.comboFdcTCIOBit, gridBagConstraints6);
        this.btnFdcEnabled.addActionListener(this);
        this.updFdcFieldsEnabled();
        this.tabGIDE = new GIDESettingsFld(settingsFrm, string, 128, 0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 160, 176, 192, 208, 224, 240);
        this.tabbedPane.addTab("GIDE", this.tabGIDE);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 500, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, false, 0, 500);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.selModelRom) {
            CustomSysROM customSysROM;
            int n;
            int n2 = this.tableRom.getRowCount();
            int n3 = this.tableRom.getSelectedRowCount();
            int n4 = this.tableRom.getSelectedRow();
            boolean bl = n3 == 1 && n4 >= 0;
            boolean bl2 = false;
            this.btnRomUp.setEnabled(n3 == 1 && n4 > 0);
            this.btnRomDown.setEnabled(bl && n4 < n2 - 1);
            this.btnRomRemove.setEnabled(n3 > 0);
            if (bl && (n = this.tableRom.convertRowIndexToModel(n4)) >= 0 && (customSysROM = this.tableModelRom.getRow(n)) != null) {
                bl2 = true;
            }
            this.btnRomEdit.setEnabled(bl2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && mouseEvent.getComponent() == this.tableRom) {
            this.doRomEdit();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        JPanel jPanel = null;
        Object var4_4 = null;
        try {
            String string;
            int n;
            block54: {
                int n2;
                int n3;
                int n4;
                int n5;
                block53: {
                    int n6;
                    int n7;
                    EmuUtil.setProperty(properties, this.propPrefix + "title", this.fldTitle.getText());
                    String string2 = this.fldSpeedMHz.getText();
                    if (string2 == null) {
                        string2 = "";
                    }
                    try {
                        n7 = 0;
                        Number number = this.settingsFrm.getSpeedFmt().parse(string2);
                        if (number != null) {
                            n7 = Math.round(number.floatValue() * 1000.0f);
                        }
                        if (n7 < 1) {
                            throw new UserInputException("Taktfrequenz: Ung\u00fcltiger Wert");
                        }
                        EmuUtil.setProperty(properties, this.propPrefix + "speed.khz", n7);
                    }
                    catch (ParseException parseException) {
                        throw new UserInputException("Taktfrequenz: Ung\u00fcltiger Wert");
                    }
                    n7 = 0;
                    boolean bl2 = false;
                    int n8 = 0;
                    int n9 = this.tableModelRom.getRowCount();
                    if (bl) {
                        block9: for (n6 = 0; n6 < n9; ++n6) {
                            CustomSysROM customSysROM = this.tableModelRom.getRow(n6);
                            if (customSysROM == null) continue;
                            if (customSysROM.getBegAddr() == 0) {
                                bl2 = true;
                            }
                            if (customSysROM.isBootROM() && customSysROM.isEnabledAfterReset()) {
                                ++n8;
                            }
                            for (int i = n6 + 1; i < n9; ++i) {
                                int n10 = customSysROM.getBegAddr();
                                int n11 = customSysROM.getSize();
                                CustomSysROM customSysROM2 = this.tableModelRom.getRow(i);
                                if (customSysROM2 == null) continue;
                                n = customSysROM2.getBegAddr();
                                int n12 = customSysROM2.getSize();
                                if ((n10 > n || n10 + n11 <= n) && (n > n10 || n + n12 <= n10)) continue;
                                n7 = 1;
                                continue block9;
                            }
                        }
                        if (n7 != 0 && !BaseDlg.showConfirmDlg(this.settingsFrm, "ROM-Bereiche \u00fcberlappen sich.\nIm Fall einer \u00dcberlappung ist der ROM-Bereich relevant,\nder in der Liste weiter oben steht.")) {
                            throw new UserCancelException();
                        }
                        if (!bl2 && n8 == 0 && !BaseDlg.showConfirmDlg(this.settingsFrm, "An der Adesse 0000h befindet sich kein ROM\nund es ist auch kein Boot-ROM markiert.\nNach RESET beginnt die Programmausf\u00fchrung somit im RAM!")) {
                            throw new UserCancelException();
                        }
                    }
                    n6 = 0;
                    for (n5 = 0; n5 < n9; ++n5) {
                        CustomSysROM customSysROM = this.tableModelRom.getRow(n5);
                        if (customSysROM == null) continue;
                        String string3 = customSysROM.getFileName();
                        String string4 = String.format("%s%s%d.", this.propPrefix, "rom.", n6++);
                        EmuUtil.setProperty(properties, string4 + "addr.begin", customSysROM.getBegAddr());
                        EmuUtil.setProperty(properties, string4 + "size", customSysROM.getSize());
                        EmuUtil.setProperty(properties, string4 + "file", string3 != null ? string3 : "");
                        EmuUtil.setProperty(properties, string4 + "switch.ioaddr", customSysROM.getSwitchIOAddr());
                        EmuUtil.setProperty(properties, string4 + "switch.iomask", customSysROM.getSwitchIOMask());
                        EmuUtil.setProperty(properties, string4 + "switch.iovalue", customSysROM.getSwitchIOValue());
                        EmuUtil.setProperty(properties, string4 + "enable_on_reset", customSysROM.getEnableOnReset());
                        EmuUtil.setProperty(properties, string4 + "boot", customSysROM.isBootROM());
                    }
                    EmuUtil.setProperty(properties, this.propPrefix + "rom." + "count", n6);
                    jPanel = this.tabScreen;
                    n5 = this.btnScreenEnabled.isSelected() ? 1 : 0;
                    n4 = EmuUtil.getInt(this.comboScreenCols);
                    n3 = EmuUtil.getInt(this.comboScreenRows);
                    n2 = 63488;
                    try {
                        n2 = this.docScreenBegAddr.intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!bl || n5 == 0) break block53;
                        throw new UserInputException("Anfangsadresse Bildspeicher (hex): Ung\u00fcltige Adresse");
                    }
                }
                if (bl && n5 != 0) {
                    if (n4 < 1) {
                        throw new UserInputException("Anzahl Textspalten: Ung\u00fcltiger Wert");
                    }
                    if (n3 < 1) {
                        throw new UserInputException("Anzahl Textzeilen: Ung\u00fcltiger Wert");
                    }
                    if (n2 + n4 * n3 > 65536) {
                        throw new UserInputException("Bildwiederholspeicher ragt \u00fcber die Adresse FFFFh hinaus.");
                    }
                }
                EmuUtil.setProperty(properties, this.propPrefix + "screen.enabled", n5 != 0);
                EmuUtil.setProperty(properties, this.propPrefix + "screen.addr.begin", n2);
                EmuUtil.setProperty(properties, this.propPrefix + "screen.cols", n4);
                EmuUtil.setProperty(properties, this.propPrefix + "screen.rows", n3);
                this.fldAltFont.applyInput(properties, bl);
                boolean bl3 = false;
                n = 0;
                string = "none";
                if (this.btnKeyboardPortRaw.isSelected()) {
                    bl3 = true;
                    string = "port.raw";
                } else if (this.btnKeyboardPioAhs.isSelected()) {
                    string = "pio.a.handshake";
                } else if (this.btnKeyboardPioAbit7.isSelected()) {
                    string = "pio.a.bit7";
                } else if (this.btnKeyboardPioBhs.isSelected()) {
                    string = "pio.b.handshake";
                } else if (this.btnKeyboardPioBbit7.isSelected()) {
                    string = "pio.b.bit7";
                } else if (this.btnKeyboardSioA.isSelected()) {
                    string = "sio.a";
                } else if (this.btnKeyboardSioB.isSelected()) {
                    string = "sio.b";
                }
                try {
                    n = this.docKeyboardIOAddr.intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl || !bl3) break block54;
                    throw new UserInputException(this.btnKeyboardPortRaw.getText() + TEXT_INVALID_ADDR);
                }
            }
            EmuUtil.setProperty(properties, this.propPrefix + "keyboard.hardware", string);
            EmuUtil.setProperty(properties, this.propPrefix + "keyboard.io_addr", n);
            EmuUtil.setProperty(properties, this.propPrefix + "swap_key_char_case", this.btnKeyboardSwapCase.isSelected());
            int n13 = this.applyIOAddrInput(bl, this.btnPioEnabled, "pio.enabled", this.docPioIOBaseAddr, "pio.io_base_addr", properties);
            int n14 = this.applyIOAddrInput(bl, this.btnSioEnabled, "sio.enabled", this.docSioIOBaseAddr, "sio.io_base_addr", properties);
            EmuUtil.setProperty(properties, this.propPrefix + "sio.a.clock", this.comboSioClockA.getSelectedIndex());
            EmuUtil.setProperty(properties, this.propPrefix + "sio.b.clock", this.comboSioClockB.getSelectedIndex());
            EmuUtil.setProperty(properties, this.propPrefix + "sio.a.out", CustomSysSettingsFld.getSioOutValue(this.comboSioOutA));
            EmuUtil.setProperty(properties, this.propPrefix + "sio.b.out", CustomSysSettingsFld.getSioOutValue(this.comboSioOutB));
            int n15 = this.applyIOAddrInput(bl, this.btnCtcEnabled, "ctc.enabled", this.docCtcIOBaseAddr, "ctc.io_base_addr", properties);
            int n16 = this.applyIOAddrInput(bl, this.btnKCNetEnabled, "kcnet.enabled", this.docKCNetIOBaseAddr, "kcnet.io_base_addr", properties);
            int n17 = this.applyIOAddrInput(bl, this.btnVdipEnabled, "vdip.enabled", this.docVdipIOBaseAddr, "vdip.io_base_addr", properties);
            EmuUtil.setProperty(properties, this.propPrefix + "unused_port.value", this.docUnusedPortValue.intValue());
            boolean bl4 = this.btnFdcEnabled.isSelected();
            EmuUtil.setProperty(properties, this.propPrefix + "fdc.enabled", bl4);
            int n18 = this.applyIOAddrInput(bl, LABEL_FDC_DATA_IOADDR, this.docFdcDataIOAddr, "fdc.data.ioaddr", properties);
            int n19 = this.applyIOAddrInput(bl, LABEL_FDC_STATUS_IOADDR, this.docFdcStatusIOAddr, "fdc.status.ioaddr", properties);
            int n20 = this.applyIOAddrInput(bl, LABEL_FDC_TC_IOADDR, this.docFdcTCIOAddr, "fdc.tc.ioaddr", properties);
            int n21 = 0;
            int n22 = 0;
            int n23 = this.comboFdcTCIOBit.getSelectedIndex();
            if (n23 > 0) {
                n21 = 1 << (n23 - 1) % 8;
                if (n23 < 9) {
                    n22 = n21;
                }
            }
            EmuUtil.setProperty(properties, this.propPrefix + "fdc.tc.iomask", n21);
            EmuUtil.setProperty(properties, this.propPrefix + "fdc.tc.iovalue", n22);
            jPanel = this.tabGIDE;
            this.tabGIDE.applyInput(properties, bl);
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
            if (bl) {
                if (this.btnKeyboardPioAhs.isSelected() && this.btnKeyboardPioAbit7.isSelected() && this.btnKeyboardPioBhs.isSelected() && this.btnKeyboardPioBbit7.isSelected() && !this.btnPioEnabled.isSelected()) {
                    this.tabbedPane.setSelectedComponent(this.tabIO);
                    throw new UserInputException("Wenn die Tastatur an einer PIO angeschlossen ist,\nmuss auch eine PIO emuliert werden.");
                }
                if (this.btnKeyboardSioA.isSelected() && this.btnKeyboardSioB.isSelected() && !this.btnSioEnabled.isSelected()) {
                    this.tabbedPane.setSelectedComponent(this.tabIO);
                    throw new UserInputException("Wenn die Tastatur an einer SIO angeschlossen ist,\nmuss auch eine SIO emuliert werden.");
                }
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                jPanel = this.tabKeyboard;
                if (this.btnKeyboardPortRaw.isSelected()) {
                    this.addToIOAddrMasp(hashMap, n, 1, "Eingabeport Tastatur");
                }
                jPanel = this.tabIO;
                if (n13 >= 0) {
                    this.addToIOAddrMasp(hashMap, n13, 4, "PIO");
                }
                if (n14 >= 0) {
                    this.addToIOAddrMasp(hashMap, n14, 4, "SIO");
                }
                if (n15 >= 0) {
                    this.addToIOAddrMasp(hashMap, n15, 4, "CTC");
                }
                if (n16 >= 0) {
                    this.addToIOAddrMasp(hashMap, n16, 4, "PIO");
                }
                if (n17 >= 0) {
                    this.addToIOAddrMasp(hashMap, n17, 4, "USB");
                }
                jPanel = this.tabFDC;
                if (n18 >= 0) {
                    this.addToIOAddrMasp(hashMap, n18, 1, "FDC Datenregister");
                }
                if (n19 >= 0) {
                    this.addToIOAddrMasp(hashMap, n19, 1, "FDC Statusregister");
                }
                if (n20 >= 0) {
                    this.addToIOAddrMasp(hashMap, n20, 1, "FDC Terminal Count");
                }
                jPanel = this.tabGIDE;
                int n24 = this.tabGIDE.getAppliedIOBaseAddr();
                if (n24 >= 0) {
                    this.addToIOAddrMasp(hashMap, n24, 16, "GIDE");
                }
            }
        }
        catch (UserCancelException userCancelException) {
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        this.settingsFrm.setWaitCursor(true);
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnRomAdd) {
                bl = true;
                this.doRomAdd();
            } else if (object == this.btnRomEdit) {
                bl = true;
                this.doRomEdit();
            } else if (object == this.btnRomRemove) {
                bl = true;
                this.doRomRemove();
            } else if (object == this.btnRomUp) {
                bl = true;
                this.doRomMove(-1);
            } else if (object == this.btnRomDown) {
                bl = true;
                this.doRomMove(1);
            } else if (object == this.btnKeyboardNone || object == this.btnKeyboardPortRaw || object == this.btnKeyboardPioAhs || object == this.btnKeyboardPioAbit7 || object == this.btnKeyboardPioBhs || object == this.btnKeyboardPioBbit7 || object == this.btnKeyboardSioA || object == this.btnKeyboardSioB) {
                bl = true;
                this.updKeyboardFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnScreenEnabled) {
                bl = true;
                this.updScreenFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnPioEnabled) {
                bl = true;
                this.updPioFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnSioEnabled) {
                bl = true;
                this.updSioFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnCtcEnabled) {
                bl = true;
                this.updCtcFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnKCNetEnabled) {
                bl = true;
                this.updKCNetFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnVdipEnabled) {
                bl = true;
                this.updVdipFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnFdcEnabled) {
                bl = true;
                this.updFdcFieldsEnabled();
                this.fireDataChanged();
            } else if (object instanceof AbstractButton || object instanceof JComboBox) {
                bl = true;
                this.fireDataChanged();
            }
        }
        if (!bl) {
            bl = this.tabGIDE.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoLoad.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoInput.doAction(eventObject);
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltFont.lookAndFeelChanged();
        this.tabGIDE.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        this.fldTitle.setText(CustomSys.getTitle(properties));
        this.fldSpeedMHz.setText(this.settingsFrm.getSpeedFmt().format((float)CustomSys.getDefaultSpeedKHz(properties) / 1000.0f));
        this.tableModelRom.setRows(CustomSys.getDeclaredROMs(properties));
        this.btnScreenEnabled.setSelected(CustomSys.emulatesScreen(properties));
        this.docScreenBegAddr.setValue(CustomSys.getScreenBegAddr(properties), 4);
        this.comboScreenCols.setSelectedItem(Integer.toString(CustomSys.getScreenCols(properties)));
        this.comboScreenRows.setSelectedItem(Integer.toString(CustomSys.getScreenRows(properties)));
        this.fldAltFont.updFields(properties);
        this.updScreenFieldsEnabled();
        switch (EmuUtil.getProperty(properties, this.propPrefix + "keyboard.hardware")) {
            case "port.raw": {
                this.btnKeyboardPortRaw.setSelected(true);
                break;
            }
            case "pio.a.handshake": {
                this.btnKeyboardPioAhs.setSelected(true);
                break;
            }
            case "pio.a.bit7": {
                this.btnKeyboardPioAbit7.setSelected(true);
                break;
            }
            case "pio.b.handshake": {
                this.btnKeyboardPioBhs.setSelected(true);
                break;
            }
            case "pio.b.bit7": {
                this.btnKeyboardPioBbit7.setSelected(true);
                break;
            }
            case "sio.a": {
                this.btnKeyboardSioA.setSelected(true);
                break;
            }
            case "sio.b": {
                this.btnKeyboardSioB.setSelected(true);
                break;
            }
            default: {
                this.btnKeyboardNone.setSelected(true);
            }
        }
        this.docKeyboardIOAddr.setValue(CustomSys.getKeyboardIOAddr(properties), 2);
        this.btnKeyboardSwapCase.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "swap_key_char_case", false));
        this.updKeyboardFieldsEnabled();
        this.btnPioEnabled.setSelected(CustomSys.emulatesPIO(properties));
        this.docPioIOBaseAddr.setValue(CustomSys.getPioIOBaseAddr(properties), 2);
        this.updPioFieldsEnabled();
        this.btnSioEnabled.setSelected(CustomSys.emulatesSIO(properties));
        this.docSioIOBaseAddr.setValue(CustomSys.getSioIOBaseAddr(properties), 2);
        this.setSelectedSioClock(this.comboSioClockA, properties, "sio.a.clock");
        this.setSelectedSioClock(this.comboSioClockB, properties, "sio.b.clock");
        this.setSelectedSioOut(this.comboSioOutA, properties, "sio.a.out");
        this.setSelectedSioOut(this.comboSioOutB, properties, "sio.b.out");
        this.updSioFieldsEnabled();
        this.btnCtcEnabled.setSelected(CustomSys.emulatesCTC(properties));
        this.docCtcIOBaseAddr.setValue(CustomSys.getCtcIOBaseAddr(properties), 2);
        this.updCtcFieldsEnabled();
        this.btnKCNetEnabled.setSelected(CustomSys.emulatesKCNet(properties));
        this.docKCNetIOBaseAddr.setValue(CustomSys.getKCNetIOBaseAddr(properties), 2);
        this.updKCNetFieldsEnabled();
        this.btnVdipEnabled.setSelected(CustomSys.emulatesVDIP(properties));
        this.docVdipIOBaseAddr.setValue(CustomSys.getVdipIOBaseAddr(properties), 2);
        this.updVdipFieldsEnabled();
        this.docUnusedPortValue.setValue(CustomSys.getUnusedPortValue(properties), 2);
        this.btnFdcEnabled.setSelected(CustomSys.emulatesFDC(properties));
        this.docFdcDataIOAddr.setValue(CustomSys.getFdcDataIOAddr(properties), 4);
        this.docFdcStatusIOAddr.setValue(CustomSys.getFdcStatusIOAddr(properties), 4);
        this.docFdcTCIOAddr.setValue(CustomSys.getFdcTCIOAddr(properties), 4);
        int n = 0;
        int n2 = EmuUtil.getIntProperty(properties, this.propPrefix + "fdc.tc.iomask", 0) & 0xFF;
        if (n2 != 0) {
            ++n;
            while ((n2 & 1) != 0) {
                n2 <<= 1;
                ++n;
            }
            if ((EmuUtil.getIntProperty(properties, this.propPrefix + "fdc.tc.iovalue", 255) & 0xFF) == 0) {
                n += 8;
            }
        }
        this.tabGIDE.updFields(properties);
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }

    private void doRomAdd() {
        CustomSysROM customSysROM;
        boolean bl = false;
        int n = this.tableModelRom.getRowCount();
        for (int i = 0; i < n; ++i) {
            CustomSysROM customSysROM2 = this.tableModelRom.getRow(i);
            if (customSysROM2 == null || !customSysROM2.isBootROM() || !customSysROM2.isEnabledAfterReset()) continue;
            bl = true;
            break;
        }
        if ((customSysROM = CustomSysROMSettingsDlg.showNewROMDlg(this.settingsFrm, !bl)) != null) {
            this.tableModelRom.addRow(customSysROM);
            this.fireDataChanged();
        }
    }

    private void doRomEdit() {
        int n;
        CustomSysROM customSysROM;
        int[] nArray = this.tableRom.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (customSysROM = this.tableModelRom.getRow(n = this.tableRom.convertRowIndexToModel(nArray[0]))) != null && (customSysROM = CustomSysROMSettingsDlg.showDlg(this.settingsFrm, customSysROM)) != null) {
            this.tableModelRom.setRow(n, customSysROM);
            this.fireDataChanged();
        }
    }

    private void doRomMove(int n) {
        int[] nArray = this.tableRom.getSelectedRows();
        if (nArray != null && nArray.length == 1) {
            int n2 = this.tableModelRom.getRowCount();
            int n3 = nArray[0];
            int n4 = n3 + n;
            if (n3 >= 0 && n3 < n2 && n4 >= 0 && n4 < n2) {
                CustomSysROM customSysROM = this.tableModelRom.getRow(n3);
                CustomSysROM customSysROM2 = this.tableModelRom.getRow(n4);
                if (customSysROM != null && customSysROM2 != null) {
                    this.tableModelRom.setRow(n3, customSysROM2);
                    this.tableModelRom.setRow(n4, customSysROM);
                    EmuUtil.fireSelectRow(this.tableRom, n4);
                    this.fireDataChanged();
                }
            }
        }
    }

    private void doRomRemove() {
        int[] nArray = this.tableRom.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = this.tableRom.convertRowIndexToModel(nArray[i]);
                if (n < 0) continue;
                this.tableModelRom.removeRow(n);
            }
            this.fireDataChanged();
        }
    }

    private void addToIOAddrMasp(Map<Integer, String> map, int n, int n2, String string) throws UserInputException {
        for (int i = 0; i < n2; ++i) {
            String string2 = map.get(n);
            if (string2 != null) {
                throw new UserInputException(String.format("E/A-Adresskonflikt bei Adresse %02Xh:\n%s <> %s\n\nDen E/A-Komponenten m\u00fcssen unterschiedliche\nAdressen bzw. Adressbereiche zugewiesen werden.\nPIO, SIO, CTC, KCNet und USB verwenden jeweils 4\nund GIDE 16 aufeinanderfolgende Adressen.", n, string2, string));
            }
            map.put(n++, string);
        }
    }

    private int applyIOAddrInput(boolean bl, JCheckBox jCheckBox, String string, HexDocument hexDocument, String string2, Properties properties) throws UserInputException {
        boolean bl2 = jCheckBox.isSelected();
        EmuUtil.setProperty(properties, this.propPrefix + string, bl2);
        return this.applyIOAddrInput(bl && bl2, jCheckBox.getText(), hexDocument, string2, properties);
    }

    private int applyIOAddrInput(boolean bl, String string, HexDocument hexDocument, String string2, Properties properties) throws UserInputException {
        int n;
        int n2;
        block5: {
            n2 = -1;
            n = -1;
            try {
                n = hexDocument.intValue();
                if (bl) {
                    if (n > 255) {
                        throw new UserInputException(string + TEXT_INVALID_ADDR);
                    }
                    n2 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!bl) break block5;
                throw new UserInputException(string + TEXT_INVALID_ADDR);
            }
        }
        if (n >= 0) {
            EmuUtil.setProperty(properties, this.propPrefix + string2, n);
        }
        return n2;
    }

    private void docChanged(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.docTitle || document == this.docSpeedMHz || document == this.docScreenBegAddr || document == this.docKeyboardIOAddr || document == this.docPioIOBaseAddr || document == this.docSioIOBaseAddr || document == this.docCtcIOBaseAddr || document == this.docKCNetIOBaseAddr || document == this.docVdipIOBaseAddr || document == this.docFdcDataIOAddr || document == this.docFdcStatusIOAddr || document == this.docFdcTCIOAddr || document == this.docUnusedPortValue) {
            this.fireDataChanged();
        }
    }

    private static String getSioOutValue(JComboBox jComboBox) {
        return jComboBox.getSelectedIndex() == 1 ? "printer" : "";
    }

    private void setSelectedSioClock(JComboBox jComboBox, Properties properties, String string) {
        int n = EmuUtil.getIntProperty(properties, this.propPrefix + string, 0);
        if (n >= 0 && n < jComboBox.getItemCount()) {
            try {
                jComboBox.setSelectedIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void setSelectedSioOut(JComboBox jComboBox, Properties properties, String string) {
        int n = 0;
        if (EmuUtil.getProperty(properties, this.propPrefix + string).equals("printer")) {
            n = 1;
        }
        if (n >= 0 && n < jComboBox.getItemCount()) {
            try {
                jComboBox.setSelectedIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void updCtcFieldsEnabled() {
        this.fldCtcIOBaseAddr.setEnabled(this.btnCtcEnabled.isSelected());
    }

    private void updFdcFieldsEnabled() {
        boolean bl = this.btnFdcEnabled.isSelected();
        this.labelFdcDataIOAddr.setEnabled(bl);
        this.labelFdcStatusIOAddr.setEnabled(bl);
        this.labelFdcTCIOAddr.setEnabled(bl);
        this.labelFdcTCBit.setEnabled(bl);
        this.fldFdcDataIOAddr.setEnabled(bl);
        this.fldFdcStatusIOAddr.setEnabled(bl);
        this.fldFdcTCIOAddr.setEnabled(bl);
        this.comboFdcTCIOBit.setEnabled(bl);
    }

    private void updKCNetFieldsEnabled() {
        this.fldKCNetIOBaseAddr.setEnabled(this.btnKCNetEnabled.isSelected());
    }

    private void updKeyboardFieldsEnabled() {
        boolean bl = this.btnKeyboardPortRaw.isSelected();
        this.fldKeyboardIOAddr.setEnabled(bl);
    }

    private void updPioFieldsEnabled() {
        this.fldPioIOBaseAddr.setEnabled(this.btnPioEnabled.isSelected());
    }

    private void updScreenFieldsEnabled() {
        boolean bl = this.btnScreenEnabled.isSelected();
        this.labelScreenBegAddr.setEnabled(bl);
        this.labelScreenCols.setEnabled(bl);
        this.labelScreenRows.setEnabled(bl);
        this.fldScreenBegAddr.setEnabled(bl);
        this.comboScreenCols.setEnabled(bl);
        this.comboScreenRows.setEnabled(bl);
        this.fldAltFont.setEnabled(bl);
    }

    private void updSioFieldsEnabled() {
        boolean bl = this.btnSioEnabled.isSelected();
        this.fldSioIOBaseAddr.setEnabled(bl);
        this.labelSioClockA.setEnabled(bl);
        this.labelSioClockB.setEnabled(bl);
        this.labelSioOutA.setEnabled(bl);
        this.labelSioOutB.setEnabled(bl);
        this.comboSioClockA.setEnabled(bl);
        this.comboSioClockB.setEnabled(bl);
        this.comboSioOutA.setEnabled(bl);
        this.comboSioOutB.setEnabled(bl);
    }

    private void updVdipFieldsEnabled() {
        this.fldVdipIOBaseAddr.setEnabled(this.btnVdipEnabled.isSelected());
    }
}

