/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.etc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.SLC1;

public class SLC1KeyboardFld
extends AbstractKeyboardFld<SLC1> {
    private static final int MARGIN = 10;
    private static final int FONT_SIZE_MAIN = 18;
    private static final int FONT_SIZE_SUB = 12;
    private static final int KEY_DIST = 70;
    private static final int KEY_SIZE = 60;
    private Font fontMain = new Font("SansSerif", 1, 18);
    private Font fontSub = new Font("SansSerif", 0, 12);
    private int[] kbMatrix = new int[3];
    private int curIdx = 0;
    private int curX = 10;
    private int curY = 10;

    public SLC1KeyboardFld(SLC1 sLC1) {
        super(sLC1, 12, true);
        this.addKey("C#Seq", null, "#BG", 2, 16, "Esc#S");
        this.addKey("A#\u00b11", null, "#SS", 2, 32, "F1#+ oder -");
        this.addKey("St#Fu", null, "#DP", 2, 64, "S#F2");
        this.addKey("Z#Adr", null, "#BP", 2, 128, "Z#F1");
        this.curX = 10;
        this.curY += 70;
        this.addKey("H#7", "8#F", "-#GO", 1, 128, "H oder 8#7 oder F");
        this.addKey("G#6", "7#E", "-#BL", 1, 64, "G oder 7#6 oder E");
        this.addKey("F#5", "6#D", "K\u00f6nig#DEL", 1, 32, "F oder 6#5 oder D");
        this.addKey("E#4", "5#C", "Dame#INS", 1, 16, "E oder 5#4 oder C");
        this.curX = 10;
        this.curY += 70;
        this.addKey("D#3", "4#B", "Turm#", 0, 16, "D oder 4#3 oder B");
        this.addKey("C#2", "3#A", "L\u00e4ufer#", 0, 32, "C oder 3#2 oder A");
        this.addKey("B#1", "2#9", "Springer#", 0, 64, "B oder 2#1 oder 9");
        this.addKey("A#0", "1#8", "Bauer#", 0, 128, "A oder 1#0 oder 8");
        this.setPreferredSize(new Dimension(290, 220));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof SLC1;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = super.getToolTipText(mouseEvent);
        if (string != null && (string = SLC1KeyboardFld.getText(string, ((SLC1)this.emuSys).isChessMode())) != null && string.isEmpty()) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((SLC1)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean bl = ((SLC1)this.emuSys).isChessMode();
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            boolean bl2 = this.isKeySelected(keyData);
            if (bl2) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1, !bl2);
            graphics.setColor(Color.black);
            String string = SLC1KeyboardFld.getText(keyData.text3, bl);
            if (string != null && string.isEmpty()) {
                string = null;
            }
            if (keyData.text1 != null) {
                int n = keyData.y + 18 + 8;
                graphics.setFont(this.fontMain);
                if (keyData.text2 != null) {
                    SLC1KeyboardFld.drawLeft(graphics, keyData.x, n, SLC1KeyboardFld.getText(keyData.text1, bl));
                    SLC1KeyboardFld.drawRight(graphics, keyData.x, n, SLC1KeyboardFld.getText(keyData.text2, bl));
                } else {
                    if (string == null) {
                        n = keyData.y + (keyData.h - 18) / 2 + 18 - 2;
                    }
                    SLC1KeyboardFld.drawCentered(graphics, keyData.x, n, SLC1KeyboardFld.getText(keyData.text1, bl));
                }
            }
            if (string == null) continue;
            graphics.setFont(this.fontSub);
            SLC1KeyboardFld.drawCentered(graphics, keyData.x, keyData.y + keyData.h - 6, string);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof SLC1)) {
            throw new IllegalArgumentException("EmuSys != SLC1");
        }
        this.emuSys = (SLC1)emuSys;
    }

    private AbstractKeyboardFld.KeyData addKey(String string, String string2, String string3, int n, int n2, String string4) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, string, string2, string3, null, null, n, n2, false, string4);
        this.keys[this.curIdx++] = keyData;
        this.curX += 70;
        return keyData;
    }

    private static void drawCentered(Graphics graphics, int n, int n2, String string) {
        FontMetrics fontMetrics;
        if (string != null && (fontMetrics = graphics.getFontMetrics()) != null) {
            graphics.drawString(string, n + (60 - fontMetrics.stringWidth(string)) / 2 + 2, n2);
        }
    }

    private static void drawLeft(Graphics graphics, int n, int n2, String string) {
        if (string != null) {
            graphics.drawString(string, n + 8, n2);
        }
    }

    private static void drawRight(Graphics graphics, int n, int n2, String string) {
        FontMetrics fontMetrics;
        if (string != null && (fontMetrics = graphics.getFontMetrics()) != null) {
            graphics.drawString(string, n + 60 - fontMetrics.stringWidth(string) - 8, n2);
        }
    }

    private static String getText(String string, boolean bl) {
        String string2 = "";
        if (string != null) {
            int n = string.indexOf(35);
            if (n >= 0) {
                if (bl) {
                    string2 = string.substring(0, n);
                } else if (n + 1 < string.length()) {
                    string2 = string.substring(n + 1);
                }
            } else {
                string2 = string;
            }
        }
        return string2;
    }
}

