/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.etc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.VCS80;

public class VCS80KeyboardFld
extends AbstractKeyboardFld<VCS80> {
    private static final int MARGIN = 10;
    private static final int FONT_SIZE = 18;
    private static final int KEY_SIZE = 40;
    private Font fontBtn = new Font("SansSerif", 0, 18);
    private int[] kbMatrix = new int[8];
    private int curIdx = 0;
    private int curX = 10;
    private int curY = 10;

    public VCS80KeyboardFld(VCS80 vCS80) {
        super(vCS80, 24, true);
        this.addKey("C", 3, 32, null);
        this.addKey("D", 2, 32, null);
        this.addKey("E", 1, 32, null);
        this.addKey("F", 0, 32, null);
        this.curX += 20;
        this.addKey("PE", 0, 64, "P");
        this.addKey("ST", 1, 64, "S");
        this.curX = 10;
        this.curY += 40;
        this.addKey("8", 7, 32, null);
        this.addKey("9", 6, 32, null);
        this.addKey("A", 5, 32, null);
        this.addKey("B", 4, 32, null);
        this.curX += 20;
        this.addKey("TR", 2, 64, "T");
        this.addKey("GO", 3, 64, "G");
        this.curX = 10;
        this.curY += 40;
        this.addKey("4", 3, 16, null);
        this.addKey("5", 2, 16, null);
        this.addKey("6", 1, 16, null);
        this.addKey("7", 0, 16, null);
        this.curX += 20;
        this.addKey("RE", 4, 64, "R");
        this.addKey("MA", 5, 64, "M");
        this.curX = 10;
        this.curY += 40;
        this.addKey("0", 7, 16, null);
        this.addKey("1", 6, 16, null);
        this.addKey("2", 5, 16, null);
        this.addKey("3", 4, 16, null);
        this.curX += 20;
        this.addKey("A-", 6, 64, "-");
        this.addKey("A+", 7, 64, "+");
        int n = this.curY + 40 + 10;
        this.setPreferredSize(new Dimension(280, 180));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof VCS80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((VCS80)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setFont(this.fontBtn);
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            FontMetrics fontMetrics;
            boolean bl = this.isKeySelected(keyData);
            if (bl) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1, !bl);
            if (keyData.text1 == null || (fontMetrics = graphics.getFontMetrics()) == null) continue;
            graphics.setColor(Color.black);
            graphics.drawString(keyData.text1, keyData.x + (keyData.w - fontMetrics.stringWidth(keyData.text1)) / 2 + 1, keyData.y + 18 + (keyData.h - 18) / 2 - 1);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof VCS80)) {
            throw new IllegalArgumentException("EmuSys != VCS80");
        }
        this.emuSys = (VCS80)emuSys;
    }

    private void addKey(String string, int n, int n2, String string2) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, null, null, null, null, n, n2, false, string2);
        this.curX += 40;
    }
}

