/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Component;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.kc85.AbstractKC85Module;

public abstract class AbstractKC85UserPROMModule
extends AbstractKC85Module {
    protected int begAddr;
    protected int segMask;
    private int typeByte;
    private int segSize;
    private int fullSize;
    private String moduleName;
    private String fileName;
    private byte[] rom;

    public AbstractKC85UserPROMModule(int n, int n2, String string, int n3, int n4, Component component, String string2) {
        super(n);
        this.typeByte = n2;
        this.segSize = n4;
        this.fullSize = n3 * n4;
        this.moduleName = string;
        this.fileName = string2;
        this.begAddr = 0;
        this.segMask = 0;
        this.reload(component);
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public int getTypeByte() {
        return this.typeByte;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + this.segSize && this.rom != null && (n2 = n - this.begAddr | this.segMask) < this.rom.length) {
            n3 = this.rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void reload(Component component) {
        this.rom = EmuUtil.readFile(component, this.fileName, true, this.fullSize, this.moduleName + " ROM-Datei");
    }
}

