/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.EmuUtil;
import jkcemu.base.ErrorMsg;
import jkcemu.base.ScreenFrm;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.GIDE;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80IOSystem;
import z80emu.Z80Memory;
import z80emu.Z80TStatesListener;

public class D004ProcSys
implements FDC8272.DriveSelector,
Runnable,
Z80IOSystem,
Z80Memory,
Z80TStatesListener {
    private ScreenFrm screenFrm;
    private String propPrefix;
    private FloppyDiskDrive curFDDrive;
    private FloppyDiskDrive[] fdDrives;
    private byte[] ram;
    private byte[] loadData;
    private int loadAddr;
    private int startAddr;
    private int ctcTStateCounter;
    private volatile int runLevel;
    private Object loadLock;
    private Object runLock;
    private GIDE gide;
    private FDC8272 fdc;
    private Z80CPU cpu;
    private Z80CTC ctc;

    public D004ProcSys(ScreenFrm screenFrm, Properties properties, String string) {
        this.screenFrm = screenFrm;
        this.propPrefix = string;
        this.ctcTStateCounter = 0;
        this.runLevel = 0;
        this.startAddr = -1;
        this.loadAddr = -1;
        this.loadData = null;
        this.curFDDrive = null;
        this.fdDrives = new FloppyDiskDrive[4];
        this.ram = new byte[65536];
        this.clearRAM();
        Arrays.fill(this.fdDrives, null);
        this.loadLock = new Object();
        this.runLock = new Object();
        this.gide = GIDE.getGIDE(this.screenFrm, properties, string);
        this.fdc = new FDC8272(this, 4);
        this.cpu = new Z80CPU(this, this);
        this.ctc = new Z80CTC("CTC (FCh-FFh)");
        this.ctc.setTimerConnection(0, 1);
        this.ctc.setTimerConnection(1, 2);
        this.ctc.setTimerConnection(2, 3);
        this.cpu.setMaxSpeedKHz(4000);
        this.cpu.setInterruptSources(this.ctc);
        this.cpu.addMaxSpeedListener(this.fdc);
        this.cpu.addTStatesListener(this);
        this.fdc.setTStatesPerMilli(this.cpu.getMaxSpeedKHz());
    }

    public void applySettings(Properties properties) {
        this.cpu.setMaxSpeedKHz(EmuUtil.getIntProperty(properties, this.propPrefix + "d004.maxspeed.khz", 4000));
        this.fdc.setTStatesPerMilli(this.cpu.getMaxSpeedKHz());
    }

    public boolean canApplySettings(Properties properties) {
        return GIDE.complies(this.gide, properties, this.propPrefix);
    }

    public void clearRAM() {
        Arrays.fill(this.ram, (byte)0);
    }

    public void die() {
        if (this.gide != null) {
            this.gide.die();
        }
        this.cpu.removeTStatesListener(this);
        this.cpu.removeMaxSpeedListener(this.fdc);
        this.fdc.die();
    }

    public void fireNMI() {
        this.cpu.fireNMI();
    }

    public void fireReset() {
        this.cpu.fireExit();
    }

    public void fireStop() {
        this.runLevel = 0;
        this.cpu.fireExit();
    }

    public int getSupportedFloppyDiskDriveCount() {
        return this.fdDrives.length;
    }

    public Z80CPU getZ80CPU() {
        return this.cpu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIntoRAM(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            if (this.runLevel > 0 && n2 >= 0) {
                Object object = this.loadLock;
                synchronized (object) {
                    this.loadData = byArray;
                    this.loadAddr = n;
                    this.startAddr = n2;
                    this.cpu.fireExit();
                }
            } else {
                this.loadIntoRAM(byArray, n);
            }
        }
    }

    public void setDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (n >= 0 && n < this.fdDrives.length) {
            this.fdDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        return this.curFDDrive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.runLevel = 1;
        Object object = this.runLock;
        synchronized (object) {
            boolean bl = true;
            while (this.runLevel > 0) {
                try {
                    byte[] byArray = null;
                    int n = -1;
                    int n2 = -1;
                    Object object2 = this.loadLock;
                    synchronized (object2) {
                        byArray = this.loadData;
                        n = this.loadAddr;
                        n2 = this.startAddr;
                        this.loadData = null;
                        this.loadAddr = -1;
                        this.startAddr = -1;
                    }
                    if (byArray != null && n >= 0) {
                        this.loadIntoRAM(byArray, n);
                        if (n2 >= 0) {
                            this.cpu.setRegPC(n2);
                        }
                    } else {
                        this.curFDDrive = null;
                        this.fdc.reset(bl);
                        if (this.gide != null) {
                            this.gide.reset();
                        }
                        this.cpu.resetCPU(bl);
                    }
                    this.cpu.run();
                }
                catch (Exception exception) {
                    EventQueue.invokeLater(new ErrorMsg(this.screenFrm, exception));
                }
            }
            bl = false;
        }
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if ((n & 0xF0) == 0 && this.gide != null) {
            int n4 = this.gide.read(n);
            if (n4 >= 0) {
                n3 = n4;
            }
        } else {
            switch (n & 0xFF) {
                case 240: {
                    n3 = this.fdc.readMainStatusReg();
                    break;
                }
                case 241: {
                    n3 = this.fdc.readData();
                    break;
                }
                case 242: 
                case 243: {
                    n3 = this.fdc.readDMA();
                    break;
                }
                case 244: {
                    n3 = 223;
                    FloppyDiskDrive floppyDiskDrive = this.curFDDrive;
                    if (floppyDiskDrive != null && floppyDiskDrive.isReady()) {
                        n3 |= 0x20;
                        if (this.fdc.getIndexHoleState()) {
                            n3 &= 0xFFFFFFEF;
                        }
                    }
                    if (this.fdc.isInterruptRequest()) {
                        n3 &= 0xFFFFFFBF;
                    }
                    if (!this.fdc.isDMARequest()) break;
                    n3 &= 0xFFFFFF7F;
                    break;
                }
                case 248: 
                case 249: {
                    this.fdc.fireTC();
                    break;
                }
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    n3 = this.ctc.read(n & 3, n2);
                }
            }
        }
        return n3;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if ((n & 0xF0) == 0 && this.gide != null) {
            this.gide.write(n, n2);
        } else {
            switch (n & 0xFF) {
                case 241: {
                    this.fdc.write(n2);
                    break;
                }
                case 242: 
                case 243: {
                    this.fdc.writeDMA(n2);
                    break;
                }
                case 246: 
                case 247: {
                    FloppyDiskDrive floppyDiskDrive = null;
                    int n4 = 1;
                    for (int i = 0; i < this.fdDrives.length; ++i) {
                        if ((n2 & n4) != 0) {
                            floppyDiskDrive = this.fdDrives[i];
                            break;
                        }
                        n4 <<= 1;
                    }
                    this.curFDDrive = floppyDiskDrive;
                    break;
                }
                case 248: 
                case 249: {
                    this.fdc.fireTC();
                    break;
                }
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    this.ctc.write(n & 3, n2, n3);
                }
            }
        }
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        return (n &= 0xFFFF) >= 0 && n < this.ram.length ? this.ram[n] & 0xFF : 0;
    }

    @Override
    public int getMemWord(int n) {
        return this.getMemByte(n + 1, false) << 8 | this.getMemByte(n, false);
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        int n2 = 0;
        if (this.runLevel > 0 && (n &= 0xFFFF) >= 0 && n < this.ram.length) {
            if (this.runLevel == 1) {
                if (n >= 64512) {
                    this.runLevel = 2;
                } else {
                    this.setMemByte(n, 0);
                    this.ram[n] = (byte)n2;
                }
            }
            if (this.runLevel > 1) {
                n2 = this.getMemByte(n, bl);
            }
        }
        return n2;
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if ((n &= 0xFFFF) >= 0 && n < this.ram.length) {
            this.ram[n] = (byte)n2;
            bl = true;
        }
        return bl;
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.setMemByte(n, n2);
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        this.ctcTStateCounter += n;
        while (this.ctcTStateCounter >= 8) {
            this.ctc.externalUpdate(0, 1);
            this.ctcTStateCounter -= 8;
        }
        this.ctc.z80TStatesProcessed(z80CPU, n);
        this.fdc.z80TStatesProcessed(z80CPU, n);
    }

    private void loadIntoRAM(byte[] byArray, int n) {
        if (byArray != null && n >= 0) {
            int n2 = 0;
            while (n2 < byArray.length && n < this.ram.length) {
                this.ram[n++] = byArray[n2++];
            }
        }
    }
}

