/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.KC85;
import jkcemu.emusys.kc85.AbstractKC85KeyboardFld;

public class D005KeyboardFld
extends AbstractKC85KeyboardFld {
    private static final int TEXT_FONT_SIZE = 9;
    private static final int LETTER_FONT_SIZE = 14;
    private static final int DIGIT_FONT_SIZE = 11;
    private static final int LED_SIZE = 8;
    private static final int KEY_SIZE = 40;
    private static final int KEY_HALF_SIZE = 20;
    private static final int MEDIUM_KEY_SIZE = 50;
    private static final int LARGE_KEY_SIZE = 60;
    private static final int SPACE_KEY_SIZE = 320;
    private static final int MARGIN = 20;
    private static final int PRE_F1_MASK = 31744;
    private Image imgKey40x40 = this.getImage("/images/keyboard/key40x40.png");
    private Image imgKey50x40 = this.getImage("/images/keyboard/key50x40.png");
    private Image imgKey60x40 = this.getImage("/images/keyboard/key60x40.png");
    private Image imgKey320x40 = this.getImage("/images/keyboard/key320x40.png");
    private Image imgLeft = this.getImage("/images/keyboard/left.png");
    private Image imgRight = this.getImage("/images/keyboard/right.png");
    private Image imgUp = this.getImage("/images/keyboard/up.png");
    private Image imgDown = this.getImage("/images/keyboard/down.png");
    private Image imgPoint = this.getImage("/images/keyboard/point.png");
    private Font fontText;
    private Font fontLetter;
    private Font fontDigit;
    private AbstractKeyboardFld.KeyData digit1Key;
    private AbstractKeyboardFld.KeyData digit2Key;
    private AbstractKeyboardFld.KeyData deleteKey;
    private AbstractKeyboardFld.KeyData escapeKey;
    private AbstractKeyboardFld.KeyData controlKey;
    private AbstractKeyboardFld.KeyData spaceKey;
    private AbstractKeyboardFld.KeyData shiftKey1;
    private AbstractKeyboardFld.KeyData shiftKey2;
    private AbstractKeyboardFld.KeyData capsLockKey;
    private AbstractKeyboardFld.KeyData f1Key;
    private AbstractKeyboardFld.KeyData f4Key;
    private AbstractKeyboardFld.KeyData f5Key;
    private AbstractKeyboardFld.KeyData aeKey;
    private AbstractKeyboardFld.KeyData oeKey;
    private AbstractKeyboardFld.KeyData ueKey;
    private AbstractKeyboardFld.KeyData szKey;
    private int[] kbMatrix;
    private int curIdx = 0;
    private int curX = 20;
    private int curY = 20;
    private int xRow1Left;
    private int xRow1Right;
    private int xRow3Right;
    private boolean capsLockMode = false;
    private boolean pcMode = false;
    private Color colorLEDRedOn = Color.red;
    private Color colorLEDRedOff = new Color(120, 60, 60);

    public D005KeyboardFld(KC85 kC85) {
        super(kC85, 69);
        this.fontText = new Font("SansSerif", 0, 9);
        this.fontLetter = new Font("SansSerif", 0, 14);
        this.fontDigit = new Font("SansSerif", 0, 11);
        this.kbMatrix = new int[10];
        this.f1Key = this.addKey("F1", "F7", null, 124, 125, 124, "F1");
        this.curX += 20;
        this.xRow1Left = this.curX;
        this.addKey("/", "'", "\u00ac", 106, 53, 23, null);
        this.digit1Key = this.addKey("1", "!", 116, 117);
        this.digit2Key = this.addKey("2", "\"", 4, 5);
        this.addKey("3", "#", 20, 21);
        this.addKey("4", "$", 100, 101);
        this.addKey("5", "%", 36, 37);
        this.addKey("6", "&", 84, 85);
        this.addKey("7", "^", "@", 52, 22, 43, null);
        this.addKey("8", "(", "|", 68, 69, 103, null);
        this.addKey("9", ")", 58, 59);
        this.addKey("0", "=", 42, 11);
        this.szKey = this.addKey("\u00df", "?", "F4", 108, 107, -1, "F4");
        this.addKey("HOME", null, null, 8, 9, -1, "Pos1");
        this.addKey("INS", null, null, 56, 57, 118, "Einfg");
        this.xRow1Right = this.curX - 1;
        this.curX += 30;
        int n = this.curX + 30;
        this.deleteKey = this.addLargeKey("DEL", 40, 41, "Entf");
        this.curX = 20;
        this.curY += 40;
        this.addKey("F2", "F8", null, 12, 13, -1, "F2");
        this.curX += 40;
        this.addKey("<", ">", 75, 91);
        this.addControlSensitiveKey("Q", 112, 113);
        this.addControlSensitiveKey("W", 0, 1);
        this.addControlSensitiveKey("E", 16, 17);
        this.addControlSensitiveKey("R", null, 96, 97, 87, null);
        this.addControlSensitiveKey("T", 32, 33);
        this.addControlSensitiveKey("Z", 80, 81);
        this.addControlSensitiveKey("U", 48, 49);
        this.addControlSensitiveKey("I", 64, 65);
        this.addControlSensitiveKey("O", 54, 55);
        this.addControlSensitiveKey("P", 38, 39);
        this.ueKey = this.addKey("\u00dc", null, "F3", 28, 29, -1, "F3");
        this.addKey("+", "*", 104, 27);
        this.curX = n - 20;
        this.addKey(this.imgUp, 120, 121);
        this.curX = 20;
        this.curY += 40;
        this.addKey("F3", "F9", null, 28, 29, -1, "F3");
        this.curX += 40;
        this.capsLockKey = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, "CAPS\nLOCK", null, null, null, null, -1, 114, false, null);
        this.keys[this.curIdx++] = this.capsLockKey;
        this.curX += 50;
        this.addControlSensitiveKey("A", 2, 3);
        this.addControlSensitiveKey("S", 18, 19);
        this.addControlSensitiveKey("D", 98, 99);
        this.addControlSensitiveKey("F", 34, 35);
        this.addControlSensitiveKey("G", 82, 83);
        this.addControlSensitiveKey("H", 50, 51);
        this.addControlSensitiveKey("J", 66, 67);
        this.addControlSensitiveKey("K", 72, 73);
        this.addControlSensitiveKey("L", null, 88, 89, 86, null);
        this.oeKey = this.addKey("\u00d6", null, "F2", 12, 13, -1, "F2");
        this.aeKey = this.addKey("\u00c4", null, "F1", 124, 125, -1, "F1");
        this.addControlSensitiveKey("CLR", null, 24, 25, -1, "F9");
        this.xRow3Right = this.curX - 1;
        this.curX = n - 40;
        this.addKey(this.imgLeft, 6, 7);
        this.addKey(this.imgRight, 122, 123);
        int n2 = this.curX + 20;
        this.curX = 20;
        this.curY += 40;
        this.f4Key = this.addKey("F4", "F10", null, 108, 109, -1, "F4");
        this.curX += 20;
        this.addKey("F6", "F12", null, 92, 93, -1, "F6");
        this.shiftKey1 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, "SHIFT", null, null, null, null, -1, -1, true, null);
        this.keys[this.curIdx++] = this.shiftKey1;
        this.curX += 50;
        this.addControlSensitiveKey("Y", 14, 15);
        this.addControlSensitiveKey("X", 30, 31);
        this.addControlSensitiveKey("C", 110, 111);
        this.addControlSensitiveKey("V", 46, 47);
        this.addControlSensitiveKey("B", 94, 95);
        this.addControlSensitiveKey("N", 62, 63);
        this.addControlSensitiveKey("M", 78, 79);
        this.addKey(",", ";", 74, 105);
        this.addKey(".", ":", 90, 26);
        this.addKey("-", "_", 10, 102);
        this.shiftKey2 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, "SHIFT", null, null, null, null, -1, -1, true, null);
        this.keys[this.curIdx++] = this.shiftKey2;
        this.curX = n - 20;
        this.addKey(this.imgDown, 118, 119);
        this.curX = 20;
        this.curY += 40;
        this.f5Key = this.addKey("F5", "F11", null, 44, 45, -1, "F5");
        this.curX += 50;
        this.controlKey = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, "CTRL", null, null, null, null, -1, -1, true, null);
        this.keys[this.curIdx++] = this.controlKey;
        this.curX += 40;
        this.escapeKey = this.addKey("ESC", null, 77, 77);
        this.spaceKey = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 320, 40, null, null, null, null, null, -1, 16729926, false, null);
        this.keys[this.curIdx++] = this.spaceKey;
        this.curX += 320;
        this.addControlSensitiveKey("BRK", null, 60, 61, -1, "F7");
        this.addControlSensitiveKey("STOP", null, 76, 77, -1, "F8");
        this.curX = n - 30;
        this.addLargeKey("RETURN", 126, 127, "Enter");
        int n3 = this.curY + 40 + 20;
        this.setPreferredSize(new Dimension(n2, n3));
        this.setShiftKeys(this.shiftKey1, this.shiftKey2);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        boolean bl = false;
        if (emuSys instanceof KC85 && ((KC85)emuSys).getKCTypeNum() >= 4) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void fireKOut() {
        this.capsLockMode = false;
        this.pcMode = false;
        this.repaint();
    }

    @Override
    public String getKeyboardName() {
        return "Komforttastatur D005";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        AbstractKeyboardFld.KeyData keyData = null;
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData2 : this.selectedKeys) {
                if (keyData2 == this.controlKey) {
                    bl = true;
                    continue;
                }
                if (keyData2 == this.shiftKey1 || keyData2 == this.shiftKey2) {
                    bl2 = true;
                    continue;
                }
                if (keyData != null) {
                    keyData = null;
                    break;
                }
                keyData = keyData2;
            }
        }
        if (keyData != null) {
            if (bl) {
                if (keyData == this.escapeKey) {
                    this.pcMode = !this.pcMode;
                    this.repaint();
                } else {
                    n = this.pcMode && keyData == this.digit1Key ? 31796 : (this.pcMode && keyData == this.digit2Key ? 31812 : (this.pcMode && keyData == this.deleteKey ? 31784 : (this.pcMode && keyData == this.f4Key ? 31852 : (this.pcMode && keyData == this.f5Key ? 31788 : (this.pcMode && keyData == this.spaceKey ? 31814 : (this.pcMode && (keyData.value & 0x1000000) != 0 ? 0x7C00 | keyData.value & 0xFF : keyData.value >> 16 & 0xFF))))));
                }
            } else if (keyData == this.capsLockKey) {
                n = this.pcMode ? 31800 : keyData.value & 0xFF;
                this.capsLockMode = !this.capsLockMode;
            } else {
                boolean bl3 = bl2;
                if (this.capsLockMode) {
                    boolean bl4 = bl3 = !bl3;
                }
                n = keyData == this.aeKey ? (this.pcMode ? 0x7C00 | (bl3 ? 116 : 100) : (bl3 ? keyData.value >> 8 : keyData.value) & 0xFF) : (keyData == this.oeKey ? (this.pcMode ? 0x7C00 | (bl3 ? 4 : 36) : (bl3 ? keyData.value >> 8 : keyData.value) & 0xFF) : (keyData == this.ueKey ? (this.pcMode ? 0x7C00 | (bl3 ? 20 : 84) : (bl3 ? keyData.value >> 8 : keyData.value) & 0xFF) : (this.pcMode && keyData == this.f1Key ? 0x7C00 | (bl2 ? 28 : 12) : (!bl2 && this.pcMode && keyData == this.szKey ? 31786 : (this.pcMode && keyData == this.escapeKey ? 125 : (bl2 ? keyData.value >> 8 : keyData.value) & 0xFF)))));
            }
            if ((n & 0xFF) == 255) {
                n = -1;
            }
        }
        ((KC85)this.emuSys).setKeyNumPressed(n);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            int n;
            int n2;
            if (this.isKeySelected(keyData)) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x, keyData.y, keyData.w, keyData.h);
            }
            switch (keyData.w) {
                case 40: {
                    if (this.imgKey40x40 == null) break;
                    graphics.drawImage(this.imgKey40x40, keyData.x, keyData.y, this);
                    break;
                }
                case 50: {
                    if (this.imgKey50x40 == null) break;
                    graphics.drawImage(this.imgKey50x40, keyData.x, keyData.y, this);
                    break;
                }
                case 60: {
                    if (this.imgKey60x40 == null) break;
                    graphics.drawImage(this.imgKey60x40, keyData.x, keyData.y, this);
                    break;
                }
                case 320: {
                    if (this.imgKey320x40 == null) break;
                    graphics.drawImage(this.imgKey320x40, keyData.x, keyData.y, this);
                }
            }
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x + 8, keyData.y + 10, this);
                continue;
            }
            graphics.setColor(Color.black);
            if (keyData.text1 == null) continue;
            if (keyData.text2 != null) {
                graphics.setFont(this.fontDigit);
                graphics.drawString(keyData.text2, keyData.x + 8, keyData.y + 4 + 11);
                graphics.drawString(keyData.text1, keyData.x + 8, keyData.y + 40 - 9);
            } else {
                n2 = keyData.text1.length();
                if (n2 == 1) {
                    graphics.setFont(this.fontLetter);
                    graphics.drawString(keyData.text1, keyData.x + 8, keyData.y + 6 + 14);
                } else {
                    graphics.setFont(this.fontText);
                    n = keyData.text1.indexOf(10);
                    if (n >= 0) {
                        graphics.drawString(keyData.text1.substring(0, n), keyData.x + 5, keyData.y + 6 + 9);
                        if (n + 1 < n2) {
                            graphics.drawString(keyData.text1.substring(n + 1), keyData.x + 5, keyData.y + 8 + 18);
                        }
                    } else {
                        graphics.drawString(keyData.text1, keyData.x + 5, keyData.y + 6 + 9);
                    }
                }
            }
            if (keyData.text3 == null) continue;
            n2 = keyData.x + 22;
            n = keyData.y + 40 - 9;
            if (keyData.text3.length() == 1) {
                n = keyData.y + 4 + 11;
            }
            graphics.setFont(this.fontDigit);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                n2 = keyData.x + keyData.w - 7 - fontMetrics.stringWidth(keyData.text3);
            }
            graphics.drawString(keyData.text3, n2, n);
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xRow1Left, 60, this.xRow1Left, 140);
        int n = this.xRow1Left + 6;
        int n3 = 76;
        graphics.setColor(Color.gray);
        graphics.fillOval(n, n3, 8, 8);
        graphics.fillOval(n, n3 + 40, 8, 8);
        n3 = 100;
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xRow1Right, 60, this.xRow1Right, n3);
        graphics.drawLine(this.xRow1Right, n3, this.xRow3Right, n3);
        graphics.setColor(this.pcMode ? this.colorLEDRedOn : this.colorLEDRedOff);
        n = this.xRow1Right - 20 + 6;
        n3 = 76;
        graphics.fillOval(n, n3, 8, 8);
    }

    @Override
    public void reset() {
        this.capsLockMode = false;
        this.pcMode = false;
        super.reset();
    }

    @Override
    public void setEmuSys(EmuSys emuSys) throws IllegalArgumentException {
        if (!this.accepts(emuSys)) {
            throw new IllegalArgumentException("EmuSys != KC85/4..5");
        }
        this.emuSys = (KC85)emuSys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeySelection(int n) {
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (n >= 0) {
                for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                    int n2 = keyData.value & 0xFF;
                    int n3 = keyData.value >> 8 & 0xFF;
                    int n4 = keyData.value >> 16 & 0xFF;
                    if (n == n2 && n2 != 255) {
                        this.selectedKeys.add(keyData);
                        bl = true;
                        continue;
                    }
                    if (n == n3 && n3 != 255) {
                        this.selectedKeys.add(this.shiftKey1);
                        this.selectedKeys.add(this.shiftKey2);
                        this.selectedKeys.add(keyData);
                        bl = true;
                        continue;
                    }
                    if (n != n4 || n4 == 255) continue;
                    this.selectedKeys.add(this.controlKey);
                    this.selectedKeys.add(keyData);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    private void addControlSensitiveKey(String string, String string2, int n, int n2, int n3, String string3) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, string2, null, null, null, -1, 0x1000000 | n3 << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n & 0xFF, false, string3);
        this.curX += 40;
    }

    private void addControlSensitiveKey(String string, int n, int n2) {
        this.addControlSensitiveKey(string, null, n, n2, -1, null);
    }

    private AbstractKeyboardFld.KeyData addKey(Image image, int n, int n2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, null, null, null, null, image, -1, 0xFF0000 | n2 << 8 & 0xFF00 | n & 0xFF, false, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 40;
        return keyData;
    }

    private AbstractKeyboardFld.KeyData addKey(String string, String string2, String string3, int n, int n2, int n3, String string4) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, string2, string3, null, null, -1, n3 << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n & 0xFF, false, string4);
        this.keys[this.curIdx++] = keyData;
        this.curX += 40;
        return keyData;
    }

    private AbstractKeyboardFld.KeyData addKey(String string, String string2, int n, int n2) {
        return this.addKey(string, string2, null, n, n2, 255, null);
    }

    private AbstractKeyboardFld.KeyData addLargeKey(String string, int n, int n2, String string2) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, string, null, null, null, null, -1, 0xFF0000 | n2 << 8 & 0xFF00 | n & 0xFF, false, string2);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        return keyData;
    }
}

