/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.KC85;
import jkcemu.emusys.kc85.AbstractKC85KeyboardFld;

public class KC85KeyboardFld
extends AbstractKC85KeyboardFld {
    private static final int FS_KEY = 14;
    private static final int FS_NOSHIFT = 12;
    private static final int FS_SHIFT = 10;
    private static final int MARGIN_X = 15;
    private static final int MARGIN_Y = 20;
    private static final int KEY_COL_W = 50;
    private static final int KEY_ROW_H = 50;
    private static final int KEY_PAD_X = 16;
    private static final int KEY_PAD_Y = 21;
    private static final int KEY_PAD_W = 620;
    private static final int KEY_PAD_H = 272;
    private static final int X_CRS_MID = 695;
    private Image imgBG;
    private Image imgKeySmall = this.getImage("key_small_gray.png");
    private Image imgKeySmallPressed = this.getImage("key_small_pressed.png");
    private Image imgKeySpace;
    private Image imgKeySpacePressed = this.getImage("key_space_pressed.png");
    private Image imgLeft = this.getImage("left.png");
    private Image imgRight = this.getImage("right.png");
    private Image imgUp = this.getImage("up.png");
    private Image imgDown = this.getImage("down.png");
    private Image imgEnter = this.getImage("enter.png");
    private Image imgShift = this.getImage("shift.png");
    private Image imgShLock = this.getImage("shiftlock.png");
    private Color colorBG;
    private Font fontKey;
    private Font fontNoShift;
    private Font fontShift;
    private AbstractKeyboardFld.KeyData shiftKey;
    private AbstractKeyboardFld.KeyData spaceKey;
    private int wKey;
    private int hKey;
    private int curIdx;
    private int curX;
    private int curY;

    public KC85KeyboardFld(KC85 kC85) {
        super(kC85, 64);
        int n;
        int n2;
        int n3;
        this.prepareLayout();
        this.wKey = 0;
        this.hKey = 0;
        if (this.imgKeySmall != null) {
            this.wKey = this.imgKeySmall.getWidth(this);
            this.hKey = this.imgKeySmall.getHeight(this);
        }
        this.fontKey = new Font("SansSerif", 1, 14);
        this.fontNoShift = new Font("SansSerif", 1, 12);
        this.fontShift = new Font("SansSerif", 1, 10);
        this.curIdx = 0;
        int n4 = (620 - (550 + this.wKey)) / 3;
        this.curX = n3 = 16 + 2 * n4;
        this.curY = 60 - this.hKey / 2;
        this.addKey("F1", 124, "F1");
        this.addKey("F2", 12, "F2");
        this.addKey("F3", 28, "F3");
        this.addKey("F4", 108, "F4");
        this.addKey("F5", 44, "F5");
        this.addKey("F6", 92, "F6");
        this.addKey("BRK", 60, "F7");
        this.addKey("STOP", 76, "F8");
        this.addKey("INS", 56, "Einfg");
        this.addKey("DEL", 40, "Entf");
        this.addKey("CLR", 24, "F9");
        this.addKey("HOME", 8, "Pos1");
        this.curX = n3;
        this.curY += 50;
        this.addKey("1", "!", 116);
        this.addKey("2", "\"", 4);
        this.addKey("3", "#", 20);
        this.addKey("4", "$", 100);
        this.addKey("5", "%", 36);
        this.addKey("6", "&", 84);
        this.addKey("7", "'", 52);
        this.addKey("8", "(", 68);
        this.addKey("9", ")", 58);
        this.addKey("0", "@", 42);
        this.addKey(":", "*", 26);
        this.addKey("-", "=", 10);
        this.curX += 50;
        int n5 = 695 - this.wKey / 2;
        this.addKey(n5, this.curY, this.wKey, null, null, this.imgUp, 120, null);
        this.curX = n3 + (50 + this.wKey) / 2 - this.wKey / 2;
        this.curY += 50;
        this.addKey("Q", 112);
        this.addKey("W", 0);
        this.addKey("E", 16);
        this.addKey("R", 96);
        this.addKey("T", 32);
        this.addKey("Z", 80);
        this.addKey("U", 48);
        this.addKey("I", 64);
        this.addKey("O", 54);
        this.addKey("P", 38);
        this.addKey("^", "\u00ac", 22);
        this.curX += 50;
        this.curX = n5 - 25;
        this.addKey(this.curX, this.curY, this.wKey, null, null, this.imgLeft, 6, null);
        int n6 = this.curX + this.wKey + 15;
        this.addKey(this.curX, this.curY, this.wKey, null, null, this.imgRight, 122, null);
        this.curX = n2 = 16 + n4;
        this.curY += 50;
        this.addKey(this.curX, this.curY, this.wKey, null, null, this.imgShLock, 114, null);
        this.addKey("A", 2);
        this.addKey("S", 18);
        this.addKey("D", 98);
        this.addKey("F", 34);
        this.addKey("G", 82);
        this.addKey("H", 50);
        this.addKey("J", 66);
        this.addKey("K", 72);
        this.addKey("L", 88);
        this.addKey("+", ";", 104);
        this.addKey("_", "|", 102);
        this.curX = n5;
        this.addKey(this.curX, this.curY, this.wKey, null, null, this.imgDown, 118, null);
        this.curX = n = n2 + (50 + this.wKey) / 2 - this.wKey / 2;
        this.curY += 50;
        this.shiftKey = new AbstractKeyboardFld.KeyData(this.curX, this.curY, this.wKey, this.hKey, null, null, null, null, this.imgShift, 0, -1, true, null);
        this.keys[this.curIdx++] = this.shiftKey;
        this.curX += 50;
        this.addKey("Y", 14);
        this.addKey("X", 30);
        this.addKey("C", 110);
        this.addKey("V", 46);
        this.addKey("B", 94);
        this.addKey("N", 62);
        this.addKey("M", 78);
        this.addKey(",", "<", 74);
        this.addKey(".", ">", 90);
        this.addKey("/", "?", 106);
        this.curX = n5;
        this.addKey(this.curX, this.curY, this.wKey, null, null, this.imgEnter, 126, "Enter");
        int n7 = 0;
        int n8 = 0;
        if (this.imgKeySpace != null) {
            n7 = this.imgKeySpace.getWidth(this);
            n8 = this.imgKeySpace.getHeight(this);
        }
        this.spaceKey = new AbstractKeyboardFld.KeyData(n + (500 + this.wKey - n7) / 2, 293 + n8, n7, n8, null, null, null, null, null, 0, 70, false, null);
        this.keys[this.curIdx++] = this.spaceKey;
        this.setPreferredSize(new Dimension(n6, 293 + 2 * n8 + 20));
        this.setShiftKeys(this.shiftKey);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof KC85;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        int n = -1;
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.shift) {
                    bl = true;
                    continue;
                }
                if (keyData.value < 0) continue;
                n = keyData.value;
            }
        }
        if (bl && n >= 0) {
            ++n;
        }
        ((KC85)this.emuSys).setKeyNumPressed(n);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.colorBG);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.imgBG != null) {
            graphics.drawImage(this.imgBG, 15, 20, this);
        }
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            this.drawKey(graphics, keyData, this.isKeySelected(keyData));
        }
    }

    @Override
    protected Image getImage(String string) {
        return super.getImage("/images/keyboard/kc85/" + string);
    }

    @Override
    public void setEmuSys(EmuSys emuSys) throws IllegalArgumentException {
        if (!(emuSys instanceof KC85)) {
            throw new IllegalArgumentException("EmuSys != KC85");
        }
        this.emuSys = (KC85)emuSys;
        this.prepareLayout();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeySelection(int n) {
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (n >= 0) {
                for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                    if (keyData.value == n) {
                        this.selectedKeys.add(keyData);
                        bl = true;
                        continue;
                    }
                    if (keyData.value < 0 || keyData.value + 1 != n) continue;
                    this.selectedKeys.add(this.shiftKey);
                    this.selectedKeys.add(keyData);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    private void addKey(int n, int n2, int n3, String string, String string2, Image image, int n4, String string3) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(n, n2, n3, this.hKey, string, string2, null, null, image, 0, n4, false, string3);
        this.curX += 50;
    }

    private void addKey(String string, int n) {
        this.addKey(this.curX, this.curY, this.wKey, string, null, null, n, null);
    }

    private void addKey(String string, int n, String string2) {
        this.addKey(this.curX, this.curY, this.wKey, string, null, null, n, string2);
    }

    private void addKey(String string, String string2, int n) {
        this.addKey(this.curX, this.curY, this.wKey, string, string2, null, n, null);
    }

    private void drawCenter(Graphics graphics, int n, int n2, int n3, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)) / 2, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    private void drawCenter(Graphics graphics, int n, int n2, int n3, int n4, Image image) {
        if (image != null) {
            int n5 = image.getWidth(this);
            int n6 = image.getHeight(this);
            if (n5 > 0 && n4 > 0) {
                graphics.drawImage(image, n + (n3 - n5) / 2, n2 + (n4 - n6) / 2, this);
            }
        }
    }

    private void drawKey(Graphics graphics, AbstractKeyboardFld.KeyData keyData, boolean bl) {
        if (keyData == this.spaceKey) {
            if (bl) {
                if (this.imgKeySpacePressed != null) {
                    graphics.drawImage(this.imgKeySpacePressed, keyData.x, keyData.y, this);
                }
            } else if (this.imgKeySpace != null) {
                graphics.drawImage(this.imgKeySpace, keyData.x, keyData.y, this);
            }
        } else {
            if (bl) {
                if (this.imgKeySmallPressed != null) {
                    graphics.drawImage(this.imgKeySmallPressed, keyData.x, keyData.y, this);
                }
            } else if (this.imgKeySmall != null) {
                graphics.drawImage(this.imgKeySmall, keyData.x, keyData.y, this);
            }
            graphics.setColor(Color.black);
            if (keyData.image != null) {
                this.drawCenter(graphics, keyData.x, keyData.y, keyData.w, keyData.h, keyData.image);
            } else if (keyData.text1 != null) {
                if (keyData.text2 != null) {
                    this.drawCenter(graphics, keyData.x + 6, keyData.y + keyData.h - 6, keyData.w / 2 - 4, keyData.text1);
                    this.drawCenter(graphics, keyData.x + keyData.w / 2 + 1, keyData.y + 5 + 10, keyData.w / 2 - 4, keyData.text2);
                } else {
                    this.drawCenter(graphics, keyData.x, keyData.y + (keyData.h - 14) / 2 + 14 - 2, keyData.w, keyData.text1);
                }
            }
        }
    }

    private void drawRight(Graphics graphics, int n, int n2, int n3, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)), n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    private void prepareLayout() {
        if (((KC85)this.emuSys).getKCTypeNum() >= 4) {
            this.imgBG = this.getImage("bg_gray.png");
            this.imgKeySpace = this.getImage("key_space_gray.png");
            this.colorBG = new Color(230, 230, 220);
        } else {
            this.imgBG = ((KC85)this.emuSys).getTitle().startsWith("HC") ? this.getImage("bg_hc900.png") : this.getImage("bg_dark.png");
            this.imgKeySpace = this.getImage("key_space_dark.png");
            this.colorBG = new Color(40, 45, 50);
        }
    }
}

