/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.util.Arrays;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class KC85PlainRAMModule
extends AbstractKC85Module {
    private String moduleName;
    private int typeByte;
    private int begAddr;
    private boolean cmos;
    private boolean readWrite;
    private byte[] ram;

    public KC85PlainRAMModule(int n, int n2, String string, int n3, boolean bl) {
        super(n);
        this.typeByte = n2;
        this.moduleName = string;
        this.cmos = bl;
        this.begAddr = 0;
        this.readWrite = false;
        this.ram = new byte[n3];
    }

    @Override
    public void clearRAM() {
        Arrays.fill(this.ram, (byte)0);
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Boolean getReadWrite() {
        return this.readWrite;
    }

    @Override
    public int getTypeByte() {
        return this.typeByte;
    }

    @Override
    public int readMemByte(int n) {
        int n2 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + this.ram.length) {
            n2 = this.ram[n - this.begAddr] & 0xFF;
        }
        return n2;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.readWrite = (n & 2) != 0;
        this.begAddr = n << 8 & 0xC000;
    }

    @Override
    public int writeMemByte(int n, int n2) {
        int n3 = 0;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + this.ram.length) {
            if (this.readWrite) {
                this.ram[n - this.begAddr] = (byte)n2;
                n3 = 2;
            } else {
                n3 = 1;
            }
        }
        return n3;
    }
}

