/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.util.HashMap;
import java.util.Map;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class KC85ROM8KModule
extends AbstractKC85Module {
    private static Map<String, byte[]> map = new HashMap<String, byte[]>();
    private String moduleName;
    private int begAddr = 0;
    private byte[] rom;

    public KC85ROM8KModule(int n, EmuThread emuThread, String string, byte[] byArray) {
        super(n);
        this.moduleName = string;
        this.rom = byArray;
    }

    public KC85ROM8KModule(int n, EmuThread emuThread, String string, String string2) {
        super(n);
        this.moduleName = string;
        this.rom = map.get(string2);
        if (this.rom == null) {
            this.rom = EmuUtil.readResource(emuThread.getScreenFrm(), string2);
            map.put(string2, this.rom);
        }
    }

    protected void setROM(byte[] byArray) {
        this.rom = byArray;
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public int getTypeByte() {
        return 251;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + 8192 && this.rom != null && (n2 = n - this.begAddr) < this.rom.length) {
            n3 = this.rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.begAddr = n << 8 & 0xE000;
    }
}

