/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jkcemu.Main;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;
import jkcemu.disk.GIDESettingsFld;
import jkcemu.emusys.KC85;
import jkcemu.emusys.kc85.KC85ModuleTableModel;
import jkcemu.emusys.kc85.KC85UserPROMSettingsDlg;

public class KC85SettingsFld
extends AbstractSettingsFld
implements ListSelectionListener,
MouseListener {
    private static final String ACTION_MODULE_ADD_PREFIX = "kc85.module.add.";
    private static final int MOD_IDX_TYPE = 0;
    private static final int MOD_IDX_NAME = 1;
    private static final int MOD_IDX_DESC = 2;
    private static final String[][] modules = new String[][]{{"ETC", "M003", "V.24 mit angeschlossenem Drucker"}, {"ROM", "M006", "BASIC"}, {"ETC", "M008", "Joystick"}, {"RAM", "M011", "64 KByte RAM"}, {"ROM", "M012", "TEXOR"}, {"ETC", "M021", "Joystick/Centronics mit angeschlossenem Drucker"}, {"RAM", "M022", "16 KByte Expander RAM"}, {"ROM", "M025", "8 KByte User PROM"}, {"ROM", "M026", "Forth"}, {"ROM", "M027", "Development"}, {"ROM", "M028", "16 KByte User PROM"}, {"RAM", "M032", "256 KByte Segmented RAM"}, {"ROM", "M033", "TypeStar"}, {"RAM", "M034", "512 KByte Segmented RAM"}, {"RAM", "M035", "1 MByte Segmented RAM"}, {"RAM", "M035x4", "4 MByte Segmented RAM"}, {"RAM", "M036", "128 KByte Segmented RAM"}, {"ROM", "M040", "8/16 KByte User PROM"}, {"ROM", "M045", "4x8 KByte User PROM"}, {"ROM", "M046", "8x8 KByte User PROM"}, {"ROM", "M047", "16x8 KByte User PROM"}, {"ROM", "M048", "16x16 KByte User PROM"}, {"ETC", "M052", "USB/Netzwerk"}, {"RAM", "M120", "8 KByte CMOS RAM"}, {"RAM", "M122", "16 KByte CMOS RAM"}, {"RAM", "M124", "32 KByte CMOS RAM"}};
    private static final String[] altRomTitles2 = new String[]{"CAOS-ROM E000-E7FF", "CAOS-ROM F000-F7FF", "M052-ROM (USB/Netzwerk)"};
    private static final String[] altRomKeys2 = new String[]{"rom.caos_e.file", "rom.caos_f.file", "rom.m052.file"};
    private static final String[] altRomTitles3 = new String[]{"BASIC-ROM C000-DFFF", "CAOS-ROM E000-FFFF", "M052-ROM (USB/Netzwerk)"};
    private static final String[] altRomKeys3 = new String[]{"rom.basic.file", "rom.caos_e.file", "rom.m052.file"};
    private static final String[] altRomTitles4 = new String[]{"BASIC-ROM C000-DFFF", "CAOS-ROM C000-CFFF (oder C000-DFFF)", "CAOS-ROM E000-FFFF", "M052-ROM (USB/Netzwerk)"};
    private static final String[] altRomKeys4 = new String[]{"rom.basic.file", "rom.caos_c.file", "rom.caos_e.file", "rom.m052.file"};
    private static final String[] altRomTitles5 = new String[]{"BASIC-/USER-ROM C000-DFFF (4x8K)", "CAOS-ROM C000-DFFF", "CAOS-ROM E000-FFFF", "M052-ROM (USB/Netzwerk)"};
    private static final String[] altRomKeys5 = new String[]{"rom.basic.file", "rom.caos_c.file", "rom.caos_e.file", "rom.m052.file"};
    private int kcTypeNum;
    private String modulePropPrefix;
    private String[] altRomTitles;
    private String[] altRomKeys;
    private ListSelectionModel selModelModule;
    private KC85ModuleTableModel tableModelModule;
    private JTable tableModule;
    private JTabbedPane tabbedPane;
    private JPanel tabModule;
    private JPanel tabD004;
    private JPanel tabROM;
    private JPanel tabEtc;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;
    private JPopupMenu popupModule;
    private JButton btnModuleAdd;
    private JButton btnModuleEdit;
    private JButton btnModuleRemove;
    private JButton btnModuleUp;
    private JButton btnModuleDown;
    private JCheckBox btnD004Enabled;
    private JComboBox<String> comboD004Rom;
    private JLabel labelD004Rom;
    private JLabel labelD004Speed;
    private JRadioButton btnD004Speed4MHz;
    private JRadioButton btnD004Speed8MHz;
    private JRadioButton btnD004Speed16MHz;
    private FileNameFld fldD004RomFile;
    private JButton btnD004RomFileSelect;
    private JButton btnD004RomFileRemove;
    private GIDESettingsFld tabGIDE;
    private FileNameFld[] altRomTextFlds;
    private JButton[] altRomSelectBtns;
    private JButton[] altRomRemoveBtns;
    private JCheckBox btnKeysDirectToBuf;
    private JCheckBox btnPasteFast;
    private JCheckBox btnVideoTiming;

    public KC85SettingsFld(SettingsFrm settingsFrm, String string, int n) {
        super(settingsFrm, string);
        int n2;
        Object object;
        Serializable serializable;
        Object object2;
        this.kcTypeNum = n;
        this.modulePropPrefix = string + "module.";
        if (n < 3) {
            this.altRomTitles = altRomTitles2;
            this.altRomKeys = altRomKeys2;
        } else if (n == 3) {
            this.altRomTitles = altRomTitles3;
            this.altRomKeys = altRomKeys3;
        } else if (n == 4) {
            this.altRomTitles = altRomTitles4;
            this.altRomKeys = altRomKeys4;
        } else {
            this.altRomTitles = altRomTitles5;
            this.altRomKeys = altRomKeys5;
        }
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabModule = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Module", this.tabModule);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tableModelModule = new KC85ModuleTableModel();
        this.tableModule = new JTable(this.tableModelModule);
        this.tableModule.setAutoCreateRowSorter(false);
        this.tableModule.setAutoResizeMode(0);
        this.tableModule.setColumnSelectionAllowed(false);
        this.tableModule.setDragEnabled(false);
        this.tableModule.setFillsViewportHeight(false);
        this.tableModule.setPreferredScrollableViewportSize(new Dimension(1, 1));
        this.tableModule.setRowSelectionAllowed(true);
        this.tableModule.setSelectionMode(2);
        this.tableModule.addMouseListener(this);
        this.tabModule.add((Component)new JScrollPane(this.tableModule), gridBagConstraints);
        EmuUtil.setTableColWidths(this.tableModule, 60, 60, 300);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridx;
        this.tabModule.add((Component)jPanel, gridBagConstraints);
        this.btnModuleUp = this.createImageButton("/images/nav/up.png", "Auf");
        jPanel.add(this.btnModuleUp);
        this.btnModuleDown = this.createImageButton("/images/nav/down.png", "Ab");
        jPanel.add(this.btnModuleDown);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 5));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.tabModule.add((Component)jPanel2, gridBagConstraints);
        this.btnModuleAdd = new JButton("Hinzuf\u00fcgen");
        this.btnModuleAdd.addActionListener(this);
        this.btnModuleAdd.addKeyListener(this);
        jPanel2.add(this.btnModuleAdd);
        this.btnModuleEdit = new JButton("Bearbeiten");
        this.btnModuleEdit.addActionListener(this);
        this.btnModuleEdit.addKeyListener(this);
        jPanel2.add(this.btnModuleEdit);
        this.btnModuleRemove = new JButton("Entfernen");
        this.btnModuleRemove.addActionListener(this);
        this.btnModuleRemove.addKeyListener(this);
        jPanel2.add(this.btnModuleRemove);
        this.selModelModule = this.tableModule.getSelectionModel();
        if (this.selModelModule != null) {
            this.selModelModule.addListSelectionListener(this);
            this.btnModuleUp.setEnabled(false);
            this.btnModuleDown.setEnabled(false);
            this.btnModuleEdit.setEnabled(false);
            this.btnModuleRemove.setEnabled(false);
        }
        this.popupModule = new JPopupMenu();
        JMenu jMenu = new JMenu("RAM-Module");
        this.popupModule.add(jMenu);
        JMenu jMenu2 = new JMenu("ROM-Module");
        this.popupModule.add(jMenu2);
        JMenu jMenu3 = new JMenu("Sonstige Module");
        this.popupModule.add(jMenu3);
        block10: for (int i = 0; i < modules.length; ++i) {
            object2 = modules[i][1];
            if (n >= 3 && ((String)object2).equals("M006")) continue;
            serializable = new JMenuItem(String.format("%s - %s", object2, modules[i][2]));
            ((AbstractButton)serializable).setActionCommand(ACTION_MODULE_ADD_PREFIX + (String)object2);
            ((AbstractButton)serializable).addActionListener(this);
            object = modules[i][0];
            n2 = -1;
            switch (((String)object).hashCode()) {
                case 80894: {
                    if (!((String)object).equals("RAM")) break;
                    n2 = 0;
                    break;
                }
                case 81328: {
                    if (!((String)object).equals("ROM")) break;
                    n2 = 1;
                    break;
                }
                case 68980: {
                    if (!((String)object).equals("ETC")) break;
                    n2 = 2;
                }
            }
            switch (n2) {
                case 0: {
                    jMenu.add((JMenuItem)serializable);
                    continue block10;
                }
                case 1: {
                    jMenu2.add((JMenuItem)serializable);
                    continue block10;
                }
                case 2: {
                    jMenu3.add((JMenuItem)serializable);
                }
            }
        }
        this.tabD004 = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("D004", this.tabD004);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnD004Enabled = new JCheckBox("Floppy-Disk-Erweiterung D004 emulieren (bei Bedarf mit GIDE)", false);
        this.btnD004Enabled.addActionListener(this);
        this.tabD004.add((Component)this.btnD004Enabled, gridBagConstraints2);
        this.labelD004Rom = new JLabel("D004-ROM:");
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.insets.top = 20;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        this.tabD004.add((Component)this.labelD004Rom, gridBagConstraints2);
        this.comboD004Rom = new JComboBox();
        this.comboD004Rom.setEditable(false);
        this.comboD004Rom.addItem("Version 2.0");
        this.comboD004Rom.addItem("Version 3.3");
        this.comboD004Rom.addItem("Datei");
        this.comboD004Rom.addActionListener(this);
        gridBagConstraints2.insets.left = 0;
        ++gridBagConstraints2.gridx;
        this.tabD004.add(this.comboD004Rom, gridBagConstraints2);
        this.fldD004RomFile = new FileNameFld();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        this.tabD004.add((Component)this.fldD004RomFile, gridBagConstraints2);
        this.btnD004RomFileSelect = this.createImageButton("/images/file/open.png", "ROM-Datei ausw\u00e4hlen");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets.left = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx += 2;
        this.tabD004.add((Component)this.btnD004RomFileSelect, gridBagConstraints2);
        this.btnD004RomFileRemove = this.createImageButton("/images/file/delete.png", "ROM-Datei entfernen");
        ++gridBagConstraints2.gridx;
        this.tabD004.add((Component)this.btnD004RomFileRemove, gridBagConstraints2);
        this.labelD004Speed = new JLabel("Taktfrequenz:");
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.insets.top = 20;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        this.tabD004.add((Component)this.labelD004Speed, gridBagConstraints2);
        object2 = new JPanel(new FlowLayout(0, 10, 0));
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridwidth = 0;
        ++gridBagConstraints2.gridy;
        this.tabD004.add((Component)object2, gridBagConstraints2);
        serializable = new ButtonGroup();
        this.btnD004Speed4MHz = new JRadioButton("4 MHz (original)", true);
        this.btnD004Speed4MHz.addActionListener(this);
        ((ButtonGroup)serializable).add(this.btnD004Speed4MHz);
        ((Container)object2).add(this.btnD004Speed4MHz);
        this.btnD004Speed8MHz = new JRadioButton("8 MHz", false);
        this.btnD004Speed8MHz.addActionListener(this);
        ((ButtonGroup)serializable).add(this.btnD004Speed8MHz);
        ((Container)object2).add(this.btnD004Speed8MHz);
        this.btnD004Speed16MHz = new JRadioButton("16 MHz", false);
        this.btnD004Speed16MHz.addActionListener(this);
        ((ButtonGroup)serializable).add(this.btnD004Speed16MHz);
        ((Container)object2).add(this.btnD004Speed16MHz);
        this.tabGIDE = new GIDESettingsFld(settingsFrm, string);
        this.tabbedPane.addTab("GIDE", this.tabGIDE);
        this.tabROM = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("ROM", this.tabROM);
        object = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.tabROM.add((Component)new JLabel("Alternative ROM-Inhalte:"), object);
        this.altRomTextFlds = new FileNameFld[this.altRomTitles.length];
        this.altRomSelectBtns = new JButton[this.altRomTitles.length];
        this.altRomRemoveBtns = new JButton[this.altRomTitles.length];
        for (n2 = 0; n2 < this.altRomTitles.length; ++n2) {
            ((GridBagConstraints)object).insets.left = 50;
            ((GridBagConstraints)object).insets.bottom = 0;
            ((GridBagConstraints)object).gridx = 0;
            ++((GridBagConstraints)object).gridy;
            this.tabROM.add((Component)new JLabel(this.altRomTitles[n2] + ":"), object);
            FileNameFld fileNameFld = new FileNameFld();
            ((GridBagConstraints)object).fill = 2;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).insets.top = 0;
            ((GridBagConstraints)object).insets.bottom = 5;
            ++((GridBagConstraints)object).gridy;
            this.tabROM.add((Component)fileNameFld, object);
            this.altRomTextFlds[n2] = fileNameFld;
            JButton jButton = this.createImageButton("/images/file/open.png", "ROM-Datei ausw\u00e4hlen");
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).insets.left = 0;
            ++((GridBagConstraints)object).gridx;
            this.tabROM.add((Component)jButton, object);
            this.altRomSelectBtns[n2] = jButton;
            jButton = this.createImageButton("/images/file/delete.png", "ROM-Datei entfernen");
            ++((GridBagConstraints)object).gridx;
            this.tabROM.add((Component)jButton, object);
            this.altRomRemoveBtns[n2] = jButton;
        }
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnKeysDirectToBuf = new JCheckBox("Schnellere Tastatureingaben durch direktes Schreiben in den Tastaturpuffer", false);
        this.btnKeysDirectToBuf.addActionListener(this);
        this.tabEtc.add((Component)this.btnKeysDirectToBuf, gridBagConstraints3);
        this.btnPasteFast = new JCheckBox("Einf\u00fcgen von Text direkt in den Tastaturpuffer", true);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        this.btnPasteFast.addActionListener(this);
        this.tabEtc.add((Component)this.btnPasteFast, gridBagConstraints3);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets.top = 10;
        ++gridBagConstraints3.gridy;
        this.tabEtc.add((Component)new JSeparator(), gridBagConstraints3);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 0.0;
        ++gridBagConstraints3.gridy;
        this.tabEtc.add((Component)new JLabel("Die folgende Option ist f\u00fcr die korrekte Darstellung einiger Programme notwendig,"), gridBagConstraints3);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        this.tabEtc.add((Component)new JLabel("ben\u00f6tigt aber relativ viel Rechenleistung. Sollte diese Leistung nicht zur"), gridBagConstraints3);
        ++gridBagConstraints3.gridy;
        this.tabEtc.add((Component)new JLabel("Verf\u00fcgung stehen, dann schalten Sie die Option bitte aus."), gridBagConstraints3);
        this.btnVideoTiming = new JCheckBox("Zeitverhalten der Bildschirmsteuerung emulieren", KC85.getDefaultEmulateVideoTiming());
        this.btnVideoTiming.addActionListener(this);
        gridBagConstraints3.insets.top = 5;
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        this.tabEtc.add((Component)this.btnVideoTiming, gridBagConstraints3);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, this.kcTypeNum < 4 ? 3000 : 1500, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, this.kcTypeNum < 4 ? 3000 : 1500);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
        new DropTarget(this.fldD004RomFile, this).setActive(true);
        for (int i = 0; i < this.altRomTextFlds.length; ++i) {
            new DropTarget(this.altRomTextFlds[i], this).setActive(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.selModelModule) {
            String string;
            String[] stringArray;
            int n;
            int n2 = this.tableModule.getRowCount();
            int n3 = this.tableModule.getSelectedRowCount();
            int n4 = this.tableModule.getSelectedRow();
            boolean bl = n3 == 1 && n4 >= 0;
            boolean bl2 = false;
            this.btnModuleUp.setEnabled(n3 == 1 && n4 > 0);
            this.btnModuleDown.setEnabled(bl && n4 < n2 - 1);
            this.btnModuleRemove.setEnabled(n3 > 0);
            if (bl && (n = this.tableModule.convertRowIndexToModel(n4)) >= 0 && (stringArray = this.tableModelModule.getRow(n)) != null && stringArray.length > 1 && (string = stringArray[1]) != null && (string.equals("M025") || string.equals("M028") || string.equals("M040") || string.equals("M045") || string.equals("M046") || string.equals("M047") || string.equals("M048"))) {
                bl2 = true;
            }
            this.btnModuleEdit.setEnabled(bl2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && mouseEvent.getComponent() == this.tableModule) {
            this.doModuleEdit();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        JPanel jPanel = null;
        try {
            Object object;
            Object object2;
            Object object3;
            int n;
            jPanel = this.tabModule;
            int n2 = this.tableModelModule.getRowCount();
            for (n = 0; n < n2; n += 1) {
                object3 = this.tableModelModule.getValueAt(n, 0);
                object2 = this.tableModelModule.getValueAt(n, 1);
                object = this.tableModelModule.getValueAt(n, 3);
                Object object4 = this.tableModelModule.getValueAt(n, 4);
                if (object3 == null || object2 == null) continue;
                String string = object3.toString();
                String string2 = object2.toString();
                if (string == null || string2 == null || string.isEmpty() || string2.isEmpty()) continue;
                String string3 = String.format("%s%s.", this.modulePropPrefix, string);
                EmuUtil.setProperty(properties, string3 + "name", string2);
                EmuUtil.setProperty(properties, string3 + "typebyte", object);
                EmuUtil.setProperty(properties, string3 + "file", object4);
            }
            properties.setProperty(this.modulePropPrefix + "count", Integer.toString(n2));
            jPanel = this.tabD004;
            n = this.btnD004Enabled.isSelected() ? 1 : 0;
            properties.setProperty(this.propPrefix + "d004.enabled", Boolean.toString(n != 0));
            object3 = "standard";
            switch (this.comboD004Rom.getSelectedIndex()) {
                case 0: {
                    object3 = "2.0";
                    break;
                }
                case 1: {
                    object3 = "3.3";
                    break;
                }
                case 2: {
                    object2 = this.fldD004RomFile.getFile();
                    if (object2 == null && n && bl) {
                        this.tabbedPane.setSelectedComponent(this.tabD004);
                        throw new UserInputException("D004-ROM: Bitte w\u00e4hlen Sie eine ROM-Datei aus\noder stellen Sie einen anderen D004-ROM ein.");
                    }
                    if (object2 == null) break;
                    object3 = "file:" + ((File)object2).getPath();
                }
            }
            properties.setProperty(this.propPrefix + "d004.rom", (String)object3);
            if (this.btnD004Speed8MHz.isSelected()) {
                properties.setProperty(this.propPrefix + "d004.maxspeed.khz", "8000");
            } else if (this.btnD004Speed16MHz.isSelected()) {
                properties.setProperty(this.propPrefix + "d004.maxspeed.khz", "16000");
            } else {
                properties.setProperty(this.propPrefix + "d004.maxspeed.khz", "4000");
            }
            jPanel = this.tabGIDE;
            this.tabGIDE.applyInput(properties, bl);
            jPanel = this.tabROM;
            for (int i = 0; i < this.altRomKeys.length; ++i) {
                object = this.altRomTextFlds[i].getFile();
                properties.setProperty(this.propPrefix + this.altRomKeys[i], object != null ? ((File)object).getPath() : "");
            }
            jPanel = this.tabEtc;
            properties.setProperty(this.propPrefix + "keys.direct_to_buffer", Boolean.toString(this.btnKeysDirectToBuf.isSelected()));
            properties.setProperty(this.propPrefix + "paste.fast", Boolean.toString(this.btnPasteFast.isSelected()));
            properties.setProperty(this.propPrefix + "emulate_video_timing", Boolean.toString(this.btnVideoTiming.isSelected()));
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        this.settingsFrm.setWaitCursor(true);
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnModuleAdd) {
                bl = true;
                this.doModuleAdd();
            } else if (object == this.btnModuleEdit) {
                bl = true;
                this.doModuleEdit();
            } else if (object == this.btnModuleRemove) {
                bl = true;
                this.doModuleRemove();
            } else if (object == this.btnModuleUp) {
                bl = true;
                this.doModuleMove(-1);
            } else if (object == this.btnModuleDown) {
                bl = true;
                this.doModuleMove(1);
            } else if (object == this.btnD004Enabled || object == this.comboD004Rom || object == this.btnD004Speed4MHz || object == this.btnD004Speed8MHz || object == this.btnD004Speed16MHz) {
                bl = true;
                this.fireDataChanged();
                this.updD004FieldsEnabled();
            } else if (object == this.btnD004RomFileSelect) {
                bl = true;
                this.doRomFileSelect(this.fldD004RomFile, this.btnD004RomFileRemove, "D004-ROM-Datei ausw\u00e4hlen");
            } else if (object == this.btnD004RomFileRemove) {
                bl = true;
                this.doD004RomFileRemove();
            } else if (object == this.btnKeysDirectToBuf) {
                bl = true;
                this.updPasteFastEnabled();
                this.fireDataChanged();
            } else if (eventObject instanceof ActionEvent) {
                String string = ((ActionEvent)eventObject).getActionCommand();
                if (string != null && string.startsWith(ACTION_MODULE_ADD_PREFIX)) {
                    int n = ACTION_MODULE_ADD_PREFIX.length();
                    if (string.length() > n) {
                        this.addModule(string.substring(n));
                        bl = true;
                    }
                }
                this.fireDataChanged();
            }
            if (!bl) {
                for (int i = 0; i < this.altRomSelectBtns.length; ++i) {
                    if (object != this.altRomSelectBtns[i]) continue;
                    bl = true;
                    this.doRomFileSelect(this.altRomTextFlds[i], this.altRomRemoveBtns[i], "ROM-Datei (" + this.altRomTitles[i] + ") ausw\u00e4hlen");
                    break;
                }
            }
            if (!bl) {
                for (int i = 0; i < this.altRomRemoveBtns.length; ++i) {
                    if (object != this.altRomRemoveBtns[i]) continue;
                    bl = true;
                    this.altRomTextFlds[i].setFile(null);
                    this.altRomRemoveBtns[i].setEnabled(false);
                }
            }
            if (!bl) {
                bl = this.tabGIDE.doAction(eventObject);
            }
            if (!bl) {
                bl = this.tabAutoLoad.doAction(eventObject);
            }
            if (!bl) {
                bl = this.tabAutoInput.doAction(eventObject);
            }
            if (!bl && object instanceof AbstractButton) {
                bl = true;
                this.fireDataChanged();
            }
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = false;
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        if (dropTargetContext != null && dropTargetContext.getComponent() == this.fldD004RomFile && !this.fldD004RomFile.isEnabled()) {
            dropTargetDragEvent.rejectDrag();
            bl = true;
        }
        if (!bl) {
            super.dragEnter(dropTargetDragEvent);
        }
    }

    @Override
    protected boolean fileDropped(Component component, File file) {
        boolean bl;
        block2: {
            block1: {
                bl = false;
                if (component != this.fldD004RomFile) break block1;
                if (!this.fldD004RomFile.isEnabled()) break block2;
                this.fldD004RomFile.setFile(file);
                this.btnD004RomFileRemove.setEnabled(file != null);
                Main.setLastFile(file, "rom");
                this.fireDataChanged();
                bl = true;
                break block2;
            }
            for (int i = 0; i < this.altRomTextFlds.length; ++i) {
                if (component != this.altRomTextFlds[i]) continue;
                this.altRomTextFlds[i].setFile(file);
                this.altRomRemoveBtns[i].setEnabled(file != null);
                Main.setLastFile(file, "rom");
                this.fireDataChanged();
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.tabGIDE.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
        if (this.popupModule != null) {
            SwingUtilities.updateComponentTreeUI(this.popupModule);
        }
    }

    @Override
    public void updFields(Properties properties) {
        String string;
        Object object;
        int n;
        this.tableModelModule.clear();
        if (properties != null) {
            int n2 = EmuUtil.getIntProperty(properties, this.modulePropPrefix + "count", 0);
            n = 8;
            boolean bl = true;
            while (bl && n2 > 0) {
                object = String.format("%02X", n);
                String string2 = String.format("%s%s.", this.modulePropPrefix, object);
                bl = this.addModule((String)object, properties.getProperty(string2 + "name"), properties.getProperty(string2 + "typebyte"), properties.getProperty(string2 + "file"));
                --n2;
                n += 4;
            }
        }
        this.btnD004Enabled.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "d004.enabled", false));
        try {
            string = EmuUtil.getProperty(properties, this.propPrefix + "d004.rom");
            if (string.equals("2.0")) {
                this.comboD004Rom.setSelectedIndex(0);
            } else if (string.equals("3.3")) {
                this.comboD004Rom.setSelectedIndex(1);
            } else if (string.toLowerCase().startsWith("file:")) {
                this.comboD004Rom.setSelectedIndex(2);
                if (string.length() > "file:".length()) {
                    this.fldD004RomFile.setFileName(string.substring("file:".length()));
                } else {
                    this.fldD004RomFile.setFile(null);
                }
            } else {
                this.comboD004Rom.setSelectedIndex(this.kcTypeNum > 4 ? 1 : 0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        string = EmuUtil.getProperty(properties, this.propPrefix + "d004.maxspeed.khz");
        if (string.equals("8000")) {
            this.btnD004Speed8MHz.setSelected(true);
        } else if (string.equals("16000")) {
            this.btnD004Speed16MHz.setSelected(true);
        } else {
            this.btnD004Speed4MHz.setSelected(true);
        }
        this.updD004FieldsEnabled();
        this.tabGIDE.updFields(properties);
        for (n = 0; n < this.altRomKeys.length; ++n) {
            String string3 = EmuUtil.getProperty(properties, this.propPrefix + this.altRomKeys[n]);
            object = string3.isEmpty() ? null : new File(string3);
            this.altRomTextFlds[n].setFile((File)object);
            this.altRomRemoveBtns[n].setEnabled(object != null);
        }
        this.btnKeysDirectToBuf.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "keys.direct_to_buffer", false));
        this.btnPasteFast.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true));
        this.btnVideoTiming.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "emulate_video_timing", KC85.getDefaultEmulateVideoTiming()));
        this.updPasteFastEnabled();
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }

    private void doD004RomFileRemove() {
        this.fldD004RomFile.setFile(null);
        this.btnD004RomFileRemove.setEnabled(false);
        this.fireDataChanged();
    }

    private void doModuleAdd() {
        this.popupModule.show(this.btnModuleAdd, 0, this.btnModuleAdd.getHeight());
    }

    private void doModuleEdit() {
        String string;
        String[] stringArray;
        int n;
        int[] nArray = this.tableModule.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n = this.tableModule.convertRowIndexToModel(nArray[0])) >= 0 && (stringArray = this.tableModelModule.getRow(n)) != null && stringArray.length > 1 && (string = stringArray[1]) != null && (string.equals("M025") || string.equals("M028") || string.equals("M040") || string.equals("M045") || string.equals("M046") || string.equals("M047") || string.equals("M048"))) {
            KC85UserPROMSettingsDlg kC85UserPROMSettingsDlg = new KC85UserPROMSettingsDlg((Frame)this.settingsFrm, string, stringArray.length > 3 ? stringArray[3] : null, stringArray.length > 4 ? stringArray[4] : null);
            kC85UserPROMSettingsDlg.setVisible(true);
            String string2 = kC85UserPROMSettingsDlg.getApprovedFileName();
            String string3 = kC85UserPROMSettingsDlg.getApprovedTypeByteText();
            if (string3 != null && !string3.isEmpty()) {
                if (stringArray.length > 2) {
                    stringArray[2] = KC85SettingsFld.createModuleDesc(string, string3, string2);
                }
                if (stringArray.length > 3) {
                    stringArray[3] = string3;
                }
                if (stringArray.length > 4) {
                    stringArray[4] = string2;
                }
                this.tableModelModule.fireTableRowsUpdated(n, n);
                this.fireDataChanged();
            }
        }
    }

    private void doModuleRemove() {
        int[] nArray = this.tableModule.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            int n;
            int n2;
            Arrays.sort(nArray);
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                n = this.tableModule.convertRowIndexToModel(nArray[n2]);
                if (n < 0) continue;
                this.tableModelModule.removeRow(n);
            }
            n2 = this.tableModelModule.getRowCount();
            for (n = 0; n < n2; ++n) {
                this.tableModelModule.setValueAt(String.format("%02X", (n + 2) * 4), n, 0);
            }
            this.fireDataChanged();
        }
    }

    private void doModuleMove(int n) {
        int[] nArray = this.tableModule.getSelectedRows();
        if (nArray != null && nArray.length == 1) {
            int n2 = this.tableModelModule.getRowCount();
            int n3 = nArray[0];
            int n4 = n3 + n;
            if (n3 >= 0 && n3 < n2 && n4 >= 0 && n4 < n2) {
                String[] stringArray = this.tableModelModule.getRow(n3);
                String[] stringArray2 = this.tableModelModule.getRow(n4);
                if (stringArray != null && stringArray2 != null) {
                    int n5 = Math.min(stringArray.length, stringArray2.length);
                    for (int i = 1; i < n5; ++i) {
                        String string = stringArray[i];
                        stringArray[i] = stringArray2[i];
                        stringArray2[i] = string;
                    }
                    this.tableModelModule.fireTableRowsUpdated(Math.min(n3, n4), Math.max(n3, n4));
                    EmuUtil.fireSelectRow(this.tableModule, n4);
                    this.fireDataChanged();
                }
            }
        }
    }

    private void doRomFileSelect(FileNameFld fileNameFld, JButton jButton, String string) {
        File file = this.selectRomFile(fileNameFld.getFile(), string);
        if (file != null) {
            fileNameFld.setFile(file);
            jButton.setEnabled(true);
            Main.setLastFile(file, "rom");
            this.fireDataChanged();
        }
    }

    private boolean addModule(String string, String string2, String string3, String string4) {
        boolean bl = false;
        int n = this.tableModelModule.getRowCount();
        if (string2 != null && n < 60 && !string2.isEmpty()) {
            for (int i = 0; i < modules.length; ++i) {
                String string5 = modules[i][1];
                if (!string2.equals(string5)) continue;
                if (string == null) {
                    string = String.format("%02X", (n + 2) * 4);
                }
                this.tableModelModule.addRow(string, string2, KC85SettingsFld.createModuleDesc(string2, string3, string4), string3, string4);
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void addModule(String string) {
        if (string != null && !string.isEmpty()) {
            String string2 = null;
            String string3 = null;
            if (string.equals("M025") || string.equals("M028") || string.equals("M040") || string.equals("M045") || string.equals("M046") || string.equals("M047") || string.equals("M048")) {
                boolean bl = false;
                KC85UserPROMSettingsDlg kC85UserPROMSettingsDlg = new KC85UserPROMSettingsDlg((Frame)this.settingsFrm, string, null, null);
                kC85UserPROMSettingsDlg.setVisible(true);
                string2 = kC85UserPROMSettingsDlg.getApprovedTypeByteText();
                string3 = kC85UserPROMSettingsDlg.getApprovedFileName();
                if (string2 != null && string3 != null && !string2.isEmpty() && !string3.isEmpty()) {
                    bl = true;
                }
                if (!bl) {
                    string = null;
                }
            }
            if (string != null && this.addModule(null, string, string2, string3)) {
                EmuUtil.fireSelectRow(this.tableModule, this.tableModelModule.getRowCount() - 1);
            }
        }
    }

    private static String createModuleDesc(String string, String string2, String string3) {
        String string4 = null;
        if (string != null) {
            if (string2 != null) {
                if (string.equals("M025")) {
                    if (string2.equals("F7")) {
                        string4 = "8K User PROM";
                    } else if (string2.equals("FB")) {
                        string4 = "8 KByte ROM";
                    }
                } else if (string.equals("M028")) {
                    if (string2.equals("F8")) {
                        string4 = "16K User PROM";
                    } else if (string2.equals("FC")) {
                        string4 = "16K ROM";
                    }
                } else if (string.equals("M040")) {
                    if (string2.equals("1") || string2.equals("01")) {
                        string4 = "8/16K Autostart User PROM";
                    } else if (string2.equals("F7")) {
                        string4 = "8K User ROM";
                    }
                    if (string2.equals("F8")) {
                        string4 = "16K User PROM";
                    }
                }
            }
            if (string4 == null) {
                for (int i = 0; i < modules.length; ++i) {
                    if (!modules[i][1].equals(string)) continue;
                    string4 = modules[i][2];
                }
            }
            if (string4 != null && string3 != null && !string3.isEmpty()) {
                string4 = String.format("%s: %s", string4, string3);
            }
        }
        return string4;
    }

    private File selectRomFile(File file, String string) {
        File file2 = null;
        File file3 = EmuUtil.showFileOpenDlg(this.settingsFrm, string, file != null ? file : Main.getLastDirFile("rom"), EmuUtil.getROMFileFilter());
        if (file3 != null) {
            String string2 = null;
            if (file3.exists()) {
                if (file3.isFile()) {
                    if (file3.canRead()) {
                        if (file3.length() > 0L) {
                            file2 = file3;
                            Main.setLastFile(file3, "rom");
                        } else {
                            string2 = "Datei ist leer";
                        }
                    } else {
                        string2 = "Datei nicht lesbar";
                    }
                } else {
                    string2 = "Datei ist keine regul\u00e4re Datei";
                }
            } else {
                string2 = "Datei nicht gefunden";
            }
            if (string2 != null) {
                BaseDlg.showErrorDlg((Component)this, file3.getPath() + ": " + string2);
            }
        }
        return file2;
    }

    private void updD004FieldsEnabled() {
        boolean bl = this.btnD004Enabled.isSelected();
        this.tabGIDE.setEnabled(bl);
        this.labelD004Rom.setEnabled(bl);
        this.comboD004Rom.setEnabled(bl);
        this.labelD004Speed.setEnabled(bl);
        this.btnD004Speed4MHz.setEnabled(bl);
        this.btnD004Speed8MHz.setEnabled(bl);
        this.btnD004Speed16MHz.setEnabled(bl);
        if (bl && this.comboD004Rom.getSelectedIndex() != 2) {
            bl = false;
        }
        this.fldD004RomFile.setEnabled(bl);
        this.btnD004RomFileSelect.setEnabled(bl);
        if (bl) {
            bl = this.fldD004RomFile.getFile() != null;
        }
        this.btnD004RomFileRemove.setEnabled(bl);
    }

    private void updPasteFastEnabled() {
        if (this.btnPasteFast != null) {
            this.btnPasteFast.setEnabled(!this.btnKeysDirectToBuf.isSelected());
        }
    }
}

