/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.io.IOException;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.base.ByteIterator;

public class KCAudioCreator
extends BitSampleBuffer {
    private boolean phase = false;

    public KCAudioCreator(boolean bl, int n, byte[] byArray, int n2, int n3) throws IOException {
        super(8000, 32768);
        ByteIterator byteIterator = new ByteIterator(byArray, n2, n3);
        if (bl && !KCAudioCreator.skipString(byteIterator, "\u00c3KC-TAPE by AF. ")) {
            throw new IOException("KC-TAP-Kopf erwartet");
        }
        boolean bl2 = true;
        while (byteIterator.hasNext()) {
            int n4;
            int n5 = 320;
            if (bl && KCAudioCreator.skipString(byteIterator, "\u00c3KC-TAPE by AF. ")) {
                n5 = 16000;
            }
            if (bl2) {
                n5 = 16000;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                this.addPhaseChangeSamples(4);
            }
            this.addPhaseChangeSamples(8);
            this.addPhaseChangeSamples(8);
            n4 = 0;
            n4 = bl ? byteIterator.readByte() : (byteIterator.available() > 128 ? n++ : 255);
            this.addByteSamples(n4);
            int n6 = 0;
            for (int i = 0; i < 128; ++i) {
                n4 = byteIterator.readByte();
                this.addByteSamples(n4);
                n6 = n6 + n4 & 0xFF;
            }
            this.addByteSamples(n6);
            bl2 = false;
        }
        if (this.getFrameCount() > 0L) {
            this.addPhaseChangeSamples(40);
        }
    }

    public KCAudioCreator(boolean bl, int n, byte[] byArray) throws IOException {
        this(bl, n, byArray, 0, byArray.length);
    }

    private void addPhaseChangeSamples(int n) throws IOException {
        this.phase = !this.phase;
        this.addSamples(n, this.phase);
    }

    private void addByteSamples(int n) throws IOException {
        for (int i = 0; i < 8; ++i) {
            if ((n & 1) != 0) {
                this.addPhaseChangeSamples(4);
                this.addPhaseChangeSamples(4);
            } else {
                this.addPhaseChangeSamples(2);
                this.addPhaseChangeSamples(2);
            }
            n >>= 1;
        }
        this.addPhaseChangeSamples(8);
        this.addPhaseChangeSamples(8);
    }

    private static boolean skipString(ByteIterator byteIterator, String string) {
        boolean bl = true;
        int n = byteIterator.getIndex();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (byteIterator.readByte() == string.charAt(i)) continue;
            byteIterator.setIndex(n);
            bl = false;
            break;
        }
        return bl;
    }
}

