/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import jkcemu.base.EmuThread;
import jkcemu.emusys.kc85.AbstractKC85Module;
import jkcemu.print.PrintMngr;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80SIO;
import z80emu.Z80SIOChannelListener;
import z80emu.Z80TStatesListener;

public class M003
extends AbstractKC85Module
implements Z80CTCListener,
Z80InterruptSource,
Z80SIOChannelListener,
Z80TStatesListener {
    private String title;
    private int remainTStates;
    private PrintMngr printMngr;
    private Z80CPU cpu;
    private Z80CTC ctc;
    private Z80SIO sio;

    public M003(int n, EmuThread emuThread) {
        super(n);
        this.title = String.format("M003 im Schacht %02X", n);
        this.remainTStates = 0;
        this.printMngr = emuThread.getPrintMngr();
        this.cpu = emuThread.getZ80CPU();
        this.ctc = new Z80CTC("CTC (M003)");
        this.sio = new Z80SIO("SIO (M003)");
        this.sio.addChannelListener(this, 0);
        this.ctc.addCTCListener(this);
        this.cpu.addTStatesListener(this);
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc) {
            if (n == 0) {
                this.sio.clockPulseSenderA();
                this.sio.clockPulseReceiverA();
            } else if (n == 1) {
                this.sio.clockPulseSenderB();
                this.sio.clockPulseReceiverB();
            }
        }
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("<h2>CTC (E/A-Adressen 0C-0F)</h2>\n");
        this.ctc.appendInterruptStatusHTMLTo(stringBuilder);
        stringBuilder.append("<br/><br/>\n<h2>SIO (E/A-Adressen 08-0B)</h2>\n");
        this.sio.appendInterruptStatusHTMLTo(stringBuilder);
    }

    @Override
    public synchronized int interruptAccept() {
        int n = 0;
        if (this.sio.isInterruptRequested()) {
            n = this.sio.interruptAccept();
        } else if (this.ctc.isInterruptRequested()) {
            n = this.ctc.interruptAccept();
        }
        return n;
    }

    @Override
    public synchronized void interruptFinish() {
        if (this.sio.isInterruptAccepted()) {
            this.sio.interruptFinish();
        } else if (this.ctc.isInterruptAccepted()) {
            this.ctc.interruptFinish();
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.sio.isInterruptAccepted() || this.ctc.isInterruptAccepted();
    }

    @Override
    public boolean isInterruptRequested() {
        boolean bl = this.sio.isInterruptRequested();
        if (!bl && !this.sio.isInterruptAccepted()) {
            bl = this.ctc.isInterruptRequested();
        }
        return bl;
    }

    @Override
    public void reset(boolean bl) {
        this.ctc.reset(bl);
        this.sio.reset(bl);
        this.sio.setClearToSendA(true);
        this.sio.setClearToSendB(true);
    }

    @Override
    public void z80SIOByteSent(Z80SIO z80SIO, int n, int n2) {
        if (z80SIO == this.sio && n == 0) {
            this.printMngr.putByte(n2);
            this.sio.setClearToSendA(false);
            this.sio.setClearToSendA(true);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        this.ctc.z80TStatesProcessed(z80CPU, n);
        this.remainTStates += n;
        int n2 = this.remainTStates / 2;
        if (n2 > 0) {
            this.ctc.externalUpdate(0, n2);
            this.ctc.externalUpdate(1, n2);
            this.remainTStates -= n2 * 2;
        }
    }

    @Override
    public void die() {
        this.cpu.removeTStatesListener(this);
        this.ctc.removeCTCListener(this);
        this.sio.removeChannelListener(this, 0);
    }

    @Override
    public String getModuleName() {
        return "M003";
    }

    @Override
    public int getTypeByte() {
        return 238;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = -1;
        if (this.enabled) {
            switch (n & 0xFF) {
                case 8: {
                    n3 = this.sio.readDataA();
                    break;
                }
                case 9: {
                    n3 = this.sio.readDataB();
                    break;
                }
                case 10: {
                    n3 = this.sio.readControlA();
                    break;
                }
                case 11: {
                    n3 = this.sio.readControlB();
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n3 = this.ctc.read(n & 3, n2);
                }
            }
        }
        return n3;
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    public String toString() {
        return this.title;
    }

    @Override
    public boolean writeIOByte(int n, int n2, int n3) {
        boolean bl = false;
        if (this.enabled) {
            switch (n & 0xFF) {
                case 8: {
                    this.sio.writeDataA(n2);
                    bl = true;
                    break;
                }
                case 9: {
                    this.sio.writeDataB(n2);
                    bl = true;
                    break;
                }
                case 10: {
                    this.sio.writeControlA(n2);
                    bl = true;
                    break;
                }
                case 11: {
                    this.sio.writeControlB(n2);
                    bl = true;
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.ctc.write(n & 3, n2, n3);
                    bl = true;
                }
            }
        }
        return bl;
    }
}

