/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.util.Arrays;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class M011
extends AbstractKC85Module {
    private int negMask = 0;
    private boolean readWrite = false;
    private byte[] ram = new byte[65536];

    public M011(int n) {
        super(n);
    }

    @Override
    public void appendEtcInfoHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("Blockreihung: ");
        switch (this.negMask) {
            case 0: {
                stringBuilder.append("1 2 3 4");
                break;
            }
            case 16384: {
                stringBuilder.append("2 1 4 3");
                break;
            }
            case 32768: {
                stringBuilder.append("3 4 1 2");
                break;
            }
            case 49152: {
                stringBuilder.append("4 3 2 1");
            }
        }
    }

    @Override
    public void clearRAM() {
        Arrays.fill(this.ram, (byte)0);
    }

    @Override
    public String getModuleName() {
        return "M011";
    }

    @Override
    public Boolean getReadWrite() {
        return this.readWrite;
    }

    @Override
    public int getTypeByte() {
        return 246;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && (n2 = n ^ this.negMask) >= 0 && n2 < this.ram.length) {
            n3 = this.ram[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.negMask = n << 8 & 0xC000;
        this.readWrite = (n & 2) != 0;
    }

    @Override
    public int writeMemByte(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.enabled && (n3 = n ^ this.negMask) >= 0 && n3 < this.ram.length) {
            if (this.readWrite) {
                this.ram[n3] = (byte)n2;
                n4 = 2;
            } else {
                n4 = 1;
            }
        }
        return n4;
    }
}

